function TypeOnDialogFunc() {

    var _self = this;
    var _params;

    var _chosenFont = "";
    var _chosenStyle = "";
    var _chosenSize = 0;
    var _justification = "";
    var _chosenColor = {};
    var _trackingX;
    var _trackingY;

    var _fontPicker;
    var _sizePicker;
    var _justificationPicker;
    var _colorPicker;
    var _trackingXPicker;
    var _trackingYPicker;

    this.init = function() {
      RG.ucui.core.init().then( function(params) {

        _params = params;
        document.getElementById('lines_field').value = "" + (params.customConfig.lines ? params.customConfig.lines : 0);

          _chosenFont = params.customConfig.fontName;
          _chosenStyle = params.customConfig.fontStyle;
          _chosenSize = params.customConfig.fontSize;
          _justification = params.customConfig.justification;

          _chosenColor.r = Math.trunc(params.customConfig.fontColor[0]*255);
          _chosenColor.g = Math.trunc(params.customConfig.fontColor[1]*255);
          _chosenColor.b = Math.trunc(params.customConfig.fontColor[2]*255);

          _trackingX = params.customConfig.trackingX;
          _trackingY = params.customConfig.trackingY;

          $('body').append(RG.ucui.core.addComponent("Reset", {}).getDiv());

          $('#preview_area').append(RG.ucui.core.addComponent("Preview", {}).getDiv());

          _fontPicker = RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosen,
              onStyleChosen: _onStyleChosen,
              initialFont: _chosenFont,
              initialStyle: _chosenStyle,
          });
          $('#font_area').append(_fontPicker.getDiv());

          _sizePicker = RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosen,
              initialValue: Math.round(_chosenSize * 10) / 10,
          });
          $('#size_area').append(_sizePicker.getDiv());

          _justificationPicker = RG.ucui.core.addComponent("JustificationPicker", {
              onValueChosen: _onJustificationChosen,
              initialValue: _justification,
          });
          $('#justification_area').append(_justificationPicker.getDiv());

          _colorPicker = RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosen,
              color: {
                r: _chosenColor.r,
                g: _chosenColor.g,
                b: _chosenColor.b,
              }
          });
          $('#color_area').append(_colorPicker.getDiv());

          _trackingXPicker = RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosen,
              initialValue: _trackingX,
          });
          $('#trackingX_area').append(_trackingXPicker.getDiv());
          
          _trackingYPicker = RG.ucui.core.addComponent("TrackingYPicker", {
              onValueChosen: _onTrackingYChosen,
              initialValue: _trackingY,
          });
          $('#trackingY_area').append(_trackingYPicker.getDiv());

          // OK/Cancel
          RG.ucui.core.addComponent("OkCancel", {
              validateOk: _validateOk,
              getDialogResult: _getDialogResult
          });

        // Custom control reset support
        RGClientMain.getNotifier().registerForNotifications(RG.ucui.core.ParamResetAllNotification, function() {
            // Text fields      
            document.getElementById('lines_field').value = "" + (params.customConfig.lines ? params.customConfig.lines : 0);
        });
      });
    }

    var _onFontChosen = function(fp, fontName) {
        _chosenFont = fontName;
        RGClientMain.getNotifier().postNotification("rg.value.updated", fontName);
    };

    var _onStyleChosen = function(fp, fontStyle) {
        _chosenStyle = fontStyle;
        RGClientMain.getNotifier().postNotification("rg.value.updated", fontStyle);
    };

    var _onSizeChosen = function(cp, size) {
        _chosenSize = size;
    };

    var _onJustificationChosen = function(cp, justification) {
        _justification = justification;
    };

    var _onColorChosen = function(cp, rgb) {
        _chosenColor = rgb;
    };

    var _onTrackingXChosen = function(cp, trackingX) {
        _trackingX = trackingX;
    };

    var _onTrackingYChosen = function(cp, trackingY) {
        _trackingY = trackingY;
    };

    var _validateOk = function() {
        return (_chosenFont !== "" && _chosenStyle !== "");
    };

    var _getDialogResult = function() {
        var justificationIdx = 0; // "Left"
        if (_justification == "Center") {
          justificationIdx = 1;
        }
        else if (_justification == "Right") {
          justificationIdx = 2;
        }

        return {
          lines:document.getElementById('lines_field').value,
          fontName: _chosenFont,
          fontStyle: _chosenStyle,
          fontSize: _chosenSize,
          fontColor: _chosenColor,
          justification:_justification,
          trackingX:_trackingX,
          trackingY:_trackingY,

          previewMappings: [
            {
                "name" : _params.customConfig.parameterNames.text,
                "type" : "text",
                "value" : document.getElementById('lines_field').value,
            },
            {
                "name" : _params.customConfig.parameterNames.fontName,
                "type" : "text",
                "value" : _chosenFont
            },
            {
                "name" : _params.customConfig.parameterNames.fontStyle,
                "type" : "text",
                "value" : _chosenStyle
            },
            {
                "name" : _params.customConfig.parameterNames.fontSize,
                "type" : "float",
                "value" : _chosenSize
            },
            {
                "name" : _params.customConfig.parameterNames.fontColor,
                "type" : "color",
                "value" : [
                    _chosenColor.r/255,
                    _chosenColor.g/255,
                    _chosenColor.b/255
                ]
            },
            {
                "name" : _params.customConfig.parameterNames.justification,
                "type" : "choice",
                "value" : justificationIdx
            },
            {
                "name" : _params.customConfig.parameterNames.trackingX,
                "type" : "float",
                "value" : _trackingX
            },
            {
                "name" : _params.customConfig.parameterNames.trackingY,
                "type" : "float",
                "value" : _trackingY
            },

            _params.customConfig.parameterOverrides[0] ? _params.customConfig.parameterOverrides[0] : ""
          ]
        };
    }
};

var DialogApp = new TypeOnDialogFunc();

document.addEventListener("DOMContentLoaded", function() {
    DialogApp.init();
});
