function TitleMotionDialogFunc() {

    var _self = this;
    var _params;

    var _justification = "";
    var _trackingY = 0;

    var _chosenFontLine1 = "";
    var _chosenStyleLine1 = "";
    var _chosenSizeLine1 = 0;
    var _trackingXLine1 = 0;
    var _chosenColorLine1 = {};

    var _chosenFontLine2 = "";
    var _chosenStyleLine2 = "";
    var _chosenSizeLine2 = 0;
    var _trackingXLine2 = 0;
    var _chosenColorLine2 = {};

    var _justificationPicker;
    var _trackingYPicker;

    var _fontPicker1;
    var _sizePicker1;
    var _colorPicker1;
    var _trackingXPicker1;

    var _fontPicker2;
    var _sizePicker2;
    var _colorPicker2;
    var _trackingXPicker2;

    this.init = function() {
      RG.ucui.core.init().then( function(params) {

          _params = params;
          document.getElementById('lines_field1').value = "" + (params.customConfig.line1 ? params.customConfig.line1 : "");
          document.getElementById('lines_field2').value = "" + (params.customConfig.line2 ? params.customConfig.line2 : "");

          _justification = params.customConfig.justification;
          _trackingY = params.customConfig.trackingY;

          _chosenFontLine1 = params.customConfig.font1Name;
          _chosenStyleLine1 = params.customConfig.font1Style;
          _chosenSizeLine1 = params.customConfig.font1Size;
          _chosenColorLine1.r = Math.trunc(params.customConfig.font1Color[0]*255);
          _chosenColorLine1.g = Math.trunc(params.customConfig.font1Color[1]*255);
          _chosenColorLine1.b = Math.trunc(params.customConfig.font1Color[2]*255);
          _trackingXLine1 = params.customConfig.font1Tracking;

          _chosenFontLine2 = params.customConfig.font2Name;
          _chosenStyleLine2 = params.customConfig.font2Style;
          _chosenSizeLine2 = params.customConfig.font2Size;
          _chosenColorLine2.r = Math.trunc(params.customConfig.font2Color[0]*255);
          _chosenColorLine2.g = Math.trunc(params.customConfig.font2Color[1]*255);
          _chosenColorLine2.b = Math.trunc(params.customConfig.font2Color[2]*255);
          _trackingXLine2 = params.customConfig.font2Tracking;

          $('body').append(RG.ucui.core.addComponent("Reset", {}).getDiv());

          $('#preview_area').append(RG.ucui.core.addComponent("Preview", {}).getDiv());

          _justificationPicker = RG.ucui.core.addComponent("JustificationPicker", {
              onValueChosen: _onJustificationChosen,
              initialValue: _justification,
          });
          $('#justification_area').append(_justificationPicker.getDiv());

          _trackingYPicker = RG.ucui.core.addComponent("TrackingYPicker", {
              onValueChosen: _onTrackingYChosen,
              initialValue: _trackingY,
          });
          $('#trackingY_area').append(_trackingYPicker.getDiv());

          // Line 1

          _fontPicker1 = RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosenLine1,
              onStyleChosen: _onStyleChosenLine1,
              initialFont: _chosenFontLine1,
              initialStyle: _chosenStyleLine1,
          });
          $('#font_area1').append(_fontPicker1.getDiv());

          _sizePicker1 = RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosenLine1,
              initialValue: Math.round(_chosenSizeLine1 * 10) / 10,
          });
          $('#size_area1').append(_sizePicker1.getDiv());

          _colorPicker1 = RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosenLine1,
              color: {
                r: _chosenColorLine1.r,
                g: _chosenColorLine1.g,
                b: _chosenColorLine1.b,
              }
          });
          $('#color_area1').append(_colorPicker1.getDiv());

          _trackingXPicker1 = RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosenLine1,
              initialValue: _trackingXLine1,
          });
          $('#trackingX_area1').append(_trackingXPicker1.getDiv());

          // Line 2

          _fontPicker2 = RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosenLine2,
              onStyleChosen: _onStyleChosenLine2,
              initialFont: _chosenFontLine2,
              initialStyle: _chosenStyleLine2,
          });
          $('#font_area2').append(_fontPicker2.getDiv());

          _sizePicker2 = RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosenLine2,
              initialValue: Math.round(_chosenSizeLine2 * 10) /10,
          });
          $('#size_area2').append(_sizePicker2.getDiv());

          _colorPicker2 = RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosenLine2,
              color: {
                r: _chosenColorLine2.r,
                g: _chosenColorLine2.g,
                b: _chosenColorLine2.b,
              }
          });
          $('#color_area2').append(_colorPicker2.getDiv());

          _trackingXPicker2 = RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosenLine2,
              initialValue: _trackingXLine2,
          });
          $('#trackingX_area2').append(_trackingXPicker2.getDiv());

          // OK/Cancel
          RG.ucui.core.addComponent("OkCancel", {
              validateOk: _validateOk,
              getDialogResult: _getDialogResult
          });


          // Custom control reset support
          RGClientMain.getNotifier().registerForNotifications(RG.ucui.core.ParamResetAllNotification, function() {

            // Text fields
            document.getElementById('lines_field1').value = "" + (params.customConfig.line1 ? params.customConfig.line1 : "");
            document.getElementById('lines_field2').value = "" + (params.customConfig.line2 ? params.customConfig.line2 : "");

          });

      });
    }

    var _onJustificationChosen = function(cp, justification) {
        _justification = justification;
    };

    var _onTrackingYChosen = function(cp, trackingY) {
        _trackingY = trackingY;
    };

    var _onFontChosenLine1 = function(fp, fontName) {
        _chosenFontLine1 = fontName;
    };

    var _onStyleChosenLine1 = function(fp, fontStyle) {
        _chosenStyleLine1 = fontStyle;
    };

    var _onSizeChosenLine1 = function(cp, size) {
        _chosenSizeLine1 = size;
    };

    var _onColorChosenLine1 = function(cp, rgb) {
        _chosenColorLine1 = rgb;
    };

    var _onTrackingXChosenLine1 = function(cp, trackingX) {
        _trackingXLine1 = trackingX;
    };

    var _onFontChosenLine2 = function(fp, fontName) {
        _chosenFontLine2 = fontName;
    };

    var _onStyleChosenLine2 = function(fp, fontStyle) {
        _chosenStyleLine2 = fontStyle;
    };

    var _onSizeChosenLine2 = function(cp, size) {
        _chosenSizeLine2 = size;
    };

    var _onColorChosenLine2 = function(cp, rgb) {
        _chosenColorLine2 = rgb;
    };

    var _onTrackingXChosenLine2 = function(cp, trackingX) {
        _trackingXLine2 = trackingX;
    };

    var _validateOk = function() {
        return true;
    };

    var _getDialogResult = function() {
        var textLine1 = document.getElementById('lines_field1').value;
        var textLine2 = document.getElementById('lines_field2').value;
        var justificationVal = 0
        if (_justification == "Center") {
          justificationVal = 1;
        }
        else if (_justification == "Right") {
          justificationVal = 2;
        }

        result = {
          line1:textLine1,
          line2:textLine2,
          justification:_justification.toLowerCase(),
          trackingY:_trackingY == 0 ? -1 : _trackingY,

          fontNameLine1: _chosenFontLine1,
          fontStyleLine1: _chosenStyleLine1,
          fontSizeLine1: _chosenSizeLine1,
          fontColorLine1: [_chosenColorLine1.r/255, _chosenColorLine1.g/255, _chosenColorLine1.b/255],
          trackingXLine1:_trackingXLine1,

          fontNameLine2: _chosenFontLine2,
          fontStyleLine2: _chosenStyleLine2,
          fontSizeLine2: _chosenSizeLine2,
          fontColorLine2: [_chosenColorLine2.r/255, _chosenColorLine2.g/255, _chosenColorLine2.b/255],
          trackingXLine2:_trackingXLine2,

          previewMappings: [
            {
               "name" : _params.customConfig.parameterNames.line1 ? _params.customConfig.parameterNames.line1 : "Line 1",
               "type" : "text",
               "value" : textLine1
            },
            {
               "name" : _params.customConfig.parameterNames.line2 ? _params.customConfig.parameterNames.line2 : "Line 2",
               "type" : "text",
               "value" : textLine2
            },
            {
                "name" : _params.customConfig.parameterNames.justification ? _params.customConfig.parameterNames.justification : "Justification",
                "type" : "choice",
                "value" : justificationVal
            },
            {
                "name" : _params.customConfig.parameterNames.lineSpacing ? _params.customConfig.parameterNames.lineSpacing : "Line Spacing",
                "type" : "float",
                "value" : _trackingY == 0 ? -1 : _trackingY
            },
            {
               "name" : _params.customConfig.parameterNames.font1Name ? _params.customConfig.parameterNames.font1Name : "Font1",
               "type" : "text",
               "value" : _chosenFontLine1
            },
            {
               "name" : _params.customConfig.parameterNames.font1Style ? _params.customConfig.parameterNames.font1Style : "Font1 Style",
               "type" : "text",
               "value" : _chosenStyleLine1
            },
            {
                "name" : _params.customConfig.parameterNames.font1Size ? _params.customConfig.parameterNames.font1Size : "Font Size1",
                "type" : "float",
                "value" : _chosenSizeLine1
            },
            {
                "name" : _params.customConfig.parameterNames.font1Tracking ? _params.customConfig.parameterNames.font1Tracking : "Horizontal Tracking1",
                "type" : "float",
                "value" : _trackingXLine1
            },
            {
                "name" : _params.customConfig.parameterNames.font1Color ? _params.customConfig.parameterNames.font1Color : "Font Color1",
                "type" : "color",
                "value" : [
                    _chosenColorLine1.r/255,
                    _chosenColorLine1.g/255,
                    _chosenColorLine1.b/255
                ]
            },
            {
               "name" : _params.customConfig.parameterNames.font2Name ? _params.customConfig.parameterNames.font2Name : "Font2",
               "type" : "text",
               "value" : _chosenFontLine2
            },
            {
               "name" : _params.customConfig.parameterNames.font2Style ? _params.customConfig.parameterNames.font2Style : "Font2 Style",
               "type" : "text",
               "value" : _chosenStyleLine2
            },
            {
                "name" : _params.customConfig.parameterNames.font2Size ? _params.customConfig.parameterNames.font2Size : "Font Size2",
                "type" : "float",
                "value" : _chosenSizeLine2
            },
            {
                "name" : _params.customConfig.parameterNames.font2Tracking ? _params.customConfig.parameterNames.font2Tracking : "Horizontal Tracking2",
                "type" : "float",
                "value" : _trackingXLine2
            },
            {
                "name" : _params.customConfig.parameterNames.font2Color ? _params.customConfig.parameterNames.font2Color : "Font Color2",
                "type" : "color",
                "value" : [
                    _chosenColorLine2.r/255,
                    _chosenColorLine2.g/255,
                    _chosenColorLine2.b/255
                ]
            },
          ]
        };

        _params.customConfig.parameterOverrides.forEach(function(paramOverride) {
            result.previewMappings.push(paramOverride);
        });

        return result;
    }
};

var DialogApp = new TitleMotionDialogFunc();

document.addEventListener("DOMContentLoaded", function() {
    DialogApp.init();
});
