function TextAttributesDialogFunc() {

    var _self = this;
    var _chosenFont = "";
    var _chosenStyle = "";
    var _chosenSize = 0;
    var _justification = "";
    var _chosenColor = {};
    var _trackingX;
    var _trackingY;

    this.init = function() {
      RG.ucui.core.init().then( function(params) {

          // Font picker
          _chosenFont = params.customConfig.fontName;
          _chosenStyle = params.customConfig.fontStyle;
          _chosenSize = params.customConfig.fontSize;
          _justification = params.customConfig.justification;

          _chosenColor.r = Math.trunc(params.customConfig.fontColor[0]*255);
          _chosenColor.g = Math.trunc(params.customConfig.fontColor[1]*255);
          _chosenColor.b = Math.trunc(params.customConfig.fontColor[2]*255);

          _trackingX = params.customConfig.trackingX;
          _trackingY = params.customConfig.trackingY != undefined ? params.customConfig.trackingY : 0;

          $('#font_area').append(RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosen,
              onStyleChosen: _onStyleChosen,
              initialFont: _chosenFont,
              initialStyle: _chosenStyle,
          }).getDiv());

          $('#size_area').append(RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosen,
              initialValue: Math.round(_chosenSize * 10) / 10,
          }).getDiv());

          $('#justification_area').append(RG.ucui.core.addComponent("JustificationPicker", {
              onValueChosen: _onJustificationChosen,
              initialValue: _justification,
          }).getDiv());

          // Color Picker
          $('#color_area').append(RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosen,
              color: {
                r: _chosenColor.r,
                g: _chosenColor.g,
                b: _chosenColor.b,
              }
          }).getDiv());

          $('#trackingX_area').append(RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosen,
              initialValue: _trackingX,
          }).getDiv());

          $('#trackingY_area').append(RG.ucui.core.addComponent("TrackingYPicker", {
              onValueChosen: _onTrackingYChosen,
              initialValue: _trackingY,
          }).getDiv());

          // OK/Cancel
          RG.ucui.core.addComponent("OkCancel", {
              validateOk: _validateOk,
              getDialogResult: _getDialogResult
          });
      });
    }

    var _onFontChosen = function(fp, fontName) {
        _chosenFont = fontName;
        RGClientMain.getNotifier().postNotification("rg.value.updated", fontName);
    };

    var _onStyleChosen = function(fp, fontStyle) {
        _chosenStyle = fontStyle;
        RGClientMain.getNotifier().postNotification("rg.value.updated", fontStyle);
    };

    var _onSizeChosen = function(cp, size) {
        _chosenSize = size;
    };

    var _onJustificationChosen = function(cp, justification) {
        _justification = justification;
    };

    var _onColorChosen = function(cp, rgb) {
        _chosenColor = rgb;
    };

    var _onTrackingXChosen = function(cp, trackingX) {
        _trackingX = trackingX;
    };

    var _onTrackingYChosen = function(cp, trackingY) {
        _trackingY = trackingY;
    };

    var _validateOk = function() {
        return (_chosenFont !== "" && _chosenStyle !== "");
    };

    var _getDialogResult = function() {
        return {
          fontName: _chosenFont,
          fontStyle: _chosenStyle,
          fontSize: _chosenSize,
          fontColor: _chosenColor,
          justification:_justification,
          trackingX:_trackingX,
          trackingY:_trackingY,
        };
    }
};

var DialogApp = new TextAttributesDialogFunc();

document.addEventListener("DOMContentLoaded", function() {
    DialogApp.init();
});
