function LineDialogFunc() {

    var _self = this;
    var _params;

    var _chosenFont = "";
    var _chosenStyle = "";
    var _chosenSize = 0;
    var _trackingX = 0;
    var _chosenColor = {};

    var _fontPicker;
    var _sizePicker;
    var _colorPicker;
    var _trackingXPicker;

    this.init = function() {
      RG.ucui.core.init().then( function(params) {

          _params = params;
          document.getElementById('lines_field').value = "" + (params.customConfig.text ? params.customConfig.text : "");

          _chosenFont = params.customConfig.fontName;
          _chosenStyle = params.customConfig.fontStyle;
          _chosenSize = params.customConfig.fontSize;
          _chosenColor.r = Math.trunc(params.customConfig.fontColor[0]*255);
          _chosenColor.g = Math.trunc(params.customConfig.fontColor[1]*255);
          _chosenColor.b = Math.trunc(params.customConfig.fontColor[2]*255);
          _trackingX = params.customConfig.fontTracking;

          $('body').append(RG.ucui.core.addComponent("Reset", {}).getDiv());

          $('#preview_area').append(RG.ucui.core.addComponent("Preview", {}).getDiv());

          _fontPicker = RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosen,
              onStyleChosen: _onStyleChosen,
              initialFont: _chosenFont,
              initialStyle: _chosenStyle,
          });
          $('#font_area').append(_fontPicker.getDiv());

          _sizePicker = RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosen,
              initialValue: Math.round(_chosenSize * 10) / 10,
          });
          $('#size_area').append(_sizePicker.getDiv());

          _trackingXPicker = RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosen,
              initialValue: _trackingX,
          });
          $('#trackingX_area').append(_trackingXPicker.getDiv());

          _colorPicker = RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosen,
              color: {
                r: _chosenColor.r,
                g: _chosenColor.g,
                b: _chosenColor.b,
              }
          });
          $('#color_area').append(_colorPicker.getDiv());

          // OK/Cancel
          RG.ucui.core.addComponent("OkCancel", {
              validateOk: _validateOk,
              getDialogResult: _getDialogResult
          });

          // Custom control reset support
          RGClientMain.getNotifier().registerForNotifications(RG.ucui.core.ParamResetAllNotification, function() {
            document.getElementById('lines_field').value = "" + (params.customConfig.text ? params.customConfig.text : "");
          });
      });
    }

    var _onFontChosen = function(fp, fontName) {
        _chosenFont = fontName;
    };

    var _onStyleChosen = function(fp, fontStyle) {
        _chosenStyle = fontStyle;
    };

    var _onSizeChosen = function(cp, size) {
        _chosenSize = size;
    };

    var _onTrackingXChosen = function(cp, trackingX) {
        _trackingX = trackingX;
    };

    var _onColorChosen = function(cp, rgb) {
        _chosenColor = rgb;
    };

    var _validateOk = function() {
        return true;
    };

    var _getDialogResult = function() {
        var text = document.getElementById('lines_field').value;
        
        return {
          text:text,
          fontName: _chosenFont,
          fontStyle: _chosenStyle,
          fontSize: _chosenSize,
          trackingX:_trackingX,
          fontColor: [_chosenColor.r/255, _chosenColor.g/255, _chosenColor.b/255],

          previewMappings: [
            {
               "name" : _params.customConfig.parameterNames.text,
               "type" : "text",
               "value" : text
            },
            {
               "name" : _params.customConfig.parameterNames.fontName,
               "type" : "text",
               "value" : _chosenFont
            },
            {
               "name" : _params.customConfig.parameterNames.fontStyle,
               "type" : "text",
               "value" : _chosenStyle
            },
            {
                "name" : _params.customConfig.parameterNames.fontSize,
                "type" : "float",
                "value" : _chosenSize
            },
            {
                "name" : _params.customConfig.parameterNames.tracking,
                "type" : "float",
                "value" : _trackingX
            },
            {
                "name" : _params.customConfig.parameterNames.fontColor,
                "type" : "color",
                "value" : [
                    _chosenColor.r/255,
                    _chosenColor.g/255,
                    _chosenColor.b/255
                ]
            },
            // _params.customConfig.parameterOverrides[0] ? _params.customConfig.parameterOverrides[0] : "",
            // _params.customConfig.parameterOverrides[1] ? _params.customConfig.parameterOverrides[1] : "",
          ]
        };
    }
};

var DialogApp = new LineDialogFunc();

document.addEventListener("DOMContentLoaded", function() {
    DialogApp.init();
});
