function HackerTextDialogFunc() {

    var _self = this;
    var _textToDisplay = 0;
    var _justification = "";

    var _chosenFontTgt = "";
    var _chosenStyleTgt = "";
    var _chosenSizeTgt = 0;
    var _chosenColorTgt = {};
    var _trackingXTgt = 0;
    
    var _justificationPicker;
    var _fontPicker;
    var _sizePicker;
    var _colorPicker;
    var _trackingXPicker;

    this.init = function() {
      RG.ucui.core.init().then( function(params) {
          document.getElementById('lines_field1').value = "" + (params.customConfig.linesSrc ? params.customConfig.linesSrc : 0);
          document.getElementById('lines_field2').value = "" + (params.customConfig.linesTgt ? params.customConfig.linesTgt : 0);

          _justification = params.customConfig.justification;
          _chosenFontTgt = params.customConfig.fontNameTgt;
          _chosenStyleTgt = params.customConfig.fontStyleTgt;
          _chosenSizeTgt = params.customConfig.fontSizeTgt;
          _chosenColorTgt.r = Math.trunc(params.customConfig.fontColorTgt[0]*255);
          _chosenColorTgt.g = Math.trunc(params.customConfig.fontColorTgt[1]*255);
          _chosenColorTgt.b = Math.trunc(params.customConfig.fontColorTgt[2]*255);
          _trackingXTgt = params.customConfig.trackingXTgt;


          $('body').append(RG.ucui.core.addComponent("Reset", {}).getDiv());

          Widgets.buildRadioButtonGroup($('#text_selection_controls'), _textToDisplay, ["Source Text", "Target Text"], function(div, idx){
            _textToDisplay = idx;
            RGClientMain.getNotifier().postNotification(RG.ucui.core.ParamChangedNotification, {sender:this});
          });
          
          $('#preview_area').append(RG.ucui.core.addComponent("Preview", {}).getDiv());

          _justificationPicker = RG.ucui.core.addComponent("JustificationPicker", {
              onValueChosen: _onJustificationChosen,
              initialValue: _justification,
          });
          $('#justification_area').append(_justificationPicker.getDiv());

          // Target

          _fontPicker = RG.ucui.core.addComponent("FontPicker", {
              onFontChosen: _onFontChosenTgt,
              onStyleChosen: _onStyleChosenTgt,
              initialFont: _chosenFontTgt,
              initialStyle: _chosenStyleTgt,
          });
          $('#font_area2').append(_fontPicker.getDiv());

          _sizePicker = RG.ucui.core.addComponent("SizePicker", {
              onValueChosen: _onSizeChosenTgt,
              initialValue: Math.round(_chosenSizeTgt * 10) / 10,
          });
          $('#size_area2').append(_sizePicker.getDiv());

          _colorPicker = RG.ucui.core.addComponent("ColorPicker", {
              onColorChosen: _onColorChosenTgt,
              color: {
                r: _chosenColorTgt.r,
                g: _chosenColorTgt.g,
                b: _chosenColorTgt.b,
              }
          });
          $('#color_area2').append(_colorPicker.getDiv());

          _trackingXPicker = RG.ucui.core.addComponent("TrackingXPicker", {
              onValueChosen: _onTrackingXChosenTgt,
              initialValue: _trackingXTgt,
          });
          $('#trackingX_area2').append(_trackingXPicker.getDiv());

          // OK/Cancel
          RG.ucui.core.addComponent("OkCancel", {
              validateOk: _validateOk,
              getDialogResult: _getDialogResult
          });


          // Custom control reset support
          RGClientMain.getNotifier().registerForNotifications(RG.ucui.core.ParamResetAllNotification, function() {

            // Text fields            
            document.getElementById('lines_field1').value = "" + (params.customConfig.linesSrc ? params.customConfig.linesSrc : 0);
            document.getElementById('lines_field2').value = "" + (params.customConfig.linesTgt ? params.customConfig.linesTgt : 0);

            // Checkboxes            
            _textToDisplay = 0;
            $('#text_selection_controls').find('.bp_checked').removeClass('bp_checked');
            $('#text_selection_controls').find('.bp_checkbox').eq(0).addClass('bp_checked');
          });

      });
    }

    var _onJustificationChosen = function(cp, justification) {
        _justification = justification;
    };

    var _onFontChosenTgt = function(fp, fontName) {
        _chosenFontTgt = fontName;
    };

    var _onStyleChosenTgt = function(fp, fontStyle) {
        _chosenStyleTgt = fontStyle;
    };

    var _onSizeChosenTgt = function(cp, size) {
        _chosenSizeTgt = size;
    };

    var _onColorChosenTgt = function(cp, rgb) {
        _chosenColorTgt = rgb;
    };

    var _onTrackingXChosenTgt = function(cp, trackingX) {
        _trackingXTgt = trackingX;
    };

    var _validateOk = function() {
        return true;
    };

    var _getDialogResult = function() {
        var textSrc = document.getElementById('lines_field1').value;
        var textTgt = document.getElementById('lines_field2').value;
        var transitionValue = (_textToDisplay == 0 ? 0 : 100);
        var justificationIdx = 0; // "Left"
        if (_justification == "Center") {
          justificationIdx = 1;
        }
        else if (_justification == "Right") {
          justificationIdx = 2;
        }
        
        return {
          linesSrc:textSrc,
          linesTgt:textTgt,
          justification:_justification,
          trackingY:0,

          fontNameTgt: _chosenFontTgt,
          fontStyleTgt: _chosenStyleTgt,
          fontSizeTgt: _chosenSizeTgt,
          fontColorTgt: _chosenColorTgt,
          trackingXTgt:_trackingXTgt,
          
          previewMappings: [
            {
                "name" : "Justification",
                "type" : "choice",
                "value" : justificationIdx
            },
            {
               "name" : "Text Source",
               "type" : "text",
               "value" : textSrc
            },
            {
               "name" : "Text Target",
               "type" : "text",
               "value" : textTgt
            },
            {
               "name" : "Font Family Tgt",
               "type" : "text",
               "value" : _chosenFontTgt
            },
            {
               "name" : "Font Style Tgt",
               "type" : "text",
               "value" : _chosenStyleTgt
            },
            {
                "name" : "Font Size",
                "type" : "float",
                "value" : _chosenSizeTgt
            },
            {
                "name" : "Horizontal Tracking",
                "type" : "float",
                "value" : _trackingXTgt
            },
            {
                "name" : "Font Color",
                "type" : "color",
                "value" : [
                    _chosenColorTgt.r/255,
                    _chosenColorTgt.g/255,
                    _chosenColorTgt.b/255
                ]
            },
            {
                "name" : "Transition",
                "type" : "float",
                "value" : transitionValue
            }
          ]
          
        };
    }
};

var DialogApp = new HackerTextDialogFunc();

document.addEventListener("DOMContentLoaded", function() {
    DialogApp.init();
});
