/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1);

__webpack_require__(6);

var _chooser = __webpack_require__(8);

var _footer = _interopRequireDefault(__webpack_require__(62));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Application =
/*#__PURE__*/
function () {
  function Application() {
    _classCallCheck(this, Application);

    this._chooser = null;
    this._chosenItems = [];
    this._debugSettings = {
      mockedData: typeof nx_api === "undefined"
    };
  }

  _createClass(Application, [{
    key: "getApplicationParameters",
    value: function getApplicationParameters(clientMain) {
      var clientParms = this._params && this._params.clientParams ? this._params.clientParams : {};

      _.defaults(clientParms, {
        connectWs: false,
        validateServerVersion: false,
        loadSysInfo: false,
        hasAppServer: false
      });

      return clientParms;
    }
  }, {
    key: "init",
    value: function init(clientMain) {
      if (typeof nx_api !== "undefined") {
        nx_api.init();
      }

      var chooserParams = {
        debug: this._debugSettings
      };
      clientMain.getNotifier().registerForNotificationsWithTarget(_chooser.ChooserNotifications.ChoiceUpdated, this.onChoiceUpdated, this);
      clientMain.getNotifier().registerForNotificationsWithTarget(_chooser.ChooserNotifications.ChoiceMade, this.onChoideMade, this);
      this._chooser = new _chooser.Chooser(chooserParams);
      this._footer = new _footer.default(this);
    }
  }, {
    key: "onApplicationFinishedLaunching",
    value: function onApplicationFinishedLaunching(clientMain) {
      var _this = this;

      if (typeof nx_api !== "undefined") {
        nx_api.initialState.get().then(function (initialState) {
          _this._chooser.init(initialState);
        });
      } else if (this._debugSettings.mockedData) {
        var mockState = {
          presetSettings: {
            effectId: "Universe_Stylize_VHS",
            dialogMode: "presets"
          }
        };

        this._chooser.init(mockState);
      }
    }
  }, {
    key: "onChoiceUpdated",
    value: function onChoiceUpdated(n) {
      this._chosenItems = n.data.contentList.slice(0);

      if (this._footer) {
        this._footer.updateState();
      }
    }
  }, {
    key: "onChoideMade",
    value: function onChoideMade(n) {
      this._chosenItems = n.data.contentList.slice(0);
      this.onOk(this.getDialogResult());
    } // Delegate for the footer

  }, {
    key: "validateOk",
    value: function validateOk() {
      return this._chosenItems.length === 1;
    }
  }, {
    key: "getDialogResult",
    value: function getDialogResult() {
      var result = {};

      if (this._chosenItems.length === 1) {
        // @todo - choice mode
        result.path = this._chosenItems[0].path;
      }

      return result;
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      console.log("Dialog cancel");

      if (typeof nx_api !== "undefined") {
        nx_api.nx_window.setDialogResult(0);
        nx_api.nx_window.close();
      }
    }
  }, {
    key: "onOk",
    value: function onOk(dialogResult) {
      console.log("Dialog Ok");

      if (typeof nx_api !== "undefined") {
        nx_api.nx_window.setDialogResult(1, dialogResult);
        nx_api.nx_window.close();
      }
    }
  }]);

  return Application;
}();

var _App = new Application();

$(document).ready(function () {
  RGClientMain.init(_App);
});

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(2);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, "body {\n  background: #282828;\n  -webkit-user-select: none;\n  cursor: default;\n  overflow: hidden;\n}\n#chooser_content {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  right: 0px;\n  height: calc(100% - 50px);\n}\n#chooser_content .thumbnail-grid {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  right: 0px;\n  height: 100%;\n}\n#chooser_content .fav-button {\n  display: none;\n}\n#dialog_footer {\n  position: absolute;\n  background-color: #525252;\n  bottom: 0px;\n  left: 0px;\n  right: 0px;\n  height: 49px;\n  border-top: 1px solid black;\n}\n.dialog_footer_outer {\n  position: absolute;\n  float: left;\n  left: 50%;\n  bottom: 14px;\n  height: 24px;\n}\n.dialog_footer_inner {\n  position: relative;\n  float: left;\n  left: -50%;\n  height: 100%;\n}\n.dialog_footer_button {\n  display: inline-block;\n  min-width: 52px;\n  height: 24px;\n  line-height: 22px;\n}\n.dialog_footer_space {\n  display: inline-block;\n  width: 5px;\n}\n", ""]);

// exports


/***/ }),
/* 3 */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getTarget = function (target) {
  return document.querySelector(target);
};

var getElement = (function (fn) {
	var memo = {};

	return function(target) {
                // If passing function in options, then use it for resolve "head" element.
                // Useful for Shadow Root style i.e
                // {
                //   insertInto: function () { return document.querySelector("#foo").shadowRoot }
                // }
                if (typeof target === 'function') {
                        return target();
                }
                if (typeof memo[target] === "undefined") {
			var styleTarget = getTarget.call(this, target);
			// Special case to return head of iframe instead of iframe itself
			if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[target] = styleTarget;
		}
		return memo[target]
	};
})();

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(5);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
        if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),
/* 5 */
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(7);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".rg_grid_scroll_wrap::-webkit-scrollbar {\n  background-color: #1d1d1d;\n}\n.rg_grid_scroll_wrap::-webkit-scrollbar-corner {\n  background-color: #1d1d1d;\n}\n.rg_grid_scroll_wrap::-webkit-scrollbar-thumb {\n  background-color: #313131;\n  border-radius: 10px;\n}\n", ""]);

// exports


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _content_store = _interopRequireDefault(__webpack_require__(9));

var _filtered_content_provider = _interopRequireDefault(__webpack_require__(15));

var _content_api_json = _interopRequireDefault(__webpack_require__(17));

var _content_api = _interopRequireDefault(__webpack_require__(20));

var _content_polling_metaQ = _interopRequireDefault(__webpack_require__(21));

var _uniMock = _interopRequireDefault(__webpack_require__(23));

var _grid = _interopRequireDefault(__webpack_require__(24));

var _nxContentTransport = _interopRequireDefault(__webpack_require__(58));

__webpack_require__(6);

var _expansionstate = _interopRequireDefault(__webpack_require__(59));

var _expansionstate_api = _interopRequireDefault(__webpack_require__(60));

var _expansionstate_transport = _interopRequireDefault(__webpack_require__(61));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ChooserNotifications = {
  ChoiceUpdated: "choice.update",
  ChoiceMade: "choice.made"
};

var Chooser =
/*#__PURE__*/
function () {
  function Chooser(params) {
    _classCallCheck(this, Chooser);

    this._params = params ? params : {};
    this._waitingForPresets = true;

    _.defaults(this._params, {
      debug: {},
      notifier: RGClientMain.getNotifier(),
      div: $('#chooser_content')
    });
  }

  _createClass(Chooser, [{
    key: "init",
    value: function init(dialogConfig) {
      var _this = this;

      dialogConfig = dialogConfig ? dialogConfig : {};

      _.defaults(dialogConfig, {
        presetSettings: {}
      });

      _.defaults(dialogConfig.presetSettings, {
        dialogMode: "presets"
      });

      this._expansionState = this._initExpansionState(dialogConfig.presetSettings.effectId);

      this._expansionState.getState().then(function (data) {
        _this._transport = _this._createContentTransport();
        _this._contentApi = _this._createContentAPI();
        _this._gridDataSource = _this._createGridDataSource(dialogConfig, {
          deferInit: true
        });

        _this._initUI(dialogConfig);
      });
    }
  }, {
    key: "_initExpansionState",
    value: function _initExpansionState(matchname) {
      var transport = new _expansionstate_transport.default();
      var stateAPI = new _expansionstate_api.default(transport);
      return new _expansionstate.default(matchname, "presets", stateAPI);
    }
  }, {
    key: "_getGroupExpansionStates",
    value: function _getGroupExpansionStates() {
      var states = [];

      var groups = this._grid._arranger.getGroups().groups;

      for (var i = 0; i < groups.length; i++) {
        var groupId = groups[i].groupId;

        var state = this._expansionState.findState(groupId);

        states.push({
          id: groupId,
          isExpanded: state.isExpanded
        });
      }

      return states;
    }
  }, {
    key: "_onGroupExpansionChanged",
    value: function _onGroupExpansionChanged(gridView, isExpanded, groupIndex, groupData) {
      this._expansionState.setState(groupData.groupId, isExpanded);
    }
  }, {
    key: "onContentSelected",
    // ContentGrid delegate
    value: function onContentSelected(contentGrid, contentList) {
      if (this._params.notifier) {
        this._params.notifier.postNotification(ChooserNotifications.ChoiceUpdated, {
          sender: this,
          contentList: contentList
        });
      }
    }
  }, {
    key: "getGridEmptyContent",
    value: function getGridEmptyContent(contentGrid) {
      if (!this._waitingForPresets) {
        return __("No Presets Available");
      }

      return "";
    } // EffectController

  }, {
    key: "applyPreset",
    value: function applyPreset(effectItem, presetItem) {
      if (presetItem && this._params.notifier) {
        this._params.notifier.postNotification(ChooserNotifications.ChoiceMade, {
          sender: this,
          contentList: [presetItem]
        });
      }
    }
  }, {
    key: "_createContentTransport",
    value: function _createContentTransport() {
      if (this._params.debug.mockedData) {
        return null;
      }

      return new _nxContentTransport.default();
    }
  }, {
    key: "_createContentAPI",
    value: function _createContentAPI() {
      if (this._params.debug.mockedData) {
        return new _content_api_json.default(_uniMock.default);
      }

      return new _content_api.default(this._transport);
    }
  }, {
    key: "_createGridDataSource",
    value: function _createGridDataSource(dialogConfig, storeParams) {
      if (!storeParams) {
        storeParams = {};
      }

      var store = null;

      if (dialogConfig.presetSettings.dialogMode === "presets") {
        var polling = new _content_polling_metaQ.default(this._contentApi);
        storeParams.changeWatching = polling;
        store = new _content_store.default(this._contentApi, storeParams);
      } else if (dialogConfig.presetSettings.dialogMode === "choice") {}

      return store;
    }
  }, {
    key: "_initUI",
    value: function _initUI(dialogConfig) {
      this._buildGrid();

      var gridFilter = {
        effectId: dialogConfig.presetSettings.effectId
      };

      if (dialogConfig.presetSettings.presetCategory) {
        // If a category was specified, filter on it
        gridFilter.category = dialogConfig.presetSettings.presetCategory;
      } else if (dialogConfig.presetCategory === null || dialogConfig.presetCategory === undefined || dialogConfig.presetCategory === '') {
        gridFilter.isInnerPreset = false;
      }

      this._grid.getContentGrid().showLoadingUntilFoundContent(true);

      this._gridDataSource.addFilter(gridFilter);

      this._gridDataSource.init();

      this._gridDataSource.reload();

      this._waitForDiscovery();
    }
  }, {
    key: "_waitForDiscovery",
    value: function _waitForDiscovery() {
      var _this2 = this;

      if (typeof nx_api !== "undefined") {
        var discoveryDone = false;

        var onDone = function onDone() {
          if (!discoveryDone) {
            discoveryDone = true;
            console.log("Content Discovery Complete");

            _.delay(function () {
              // If we haven't found anything yet, give up after a short delay to let polling do its thing
              _this2._waitingForPresets = false;

              _this2._grid.getContentGrid().showLoadingUntilFoundContent(false);
            }, 5000);
          }
        }; // 2-step approach here
        // 1. Register for a notification in case it hasn't finished yet


        nx_api.notifier.registerForNotifications("uc.discovery.done", onDone); // 2. Query in case it finished already and we missed the notification

        nx_api.router.makeRequest({
          path: "/nx_api/discoveryStatus",
          method: "GET",
          success: function success(d) {
            if (d.discoveryDone) {
              onDone();
            }
          }
        });
      }
    }
  }, {
    key: "_buildGrid",
    value: function _buildGrid() {
      var getMediaPathFunc = null;
      var getGroupExpansionFunc = null;
      var onGroupExpansionChangedFunc = null;

      if (typeof nx_api !== "undefined") {
        getMediaPathFunc = this._getMediaPath.bind(this);
        getGroupExpansionFunc = this._getGroupExpansionStates.bind(this);
        onGroupExpansionChangedFunc = this._onGroupExpansionChanged.bind(this);
      }

      var gridViewElement = document.createElement('div');
      this._grid = new _grid.default(gridViewElement, {
        contentGridDelegate: this,
        contents: "presets",
        effectController: this,
        contentProvider: this._gridDataSource,
        effectOperations: null,
        getMediaPath: getMediaPathFunc,
        onGroupExpansionChanged: onGroupExpansionChangedFunc,
        getGroupExpansionStates: getGroupExpansionFunc
      });

      this._grid.addStyle('thumbnail-grid');

      this._grid.initialize();

      this._params.div.append($(gridViewElement));
    }
  }, {
    key: "_getMediaPath",
    value: function _getMediaPath(contentItem, originalUrl) {
      // We have set up subpath redirects in Neutrino that we'll use to load these assets
      var mediaPath = "";

      if (contentItem.isUserGenerated) {
        var mediaIdx = originalUrl.indexOf("_media");

        if (mediaIdx === -1) {
          return "";
        }

        mediaPath += "user_previews/" + originalUrl.slice(mediaIdx);
      } else {
        var subStr = "Universe/Presets/Plugins/";
        var nameIdx = originalUrl.indexOf(subStr);

        if (nameIdx === -1) {
          return "";
        }

        mediaPath += "stock_previews/" + originalUrl.slice(nameIdx + subStr.length);
      }

      return mediaPath;
    }
  }]);

  return Chooser;
}();

module.exports = {
  Chooser: Chooser,
  ChooserNotifications: ChooserNotifications
};

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(10));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(13));

var _content_change_context = _interopRequireDefault(__webpack_require__(14));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ContentStore =
/*#__PURE__*/
function () {
  function ContentStore(api, params) {
    _classCallCheck(this, ContentStore);

    this._api = api;
    this._content = [];

    this._contentProviderInit(params);

    this._contentFilterInit();

    this._incrementalChangeLimits = {
      updates: 100,
      removals: 100,
      additions: 0
    };
  }

  _createClass(ContentStore, [{
    key: "getContent",
    value: function getContent() {
      return this._content;
    }
  }, {
    key: "_doReload",
    value: function _doReload(changeContext) {
      var _this = this;

      var onLoaded = function onLoaded(d) {
        _this._onLoaded(d, changeContext);
      };

      return this._api.get(this._filter).then(onLoaded);
    }
  }, {
    key: "_onLoaded",
    value: function _onLoaded(d, changeContext) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        _this2._content = d;

        _this2._onContentChanged(changeContext);

        resolve(_this2);
      });
    } // ContentFilter

  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      this.invalidate();

      if (this.getChangeWatching()) {
        this.getChangeWatching().setFilter(this.getFilter());
      }
    } // ContentProvider

  }, {
    key: "_onWatchedChangesFound",
    value: function _onWatchedChangesFound(updates, removals, needsFullRefresh) {
      if (needsFullRefresh) {
        this.invalidate();
        return;
      } // See if the raw change is too big for us


      if (updates.length > this._incrementalChangeLimits.updates || removals.length > this._incrementalChangeLimits.removals) {
        this.invalidate();
        return;
      } // see if we can handle this directly or if a full refresh is actually needed


      var changeContext = this._digestWatchedChanges(this._content, updates, removals);

      if (!_content_change_context.default.WithinLimits(changeContext, this._incrementalChangeLimits)) {
        this.invalidate();
        return;
      }

      if (!_content_change_context.default.IsEmpty(changeContext)) {
        this._applyWatchedChanges(this._content, changeContext.details.updated, changeContext.details.removed);

        this._content = this._content.concat(changeContext.details.added);

        this._onContentChanged(changeContext);
      }
    }
  }]);

  return ContentStore;
}();

exports.default = ContentStore;

_content_provider_contract.default.asContentProvider(ContentStore.prototype);

_content_filter.default.asContentFilter(ContentStore.prototype);

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_predicates = _interopRequireDefault(__webpack_require__(11));

var _content_filter_utils = _interopRequireDefault(__webpack_require__(12));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentFilterAPI = {
  _contentFilterInit: function _contentFilterInit() {
    this._filter = {};
    this._filterEmpty = true;
    this._priorFilter = {};
    this._predicates = {};
  },
  filterItems: function filterItems(contentItemList, context) {
    if (this._filterEmpty) {
      return contentItemList.slice(0);
    }

    var f = [];

    for (var i = 0; i < contentItemList.length; i++) {
      if (this.doesItemPass(contentItemList[i], context)) {
        f.push(contentItemList[i]);
      }
    }

    return f;
  },
  // Override this to do something custom
  doesItemPass: function doesItemPass(contentItem, context) {
    if (this._filterEmpty) {
      return true;
    }

    var k, p, filter; // ContentItem must match every one of these

    for (var k in this._predicates) {
      if (this._predicates.hasOwnProperty(k)) {
        filter = {};
        filter[k] = this._predicates[k].f;
        p = this._predicates[k].p;

        if (!p(k, contentItem, filter, context)) {
          return false;
        }
      }
    }

    return true;
  },
  getFilter: function getFilter() {
    return this._filter;
  },
  createFilterCopy: function createFilterCopy() {
    return _content_filter_utils.default.deepCopy(this._filter);
  },
  setFilter: function setFilter(f, deferUpdate) {
    this._filter = f;

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  addFilter: function addFilter(filter, deferUpdate) {
    if (filter) {
      for (var k in filter) {
        if (filter.hasOwnProperty(k)) {
          this._filter[k] = filter[k];
        }
      }

      if (!deferUpdate) {
        this._onFiltersUpdated();
      }
    }
  },
  removeFilterKeys: function removeFilterKeys(keyList, deferUpdate) {
    for (var k = 0; k < keyList.length; k++) {
      delete this._filter[keyList[k]];
    }

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  clearFilters: function clearFilters(deferUpdate) {
    this._filter = {};

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  matchesFilter: function matchesFilter(f) {
    // brute-force approach to this
    try {
      var sMine = JSON.stringify(this._filter);
      var sOther = JSON.stringify(f);
      return sMine === sOther;
    } catch (err) {
      console.log("Error comparing filters");
      console.log(err);
    }

    return false; // to be safe
  },
  _onFiltersUpdated: function _onFiltersUpdated() {
    this._filterEmpty = _.keys(this._filter).length === 0; // Look up our predicate functions for easier processing

    this._predicates = {};

    for (var k in this._filter) {
      if (this._filter.hasOwnProperty(k)) {
        this._predicates[k] = {
          f: this._filter[k],
          p: _content_predicates.default.findPredicate(this._filter[k])
        };
      }
    } // See if anything meaningful actually changed


    var notifyOfChanges = !this.matchesFilter(this._priorFilter);
    this._priorFilter = this.createFilterCopy();

    if (notifyOfChanges) {
      this._handleFiltersUpdated();
    }
  },
  _handleFiltersUpdated: function _handleFiltersUpdated() {// Implement this to react when filters change
  }
};

var asContentFilter = function asContentFilter(target) {
  _.defaults(target, ContentFilterAPI);
};

var ContentFilter = {
  api: ContentFilterAPI,
  asContentFilter: asContentFilter
};
exports.default = ContentFilter;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ContentPredicates;
exports.default = ContentPredicates;
exports.default = ContentPredicates = {
  ///////////////////////////////////////
  // Helper Functions
  findPredicate: function findPredicate(filterEntry) {
    if (filterEntry && _typeof(filterEntry) === "object") {
      var keys = _.keys(filterEntry);

      for (var i = 0; i < keys.length; i++) {
        if (keys[i][0] === "_" && ContentPredicates[keys[i]]) {
          return ContentPredicates[keys[i]];
        }
      }
    }

    return ContentPredicates._equals;
  },
  addToAny: function addToAny(existing, value) {
    if (!existing) {
      existing = {
        _any: []
      };
    }

    existing._any.push(value);

    return existing;
  },
  addToNotAny: function addToNotAny(existing, value) {
    if (!existing) {
      existing = {
        _notAny: []
      };
    }

    existing._notAny.push(value);

    return existing;
  },
  ///////////////////////////////////////
  // Predicates
  // Exact match
  // filter[k] = anything
  _equals: function _equals(k, contentItem, filter, context) {
    return contentItem[k] === filter[k];
  },
  // Matches any provided
  // filter[k] = { _any:[array, of, anything] };
  _any: function _any(k, contentItem, filter, context) {
    for (var i = 0; i < filter[k]._any.length; i++) {
      if (contentItem[k] === filter[k]._any[i]) {
        return true;
      }
    }

    return false;
  },
  // Not equal
  // filter[k] = { _not:anything };
  _not: function _not(k, contentItem, filter, context) {
    return typeof contentItem[k] === "undefined" || contentItem[k] !== filter[k]._not;
  },
  // Not equal to any of these
  // filter[k] = { _notAny:[array, of, anything] };
  _notAny: function _notAny(k, contentItem, filter, context) {
    if (typeof contentItem[k] === "undefined") {
      return true;
    }

    for (var i = 0; i < filter[k]._notAny.length; i++) {
      if (contentItem[k] === filter[k]._notAny[i]) {
        return false;
      }
    }

    return true;
  },
  // Presence/absence of contentItem[k]
  // filter[k] = { _isSet:true|false };
  _isSet: function _isSet(k, contentItem, filter, context) {
    return typeof contentItem[k] === "undefined" !== filter[k]._isSet;
  },
  // Custom function/filter id
  // filter[k] = { _custom: { _id: "someId", _func: function(k, contentItem, filter, id, context) { return true; } } }
  _custom: function _custom(k, contentItem, filter, context) {
    return filter[k]._custom._func(k, contentItem, filter, filter[k]._custom._id, context);
  }
};

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ContentFilterUtils;
exports.default = ContentFilterUtils;
exports.default = ContentFilterUtils = {
  // Replacement for having to have a jQuery dependency via $.extend(true, {}, this._filter);
  // This doesn't handle cycles... but there shouldn't be any in a content filter.
  deepCopy: function deepCopy(input) {
    var output;

    if (input === null) {
      output = null;
    } else if (Array.isArray(input)) {
      output = [];

      for (var i = 0; i < input.length; i++) {
        output.push(ContentFilterUtils.deepCopy(input[i]));
      }
    } else if (input && _typeof(input) === "object") {
      output = {};

      for (var k in input) {
        if (input.hasOwnProperty(k)) {
          output[k] = ContentFilterUtils.deepCopy(input[k]);
        }
      }
    } else {
      output = input;
    }

    return output;
  }
};

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_change_context = _interopRequireDefault(__webpack_require__(14));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentProviderNotifications = {
  ChangePreview: "rg.cpc.content.change.preview",
  Changed: "rg.cpc.content.changed",
  Reloading: "rg.cpc.content.reloading"
};
var ContentProviderContractAPI = {
  _contentProviderInit: function _contentProviderInit(params) {
    var _this = this;

    if (!this.notifier) {
      this.notifier = new RG.utils.Notifier();
    }

    this._reloadPromise = null;
    var p = params ? params : {};

    _.defaults(p, {
      deferInit: false,
      // set to true to avoid any querying of the API until init() is called
      changeWatching: null
    });

    this._changeWatching = p.changeWatching ? p.changeWatching : null;

    if (this._changeWatching) {
      this._changeWatching.setChangeTrackingCallback(this._onWatchedChangesFound.bind(this));
    }

    this._didProviderInit = false;
    this._onProviderInit = null;
    this._providerInvalidated = false;
    this._providerInitPromise = new Promise(function (resolve, reject) {
      _this._onProviderInit = resolve;
    });

    if (!p.deferInit) {
      this.init();
    }
  },
  init: function init() {
    if (!this._didProviderInit) {
      this._didProviderInit = true;

      if (this._onProviderInit) {
        this._onProviderInit(); // allow any deferred operation to go through

      }

      if (this._changeWatching) {
        this._changeWatching.start();
      }
    }
  },
  // returns array of ContentItems
  getContent: function getContent() {
    throw "Interface implementor must implement getContent";
  },
  getContentLength: function getContentLength() {
    return this.getContent().length;
  },
  // register for this type with this.notifier to be informed before consumers handler the ContentItem change
  getChangePreviewNotificationType: function getChangePreviewNotificationType() {
    return ContentProviderNotifications.ChangePreview;
  },
  // register for this type with this.notifier to be informed when the ContentItem array contents change
  getChangedNotificationType: function getChangedNotificationType() {
    return ContentProviderNotifications.Changed;
  },
  // register for this type with this.notifier to be informed when reloading starts or ends
  // n = { sender: this, reloadPhase: "start"|"end"}
  getReloadingNotificationType: function getReloadingNotificationType() {
    return ContentProviderNotifications.Reloading;
  },
  getChangeWatching: function getChangeWatching() {
    return this._changeWatching;
  },
  // this will trigger a reload or queue one for after the current reload completes
  invalidate: function invalidate(changeContext) {
    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    this._providerInvalidated = true;
    this.reload(changeContext);
  },
  reload: function reload(changeContext) {
    var _this2 = this;

    if (this._reloadPromise) {
      return this._reloadPromise;
    }

    if (!this._didProviderInit) {
      return this._providerInitPromise.then(function () {
        return _this2.reload();
      });
    }

    if (this._providerInvalidated) {
      this._providerInvalidated = false;
    }

    this.notifier.postNotification(ContentProviderNotifications.Reloading, {
      sender: this,
      reloadPhase: "start"
    });
    this._reloadPromise = this._doReload(changeContext);

    this._reloadPromise.then(this._afterReload.bind(this)).catch(this._afterReload.bind(this));

    return this._reloadPromise;
  },
  _afterReload: function _afterReload() {
    this._reloadPromise = null;
    this.notifier.postNotification(ContentProviderNotifications.Reloading, {
      sender: this,
      reloadPhase: "end"
    });

    if (this._providerInvalidated) {
      this.reload();
    }
  },
  _onContentChanged: function _onContentChanged(changeContext) {
    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    this.notifier.postNotification(ContentProviderNotifications.ChangePreview, {
      sender: this,
      changeContext: changeContext
    });
    this.notifier.postNotification(ContentProviderNotifications.Changed, {
      sender: this,
      changeContext: changeContext
    });
  },
  // implement this to start the reload operation and return a promise
  // if the reload operation finds new content, call this._onContentChanged()
  _doReload: function _doReload(changeContext) {
    return new Promise(function (resolve, reject) {
      reject("This provider doesn't support reload");
    });
  },
  // override this to do something custom when changes are found
  _onWatchedChangesFound: function _onWatchedChangesFound(updates, removals, needsFullRefresh) {
    this.invalidate();
  },
  ////////////////////////////
  // utility methods to use from _onWatchedChangesFound()
  // produces a changeContext that can be passed to _onContentChanged
  _digestWatchedChanges: function _digestWatchedChanges(currentContent, updates, removals, identityProperty) {
    if (!identityProperty) {
      identityProperty = this._defaultCompareProperty;
    }

    var added = [];
    var updated = [];
    var removed = [];

    var removeIds = _.pluck(removals, identityProperty);

    var updateIds = _.pluck(updates, identityProperty);

    var addedIds = updateIds.slice(0);
    var rIdx;
    var uIdx;
    var nextId;
    var i;

    for (i = 0; i < currentContent.length; i++) {
      nextId = currentContent[i][identityProperty];
      rIdx = removeIds.indexOf(nextId);

      if (rIdx !== -1) {
        removed.push(removals[rIdx]);
      }

      uIdx = updateIds.indexOf(nextId);

      if (uIdx !== -1) {
        // We have it, so it's not an addition
        addedIds = _.without(addedIds, nextId);
        updated.push(updates[uIdx]);
      }
    } // Anything else we didn't touch is an addition


    if (addedIds.length > 0) {
      for (i = 0; i < updates.length; i++) {
        nextId = updates[i][identityProperty];
        uIdx = addedIds.indexOf(nextId);

        if (uIdx !== -1) {
          added.push(updates[i]);
        }
      }
    }

    return _content_change_context.default.Create(_content_change_context.default.ChangeSource.Data, added, updated, removed);
  },
  // finds matching items in currentContent and replaces/removes them from updates/removals
  _applyWatchedChanges: function _applyWatchedChanges(currentContent, updates, removals, identityProperty) {
    if (!identityProperty) {
      identityProperty = this._defaultCompareProperty;
    }

    var removeIds = _.pluck(removals, identityProperty);

    var updateIds = _.pluck(updates, identityProperty);

    var rIdx;
    var uIdx;
    var nextId;

    for (var i = 0; i < currentContent.length; i++) {
      nextId = currentContent[i][identityProperty]; // Updates

      uIdx = updateIds.indexOf(nextId);

      if (uIdx !== -1) {
        currentContent.splice(i, 1, updates[uIdx]);
      } // Removals


      rIdx = removeIds.indexOf(nextId);

      if (rIdx !== -1) {
        currentContent.splice(i, 1);
        i--;
      }
    }
  },
  _defaultCompareProperty: "_id"
};

var asContentProvider = function asContentProvider(target) {
  _.defaults(target, ContentProviderContractAPI);
};

var ContentProviderContract = {
  api: ContentProviderContractAPI,
  asContentProvider: asContentProvider
};
exports.default = ContentProviderContract;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var ContentChangeContext;
exports.default = ContentChangeContext;
exports.default = ContentChangeContext = {
  ChangeSource: {
    View: "view",
    // looking at different data source
    Data: "data",
    // change in the underlying data itself, e.g. live update
    Filter: "filter",
    // change in the filter applied to the data
    Format: "format" // change in the format applied to the data

  },
  GetChangeSource: function GetChangeSource(candidateSource) {
    if (candidateSource) {
      for (var k in ContentChangeContext.ChangeSource) {
        if (ContentChangeContext.ChangeSource.hasOwnProperty(k)) {
          if (ContentChangeContext.ChangeSource[k] === candidateSource) {
            return candidateSource;
          }
        }
      }
    }

    return ContentChangeContext.ChangeSource.Data;
  },

  /**
   * 
   * @param {ChangeSource} changeSource - optional - the source of the change
   * @param {array} added - optional - array of added items
   * @param {array} updated - optional - array of updated items
   * @param {array} removed - optional - array of removed items
   * @return {object} ChangeContext - see below
   * 
   * {
   * 	source: string - see ChangeSource
   * 	hasDetails: boolean,
   *  details: object - optional { 
   *  	addded: array,
   * 		updated: array,
   * 		removed: array
   *    }
   *  }
   * 	
   * 	MBL-2627
   * 	If hasDetails === false, this means something changed but no further information is available.
   * 	The correct action to take in response is a full refresh.
   * 
   */
  Create: function Create(changeSource, added, updated, removed) {
    var hasDetails = Array.isArray(added) || Array.isArray(updated) || Array.isArray(removed);
    var context = {
      source: ContentChangeContext.GetChangeSource(changeSource),
      hasDetails: hasDetails
    };

    if (hasDetails) {
      context.details = {
        added: Array.isArray(added) ? added : [],
        updated: Array.isArray(updated) ? updated : [],
        removed: Array.isArray(removed) ? removed : []
      };
    }

    return context;
  },

  /**
   * 
   * @param {ChangeContext} existingContext 
   */
  Copy: function Copy(existingContext) {
    if (existingContext.hasDetails) {
      var _existingContext$deta = existingContext.details,
          added = _existingContext$deta.added,
          updated = _existingContext$deta.updated,
          removed = _existingContext$deta.removed;
      return ContentChangeContext.Create(existingContext.source, added.slice(0), updated.slice(0), removed.slice(0));
    }

    return ContentChangeContext.Create(existingContext.source);
  },

  /**
   * 
   * @param {ChangeContext} changeContext 
   * @return {boolean} true if the change has details but no additions, updates, or removals. False otherwise.
   */
  IsEmpty: function IsEmpty(changeContext) {
    // If no change details are known, we cannot say that the change is empty
    if (!changeContext.hasDetails) {
      return false;
    }

    var _changeContext$detail = changeContext.details,
        added = _changeContext$detail.added,
        updated = _changeContext$detail.updated,
        removed = _changeContext$detail.removed;
    return added.length === 0 && updated.length === 0 && removed.length === 0;
  },

  /**
   * 
   * @param {ChangeContext} changeContext 
   * @param {object} changeLimits - object with optional numeric fields "updates, additions, removals"
   * @return {boolean} - true if the details of changeContext are within the specified limits
   */
  WithinLimits: function WithinLimits(changeContext, changeLimits) {
    // If no change details are known, we cannot say whether it is within the limits
    if (!changeContext.hasDetails) {
      return false;
    }

    if (!changeLimits) {
      return true;
    }

    if (changeLimits.hasOwnProperty("updates") && changeContext.details.updated.length > changeLimits.updates) {
      return false;
    }

    if (changeLimits.hasOwnProperty("removals") && changeContext.details.removed.length > changeLimits.removals) {
      return false;
    }

    if (changeLimits.hasOwnProperty("additions") && changeContext.details.added.length > changeLimits.additions) {
      return false;
    }

    return true;
  }
};

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(10));

var _content_consumer = _interopRequireDefault(__webpack_require__(16));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(13));

var _content_change_context = _interopRequireDefault(__webpack_require__(14));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var FilteredContentProvider =
/*#__PURE__*/
function () {
  function FilteredContentProvider(params) {
    _classCallCheck(this, FilteredContentProvider);

    this._params = params ? params : {};

    _.defaults(this._params, {
      filterContext: null,
      filter: {},
      contentProvider: null
    });

    this._content = [];

    this._contentProviderInit();

    this._contentFilterInit();

    this._incrementalChangeLimits = {
      updates: 100,
      removals: 100,
      additions: 1
    };
    this.addFilter(this._params.filter);

    if (this._params.contentProvider) {
      this.setContentProvider(this._params.contentProvider);
    }
  } // Content Proivder


  _createClass(FilteredContentProvider, [{
    key: "getContent",
    value: function getContent() {
      return this._content;
    }
  }, {
    key: "_doReload",
    value: function _doReload(changeContext) {
      var _this = this;

      if (this._contentProvider) {
        // We will refresh when the upstream provider does
        return this._contentProvider.reload(changeContext);
      } // Otherwise just refresh locally


      return new Promise(function (resolve, reject) {
        _this.refresh(changeContext);

        resolve(_this);
      });
    } // Content Consumer

  }, {
    key: "refresh",
    value: function refresh(changeContext) {
      if (this._contentProvider) {
        this._content = this.filterItems(this._contentProvider.getContent(), this._params.filterContext);
      } else {
        this._content = [];
      }

      this._onContentChanged(changeContext);
    } // Content Filter

  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      this.refresh(_content_change_context.default.Create(_content_change_context.default.ChangeSource.Filter));

      if (this.getChangeWatching()) {
        this.getChangeWatching().setFilter(this.getFilter());
      }
    }
  }, {
    key: "_handleIncrementalContentChange",
    value: function _handleIncrementalContentChange(changeContext) {
      if (!changeContext.hasDetails) {
        // Not the kind of change we understand
        return false;
      }

      if (!_content_change_context.default.WithinLimits(changeContext, this._incrementalChangeLimits)) {
        // Change is too big
        return false;
      }

      var forwardContext;

      if (this._filterEmpty) {
        forwardContext = _content_change_context.default.Copy(changeContext);
      } else {
        forwardContext = _content_change_context.default.Create(changeContext.source, [], [], []); // We need to figure out our own additions/updates/removals based on filtering

        var i;
        var alreadyPresent;
        var identityProperty = this._defaultCompareProperty;

        var currentIds = _.pluck(this._content, identityProperty);

        var nextItem; // Additions

        for (i = 0; i < changeContext.details.added.length; i++) {
          if (this.doesItemPass(changeContext.details.added[i], this._params.filterContext)) {
            forwardContext.details.added.push(changeContext.details.added[i]);
          }
        } // Updates


        for (i = 0; i < changeContext.details.updated.length; i++) {
          nextItem = changeContext.details.updated[i];
          var alreadyPresent = currentIds.indexOf(nextItem[identityProperty]) !== -1;

          if (this.doesItemPass(nextItem, this._params.filterContext)) {
            if (alreadyPresent) {
              forwardContext.details.updated.push(nextItem);
            } else {
              forwardContext.details.added.push(nextItem);
            }
          } else if (alreadyPresent) {
            forwardContext.details.removed.push(nextItem);
          }
        } // Removals


        for (i = 0; i < changeContext.details.removed.length; i++) {
          nextItem = changeContext.details.removed[i];
          var alreadyPresent = currentIds.indexOf(nextItem[identityProperty]) !== -1;

          if (alreadyPresent) {
            forwardContext.details.removed.push(nextItem);
          }
        }
      }

      if (!_content_change_context.default.WithinLimits(forwardContext, this._incrementalChangeLimits)) {
        // Change is too big
        return false;
      }

      this._applyWatchedChanges(this._content, forwardContext.details.updated, forwardContext.details.removed);

      this._content = this._content.concat(forwardContext.details.added);

      this._onContentChanged(forwardContext);

      return true;
    }
  }]);

  return FilteredContentProvider;
}();

exports.default = FilteredContentProvider;

_content_provider_contract.default.asContentProvider(FilteredContentProvider.prototype);

_content_consumer.default.asContentConsumer(FilteredContentProvider.prototype);

_content_filter.default.asContentFilter(FilteredContentProvider.prototype);

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_change_context = _interopRequireDefault(__webpack_require__(14));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentConsumerAPI = {
  setContentProvider: function setContentProvider(cp) {
    if (this._contentProvider) {
      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);

      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getChangedNotificationType(), this.onContentUpdated, this);

      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getReloadingNotificationType(), this.onContentReloading, this);
    }

    this._contentProvider = cp;

    if (this._contentProvider) {
      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);

      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getChangedNotificationType(), this.onContentUpdated, this);

      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getReloadingNotificationType(), this.onContentReloading, this);
    }

    this.refresh(_content_change_context.default.Create(_content_change_context.default.ChangeSource.View));
  },
  getContentProvider: function getContentProvider() {
    return this._contentProvider;
  },
  // Prefer setContentProvider unless you need to listen to multiple content streams
  addContentProvider: function addContentProvider(cp) {
    if (cp) {
      cp.notifier.registerForNotificationsWithTarget(cp.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);
      cp.notifier.registerForNotificationsWithTarget(cp.getChangedNotificationType(), this.onContentUpdated, this);
      cp.notifier.registerForNotificationsWithTarget(cp.getReloadingNotificationType(), this.onContentReloading, this);
    }
  },
  // Prefer setContentProvider unless you need to listen to multiple content streams
  removeContentProvider: function removeContentProvider(cp) {
    if (cp) {
      cp.notifier.deregisterForNotificationsWithTarget(cp.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);
      cp.notifier.deregisterForNotificationsWithTarget(cp.getChangedNotificationType(), this.onContentUpdated, this);
      cp.notifier.deregisterForNotificationsWithTarget(cp.getReloadingNotificationType(), this.onContentReloading, this);
    }
  },
  // Optional method called when new content is found.
  // Implementer can provide a version of this to perfrom whatever updates are needed.
  refresh: function refresh(changeContext) {// ...
  },
  // Optinal method called during provider reload
  // Implementor can perform custom actions here to show reloading state
  // check n.data.reloadPhase for details
  onContentReloading: function onContentReloading(n) {// ...
  },
  // Optional method called before onContentUpdated
  // Use to peek at changes before they flow through the system
  onContentUpdatedPreview: function onContentUpdatedPreview(n) {// ...
  },
  onContentUpdated: function onContentUpdated(n) {
    var changeContext = null;

    if (n && n.data) {
      changeContext = n.data.changeContext;
    }

    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    if (changeContext.hasDetails) {
      if (this._handleIncrementalContentChange(changeContext)) {
        return;
      }
    } // If we were not able to do an incremental change, drop the details and go to full refresh


    this.refresh(_content_change_context.default.Create(changeContext.source));
  },
  // Override this to do incremental updates in response to content change notifications
  // return true if you handled the change
  _handleIncrementalContentChange: function _handleIncrementalContentChange(changeContext) {
    return false;
  }
};

var asContentConsumer = function asContentConsumer(target) {
  _.defaults(target, ContentConsumerAPI);
};

var ContentConsumer = {
  api: ContentConsumerAPI,
  asContentConsumer: asContentConsumer
};
exports.default = ContentConsumer;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(10));

var _content_filter_utils = _interopRequireDefault(__webpack_require__(12));

var _content_watching = _interopRequireDefault(__webpack_require__(18));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ChangeEvents = {
  create: "cb.api.json.create",
  update: "cb.api.json.update",
  remove: "cb.api.json.remove"
};

var ContentAPIJson =
/*#__PURE__*/
function () {
  function ContentAPIJson(content) {
    _classCallCheck(this, ContentAPIJson);

    this._exposeRawItems = false;
    this._content = [];

    if (content) {
      if (typeof content === "string") {
        this._content = JSON.parse(content);
      } else {
        this._content = content;
      }
    }

    var c;

    for (var i = 0; i < this._content.length; i++) {
      c = this._content[i];

      if (!c._id) {
        c._id = RG.Uuid.create();
      }
    }

    this._notifier = new RG.utils.Notifier();
  }
  /**
   * Control whether a get() will return copies of the underlying ContentItems (default) or
   * the actual items. 
   * 
   * Returning copies is more in-line with with the actual ContentAPI would do (ideal for 
   * mock data), but is less efficient, so it can be turned off for use in production, assuming
   * you know what you're doing.
   * 
   */


  _createClass(ContentAPIJson, [{
    key: "setShouldExposeRawItems",
    value: function setShouldExposeRawItems(expose) {
      this._exposeRawItems = expose;
    }
    /**
     * Query items that match filter, organized by format
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "get",
    value: function get(filter, format) {
      this.setFilter(filter);
      var results = this.filterItems(this._content);

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        resolve(results);
      });
    }
    /**
     * Create a new item from contentItem
     * @return a promise that fulfills with a single created contentItem
     */

  }, {
    key: "create",
    value: function create(contentItem) {
      var _this = this;

      if (!contentItem) {
        return Promise.reject(new Error("400 bad request"));
      }

      var result = null;

      if (this._exposeRawItems) {
        contentItem._id = RG.Uuid.create();

        this._content.push(contentItem);

        result = contentItem;
      } else {
        var result = _content_filter_utils.default.deepCopy(contentItem);

        result._id = RG.Uuid.create();

        this._content.push(result);

        result = _content_filter_utils.default.deepCopy(result);
      }

      return new Promise(function (resolve, reject) {
        _this._notifyChanges(ChangeEvents.create, result); // Resolve


        resolve(result);
      });
    }
    /**
     * Update a single contentItem
     * @return a promise that fulfills with a single updated contentItem
     */

  }, {
    key: "update",
    value: function update(contentItem) {
      return this.updateAll([contentItem]).then(function (contentList) {
        return contentList[0];
      });
    }
    /**
     * Update all matching items
     * @param filter the filter the existing items must match to be updated
     * @param changes a json object of key-values to be applied to all matching items
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateWhere",
    value: function updateWhere(filter, modifier) {
      var _this2 = this;

      this.setFilter(filter);
      var results = this.filterItems(this._content); // safety check

      if (modifier.hasOwnProperty("_id")) {
        delete modifier._id;
      } // make changes


      for (var i = 0; i < results.length; i++) {
        _.extend(results[i], modifier);
      }

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        _this2._notifyChanges(ChangeEvents.update, results);

        resolve(results);
      });
    }
    /**
     * Update a list of items - like update() but takes an array
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateAll",
    value: function updateAll(contentList) {
      var _this3 = this;

      var map = this._buildMap(contentList); // Ensure we have everything


      var foundCount = 0;

      for (var i = 0; i < this._content.length; i++) {
        if (map.hasOwnProperty(this._content[i]._id)) {
          foundCount++;
        }
      }

      if (foundCount !== contentList.length) {
        // Asked to update something invalid
        return Promise.reject(new Error("404 not found"));
      }

      var results = [];

      for (var _i = 0; _i < this._content.length; _i++) {
        if (map.hasOwnProperty(this._content[_i]._id)) {
          _.extend(this._content[_i], map[this._content[_i]._id]);

          results.push(this._content[_i]);
        }
      }

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        _this3._notifyChanges(ChangeEvents.update, results);

        resolve(results);
      });
    }
    /**
     * Delete an item
     * @param contentItem must contain _id - all other fields ignored
     * @return a promise that fulfills with a single removed of contentItem
     */

  }, {
    key: "delete",
    value: function _delete(contentItem) {
      var _this4 = this;

      if (!contentItem || typeof contentItem._id === "undefined") {
        return Promise.reject(new Error("400 bad request"));
      }

      var result = null;
      var uuid = contentItem._id;

      for (var i = 0; i < this._content.length; i++) {
        if (this._content[i]._id === uuid) {
          result = this._content[i];

          this._content.splice(i, 1);

          break;
        }
      }

      if (!result) {
        return Promise.reject(new Error("404 not found"));
      }

      if (!this._exposeRawItems) {
        result = _content_filter_utils.default.deepCopy(result);
      }

      return new Promise(function (resolve, reject) {
        _this4._notifyChanges(ChangeEvents.remove, result);

        resolve(result);
      });
    }
  }, {
    key: "_buildMap",
    value: function _buildMap(contentList) {
      return _.indexBy(contentList, "_id");
    } ////////////////////////////////////
    // ContentWatching

  }, {
    key: "createContentWatcher",
    value: function createContentWatcher() {
      return new _content_watching.default(this, ChangeEvents.create, ChangeEvents.update, ChangeEvents.remove);
    }
  }, {
    key: "addListener",
    value: function addListener(eventName, callback) {
      this._notifier.registerForNotifications(eventName, function (n) {
        callback(n.data);
      });
    }
  }, {
    key: "_notifyChanges",
    value: function _notifyChanges(event, changes) {
      var _this5 = this;

      var changedItems = [];

      if (Array.isArray(changes)) {
        changedItems = changes.slice(0);
      } else {
        changedItems = [changes];
      }

      if (!this._exposeRawItems) {
        changedItems = _content_filter_utils.default.deepCopy(changedItems);
      }

      var n = {
        content: changedItems
      };

      _.defer(function () {
        _this5._notifier.postNotification(event, n);
      });
    }
  }]);

  return ContentAPIJson;
}();

exports.default = ContentAPIJson;

_content_filter.default.asContentFilter(ContentAPIJson.prototype);

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _change_tracking = _interopRequireDefault(__webpack_require__(19));

var _content_filter = _interopRequireDefault(__webpack_require__(10));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ContentWatching =
/*#__PURE__*/
function () {
  function ContentWatching(api, createEventName, updateEventName, removeEventName) {
    _classCallCheck(this, ContentWatching);

    this._changeTrackingInit();

    api.addListener(createEventName, this._onContentCreated.bind(this));
    api.addListener(updateEventName, this._onContentUpdated.bind(this));
    api.addListener(removeEventName, this._onContentRemoved.bind(this));
  }

  _createClass(ContentWatching, [{
    key: "_onChangeTrackingStart",
    value: function _onChangeTrackingStart() {
      if (this.isChangeTrackingInvalid()) {
        this.refreshChangeTracking();
      }
    }
  }, {
    key: "_onContentCreated",
    value: function _onContentCreated(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.updates = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }, {
    key: "_onContentUpdated",
    value: function _onContentUpdated(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.updates = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }, {
    key: "_onContentRemoved",
    value: function _onContentRemoved(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.removals = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }]);

  return ContentWatching;
}();

exports.default = ContentWatching;

_change_tracking.default.asChangeTracking(ContentWatching.prototype);

_content_filter.default.asContentFilter(ContentWatching.prototype);

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var ChangeTrackingAPI = {
  _changeTrackingInit: function _changeTrackingInit(params) {
    this._changeTrackingActive = false;
    this._changeTrackingInvalidated = false;
    this._changeTrackingCallback = null;
  },
  // callback = function(updates, removals, needsFullRefresh) { }
  setChangeTrackingCallback: function setChangeTrackingCallback(callback) {
    this._changeTrackingCallback = callback;
  },
  start: function start() {
    if (!this._changeTrackingActive) {
      this._changeTrackingActive = true;

      this._onChangeTrackingStart();
    }
  },
  stop: function stop() {
    if (this._changeTrackingActive) {
      this._changeTrackingActive = false;

      this._onChangeTrackingStop();
    }
  },
  isChangeTrackingActive: function isChangeTrackingActive() {
    return this._changeTrackingActive;
  },
  isChangeTrackingInvalid: function isChangeTrackingInvalid() {
    return this._changeTrackingInvalidated;
  },
  // call when something changes and the current request should be discarded
  invalidateChangeTracking: function invalidateChangeTracking() {
    this._changeTrackingInvalidated = true;
  },
  refreshChangeTracking: function refreshChangeTracking() {
    try {
      if (this._changeTrackingCallback) {
        this._changeTrackingCallback(null, null, true);
      }

      this._changeTrackingInvalidated = false;
    } catch (err) {
      console.log("Error refreshing change tracking:");
      console.log(err);
    }
  },
  _onChangeTrackingStart: function _onChangeTrackingStart() {},
  _onChangeTrackingStop: function _onChangeTrackingStop() {},
  _handleChangeTrackingResult: function _handleChangeTrackingResult(result) {
    try {
      if (result.updates.length > 0 || result.removals.length > 0) {
        if (this._changeTrackingCallback) {
          this._changeTrackingCallback(result.updates, result.removals, false);
        }
      }
    } catch (err) {
      console.log("Error handling change tracking results:");
      console.log(err);
    }
  }
};

var asChangeTracking = function asChangeTracking(target) {
  _.defaults(target, ChangeTrackingAPI);
};

var ChangeTracking = {
  api: ChangeTrackingAPI,
  asChangeTracking: asChangeTracking
};
exports.default = ChangeTracking;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*

    apiTransport must implement:    
        function: makeRequest({method:"GET", path:"get", data:{}, success:function, failure:function });

*/
var ContentAPI =
/*#__PURE__*/
function () {
  function ContentAPI(apiTransport) {
    _classCallCheck(this, ContentAPI);

    this._transport = apiTransport;
  }
  /**
   * Query items that match filter, organized by format
   * @return a promise that fulfills with an array of contentItems
   */


  _createClass(ContentAPI, [{
    key: "get",
    value: function get(filter, format) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        if (!_this._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "GET",
          path: "get" + _this._getFilterParam(filter),
          success: function success(d) {
            return resolve(_this._processContent(d));
          },
          failure: reject
        };

        _this._transport.makeRequest(requestParams);
      });
    }
    /**
     * Create a new item from contentItem
     * @return a promise that fulfills with a single created contentItem
     */

  }, {
    key: "create",
    value: function create(contentItem) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        if (!_this2._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "POST",
          path: "create",
          data: contentItem,
          success: function success(d) {
            return resolve(_this2._processSingleItem(d));
          },
          failure: reject
        };

        _this2._transport.makeRequest(requestParams);
      });
    }
    /**
     * Update a single contentItem
     * @return a promise that fulfills with a single updated contentItem
     */

  }, {
    key: "update",
    value: function update(contentItem) {
      var _this3 = this;

      return new Promise(function (resolve, reject) {
        if (!_this3._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "PUT",
          path: "update",
          data: contentItem,
          success: function success(d) {
            return resolve(_this3._processSingleItem(d));
          },
          failure: reject
        };

        _this3._transport.makeRequest(requestParams);
      });
    }
    /**
     * Update all matching items
     * @param filter the filter the existing items must match to be updated
     * @param changes a json object of key-values to be applied to all matching items
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateWhere",
    value: function updateWhere(filter, changes) {
      var _this4 = this;

      return new Promise(function (resolve, reject) {
        if (!_this4._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "PUT",
          path: "updateWhere",
          data: {
            filter: filter,
            changes: changes
          },
          success: function success(d) {
            return resolve(_this4._processContent(d));
          },
          failure: reject
        };

        _this4._transport.makeRequest(requestParams);
      });
    }
    /**
     * Update a list of items - like update() but takes an array
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateAll",
    value: function updateAll(contentList) {
      var _this5 = this;

      return new Promise(function (resolve, reject) {
        if (!_this5._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "PUT",
          path: "updateAll",
          data: {
            content: contentList
          },
          success: function success(d) {
            return resolve(_this5._processContent(d));
          },
          failure: reject
        };

        _this5._transport.makeRequest(requestParams);
      });
    }
    /**
     * Delete an item
     * @param contentItem must contain _id - all other fields ignored
     * @return a promise that fulfills with a single removed of contentItem
     */

  }, {
    key: "delete",
    value: function _delete(contentItem) {
      var _this6 = this;

      return new Promise(function (resolve, reject) {
        if (!_this6._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "POST",
          path: "delete",
          data: contentItem,
          success: function success(d) {
            return resolve(_this6._processSingleItem(d));
          },
          failure: reject
        };

        _this6._transport.makeRequest(requestParams);
      });
    }
  }, {
    key: "_processSingleItem",
    value: function _processSingleItem(rawResult) {
      var r = rawResult;

      try {
        if (typeof rawResult === "string") {
          r = JSON.parse(rawResult);
        }
      } catch (err) {
        console.log("Error handling content result");
        console.log(err);
        r = {};
      }

      return r;
    }
  }, {
    key: "_processContent",
    value: function _processContent(rawResult) {
      var r = rawResult;

      try {
        if (typeof rawResult === "string") {
          r = JSON.parse(rawResult);
        }

        if (_typeof(r) === "object" && typeof r.content !== "undefined" && r.content.constructor === Array) {
          r = r.content;
        }
      } catch (err) {
        console.log("Error handling content result");
        console.log(err);
        r = [];
      }

      return r;
    }
  }, {
    key: "_getFilterParam",
    value: function _getFilterParam(filter) {
      var filterParam = "";

      if (_typeof(filter) === "object") {
        try {
          var filterStr = JSON.stringify(filter);
          filterStr = encodeURIComponent(filterStr);
          filterParam = "?filter=" + filterStr;
        } catch (err) {
          console.log("Queried with invalid filter");
          console.log(err);
          console.log(filter);
        }
      }

      return filterParam;
    }
  }]);

  return ContentAPI;
}();

exports.default = ContentAPI;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _change_tracking = _interopRequireDefault(__webpack_require__(19));

var _content_filter = _interopRequireDefault(__webpack_require__(10));

var _content_polling = _interopRequireDefault(__webpack_require__(22));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ContentPollingMQPredicates = {
  Removed: "_removed",
  From: "_modifiedAfter",
  To: "_modifiedBefore"
};

var ContentPollingMetaQ =
/*#__PURE__*/
function () {
  function ContentPollingMetaQ(api, params) {
    _classCallCheck(this, ContentPollingMetaQ);

    this._api = api;
    this._params = params ? params : {};

    _.defaults(this._params, {
      pollingIntervalMS: 2000
    });

    this._pollingInit(this._params);

    this._intervalStart = 0;
    this._intervalEnd = 0;
  }

  _createClass(ContentPollingMetaQ, [{
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      // invalidate any in-flight query
      this.invalidateChangeTracking();
    }
  }, {
    key: "_onChangeTrackingStart",
    value: function _onChangeTrackingStart() {
      if (this._intervalStart === 0) {
        this._intervalStart = this._getCurrentTimeSeconds();
      }

      this._schedulePoll();
    }
  }, {
    key: "_doPolling",
    value: function _doPolling() {
      var _this = this;

      return new Promise(function (resolve, reject) {
        if (!_this._api) {
          reject("No api set for polling");
          return;
        }

        _this._intervalEnd = _this._getCurrentTimeSeconds();

        var filter = _this._prepareQueryFilter(); // console.log("Getting changes between: "+this._intervalStart +" and "+this._intervalEnd);
        // console.log(filter); 


        _this._api.get(filter).then(function (updates) {
          filter[ContentPollingMQPredicates.Removed] = true;

          _this._api.get(filter).then(function (removals) {
            resolve({
              updates: updates,
              removals: removals
            });
          }).catch(reject);
        }).catch(reject);
      });
    }
  }, {
    key: "_processPollingResults",
    value: function _processPollingResults(results) {
      // Update our time window for next time;
      this._intervalStart = this._intervalEnd;
    }
  }, {
    key: "_getCurrentTimeSeconds",
    value: function _getCurrentTimeSeconds() {
      var milliseconds = new Date().getTime();
      var utcSeconds = Math.floor(milliseconds / 1000);
      return utcSeconds;
    }
  }, {
    key: "_prepareQueryFilter",
    value: function _prepareQueryFilter() {
      var timeFilter = this.createFilterCopy();
      timeFilter[ContentPollingMQPredicates.From] = this._intervalStart;
      timeFilter[ContentPollingMQPredicates.To] = this._intervalEnd;
      return timeFilter;
    }
  }]);

  return ContentPollingMetaQ;
}();

exports.default = ContentPollingMetaQ;

_content_polling.default.asContentPolling(ContentPollingMetaQ.prototype);

_change_tracking.default.asChangeTracking(ContentPollingMetaQ.prototype);

_content_filter.default.asContentFilter(ContentPollingMetaQ.prototype);

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _change_tracking = _interopRequireDefault(__webpack_require__(19));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentPollingAPI = {
  _pollingInit: function _pollingInit(params) {
    this._changeTrackingInit(params);

    params = params ? params : {};

    _.defaults(params, {
      pollingIntervalMS: 2000
    });

    this._pollingIntervalMS = params.pollingIntervalMS;
  },
  //////////////////////////////////
  // Methods to override
  // Implement this to do any pre-processing of results before they are handed to the callback
  _processPollingResults: function _processPollingResults(results) {},
  // Be notified when polling starts
  _onChangeTrackingStart: function _onChangeTrackingStart() {
    this._schedulePoll();
  },
  // Be notified when polling stops
  _onChangeTrackingStop: function _onChangeTrackingStop() {},
  //////////////////////////////////
  // Polling implementation
  _schedulePoll: function _schedulePoll() {
    var _this = this;

    if (this._changeTrackingInvalidated) {
      this._changeTrackingInvalidated = false;
    }

    _.delay(function () {
      if (_this._changeTrackingActive) {
        _this._doPolling().then(function (result) {
          if (!_this._changeTrackingActive) {
            return;
          }

          if (!_this._changeTrackingInvalidated) {
            _this._handlePollingResult(result);
          }

          _this._schedulePoll();
        }).catch(function (err) {
          console.log("Polling attempt resulted in error:");
          console.log(err);

          _this._schedulePoll();
        });
      }
    }, this._pollingIntervalMS);
  },
  // Implement this to do the actual polling
  _doPolling: function _doPolling() {
    return new Promise(function (resolved, rejected) {
      resolved({
        updates: [],
        removals: []
      });
    });
  },
  _handlePollingResult: function _handlePollingResult(result) {
    this._processPollingResults(result);

    this._handleChangeTrackingResult(result);
  }
};

var asContentPolling = function asContentPolling(target) {
  _.defaults(target, ContentPollingAPI);
};

var ContentPolling = {
  api: ContentPollingAPI,
  asContentPolling: asContentPolling
};
exports.default = ContentPolling;

_change_tracking.default.asChangeTracking(ContentPolling.prototype);

/***/ }),
/* 23 */
/***/ (function(module) {

module.exports = [{"versionAdded":"2.1","name":"uni.Title Motion","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Utilities_Title_Motion/","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"effectId":"Universe_Utilities_Title_Motion","displayName":"Title Motion","category":"Universe Text"},{"versionAdded":"2.1","name":"uni.Ecto","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Text_Ecto/","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":true,"isAdobeInstalled":true,"lastUsed":1540220401,"effectId":"Universe_Text_Ecto","displayName":"Ecto","category":"Universe Text"},{"versionAdded":"2.0","name":"uni.Glow","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Glow_Glow/","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"effectId":"Universe_Glow_Glow","displayName":"Glow","category":"Universe Glow"},{"versionAdded":"2.0","name":"uni.Glo Fi","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Glow_Glo_Fi_Premium/","kind":"effect","isLegacy":false,"isInstalled":false,"isFavorited":false,"isAdobeInstalled":false,"effectId":"Universe_Glow_Glo_Fi_Premium","displayName":"Glo Fi","category":"Universe Glow"},{"versionAdded":"2.2","name":"uni.VHS","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Stylize_VHS/","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"lastUsed":1540220580,"effectId":"Universe_Stylize_VHS","displayName":"VHS","category":"Universe Stylize"},{"versionAdded":"2.1","name":"uni.Line","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Motion_Graphics_Draw_Path/","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"effectId":"Universe_Motion_Graphics_Draw_Path","displayName":"Line","category":"Universe Motion Graphics"},{"versionAdded":"N/A","name":"uni.Edge Glow Legacy","mediaPath":"/Users/Shared/Red Giant/Dashboard/plugins/profiles/universe/Universe_Glow_Edge_Glow/","kind":"effect","isLegacy":true,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"effectId":"Universe_Glow_Edge_Glow","displayName":"Edge Glow Legacy","category":"Universe Legacy"},{"videoPath":"/Users/Shared/Red Giant/ProductAtlas/plugins/profiles/universe/Universe_Blur_Blur_Premium/plugin-preview","versionAdded":"2.0","pluginFileName":"Universe_Blur_Blur_Premium","name":"uni.Blur","kind":"effect","isLegacy":false,"isInstalled":true,"isFavorited":false,"isAdobeInstalled":true,"imagePath":"/Users/Shared/Red Giant/ProductAtlas/plugins/profiles/universe/Universe_Blur_Blur_Premium/plugin-thumbnail","effectId":"Universe_Blur_Blur_Premium","displayName":"Blur","description":"A simple, high quality blur effect that can work in linear gamma space.","category":"Universe Blur","mediaPath":"/Users/Shared/Red Giant/ProductAtlas/plugins/profiles/universe/Universe_Blur_Blur_Premium/","lastUsed":1540550110},{"name":"A Test Preset","kind":"preset","effectId":"Universe_Stylize_VHS","isUserGenerated":true,"path":"/Users/ian/Documents/Red Giant/Universe/Presets/A Test Preset.rgx"},{"name":"Default","kind":"preset","effectId":"Universe_Stylize_VHS","isUserGenerated":false,"path":"/Library/Application Support/Red Giant/Universe/Plugins/Universe_Stylize_VHS/Resources/Presets/Default.rgx"},{"name":"Color Error","kind":"preset","effectId":"Universe_Stylize_VHS","isUserGenerated":false,"path":"/Library/Application Support/Red Giant/Universe/Plugins/Universe_Stylize_VHS/Resources/Presets/Color_Error.rgx"},{"name":"Bad Tracking","kind":"preset","effectId":"Universe_Stylize_VHS","isUserGenerated":false,"path":"/Library/Application Support/Red Giant/Universe/Plugins/Universe_Stylize_VHS/Resources/Presets/Bad_Tracking.rgx"},{"name":"Default","kind":"preset","effectId":"Universe_Blur_Blur_Premium","path":"/Library/Application Support/Red Giant/Universe/Plugins/Universe_Blur_Blur_Premium/Resources/Presets/Default.rgx","isUserGenerated":false}];

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _content_grid = _interopRequireDefault(__webpack_require__(25));

var _content_arranger_simple = __webpack_require__(28);

var _filtered_content_provider = _interopRequireDefault(__webpack_require__(15));

var _effectGridStyler = _interopRequireDefault(__webpack_require__(30));

var _presetGridStyler = _interopRequireDefault(__webpack_require__(52));

var _presetGridArranger = _interopRequireDefault(__webpack_require__(55));

var _display_strings = _interopRequireDefault(__webpack_require__(56));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Grid =
/*#__PURE__*/
function () {
  function Grid(element, params) {
    _classCallCheck(this, Grid);

    if (element == null || element == undefined) {
      throw "Element cannot be null.";
    }

    this._params = params ? params : {};

    _.defaults(this._params, {
      contentGridDelegate: null,
      contentProvider: null,
      effectController: null,
      effectOperations: null,
      contents: "effects",
      onGroupExpansionChanged: null
    });

    this._element = element;
    this._contentGrid = null;

    if (!this._params.contentProvider) {
      this._params.contentProvider = new _filtered_content_provider.default();
    }

    var filter = {};

    if (this._params.contents === "effects") {
      filter = {
        kind: "effect"
      };
    } else if (this._params.contents === "presets") {
      filter = {
        kind: "preset"
      };
    }

    this._params.contentProvider.setFilter(filter);
  }

  _createClass(Grid, [{
    key: "initialize",
    value: function initialize() {
      var _this = this;

      var gridDiv = $(this._element);
      gridDiv.addClass('uni-content-grid');

      if (this._params.contents === "effects") {
        gridDiv.addClass('uni-effect-grid');
      }

      if (this._params.contents === "presets") {
        gridDiv.addClass('uni-preset-grid');
      }

      this._arranger = this._createContentArranger();

      if (this._params.getGroupExpansionStates !== undefined) {
        this._arranger = _.extend(this._arranger, {
          getGroupExpansionStates: this._params.getGroupExpansionStates
        });
      }

      var styler = this._createStyler();

      var contentGridParams = {
        delegate: this._params.contentGridDelegate,
        contentProvider: this._params.contentProvider,
        contentArranger: this._arranger,
        gridStyler: styler,
        gridSelectionClass: 'grid-item-selected',
        gridBaseAppearanceClass: "",
        onGroupExpansionChanged: this._params.onGroupExpansionChanged
      };
      this._contentGrid = new _content_grid.default(contentGridParams);
      gridDiv.append(this._contentGrid.getDiv());
      RG.ui.tooltips.registerTooltipCallback('uni_grid_item', function (params) {
        return _this._getTooltip(params);
      });
    }
  }, {
    key: "getContentGrid",
    value: function getContentGrid() {
      return this._contentGrid;
    }
  }, {
    key: "getContentProvider",
    value: function getContentProvider() {
      return this._params.contentProvider;
    }
  }, {
    key: "addStyle",
    value: function addStyle(style) {
      this._element.classList.add(style);
    }
  }, {
    key: "removeStyle",
    value: function removeStyle(style) {
      this._element.classList.remove(style);
    }
  }, {
    key: "setRootItem",
    value: function setRootItem(contentItem) {
      if (this._arranger && typeof this._arranger.setRootItem === "function") {
        this._arranger.setRootItem(contentItem);
      }
    }
  }, {
    key: "_createContentArranger",
    value: function _createContentArranger() {
      var params = {};

      params.compareItemFunc = function (c1, c2) {
        var haveRankWeight = typeof c1.rankWeight === 'number' && _typeof(c2.rankWeight === 'number');

        var r1 = 0;
        var r2 = 0;

        if (haveRankWeight) {
          r1 = c1.rankWeight > 0 ? c1.rankWeight : Number.MAX_SAFE_INTEGER;
          r2 = c2.rankWeight > 0 ? c2.rankWeight : Number.MAX_SAFE_INTEGER;
        }

        var s1 = "" + (c1.displayName ? c1.displayName : c1.name);
        var s2 = "" + (c2.displayName ? c2.displayName : c2.name);
        var diff = r1 - r2;

        if (diff == 0) {
          diff = s1.localeCompare(s2);
        }

        return diff;
      };

      if (this._params.contents === "effects") {
        params.getGroupId = _content_arranger_simple.GridGroupers.groupByKey("category");

        params.getDataForGroupId = function (grouypId) {
          return {
            name: _display_strings.default.categoryName(grouypId),
            expand: true
          };
        };
      } else if (this._params.contents === "presets") {
        return new _presetGridArranger.default(params);
      }

      return new _content_arranger_simple.ContentArrangerSimple(params);
    }
  }, {
    key: "_createStyler",
    value: function _createStyler() {
      var styler = null;

      if (this._params.contents === 'effects') {
        styler = new _effectGridStyler.default({
          applyEffect: this._doApplyEffect.bind(this),
          setFavorited: this._doSetFavorited.bind(this),
          itemSelected: this._params.showOverlay,
          getMediaPath: this._params.getMediaPath,
          canHover: true,
          canSelect: false
        });
      } else if (this._params.contents === 'presets') {
        styler = new _presetGridStyler.default({
          applyEffect: this._doApplyEffect.bind(this),
          applyPreset: this._doApplyPreset.bind(this),
          setFavorited: this._doSetFavorited.bind(this),
          itemSelected: this._params.showOverlay,
          getMediaPath: this._params.getMediaPath,
          canHover: true,
          canSelect: true,
          arranger: this._arranger
        });
      }

      return styler;
    }
  }, {
    key: "_doApplyEffect",
    value: function _doApplyEffect(event) {
      if (event === null || event === undefined) {
        return;
      }

      var effect = event.data;

      if (effect && this._params.effectController) {
        this._params.effectController.applyEffect(effect);
      }
    }
  }, {
    key: "_doSetFavorited",
    value: function _doSetFavorited(event) {
      if (event === null || event === undefined) {
        return;
      }

      var item = event.data;

      if (item === null || item === undefined) {
        console.log('Cannot favorite a null or undefined item.');
        return;
      }

      if (this._params.effectOperations === null || this._params.effectOperations === undefined) {
        console.log('Cannot set favorite without valid effect operation parameters.');
        return;
      }

      if (typeof this._params.effectOperations.setItemFavorited !== 'function') {
        console.log('Cannot set favorite without valid effect operation parameters.');
        return;
      }

      var isPreset = item.kind === 'preset';
      var isEffect = item.kind === 'effect';

      if (isPreset && event.isFavorited) {
        var parentEffect = this._arranger.getRootItem();

        this._params.effectOperations.setItemFavorited(item, true);

        this._params.effectOperations.setItemFavorited(parentEffect, true);
      } else if (isPreset && !event.isFavorited) {
        this._params.effectOperations.setItemFavorited(item, event.isFavorited);
      }

      if (isEffect) {
        this._params.effectOperations.setItemFavorited(item, event.isFavorited);
      }
    }
  }, {
    key: "_doApplyPreset",
    value: function _doApplyPreset(event) {
      if (event === null || event === undefined) {
        return;
      }

      var preset = event.data;

      if (preset && this._params.effectController) {
        this._params.effectController.applyPreset(this._arranger.getRootItem(), preset);
      }
    }
  }, {
    key: "_getTooltip",
    value: function _getTooltip(params) {
      var element = params.$element;

      if (element === null || element === undefined) {
        return null;
      }

      var text = element.attr('toolTipText');

      if (text === null || text === undefined) {
        return null;
      }

      if (document.body.classList.contains('uni_effect_cat_transition')) {
        return "\n                    <div style=\"font-size: 10px; max-width: 150px;\">\n                        To select a preset use the Choose a Preset button directly from the plugin.\n                    </div>\n                ";
      } else if (element.body === true) {
        return null;
      }

      return text;
    }
  }]);

  return Grid;
}();

module.exports = Grid;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

__webpack_require__(26);

var _content_arranger_simple = __webpack_require__(28);

var _content_consumer = _interopRequireDefault(__webpack_require__(16));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(13));

var _content_properties = _interopRequireDefault(__webpack_require__(29));

var _content_change_context = _interopRequireDefault(__webpack_require__(14));

var _content_filter = _interopRequireDefault(__webpack_require__(10));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
    delegate = {

        // Optional - be noitified of selection updates. 
        // Note: if you install a custom gridDelegate, handle onSelectionUpdated() instead 
        onContentSelected: function(contentGrid, contentList) { }    

        // Optional - return dom element to insert if the grid has no items
        getGridEmptyContent: function(contentGrid) { }

        // Optional - examine the change and decided if the grid should maintain state on 
        //              refresh, overriding the default behaviour
        function: shouldMaintainStateOnRefresh(contentGrid, changeContext) { return true; }

    }

    contentArranger = {

        // required - be notified when content arrives
        setContent: function(contentList) { }, 

        // required - return all items to add to RGGridView
        getItems: function() { return []; },

        // optional - return group data suitable for RGGridView
        getGroups: function() { return {groups:[], totalCount:0} },

        // optional - be informed when installed in a grid
        function: setContentGrid(contentGrid) { }

        // optional - return false to bypass custom incremental update logic
        function: doDefaultIncrementalGridUpdate(contentGrid, changeContext) { return true; }

        // optional - will be called if above returns false. Return false to trigger a full refresh
        function: handleIncrementalGridUpdate(contentGrid, changeContext) { return false; }

    }

    gridStyler = {

        // optional - be informed when installed in a grid
        setContentGrid: function(contentGrid) { }

        // optional - be notified at the start of a content grid reload
        onContentGridReloading: function(contentGrid, changeContext, gridMaintainingState) { }

        // Plus all RGGridView styler methods
    }
*/
var ContentGrid =
/*#__PURE__*/
function () {
  function ContentGrid(params) {
    _classCallCheck(this, ContentGrid);

    this._params = params ? params : {};

    _.defaults(this._params, {
      allowIncrementalUpdate: true,
      delegate: null,
      // expansion callbacks
      onGroupExpansionChanged: null,
      getGroupExpansionStates: null,
      // Main Components
      contentProvider: null,
      contentArranger: new _content_arranger_simple.ContentArrangerSimple(),
      gridStyler: this,
      gridDelegate: this,
      // can pass a custom grid delegate for more control
      gridSelectionClass: 'grid-item-selected',
      gridBaseAppearanceClass: null,
      // grid default - set to "" to clear completely
      contentProperties: new _content_properties.default()
    });

    this._delegate = this._params.delegate;
    this._div = $('<div tabindex="0" class="rg_cb_grid"></div>');
    this._gridView = new RGGridView();

    this._gridView.init(this._div, this._params.gridStyler, this._params.gridDelegate, {
      selectionClassName: this._params.gridSelectionClass,
      baseAppearanceClassName: this._params.gridBaseAppearanceClass
    });

    this._contentIsLoading = false;
    this._loadingIndicatorActive = false;
    this._loadingIndicatorAddedTime = 0;
    this._showLoadingUntilFoundContent = false;

    if (this._params.contentProvider) {
      this.setContentProvider(this._params.contentProvider);
    }

    if (this._params.contentArranger && typeof this._params.contentArranger.setContentGrid === "function") {
      this._params.contentArranger.setContentGrid(this);
    }

    if (this._params.gridStyler && typeof this._params.gridStyler.setContentGrid === "function") {
      this._params.gridStyler.setContentGrid(this);
    }
  }

  _createClass(ContentGrid, [{
    key: "getDiv",
    value: function getDiv() {
      return this._div;
    }
  }, {
    key: "getGridView",
    value: function getGridView() {
      return this._gridView;
    }
  }, {
    key: "getContentArranger",
    value: function getContentArranger() {
      return this._params.contentArranger;
    }
  }, {
    key: "refresh",
    value: function refresh(changeContext) {
      var _this = this;

      if (!changeContext) {
        changeContext = _content_change_context.default.Create();
      }

      if (this._params.contentArranger) {
        if (this._contentProvider) {
          this._params.contentArranger.setContent(this._contentProvider.getContent());
        } else {
          this._params.contentArranger.setContent([]);
        }

        var scrollPos = 0;
        var currentSelection = [];
        var selectAll = false;
        var maintainGridState = this.shouldMaintainStateOnRefresh(changeContext);

        if (this._params.gridStyler && typeof this._params.gridStyler.onContentGridReloading === "function") {
          this._params.gridStyler.onContentGridReloading(this, changeContext, maintainGridState);
        }

        if (maintainGridState) {
          // Scroll position
          scrollPos = this._gridView.getScrollPosition(); // Selection

          selectAll = this._gridView.isSelectAllActive();

          if (!selectAll) {
            currentSelection = this.getIdsForCurrentSelection();
          }
        }

        this._gridView.emptyGrid();

        this._gridView.clearSelection(true);

        var allGroups = [];

        if (typeof this._params.contentArranger.getGroups === "function") {
          var groupInfo = this._params.contentArranger.getGroups();

          allGroups = groupInfo.groups;

          this._gridView.setGroups(groupInfo.groups, groupInfo.totalCount);
        }

        var items = this._params.contentArranger.getItems();

        this._gridView.addItemsToGrid(items, 0);

        if (maintainGridState) {
          // Selection
          if (selectAll) {
            this._gridView.selectAll();
          } else {
            this._setSelectionByIds(currentSelection, allGroups, items);
          } // Scroll position


          this._gridView.scrollToPosition(scrollPos);
        }
      }

      this._contentIsLoading = false;

      this._removeLoadingIndicator();

      window.requestAnimationFrame(function () {
        return _this.afterRefresh();
      });
    }
  }, {
    key: "shouldMaintainStateOnRefresh",
    value: function shouldMaintainStateOnRefresh(changeContext) {
      if (this._delegate && typeof this._delegate.shouldMaintainStateOnChange === "function") {
        return this._delegate.shouldMaintainStateOnRefresh(this, changeContext);
      } // For live updates or things like sort order, keep position


      return changeContext.source === _content_change_context.default.ChangeSource.Data || changeContext.source === _content_change_context.default.ChangeSource.Format;
    }
    /**
     * return: [ { itemId: "", groupId: ""} ]
     */

  }, {
    key: "getIdsForCurrentSelection",
    value: function getIdsForCurrentSelection() {
      var idPairs = [];

      var gridItems = this._gridView.getSelectedItems();

      for (var i = 0; i < gridItems.length; i++) {
        var nextItem = $(gridItems[i]);

        var nextData = this._gridView.getDataForGridItem(nextItem);

        var groupHeader = this._gridView.getGroupHeaderForItem(nextItem);

        var groupId = "ungrouped";

        if (groupHeader) {
          groupId = groupHeader.data().groupId;
        }

        idPairs.push({
          itemId: nextData._id,
          groupId: groupId
        });
      }

      return idPairs;
    }
    /**
     * @param {string} contentId - id to look up
     * @return: [ $Item1, $Item2, ... ]
     */

  }, {
    key: "getGridItemsForContentId",
    value: function getGridItemsForContentId(contentId, includingCollapsedItems) {
      var filter = {
        _id: contentId
      };
      return this.getMatchingGridItems(filter, includingCollapsedItems);
    }
    /**
    * @param {object} contentFilter - the filter to return items that match
    * @return: [ $Item1, $Item2, ... ]
    */

  }, {
    key: "getMatchingGridItems",
    value: function getMatchingGridItems(contentFilter, includingCollapsedItems) {
      if (!this._params.contentArranger) {
        return [];
      }

      var filter = {};

      _content_filter.default.asContentFilter(filter);

      filter._contentFilterInit();

      filter.setFilter(contentFilter); // Get the data indicies

      var items = this._params.contentArranger.getItems();

      var indicies = [];

      for (var i = 0; i < items.length; i++) {
        if (filter.doesItemPass(items[i])) {
          indicies.push(i);
        }
      } // Get the corresponding grid items


      var result = [];

      for (var _i = 0; _i < indicies.length; _i++) {
        var nextItem = this._gridView.getGridItemForIndex(indicies[_i], includingCollapsedItems);

        if (nextItem && nextItem.length > 0) {
          result.push(nextItem);
        }
      }

      return result;
    }
    /**
     * This function will select all items whose itemId AND groupId match idPairs.
     * @param {array} idPairs - as returned by getIdsForCurrentSelection
     * @param {array} groups - array of groups from the content arranger
     * @param {array} items - raw items in the grid
     */

  }, {
    key: "_setSelectionByIds",
    value: function _setSelectionByIds(idPairs, groups, items) {
      if (idPairs.length === 0) {
        // Nothing to do if there was no selection
        return;
      } // Prepare groups to account for ungrouped items, if any


      groups = groups.slice(0);
      var ungroupedItem = {
        offs: 0,
        len: items.length,
        expand: true,
        groupId: "ungrouped"
      };

      if (groups.length === 0) {
        // If we have no groups, create the "ungrouped" holder
        groups = [ungroupedItem];
      } else if (groups[0].offs > 0) {
        // Insert holder for ungrouped items at top
        ungroupedItem.len = groups[0].offs;
        groups.splice(0, 0, ungroupedItem);
      } // Sort the selection pairs by group


      var itemsPerGroup = {};

      for (var i = 0; i < idPairs.length; i++) {
        var _idPairs$i = idPairs[i],
            itemId = _idPairs$i.itemId,
            groupId = _idPairs$i.groupId;

        if (!itemsPerGroup[groupId]) {
          itemsPerGroup[groupId] = [];
        }

        itemsPerGroup[groupId].push(itemId);
      } // Walk through the grid and find items that match the previous selection


      var itemsToSelect = $();

      for (var _i2 = 0; _i2 < groups.length; _i2++) {
        var nextGroup = groups[_i2];

        if (nextGroup.expand && itemsPerGroup.hasOwnProperty(nextGroup.groupId)) {
          var idsInGroup = itemsPerGroup[nextGroup.groupId];

          for (var j = nextGroup.offs; j < nextGroup.offs + nextGroup.len && idsInGroup.length > 0; j++) {
            var igIdx = idsInGroup.indexOf(items[j]._id);

            if (igIdx !== -1) {
              // This item needs to be selected
              var gridItem = this._gridView.getGridItemForIndex(j);

              if (gridItem && gridItem.length > 0) {
                itemsToSelect = itemsToSelect.add(gridItem[0]);
              }

              idsInGroup.splice(igIdx, 1);
            }
          }
        }
      } // console.log("itemsToSelect");
      // console.log(itemsToSelect);
      // console.log(itemsToSelect ? itemsToSelect.length : "null");


      if (itemsToSelect.length > 0) {
        this._gridView.selectItems(itemsToSelect, true);
      }
    }
  }, {
    key: "afterRefresh",
    value: function afterRefresh() {
      var expansionStates = [];

      if (typeof this._params.getGroupExpansionStates === "function") {
        // First-chance use of the installed param version
        expansionStates = this._params.getGroupExpansionStates();
      } else if (this._params.contentArranger && typeof this._params.contentArranger.getGroupExpansionStates === 'function') {
        // Fallback to old-style contentArranger option
        expansionStates = this._params.contentArranger.getGroupExpansionStates();
      }

      for (var i = 0; i < expansionStates.length; i++) {
        var state = expansionStates[i];

        this._gridView.setGroupExpansion(state.id, state.isExpanded);
      }
    }
  }, {
    key: "onContentReloading",
    value: function onContentReloading(n) {
      if (n.data.reloadPhase === "start") {
        this._contentIsLoading = true;

        this._addLoadingIndicator();
      }
    }
  }, {
    key: "showLoadingUntilFoundContent",
    value: function showLoadingUntilFoundContent(shouldShow) {
      if (shouldShow !== this._showLoadingUntilFoundContent) {
        this._showLoadingUntilFoundContent = shouldShow;

        if (!this._contentIsLoading) {
          if (this._showLoadingUntilFoundContent) {
            this._contentIsLoading = true;

            this._addLoadingIndicator();
          } else {
            this._removeLoadingIndicator();
          }
        }
      }
    }
  }, {
    key: "_addLoadingIndicator",
    value: function _addLoadingIndicator() {
      var _this2 = this;

      if (this._loadingIndicatorActive) {
        return;
      } // Delay showing the loading indicator to avoid flicker


      _.delay(function () {
        if (_this2._gridView.isGridEmpty() && (_this2._contentIsLoading || _this2._showLoadingUntilFoundContent) && !_this2._loadingIndicatorActive) {
          _this2._div.addClass('content_loading');

          _this2._gridView.setToTextMode(_this2.getLoadingAnimationHTML(), true);

          _this2._loadingIndicatorActive = true;
          _this2._loadingIndicatorAddedTime = performance.now();
        }
      }, 50);
    }
  }, {
    key: "_removeLoadingIndicator",
    value: function _removeLoadingIndicator() {
      var _this3 = this;

      // Check to see if we should keep this around for a while anyway
      var gridEmpty = this._gridView.isGridEmpty();

      if (gridEmpty && this._showLoadingUntilFoundContent) {
        return;
      } // Avoid flicker - always show the indicator for a short time


      if (this._loadingIndicatorActive) {
        var nowTime = performance.now();
        var remainingTimeMS = 200 - (nowTime - this._loadingIndicatorAddedTime);

        if (remainingTimeMS > 0) {
          remainingTimeMS += 10;

          _.delay(function () {
            _this3._removeLoadingIndicator();
          }, remainingTimeMS);

          return;
        }
      } // Actually do the removal


      this._div.removeClass('content_loading');

      this._loadingIndicatorActive = false;
      var isInTextMode = false;

      if (gridEmpty) {
        if (this._delegate && typeof this._delegate.getGridEmptyContent === "function") {
          this._gridView.setToTextMode(this._delegate.getGridEmptyContent(this), true);

          isInTextMode = true;
        }
      }

      if (!isInTextMode) {
        this._gridView.setToGridMode();
      }
    }
  }, {
    key: "getLoadingAnimationHTML",
    value: function getLoadingAnimationHTML() {
      return '<div class="content_grid_loading"><div class="pip"></div><div class="pip"></div><div class="pip"></div></div>';
    }
  }, {
    key: "_handleIncrementalContentChange",
    value: function _handleIncrementalContentChange(changeContext) {
      if (!this._params.allowIncrementalUpdate) {
        return false;
      }

      if (!this._params.contentArranger) {
        return false;
      }

      if (!changeContext.hasDetails) {
        // Not the kind of change we understand
        return false;
      }

      if (changeContext.details.added.length > 0 || changeContext.details.removed.length > 0 || changeContext.details.updated.length === 0) {
        // @todo - handle additions and removals
        return false;
      }

      var arranger = this._params.contentArranger; // Make sure all the updates aren't affected by any filtering in the content arranger

      if (typeof arranger.filterItems === "function") {
        var filtered = arranger.filterItems(changeContext.details.updated);

        if (filtered.length !== changeContext.details.updated.length) {
          // this change would result in an add/remove, so bail out
          return false;
        }
      } // Give the content arranger a crack at doing this in case it has special requirements


      if (typeof arranger.doDefaultIncrementalGridUpdate === "function") {
        if (!arranger.doDefaultIncrementalGridUpdate(this, changeContext)) {
          // The content arranger wants to handle this, or else wants us to do a full refresh
          var arrangerDidUpdate = false;

          if (typeof arranger.handleIncrementalGridUpdate === "function") {
            arrangerDidUpdate = arranger.handleIncrementalGridUpdate(this, changeContext);
          }

          return arrangerDidUpdate;
        }
      } // Make sure the content arranger has the most up-to-date stuff


      var items = arranger.getItems();

      _content_provider_contract.default.api._applyWatchedChanges(items, changeContext.details.updated, []); // Find grid items for everything that changed and refresh them


      var changedIds = _.pluck(changeContext.details.updated, _content_provider_contract.default.api._defaultCompareProperty);

      var gridItems = [];
      var gridItem;

      for (var i = 0; i < items.length; i++) {
        if (changedIds.indexOf(items[i][_content_provider_contract.default.api._defaultCompareProperty]) !== -1) {
          gridItem = this._gridView.getGridItemForIndex(i);

          if (gridItem && gridItem.length > 0) {
            gridItem.data(items[i]);
            gridItems.push(gridItem);
          } else {
            // We couldn't find a grid item for this record. Do a full refresh for safety
            return false;
          }
        }
      }

      this._gridView.refreshGridItems(gridItems);

      return true;
    }
  }, {
    key: "onSelectionUpdated",
    ///////////////////////////////
    // Grid Delegate Methods
    value: function onSelectionUpdated(gridView, selectedItems) {
      var content = [];

      for (var i = 0; i < selectedItems.length; i++) {
        content.push(gridView.getDataForGridItem(selectedItems[i]));
      }

      if (this._delegate && typeof this._delegate.onContentSelected === "function") {
        this._delegate.onContentSelected(this, content);
      }
    }
  }, {
    key: "onGroupExpansionChanged",
    value: function onGroupExpansionChanged(gridView, isExpanded, groupIndex, groupData) {
      if (typeof this._params.onGroupExpansionChanged === 'function') {
        this._params.onGroupExpansionChanged(gridView, isExpanded, groupIndex, groupData);
      }
    } ///////////////////////////////
    // Grid Styler Methods - only used as a fallback if no styler is passed in	                       

  }, {
    key: "styleGridItem",
    value: function styleGridItem(gridView, gridItemDiv, gridData) {
      var titleStr = "" + this._params.contentProperties.getDisplayName(gridData);

      var divString = '<div class="rg_grid_item_title">' + titleStr + '</div>';
      gridItemDiv.append(divString);
    }
  }, {
    key: "styleGridGroupHeader",
    value: function styleGridGroupHeader(gridView, groupHeaderDiv, groupData) {
      groupHeaderDiv.addClass("rg_cb_grid_header");
      var titleStr = "";

      if (groupData.name) {
        titleStr = "" + groupData.name;
      } else {
        // find the first string property and use that ¯\_(ツ)_/¯
        for (var k in groupData) {
          if (groupData.hasOwnProperty(k) && typeof groupData[k] === "string") {
            titleStr = groupData[k];
            break;
          }
        }
      }

      groupHeaderDiv.append('<div class="rg_cb_grid_header_title">' + titleStr + '</div>');
    }
  }]);

  return ContentGrid;
}();

exports.default = ContentGrid;

_content_consumer.default.asContentConsumer(ContentGrid.prototype);

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(27);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".rg_cb_grid {\n  background-color: #282828;\n  height: 100%;\n}\n.rg_cb_grid .rg_grid_item .rg_grid_item_title {\n  font-size: 12px;\n  text-shadow: none;\n}\n.rg_cb_grid .rg_grid_item_selected .rg_grid_item_title {\n  text-shadow: none;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header {\n  height: 29px;\n  margin: 0px;\n  background: -webkit-gradient(linear, left top, left bottom, from(#666666), to(#4a4a4a));\n  border-top: 1px solid #141414;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header .rg_grid_group_toggle {\n  position: relative;\n  top: 4px;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header:nth-of-type(1) {\n  border-top: none;\n  border-bottom: none;\n}\n.rg_cb_grid .rg_cb_grid_header_title {\n  display: inline-block;\n  height: 29px;\n  line-height: 29px;\n  font-size: 14px;\n  font-family: RGMajorSans, helvetica;\n  color: #dfdfdf;\n  text-transform: uppercase;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short {\n  height: 18px;\n  padding-top: 1px;\n  border-top: none;\n  background: #484848;\n  border-bottom: 1px solid #404040;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_cb_grid_header_title {\n  height: 18px;\n  line-height: 18px;\n  text-transform: none;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_grid_group_toggle {\n  position: relative;\n  top: 0px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_cb_grid_header_title {\n  font-size: 13px;\n  line-height: 27px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short {\n  padding-top: 0px;\n  padding-bottom: 1px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_cb_grid_header_title {\n  font-size: 12px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_grid_group_toggle {\n  position: relative;\n  top: 1px;\n}\n@keyframes pip_fade {\n  0% {\n    opacity: 1;\n  }\n  25% {\n    opacity: 0.25;\n  }\n  50% {\n    opacity: 0.25;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n.content_loading .rg_grid_empty_text {\n  opacity: 1;\n}\n.content_grid_loading {\n  display: inline-block;\n  width: 100px;\n  text-align: center;\n  height: 24px;\n}\n.content_grid_loading .pip {\n  height: 8px;\n  width: 8px;\n  background-color: #a1a1a1;\n  border-radius: 50%;\n  display: inline-block;\n  margin: 8px;\n  animation: pip_fade 2s linear;\n  animation-iteration-count: infinite;\n}\n.content_grid_loading :nth-child(2) {\n  animation-delay: -1.66s;\n}\n.content_grid_loading :nth-child(3) {\n  animation-delay: 0.66s;\n}\n", ""]);

// exports


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridGroupers = exports.ContentArrangerSimple = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(10));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var GridGroupers = {
  groupByKey: function groupByKey(groupKey, defaultGroupId) {
    if (!defaultGroupId) {
      defaultGroupId = "";
    }

    return function (contentItem) {
      if (typeof contentItem[groupKey] === "string") {
        return contentItem[groupKey];
      }

      return defaultGroupId;
    };
  },
  groupDataByKey: function groupDataByKey(groupKey, filter, contentProvider) {
    var cf = {};

    _content_filter.default.asContentFilter(cf);

    cf._contentFilterInit();

    return function (groupId) {
      filter[groupKey] = groupId;
      cf.setFilter(filter);
      var d = cf.filterItems(contentProvider.getContent());

      if (d.length > 0) {
        return d[0];
      }

      return {};
    };
  },
  groupByProperty: function groupByProperty(contentProperties, propertyName, defaultGroupId) {
    if (!defaultGroupId) {
      defaultGroupId = "";
    }

    if (!propertyName) {
      propertyName = "displayCategory";
    }

    return function (contentItem) {
      var groupId = contentProperties.getProperty(contentItem, propertyName);

      if (typeof groupId === "string") {
        return groupId;
      }

      return defaultGroupId;
    };
  },
  makeSimpleDataForGroupId: function makeSimpleDataForGroupId(groupId) {
    return {
      groupId: groupId,
      name: RG.utils.toTitleCase(groupId)
    };
  }
};
exports.GridGroupers = GridGroupers;

var ContentArrangerSimple =
/*#__PURE__*/
function () {
  /*
      params = {    
          getGroupId: function(contentItem) { return ""; } // return a group id key for an item
          getDataForGroupId: function(groupId) { return { name: "Group Name"}; }
          groupCompareFunction: null, // (optional - function): a sort predicate function for groupKey values: https://www.w3schools.com/jsref/jsref_sort.asp
          alwaysShowOneGroup: false, // (optional - boolean): if true, a group header is shown if there is only one group
          compareItemFunc: null // (optional - function - depricated): a sort predicate for contentItems. Prefer ContentFormat.ordering instead.
      }
  */
  function ContentArrangerSimple(params) {
    _classCallCheck(this, ContentArrangerSimple);

    this._params = params ? params : {};

    _.defaults(this._params, {
      getGroupId: function getGroupId() {
        return "";
      },
      getDataForGroupId: null,
      groupCompareFunction: null,
      alwaysShowOneGroup: false
    });

    this._items = [];
    this._groups = [];

    this._contentFilterInit(); // MBL-2584: ContentFormat.ordering exists now - use that instead of the old compare function


    if (typeof this._params.compareItemFunc === "function") {
      console.log("Deprecation Warning: params.compareItemFunc is depreciated. Use ContentFormat.ordering instead");
    }
  }

  _createClass(ContentArrangerSimple, [{
    key: "setContentGrid",
    value: function setContentGrid(contentGrid) {
      this._contentGrid = contentGrid;
    }
  }, {
    key: "setGetGroupIdFunc",
    value: function setGetGroupIdFunc(getGroupIdFunc) {
      this._params.getGroupId = getGroupIdFunc;
    }
  }, {
    key: "setContent",
    value: function setContent(contentList) {
      this._items = this.filterItems(contentList); // Depricated but leave it in case someone is still using it UP-4125

      if (typeof this._params.compareItemFunc === "function") {
        this._items.sort(this._params.compareItemFunc);
      }

      this._buildGroups(this._params.alwaysShowOneGroup);
    }
  }, {
    key: "getItems",
    value: function getItems() {
      return this._items;
    }
  }, {
    key: "getGroups",
    value: function getGroups() {
      return {
        groups: this._groups,
        totalCount: this._items.length
      };
    }
  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      if (this._contentGrid) {
        this._contentGrid.refresh();
      }
    }
  }, {
    key: "_sortGroupIdsByCategories",
    value: function _sortGroupIdsByCategories(groupIds, categories) {
      var orderedLookup = [];
      var unorderedLookup = [];

      for (var i = 0; i < groupIds.length; i++) {
        var id = groupIds[i];
        var index = -1;

        for (var c = 0; c < categories.length; c++) {
          var category = categories[c];

          if (category.Name === id) {
            index = c;
          }
        }

        if (index >= 0) {
          orderedLookup.push({
            index: index,
            name: id
          });
        } else {
          unorderedLookup.push(id);
        }
      }

      orderedLookup = _.sortBy(orderedLookup, function (item) {
        return item.index;
      });
      var sortedIds = [];

      for (var i = 0; i < orderedLookup.length; i++) {
        var item = orderedLookup[i];
        sortedIds.push(item.name);
      }

      for (var i = 0; i < unorderedLookup.length; i++) {
        var item = unorderedLookup[i];
        sortedIds.push(item);
      }

      return sortedIds;
    }
  }, {
    key: "_buildGroups",
    value: function _buildGroups(alwaysShowOneGroup) {
      this._groups = [];

      if (typeof this._params.getGroupId !== "function") {
        // No groups - nothing to do!
        return;
      }

      var groupings = {};
      var ungrouped = [];
      var groupId;
      var i; // Find groups

      for (i = 0; i < this._items.length; i++) {
        groupId = this._params.getGroupId(this._items[i]);

        if (!groupId) {
          ungrouped.push(this._items[i]);
        } else {
          if (!groupings[groupId]) {
            groupings[groupId] = [];
          }

          groupings[groupId].push(this._items[i]);
        }
      }

      var groupIds = _.keys(groupings);

      if (!alwaysShowOneGroup) {
        if (groupIds.length === 0 || groupIds.length === 1 && ungrouped.length === 0) {
          // don't bother to create any groups since we want to hide the first one
          return;
        }
      } // Sort groups


      if (typeof this._params.groupCompareFunction === "function") {
        // custom sort
        groupIds.sort(this._params.groupCompareFunction);
      } else {
        // alphabetical
        groupIds.sort();
      }

      if (typeof this.getRootItem === 'function') {
        var rootItem = this.getRootItem();

        if (rootItem !== null && rootItem !== undefined && Array.isArray(rootItem.categories)) {
          var categories = rootItem.categories;
          groupIds = this._sortGroupIdsByCategories(groupIds, categories);
        }
      } // Reorder our items to match the group order


      var sortedItems = ungrouped;
      var g, gData;

      for (i = 0; i < groupIds.length; i++) {
        g = {
          offs: sortedItems.length,
          groupId: groupIds[i],
          len: groupings[groupIds[i]].length,
          expand: true
        };

        if (typeof this._params.getDataForGroupId === "function") {
          gData = this._params.getDataForGroupId(groupIds[i]);

          if (gData) {
            _.defaults(g, gData);
          }
        }

        this._groups.push(g);

        sortedItems = sortedItems.concat(groupings[groupIds[i]]);
      }

      this._items = sortedItems;
    }
  }]);

  return ContentArrangerSimple;
}();

exports.ContentArrangerSimple = ContentArrangerSimple;

_content_filter.default.asContentFilter(ContentArrangerSimple.prototype);

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
	A mapper that can be used to read common display properties
	from a contentItem, either by convention or by configuration.

	propertyMap = {
		// Will iterate through the array trying to find a set match
		propertyName: ["otherPropertyName", getPropertyFunction() { }]
	}

 */
var ContentProperties =
/*#__PURE__*/
function () {
  function ContentProperties(propertyMap) {
    _classCallCheck(this, ContentProperties);

    this._propertyMap = propertyMap ? propertyMap : {}; // Register default decoder maps for standard properties

    _.defaults(this._propertyMap, {
      displayName: ["displayName", "name", this._getFileNameNoExtension.bind(this)],
      displayCategory: ["displayCategory", "category", this._getParentFolderName.bind(this)],
      filePath: ["filePath", "path"],
      fileName: ["fileName", this._getFileName.bind(this)],
      parentFolderName: ["parentFolderName", this._getParentFolderName.bind(this)],
      parentFolderPath: ["parentFolderPath", this._getParentFolderPath.bind(this)]
    });
  }

  _createClass(ContentProperties, [{
    key: "getProperty",
    value: function getProperty(contentItem, propertyName) {
      if (!contentItem) {
        return undefined;
      }

      if (this._propertyMap.hasOwnProperty(propertyName)) {
        var mapper = this._propertyMap[propertyName];
        var result = undefined;

        for (var i = 0; i < mapper.length; i++) {
          if (typeof mapper[i] === "string") {
            result = contentItem[mapper[i]];
          } else if (typeof mapper[i] === "function") {
            try {
              result = mapper[i](contentItem, propertyName, this);
            } catch (err) {
              console.log("ContentProperties caught error in function for " + propertyName);
              console.log(err);
            }
          }

          if (result !== undefined) {
            return result;
          }
        }
      }

      return contentItem[propertyName];
    } ////////////////////////////////////
    // Convenience

  }, {
    key: "getDisplayName",
    value: function getDisplayName(contentItem) {
      return this.getProperty(contentItem, "displayName");
    }
  }, {
    key: "getDisplayCategory",
    value: function getDisplayCategory(contentItem) {
      return this.getProperty(contentItem, "displayCategory");
    }
  }, {
    key: "getFilePath",
    value: function getFilePath(contentItem) {
      return this.getProperty(contentItem, "filePath");
    }
  }, {
    key: "getFileName",
    value: function getFileName(contentItem) {
      return this.getProperty(contentItem, "fileName");
    }
  }, {
    key: "getParentFolderName",
    value: function getParentFolderName(contentItem) {
      return this.getProperty(contentItem, "parentFolderName");
    } ////////////////////////////////////
    // Special property decoders

  }, {
    key: "_getFileName",
    value: function _getFileName(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getFileNameFromPath(path);
      }

      return undefined;
    }
  }, {
    key: "_getFileNameNoExtension",
    value: function _getFileNameNoExtension(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getFileNameWithoutExtensionFromPath(path);
      }

      return undefined;
    }
  }, {
    key: "_getParentFolderName",
    value: function _getParentFolderName(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        var parentFolderPath = RG.utils.getParentFolderFromPath(path);
        return RG.utils.getFileNameFromPath(parentFolderPath);
      }

      return undefined;
    }
  }, {
    key: "_getParentFolderPath",
    value: function _getParentFolderPath(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getParentFolderFromPath(path);
      }

      return undefined;
    }
  }]);

  return ContentProperties;
}();

exports.default = ContentProperties;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _styler = _interopRequireDefault(__webpack_require__(31));

__webpack_require__(50);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var EffectGridStyler =
/*#__PURE__*/
function (_Styler) {
  _inherits(EffectGridStyler, _Styler);

  function EffectGridStyler(params) {
    var _this;

    _classCallCheck(this, EffectGridStyler);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EffectGridStyler).call(this, params));
    _this.applyButtonOptions = {
      style: 'text',
      text: 'Apply Effect',
      tooltip: {
        title: 'Apply Effect',
        description: 'Applies effect using its default settings'
      }
    };
    _this.tooltipOptions = {
      rollover: {
        content: "\n                    <div style=\"font-size: 10px; max-width: 150px; margin-bottom: 4px;\">\n                        Click to browse presets for this effect.\n                    </div>\n                    <div style=\"font-size: 10px; max-width: 150px;\">\n                        Double-click to apply this effect.\n                    </div>\n                    ",
        isEnabled: true
      }
    };
    return _this;
  }

  return EffectGridStyler;
}(_styler.default);

module.exports = EffectGridStyler;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _videoGridItem = _interopRequireDefault(__webpack_require__(32));

var _descriptionPanel = _interopRequireDefault(__webpack_require__(45));

__webpack_require__(48);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Styler =
/*#__PURE__*/
function () {
  function Styler(params) {
    _classCallCheck(this, Styler);

    this._params = params ? params : {};

    _.defaults(this._params, {
      applyEffect: null,
      applyPreset: null,
      setFavorited: null,
      itemSelected: null,
      canHover: false,
      canSelect: false
    });

    this.itemSelectedDelegate = this.onItemSelected.bind(this);
  }

  _createClass(Styler, [{
    key: "setContentGrid",
    value: function setContentGrid(contentGrid) {
      this._contentGrid = contentGrid;
    }
  }, {
    key: "styleGridItem",
    value: function styleGridItem(gridView, gridItemDiv, gridData) {
      var element = gridItemDiv[0];

      if (this._contentGrid) {
        if (gridData.kind === "description") {
          new _descriptionPanel.default({
            div: gridItemDiv,
            data: gridData,
            applyCallback: this._getApplyCallbackfunction(gridData)
          });
          return;
        }

        element.innerHTML = '';
        var title = gridData.displayName ? gridData.displayName : gridData.name;
        var description = gridData.description ? gridData.description : '';
        var favorited = gridData.isFavorited;
        var tooltipOptions = {
          body: {
            content: null,
            isEnabled: true
          },
          controlArea: {
            content: "\n                        <div style=\"font-size: 12px; font-weight: bold; margin-bottom: 3px;\">\n                            ".concat(title, "\n                        </div>\n                        <div style=\"font-size: 10px; max-width: 150px;\">\n                            ").concat(description, "\n                        </div>\n                        "),
            isEnabled: true
          }
        };

        _.extend(tooltipOptions, this.tooltipOptions);

        new _videoGridItem.default(title, this._getImagePath(gridData), this._getVideoPath(gridData), {
          root: element,
          favorited: favorited,
          clickCallback: this.itemSelectedDelegate,
          applyCallback: this._getApplyCallbackfunction(gridData),
          setFavoritedCallback: this._params.setFavorited,
          canHover: this._params.canHover,
          canSelect: this._params.canSelect,
          meta: gridData,
          applyButtonOptions: this.applyButtonOptions,
          tooltipOptions: tooltipOptions
        });
      }
    }
  }, {
    key: "styleGridGroupHeader",
    value: function styleGridGroupHeader(gridView, groupHeaderDiv, groupData) {
      if (this._contentGrid) {
        this._contentGrid.styleGridGroupHeader(gridView, groupHeaderDiv, groupData);
      }
    }
  }, {
    key: "onItemSelected",
    value: function onItemSelected(event) {
      if (typeof this._params.itemSelected !== 'function') {
        return;
      }

      this._params.itemSelected(event);
    }
  }, {
    key: "_getApplyCallbackfunction",
    value: function _getApplyCallbackfunction(gridData) {
      if (gridData && gridData.kind === "preset") {
        return this._params.applyPreset;
      }

      return this._params.applyEffect;
    }
  }, {
    key: "_getImagePath",
    value: function _getImagePath(gridData) {
      if (this._params.getMediaPath) {
        return this._params.getMediaPath(gridData, gridData.imagePath);
      }

      return gridData.imagePath;
    }
  }, {
    key: "_getVideoPath",
    value: function _getVideoPath(gridData) {
      if (this._params.getMediaPath) {
        return this._params.getMediaPath(gridData, gridData.videoPath);
      }

      return gridData.videoPath;
    }
  }]);

  return Styler;
}();

module.exports = Styler;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _gridItem = _interopRequireDefault(__webpack_require__(33));

var _videoRollover = _interopRequireDefault(__webpack_require__(34));

var _container = _interopRequireDefault(__webpack_require__(37));

__webpack_require__(43);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var VideoGridItem =
/*#__PURE__*/
function () {
  function VideoGridItem(title, imagePath, videoPath) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    _classCallCheck(this, VideoGridItem);

    this.defaults(options);
    this.createVideoRollover(title, imagePath, videoPath);
    this.createFavoriteButton();
    this.createApplyButton();
    this.applyClickedDelegate = this.onApplyClicked.bind(this);
    this.applyElement.addEventListener('click', this.applyClickedDelegate);
    this.clicks = 0;
    this.clickCheckDelegate = this.clickCheck.bind(this);
    this.rootClickedDelegate = this.onClicked.bind(this); // UP-3072: If this grid item is getting refreshed, remove any prior handlers we installed
    // otherwise we can stack up handlers and fire multiple events on each click

    var priorHandler = $(this.root).data('video_grid_click_handler');

    if (priorHandler) {
      this.root.removeEventListener('click', priorHandler);
    }

    this.root.addEventListener('click', this.rootClickedDelegate); // Save the handler to we can remove it later

    $(this.root).data('video_grid_click_handler', this.rootClickedDelegate);
    this.createBodyTooltip();
    this.createControlAreaTooltip();
  }

  _createClass(VideoGridItem, [{
    key: "defaults",
    value: function defaults(options) {
      _.extend(this, options);

      _.defaults(this, {
        root: document.createElement('div'),
        favorited: false,
        clickCallback: null,
        applyCallback: null,
        setFavoritedCallback: null,
        meta: null,
        canHover: false,
        canSelect: false,
        applyButtonOptions: {
          style: 'text',
          text: '',
          tooltip: {
            title: '',
            description: ''
          }
        },
        tooltipOptions: {
          rollover: {
            content: '',
            isEnabled: false
          },
          body: {
            content: '',
            isEnabled: false
          },
          controlArea: {
            content: '',
            isEnabled: false
          }
        }
      });
    }
  }, {
    key: "createBodyTooltip",
    value: function createBodyTooltip() {
      if (!this.tooltipOptions.body.isEnabled) {
        return;
      }

      var element = this.gridItem.root;
      element.setAttribute('rg_tooltip', 'uni_grid_item');
      element.setAttribute('toolTipText', this.tooltipOptions.body.content);
      element.setAttribute('body', true);
      RG.ui.tooltips.addTooltip($(element), 'uni_grid_item');
    }
  }, {
    key: "createControlAreaTooltip",
    value: function createControlAreaTooltip() {
      if (!this.tooltipOptions.controlArea.isEnabled) {
        return;
      }

      var element = this.gridItem.controlWrap;
      element.setAttribute('rg_tooltip', 'uni_grid_item');
      element.setAttribute('toolTipText', this.tooltipOptions.controlArea.content);
      RG.ui.tooltips.addTooltip($(element), 'uni_grid_item');
    }
  }, {
    key: "createVideoRollover",
    value: function createVideoRollover(title, imagePath, videoPath) {
      this.title = title;
      this.video = new _videoRollover.default(imagePath, videoPath);
      this.gridItem = new _gridItem.default(title, this.video.root, {
        root: this.root,
        canHover: this.canHover,
        canSelect: this.canSelect
      });

      if (this.tooltipOptions.rollover.isEnabled) {
        this.gridItem.mediaWrap.setAttribute('rg_tooltip', 'uni_grid_item');
        this.gridItem.mediaWrap.setAttribute('toolTipText', this.tooltipOptions.rollover.content);
      }
    }
  }, {
    key: "createFavoriteButton",
    value: function createFavoriteButton() {
      this.favoriteIcon = _container.default.favoriteStar.load();
      this.favoriteIcon.classList.add('icon');
      this.favoriteButton = document.createElement('div');
      this.favoriteButton.classList.add('fav-button');
      this.favoriteButton.appendChild(this.favoriteIcon);
      this.favoriteButton.addEventListener('click', this.onFavoriteClicked.bind(this));
      this.favoriteButton.setAttribute('rg_tooltip', 'uni_grid_item');
      this.favoriteButton.setAttribute('toolTipText', "\n            <div style=\"font-size: 10px; max-width: 150px;\">\n                Mark as favorite\n            </div>\n            ");

      if (this.favorited) {
        this.root.classList.add('favorited');
      }

      this.root.appendChild(this.favoriteButton);
    }
  }, {
    key: "createApplyButton",
    value: function createApplyButton() {
      if (this.applyButtonOptions.style === 'text') {
        this.applyContent = document.createElement('div');
        this.applyContent.classList.add('content');
        this.applyContent.innerHTML = this.applyButtonOptions.text;
        this.applyElement = document.createElement('div');
        this.applyElement.classList.add('apply');
        this.applyElement.classList.add('text-button');
        this.applyElement.appendChild(this.applyContent);
      }

      if (this.applyButtonOptions.style === 'icon') {
        this.applyIcon = _container.default.applyPreset.load();
        this.applyIcon.classList.add('icon');
        this.applyElement = document.createElement('div');
        this.applyElement.classList.add('apply');
        this.applyElement.classList.add('icon-button');
        this.applyElement.appendChild(this.applyIcon);
      }

      this.applyElement.setAttribute('rg_tooltip', 'uni_grid_item');
      this.applyElement.setAttribute('toolTipText', "\n            <div style=\"font-size: 12px; font-weight: bold; margin-bottom: 3px;\">\n                ".concat(this.applyButtonOptions.tooltip.title, "\n            </div>\n            <div style=\"font-size: 10px; max-width: 150px;\">\n                ").concat(this.applyButtonOptions.tooltip.description, "\n            </div>\n            "));
      this.gridItem.controlWrap.appendChild(this.applyElement);
    }
  }, {
    key: "onClicked",
    value: function onClicked() {
      this.clicks++;

      if (this.clicks == 1) {
        setTimeout(this.clickCheckDelegate, 300);
      }
    }
  }, {
    key: "clickCheck",
    value: function clickCheck() {
      if (this.clicks == 1) {
        this.onSingleClicked();
      } else {
        this.onDoubleClicked();
      }

      this.clicks = 0;
    }
  }, {
    key: "onSingleClicked",
    value: function onSingleClicked() {
      if (typeof this.clickCallback !== 'function') {
        return;
      }

      this.clickCallback({
        event: event,
        name: this.title,
        item: this,
        data: this.meta
      });
    }
  }, {
    key: "onDoubleClicked",
    value: function onDoubleClicked() {
      this.apply();
    }
  }, {
    key: "onApplyClicked",
    value: function onApplyClicked(event) {
      this.apply();
      event.stopPropagation();
    }
  }, {
    key: "apply",
    value: function apply() {
      if (typeof this.applyCallback !== 'function') {
        return;
      }

      this.applyCallback({
        event: event,
        name: this.title,
        item: this,
        data: this.meta
      });
    }
  }, {
    key: "onFavoriteClicked",
    value: function onFavoriteClicked(event) {
      if (typeof this.setFavoritedCallback !== 'function') {
        return;
      }

      var setFavorite = !this.root.classList.contains('favorited');
      this.root.classList.toggle('favorited');
      this.setFavoritedCallback({
        event: event,
        name: this.title,
        item: this,
        data: this.meta,
        isFavorited: setFavorite
      });
      event.stopPropagation();
    }
  }]);

  return VideoGridItem;
}();

module.exports = VideoGridItem;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var GridItem =
/*#__PURE__*/
function () {
  function GridItem(title, mediaElement) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

    _classCallCheck(this, GridItem);

    if (mediaElement === null || mediaElement === undefined) {
      throw 'Media element cannot be undefined or null.';
    }

    this.defaults(options);
    this.itemWrap = document.createElement('div');
    this.content = document.createElement('div');
    this.mediaBorder = document.createElement('div');
    this.mediaWrap = document.createElement('div');
    this.media = document.createElement('div');
    this.mediaChild = mediaElement;
    this.controlWrap = document.createElement('div');
    this.title = document.createElement('div');
    this.title.innerHTML = title;
    this.initialize();
  }

  _createClass(GridItem, [{
    key: "defaults",
    value: function defaults(options) {
      _.extend(this, options);

      _.defaults(this, {
        root: document.createElement('div'),
        canHover: false,
        canSelect: false
      });
    }
  }, {
    key: "initialize",
    value: function initialize() {
      this.media.classList.add('media');
      this.media.appendChild(this.mediaChild);
      this.mediaBorder.classList.add('media-border');
      this.mediaWrap.classList.add('media-wrap');
      this.mediaWrap.appendChild(this.media);
      this.mediaWrap.appendChild(this.mediaBorder);
      this.title.classList.add('title');
      this.controlWrap.classList.add('control-wrap');
      this.controlWrap.appendChild(this.title);
      this.content.classList.add('content');
      this.content.appendChild(this.mediaWrap);
      this.content.appendChild(this.controlWrap);
      this.itemWrap.classList.add('item-wrap');
      this.itemWrap.appendChild(this.content);
      this.root.classList.add('grid-item');
      this.root.appendChild(this.itemWrap);

      if (this.canHover) {
        this.root.classList.add('can-hover');
      }

      if (this.canSelect) {
        this.root.classList.add('can-select');
      }
    }
  }]);

  return GridItem;
}();

module.exports = GridItem;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(35);

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var VideoRollover =
/*#__PURE__*/
function () {
  function VideoRollover(imagePath, videoPath, options) {
    _classCallCheck(this, VideoRollover);

    if (!videoPath && !imagePath) {
      // UP-3038: Only show the fallback video if we're showing the fallback thumbnail, otherwise it's distracting
      videoPath = "".concat(this.getFallbackMediaPath(), "plugin-preview");
    }

    if (!imagePath) {
      imagePath = "".concat(this.getFallbackMediaPath(), "plugin-thumbnail");
    }

    this.imagePath = imagePath;
    this.videoPath = videoPath;
    this.setDefaults(options);
    this.root = document.createElement('div');
    this.root.classList.add('video-rollover');
    this.placeHolder = document.createElement('div');
    this.placeHolder.classList.add('place-holder');
    this.video = document.createElement('video');
    this.video.classList.add('video');
    this.video.autoplay = true;
    this.video.muted = true;
    this.video.loop = true;
    this.video.preload = 'none';
    this.playing = false;
    this.loadMedia();
    this.root.appendChild(this.placeHolder);
    this.mouseMoveDelegate = this.onMouseMove.bind(this);
    this.mouseOutDelegate = this.onMouseOut.bind(this);
    window.addEventListener('mousemove', this.mouseMoveDelegate);
    window.addEventListener('blur', this.mouseOutDelegate);
    this.onDelayDelegate = this.onPlayDelay.bind(this);
  }

  _createClass(VideoRollover, [{
    key: "loadMedia",
    value: function loadMedia() {
      var _this = this;

      this.isMediaLoaded = false;
      this.placeHolder.style.background = 'black';
      var fallbackPath = this.getFallbackMediaPath();
      this.urls = {
        image: ["".concat(this.imagePath).concat(this.imageExtension), "".concat(fallbackPath, "plugin-thumbnail").concat(this.imageExtension)],
        video: [this.videoPath ? "".concat(this.videoPath).concat(this.videoExtensions[0]) : null, this.videoPath ? "".concat(this.videoPath).concat(this.videoExtensions[1]) : null, this.videoPath ? "".concat(fallbackPath, "plugin-preview").concat(this.videoExtensions[0]) : null]
      };
      this.loadImage(this.urls.image[0], function (event) {
        _this.onLoadImage(event, _this.urls.image[0]);
      }, function (event) {
        _this.disposeImage(event.target);

        _this.loadImage(_this.urls.image[1], function (event) {
          _this.onLoadImage(event, _this.urls.image[1]);
        }, function () {
          console.log('Unable to load image or fallback image.');
        });
      });
      this.loadVideo(this.urls.video[0], function () {
        _this.onLoadVideo(_this.urls.video[0]);
      }, function () {
        _this.loadVideo(_this.urls.video[1], function () {
          _this.onLoadVideo(_this.urls.video[1]);
        }, function () {
          _this.urls.video[2], function () {
            _this.onLoadVideo(_this.urls.video[2]);
          }, function () {
            console.log('Unable to load video or fallback video.');
          };
        });
      });
    }
  }, {
    key: "loadImage",
    value: function loadImage(url, onLoad, onError) {
      var image = new Image();
      image.onload = onLoad;
      image.onerror = onError;
      image.src = url;
    }
  }, {
    key: "loadVideo",
    value: function loadVideo(url, onLoad, onError) {
      if (!url) {
        onError();
        return;
      }

      var request = new XMLHttpRequest();
      request.open('GET', url, true);

      request.onload = function () {
        onLoad();
      };

      request.onerror = function () {
        onError();
      };

      request.send();
    }
  }, {
    key: "onLoadImage",
    value: function onLoadImage(event, url) {
      var formattedUrl = this.calculateCssUrl(url);
      this.placeHolder.style.background = "".concat(formattedUrl, " center / contain no-repeat");
      this.disposeImage(event.target);
      this.isMediaLoaded = true;
    }
  }, {
    key: "onLoadVideo",
    value: function onLoadVideo(url) {
      if (url.includes('.gif')) {
        this.isGif = true;
        this.gif = document.createElement('img');
        this.gif.src = url;
        this.gif.style.height = '100%';
        this.video = document.createElement('div');
        this.video.style.width = '100%';
        this.video.style.height = '100%';
        this.video.style.textAlign = 'center';
        this.video.appendChild(this.gif);
      }

      this.videoUrl = url;
      this.isMediaLoaded = true;
    }
  }, {
    key: "disposeImage",
    value: function disposeImage(image) {
      if (_typeof(image) !== 'object') {
        return;
      }

      if (typeof image.onload !== 'function') {
        return;
      }

      image.onload = null;

      if (typeof image.onerror !== 'function') {
        return;
      }

      image.onerror = null;
    }
  }, {
    key: "calculateCssUrl",
    value: function calculateCssUrl(url) {
      var space = ' ';
      var regEx = new RegExp(space, 'g');
      var sanitizedUrl = url.replace(regEx, '%20');
      return "url(".concat(sanitizedUrl, ")");
    }
  }, {
    key: "getFallbackMediaPath",
    value: function getFallbackMediaPath() {
      return "fallback/";
    }
  }, {
    key: "setDefaults",
    value: function setDefaults(options) {
      _.extend(this, options);

      _.defaults(this, {
        imageExtension: '.png',
        videoExtensions: ['.mp4', '.gif']
      });
    }
  }, {
    key: "getIsHovered",
    value: function getIsHovered() {
      if (typeof RGPanel !== "undefined") {
        var rect = this.root.getBoundingClientRect();
        return event.clientX >= rect.left && event.clientX <= rect.left + rect.width && event.clientY >= rect.top && event.clientY <= rect.top + rect.height;
      } else {
        return $(this.root).is(":hover");
      }
    }
  }, {
    key: "onMouseMove",
    value: function onMouseMove(event) {
      var isHovered = this.getIsHovered();

      if (isHovered) {
        this.onMouseOver();
      } else {
        this.onMouseOut();
      }
    }
  }, {
    key: "onMouseOver",
    value: function onMouseOver() {
      var _this2 = this;

      if (!this.isGif && !this.requestPlay && !this.playing && this.isMediaLoaded && this.videoUrl) {
        this.requestPlay = true;
        this.video.classList.add('hidden');
        this.video.src = this.videoUrl;
        this.root.appendChild(this.video);
        this.video.load();
        this.playPromise = this.video.play();

        var onPlaying = function onPlaying() {
          _this2.playing = true;

          _this2.root.removeChild(_this2.root.firstChild);

          _this2.video.classList.remove('hidden');

          var duration = 45000;

          if (_this2.playPromise !== null && _this2.playPromise !== undefined) {
            duration = 5 * _this2.video.duration * 1000;
          }

          _this2.delayTimeout = setTimeout(_this2.onDelayDelegate, duration);
        };

        if (this.playPromise === null || this.playPromise === undefined) {
          onPlaying();
        } else {
          this.playPromise.then(function () {
            onPlaying();
          });
        }
      }

      if (this.isGif && this.isMediaLoaded && !this.requestPlay) {
        this.requestPlay = true;
        this.root.appendChild(this.video);
        this.root.removeChild(this.root.firstChild);
        this.video.classList.remove('hidden');
        this.playing = true;
      }
    }
  }, {
    key: "onMouseOut",
    value: function onMouseOut() {
      var _this3 = this;

      if (this.requestPlay && !this.playing && this.playPromise !== null && this.playPromise !== undefined) {
        this.playPromise.then(function () {
          _this3.pauseVideo();
        });
      } else if (this.requestPlay && this.playing) {
        this.pauseVideo();
      }
    }
  }, {
    key: "pauseVideo",
    value: function pauseVideo() {
      if (!this.isGif) {
        this.video.pause();
        this.video.currentTime = 0;

        if (this.delayTimeout !== null && this.delayTimeout !== undefined) {
          clearTimeout(this.delayTimeout);
        }
      }

      if (this.root.firstChild !== undefined && this.root.firstChild !== null) {
        this.root.removeChild(this.root.firstChild);
      }

      this.root.appendChild(this.placeHolder);
      this.playing = false;
      this.requestPlay = false;
    }
  }, {
    key: "onPlayDelay",
    value: function onPlayDelay() {
      this.onMouseOut();
    }
  }]);

  return VideoRollover;
}();

module.exports = VideoRollover;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(36);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".video-rollover {\n  position: absolute;\n  left: 0;\n  top: 0;\n  right: 0;\n  bottom: 0;\n}\n.video-rollover .place-holder {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover video {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover video.hidden {\n  width: 0px;\n  height: 0px;\n}\n", ""]);

// exports


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _logo = _interopRequireDefault(__webpack_require__(38));

var _cog = _interopRequireDefault(__webpack_require__(39));

var _caretDown = _interopRequireDefault(__webpack_require__(40));

var _favorite = _interopRequireDefault(__webpack_require__(41));

var _applyPreset = _interopRequireDefault(__webpack_require__(42));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Icon =
/*#__PURE__*/
function () {
  function Icon(source) {
    _classCallCheck(this, Icon);

    this.source = source;
  }

  _createClass(Icon, [{
    key: "load",
    value: function load() {
      var element = document.createElement('svg');
      element.innerHTML = this.source;
      return element;
    }
  }]);

  return Icon;
}();

var Container = function Container() {
  _classCallCheck(this, Container);

  this.caretDown = new Icon(_caretDown.default);
  this.cog = new Icon(_cog.default);
  this.logo = new Icon(_logo.default);
  this.favoriteStar = new Icon(_favorite.default);
  this.applyPreset = new Icon(_applyPreset.default);
};

var container = new Container();
module.exports = container;

/***/ }),
/* 38 */
/***/ (function(module, exports) {

module.exports = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 22.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 135 26\" style=\"enable-background:new 0 0 135 26;\" xml:space=\"preserve\">\n<style type=\"text/css\">\n\t.st0{fill:#D1282D;}\n\t.st1{fill:#FFFFFF;}\n</style>\n<g>\n\t<g>\n\t\t<g>\n\t\t\t<path class=\"st0\" d=\"M12.8,22.8l-5.6-9.5v9.5H2.8V2.7H10c1,0,2,0.2,2.9,0.5c0.9,0.3,1.6,0.7,2.2,1.3c0.6,0.5,1.1,1.2,1.4,1.9\n\t\t\t\tc0.3,0.7,0.5,1.5,0.5,2.4c0,1.5-0.4,2.7-1.3,3.7c-0.8,1-1.9,1.6-3.2,2l5.3,8.4H12.8z M12.5,8.7c0-0.7-0.2-1.3-0.7-1.7\n\t\t\t\tc-0.5-0.4-1.1-0.6-1.8-0.6H7.2v4.8H10c0.8,0,1.4-0.2,1.8-0.7C12.3,10.1,12.5,9.5,12.5,8.7z\"/>\n\t\t</g>\n\t\t<g>\n\t\t\t<path class=\"st0\" d=\"M19.9,22.8V2.7h11.7v3.7h-7.3v4.7h6.8v3.7h-6.8v4.2H32v3.7H19.9z\"/>\n\t\t</g>\n\t\t<g>\n\t\t\t<path class=\"st0\" d=\"M51.4,12.7c0,1.7-0.3,3.1-0.9,4.4c-0.6,1.3-1.4,2.3-2.3,3.2c-1,0.8-2.1,1.5-3.3,1.9\n\t\t\t\tc-1.3,0.4-2.6,0.7-3.9,0.7h-6.1V2.7h6.1c1.4,0,2.8,0.2,4.1,0.6c1.3,0.4,2.4,1.1,3.3,1.9c1,0.9,1.7,1.9,2.3,3.2\n\t\t\t\tC51.1,9.6,51.4,11.1,51.4,12.7z M46.8,12.7c0-0.9-0.1-1.7-0.4-2.5c-0.3-0.8-0.7-1.4-1.2-2c-0.5-0.6-1.1-1-1.9-1.3\n\t\t\t\tc-0.7-0.3-1.5-0.5-2.4-0.5h-1.7v12.7h1.7c0.9,0,1.8-0.2,2.5-0.5c0.7-0.3,1.4-0.8,1.9-1.4c0.5-0.6,0.9-1.3,1.2-2\n\t\t\t\tC46.7,14.3,46.8,13.5,46.8,12.7z\"/>\n\t\t</g>\n\t</g>\n\t<g>\n\t\t<path class=\"st1\" d=\"M66.9,15.9H74c-0.2,0.8-0.5,1.6-1,2.3c-0.5,0.7-1.1,1.4-1.8,1.9c-0.7,0.5-1.5,1-2.4,1.3\n\t\t\tc-0.9,0.3-1.8,0.4-2.7,0.4c-1.3,0-2.5-0.2-3.6-0.6c-1.1-0.4-2.1-1-2.9-1.8c-0.8-0.8-1.5-1.7-1.9-2.8c-0.5-1.1-0.7-2.4-0.7-3.7\n\t\t\tc0-1.3,0.2-2.5,0.7-3.6c0.5-1.1,1.1-2.1,1.9-2.9c0.8-0.8,1.8-1.5,2.9-1.9c1.1-0.5,2.3-0.7,3.6-0.7c0.7,0,1.3,0.1,1.9,0.2\n\t\t\tc0.6,0.1,1.1,0.3,1.7,0.5c0.5,0.2,1,0.5,1.5,0.8c0.5,0.3,1,0.8,1.5,1.3l0.1,0.1l0.9-1l-0.1-0.1c-0.9-1-2-1.8-3.2-2.3\n\t\t\tc-1.2-0.5-2.6-0.8-4.2-0.8c-1.5,0-2.9,0.3-4.1,0.8c-1.3,0.5-2.4,1.3-3.4,2.2c-1,0.9-1.7,2-2.3,3.3c-0.6,1.3-0.8,2.6-0.8,4.1\n\t\t\tc0,1.5,0.3,2.9,0.8,4.2c0.5,1.3,1.3,2.4,2.2,3.3c1,0.9,2.1,1.6,3.4,2.1c1.3,0.5,2.7,0.8,4.2,0.8c1.3,0,2.5-0.2,3.6-0.7\n\t\t\tc1.1-0.4,2.1-1.1,2.9-1.8c0.8-0.8,1.5-1.7,2-2.7c0.5-1,0.8-2.1,0.8-3.2l0-0.1h-8.7V15.9z\"/>\n\t\t<rect x=\"78.9\" y=\"2.6\" class=\"st1\" width=\"1.4\" height=\"20.1\"/>\n\t\t<path class=\"st1\" d=\"M91.6,2.3h-0.8l-7.4,20.3l0,0.1h1.5l2.7-7.7h7.2l2.7,7.6l0,0.1h1.5L91.6,2.3L91.6,2.3z M94.4,13.9H88L91.2,5\n\t\t\tL94.4,13.9z\"/>\n\t\t<path class=\"st1\" d=\"M116.4,20.1c0,0.2,0,0.3,0,0.5c0,0,0,0.1,0,0.1l-12.7-18l0,0h-1.7v20.1h1.4v-17c0-0.2,0-0.4,0-0.6\n\t\t\tc0-0.2,0-0.3,0-0.5c0,0,0-0.1,0-0.1l12.8,18.1l0,0h1.6V2.6h-1.4V20.1z\"/>\n\t\t<polygon class=\"st1\" points=\"120.7,2.6 120.7,3.9 125.8,3.9 125.8,22.8 127.2,22.8 127.2,3.9 132.2,3.9 132.2,2.6 \t\t\"/>\n\t</g>\n</g>\n</svg>\n"

/***/ }),
/* 39 */
/***/ (function(module, exports) {

module.exports = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<svg\n   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n   xmlns:cc=\"http://creativecommons.org/ns#\"\n   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"\n   xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"\n   viewBox=\"0 -256 1792 1792\"\n   id=\"svg3025\"\n   version=\"1.1\"\n   inkscape:version=\"0.48.3.1 r9886\"\n   width=\"100%\"\n   height=\"100%\"\n   sodipodi:docname=\"cog_font_awesome.svg\">\n  <metadata\n     id=\"metadata3035\">\n    <rdf:RDF>\n      <cc:Work\n         rdf:about=\"\">\n        <dc:format>image/svg+xml</dc:format>\n        <dc:type\n           rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\" />\n      </cc:Work>\n    </rdf:RDF>\n  </metadata>\n  <defs\n     id=\"defs3033\" />\n  <sodipodi:namedview\n     pagecolor=\"#ffffff\"\n     bordercolor=\"#666666\"\n     borderopacity=\"1\"\n     objecttolerance=\"10\"\n     gridtolerance=\"10\"\n     guidetolerance=\"10\"\n     inkscape:pageopacity=\"0\"\n     inkscape:pageshadow=\"2\"\n     inkscape:window-width=\"640\"\n     inkscape:window-height=\"480\"\n     id=\"namedview3031\"\n     showgrid=\"false\"\n     inkscape:zoom=\"0.13169643\"\n     inkscape:cx=\"896\"\n     inkscape:cy=\"896\"\n     inkscape:window-x=\"0\"\n     inkscape:window-y=\"25\"\n     inkscape:window-maximized=\"0\"\n     inkscape:current-layer=\"svg3025\" />\n  <g\n     transform=\"matrix(1,0,0,-1,121.49153,1285.4237)\"\n     id=\"g3027\">\n    <path\n       d=\"m 1024,640 q 0,106 -75,181 -75,75 -181,75 -106,0 -181,-75 -75,-75 -75,-181 0,-106 75,-181 75,-75 181,-75 106,0 181,75 75,75 75,181 z m 512,109 V 527 q 0,-12 -8,-23 -8,-11 -20,-13 l -185,-28 q -19,-54 -39,-91 35,-50 107,-138 10,-12 10,-25 0,-13 -9,-23 -27,-37 -99,-108 -72,-71 -94,-71 -12,0 -26,9 l -138,108 q -44,-23 -91,-38 -16,-136 -29,-186 -7,-28 -36,-28 H 657 q -14,0 -24.5,8.5 Q 622,-111 621,-98 L 593,86 q -49,16 -90,37 L 362,16 Q 352,7 337,7 323,7 312,18 186,132 147,186 q -7,10 -7,23 0,12 8,23 15,21 51,66.5 36,45.5 54,70.5 -27,50 -41,99 L 29,495 Q 16,497 8,507.5 0,518 0,531 v 222 q 0,12 8,23 8,11 19,13 l 186,28 q 14,46 39,92 -40,57 -107,138 -10,12 -10,24 0,10 9,23 26,36 98.5,107.5 72.5,71.5 94.5,71.5 13,0 26,-10 l 138,-107 q 44,23 91,38 16,136 29,186 7,28 36,28 h 222 q 14,0 24.5,-8.5 Q 914,1391 915,1378 l 28,-184 q 49,-16 90,-37 l 142,107 q 9,9 24,9 13,0 25,-10 129,-119 165,-170 7,-8 7,-22 0,-12 -8,-23 -15,-21 -51,-66.5 -36,-45.5 -54,-70.5 26,-50 41,-98 l 183,-28 q 13,-2 21,-12.5 8,-10.5 8,-23.5 z\"\n       id=\"path3029\"\n       inkscape:connector-curvature=\"0\"\n       style=\"fill:currentColor\" />\n  </g>\n</svg>\n"

/***/ }),
/* 40 */
/***/ (function(module, exports) {

module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 320 512\"><path fill=\"currentColor\" d=\"M31.3 192h257.3c17.8 0 26.7 21.5 14.1 34.1L174.1 354.8c-7.8 7.8-20.5 7.8-28.3 0L17.2 226.1C4.6 213.5 13.5 192 31.3 192z\"/></svg>"

/***/ }),
/* 41 */
/***/ (function(module, exports) {

module.exports = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 22.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 24 24\" style=\"enable-background:new 0 0 24 24;\" xml:space=\"preserve\">\n<g>\n\t\t<image style=\"overflow:visible;opacity:0.9;\" width=\"24\" height=\"24\" xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsSAAALEgHS3X78AAAA\nGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAgFJREFUeNq0letOwkAQhVtaCxQQ\nAS8RY/xtjL7/wxhj4i2CIhdRKLR1Nvk2GZsWS4JNTpbS2T1nzszuOs72j7tNsLdFbEXgC/YgSXdJ\nYBavCXqCLv+tBckuCIzaQHAiuBJcCFaCGePGTPySBFVBX3AjqAumgmfBV5nUyxLsA0NwIGgi0N0m\nAzdnDFjMkIyx1bx3BCNqoW1K9ejndElVKTMIsactGBAXUvAPukoX2xAubBP4SqmPqlMU2izqFLiF\n7y5kZ2QzV/Md6vNIdiudgbHiWHANkemQCMUBBR0Ra2rQEJwLYrJuI+YZ9Z9ZAkdtoDVKJqQbMeGN\nuBlZepD3sK2eLbqXU1SP0S46wvsBhHMILHnKnAhrbgVPzE28TPXXBLoobLGDbcrfanM1qE0XG18F\nd5BMbXdlCWIIlsrrPgW06hOsMP5fImQoeCDLL9262RokpP2Oqg4qPQrZYnLI75BWHWLlIns+5R0V\nibJqBSq0bw9lKVksVVycdy75BUeDh/c1CJss7rHIAuURWTTZcMssSdFhF2DPoeqwiBo42BUwhsRW\n1fdSGdTxuUJbvlBE8xxRm31iOhBNsGojge2mbya49PW92skz4qw1FTX+uu2KLFqi2KoZ4fmC9xjM\n1P0wziu0+8f9Gyj/9RVpFQfYGSNqVZYg71u64e5IC2L+//kRYABPo6CisBpWnQAAAABJRU5ErkJg\ngg==\">\n\t</image>\n\t<g>\n\t\t<polygon class=\"s-fill\" fill=\"currentColor\" points=\"11.2,3.4 13.1,9.5 19.2,9.5 14.3,13.3 16.2,19.4 11.2,15.6 6.3,19.4 8.2,13.3 3.2,9.5 9.4,9.5\"/>\n\t\t<polygon class=\"s-border\" fill=\"none\" stroke=\"currentColor\" stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-miterlimit=\"10\" \n\t\t\tpoints=\"11.2,3.4 13.1,9.5 19.2,9.5 14.3,13.3 16.2,19.4 11.2,15.6 6.3,19.4 8.2,13.3 3.2,9.5 9.4,9.5\"/>\n\t</g>\n</g>\n</svg>\n"

/***/ }),
/* 42 */
/***/ (function(module, exports) {

module.exports = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 22.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 14 14\" style=\"enable-background:new 0 0 14 14;\" xml:space=\"preserve\">\n<g>\n\t<path fill=\"currentColor\" d=\"M7,1C3.7,1,1,3.7,1,7c0,3.3,2.7,6,6,6c3.3,0,6-2.7,6-6C13,3.7,10.3,1,7,1 M6.4,9.5L6,10L5.6,9.5L3.2,6.8L4,6\n\t\tl2,2l4-4l0.8,0.8L6.4,9.5z\"/>\n</g>\n</svg>\n"

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(44);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".uni-content-grid .fav-button,\n.uni-content-grid .apply {\n  display: none;\n}\n.uni-content-grid .fav-button {\n  width: 22px;\n  height: 22px;\n}\n.uni-content-grid .fav-button .icon {\n  width: 100%;\n  height: 100%;\n}\n.uni-content-grid .apply.text-button {\n  background: #3077b2;\n  border-radius: 3px;\n  width: 75px;\n  height: 16px;\n}\n.uni-content-grid .apply.text-button .content {\n  position: absolute;\n  width: 100%;\n  margin-top: 1px;\n  margin-bottom: 2px;\n  color: white;\n  font-family: RGMajorBook;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 14px;\n  text-align: center;\n}\n.uni-content-grid .apply.icon-button {\n  width: 20px;\n  height: 20px;\n}\n.uni-content-grid .apply.icon-button .icon {\n  color: #3077b2;\n}\n.uni-content-grid .apply.text-button:hover {\n  background: #569fd1;\n}\n.uni-content-grid .apply.icon-button:hover .icon {\n  color: #569fd1;\n}\n.uni-content-grid .grid-item:hover .fav-button .s-fill {\n  color: transparent;\n}\n.uni-content-grid .grid-item:hover .fav-button .s-border {\n  color: #d7d7d7;\n}\n.uni-content-grid .grid-item .fav-button:hover .s-fill {\n  color: #d7d7d7;\n}\n.uni-content-grid .grid-item .fav-button:hover .s-border {\n  color: #d7d7d7;\n}\n.uni-content-grid .favorited .fav-button .icon .s-fill {\n  color: #40bafb;\n}\n.uni-content-grid .favorited .fav-button .icon .s-border {\n  color: #40bafb;\n}\n.uni-content-grid .favorited .fav-button:hover .icon .s-fill {\n  color: #40bafb;\n}\n.uni-content-grid .favorited .fav-button:hover .icon .s-border {\n  color: #40bafb;\n}\n.uni-content-grid .favorited .fav-button,\n.uni-content-grid .grid-item:hover .fav-button,\n.uni-content-grid .grid-item:hover .apply {\n  display: block;\n}\n.thumbnail-grid .fav-button {\n  position: absolute;\n  top: 5px;\n  left: 5px;\n  cursor: pointer;\n}\n.thumbnail-grid .apply.text-button {\n  position: relative;\n  cursor: pointer;\n  margin-left: calc(50% - 37.5px);\n}\n.thumbnail-grid .apply.icon-button {\n  position: relative;\n  cursor: pointer;\n  margin-left: calc(50% - 10px);\n}\n.list-grid .fav-button {\n  position: absolute;\n  top: 0px;\n  right: 12px;\n  cursor: pointer;\n}\n.list-grid .apply {\n  position: absolute;\n  right: 37px;\n  top: 4px;\n  cursor: pointer;\n}\n.uni_effect_cat_transition .uni-content-grid.uni-preset-grid .grid-item:hover .apply {\n  display: none;\n}\n", ""]);

// exports


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(46);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DescriptionPanel =
/*#__PURE__*/
function () {
  function DescriptionPanel(params) {
    _classCallCheck(this, DescriptionPanel);

    params = params ? params : {};

    _.defaults(params, {
      div: $(),
      data: null,
      applyCallback: null
    });

    this._div = params.div;
    this._data = params.data;
    this._applyCallback = params.applyCallback;
    this.populate();
  }

  _createClass(DescriptionPanel, [{
    key: "populate",
    value: function populate() {
      if (!this._data || !this._data.rootItem) {
        return;
      }

      this._div.addClass('description-item');

      var item = this._data.rootItem;
      var title = item.displayName ? item.displayName : item.name;

      if (!title) {
        title = "";
      }

      this._div.append('<div class="heading title">' + title + '</div>');

      if (this._applyCallback) {
        var applyButton = $('<div class="desc-apply">Apply Effect</div>');
        applyButton.click(this.onApplyClicked.bind(this));
        applyButton.attr('rg_tooltip', 'uni_grid_item');
        applyButton.attr('toolTipText', 'Applies an instance of the effect using its default settings.');
        RG.ui.tooltips.addTooltip(applyButton, 'uni_grid_item');

        this._div.append(applyButton);
      }

      if (typeof item.description === "string") {
        this._div.append('<div class="description">' + item.description + '</div>');
      }

      this._div.append('<div class="heading">Presets</div>');
    }
  }, {
    key: "onApplyClicked",
    value: function onApplyClicked(event) {
      if (typeof this._applyCallback !== 'function') {
        return;
      }

      this._applyCallback({
        event: event,
        name: this._data.rootItem.name,
        item: this,
        data: this._data.rootItem
      });

      event.stopPropagation();
    }
  }]);

  return DescriptionPanel;
}();

module.exports = DescriptionPanel;

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(47);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".uni-content-grid .description-item {\n  display: block;\n}\n.description-item {\n  width: 100%;\n  display: block;\n  font-size: 12px;\n  color: #9b9b9b;\n  padding-top: 8px;\n  padding-bottom: 8px;\n  padding-left: 10px;\n  padding-right: 10px;\n  position: relative;\n  max-height: none;\n}\n.description-item .heading {\n  font-family: RGMajorBook;\n  font-size: 24px;\n  color: #d2e1e1;\n  text-overflow: ellipsis;\n  text-transform: uppercase;\n  white-space: nowrap;\n  overflow: hidden;\n  max-height: 28px;\n}\n.description-item .title {\n  margin-right: 92px;\n}\n.description-item .description {\n  padding-top: 6px;\n  font-size: 13px;\n  padding-bottom: 18px;\n  font-family: RGMajorSans;\n  font-weight: 500;\n}\n.description-item .desc-apply {\n  position: absolute;\n  top: 9px;\n  right: 10px;\n  width: 88px;\n  height: 22px;\n  line-height: 22px;\n  background-color: #3077b2;\n  border-radius: 4px;\n  color: white;\n  font-family: RGMajorSans;\n  font-size: 14px;\n  text-align: center;\n  cursor: pointer;\n}\n.description-item .desc-apply:hover {\n  background: #569fd1;\n}\n.thumbnail-grid .rg_grid_item.description-item {\n  max-height: none;\n}\n", ""]);

// exports


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(49);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".uni_fav {\n  position: absolute;\n  right: 5px;\n  top: 5px;\n  width: 15px;\n  height: 15px;\n}\n.rg_grid_item {\n  outline: none;\n  border-style: none;\n}\n.uni-effect-grid .rg_grid_group_toggle {\n  display: none;\n}\n.uni-effect-grid .rg_cb_grid_header_title {\n  padding-left: 14px;\n}\n.rg_cb_grid_apply {\n  position: absolute;\n  left: 20px;\n  right: 20px;\n  bottom: 10px;\n  height: 18px;\n}\n.content_service_error {\n  color: #aaa;\n  font-size: 16px;\n  text-align: center;\n}\n", ""]);

// exports


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(51);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".list-grid .grid-item-base {\n  position: relative;\n  width: 100%;\n  height: 25px;\n}\n.list-grid .rg_grid_item {\n  position: relative;\n  width: 100%;\n  height: 25px;\n}\n.list-grid .grid-item {\n  position: relative;\n  width: 100%;\n  height: 25px;\n  border-style: solid;\n  border-left-width: 1px;\n  border-top-width: 0px;\n  border-right-width: 0px;\n  border-bottom-width: 1px;\n  border-color: #3b3b3b;\n}\n.list-grid .grid-item .item-wrap {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.list-grid .grid-item .item-wrap .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap .media {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap .media-border {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .control-wrap {\n  position: relative;\n}\n.list-grid .grid-item .item-wrap .content .control-wrap .title {\n  position: absolute;\n  left: 8px;\n  width: calc(100% - 50px);\n  height: 25px;\n  line-height: 25px;\n  color: #d7d7d7;\n  font-family: RGMajorBook;\n  font-weight: normal;\n  font-size: 14px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.thumbnail-grid .grid-item-base {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n}\n.thumbnail-grid .rg_grid_item {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n}\n.thumbnail-grid .grid-item {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n  position: relative;\n  display: inline-block;\n  margin-left: 1px;\n  background: transparent;\n}\n.thumbnail-grid .grid-item .item-wrap {\n  background-color: transparent;\n  position: relative;\n  width: calc(100% - 10px);\n  padding-top: calc(100% - 10px);\n  margin-top: 5px;\n  margin-left: 5px;\n}\n.thumbnail-grid .grid-item .item-wrap .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap {\n  position: absolute;\n  width: 100%;\n  padding-bottom: 56.25%;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap .media {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  background: black;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap .media-border {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n}\n.thumbnail-grid .grid-item .item-wrap .content .control-wrap {\n  position: absolute;\n  width: 100%;\n  top: calc(56.25% + 4px);\n  text-align: center;\n}\n.thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n  display: block;\n  width: 100%;\n  color: #d7d7d7;\n  font-family: RGMajorBook;\n  font-weight: normal;\n  font-size: 12px;\n  margin-bottom: 4px;\n}\n.thumbnail-grid .grid-item.rg_grid_item_collapsed {\n  display: none;\n}\n.thumbnail-grid .desc-grid-item-base {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.thumbnail-grid .rg_grid_item.description-item {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.thumbnail-grid .grid-item.description-item {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.grid-item.can-hover:hover {\n  background-color: #3c3c3c;\n}\n.grid-item.can-select.grid-item-selected {\n  background-color: #3c3c3c;\n}\n@media (max-width: 350px) {\n  .thumbnail-grid .grid-item {\n    min-height: 115px;\n  }\n  .thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n    min-height: 25px;\n    margin-bottom: 1px;\n  }\n}\n@media (min-width: 565px) {\n  .thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n    font-size: 14px;\n  }\n}\n", ""]);

// exports


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _styler = _interopRequireDefault(__webpack_require__(31));

__webpack_require__(53);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var PresetGridStyler =
/*#__PURE__*/
function (_Styler) {
  _inherits(PresetGridStyler, _Styler);

  function PresetGridStyler(params) {
    var _this;

    _classCallCheck(this, PresetGridStyler);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PresetGridStyler).call(this, params));
    _this.applyButtonOptions = {
      style: 'text',
      text: 'Apply Preset',
      tooltip: {
        title: 'Apply Preset',
        description: 'Applies effect using preset settings'
      }
    };
    _this.tooltipOptions = {
      rollover: {
        content: "\n                    <div style=\"font-size: 10px; max-width: 150px;\">\n                        Double-click to apply this effect using preset settings.\n                    </div>\n                    ",
        isEnabled: false
      }
    };
    return _this;
  }

  _createClass(PresetGridStyler, [{
    key: "styleGridGroupHeader",
    value: function styleGridGroupHeader(gridView, groupHeaderDiv, groupData) {
      if (this._contentGrid) {
        this._contentGrid.styleGridGroupHeader(gridView, groupHeaderDiv, groupData);

        groupHeaderDiv.addClass('rg_cb_group_header_short');
        groupHeaderDiv.addClass('rg_grid_toggle_flattened');
      }
    }
  }]);

  return PresetGridStyler;
}(_styler.default);

module.exports = PresetGridStyler;

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(54);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".list-grid .grid-item-base {\n  position: relative;\n  width: 100%;\n  height: 25px;\n}\n.list-grid .rg_grid_item {\n  position: relative;\n  width: 100%;\n  height: 25px;\n}\n.list-grid .grid-item {\n  position: relative;\n  width: 100%;\n  height: 25px;\n  border-style: solid;\n  border-left-width: 1px;\n  border-top-width: 0px;\n  border-right-width: 0px;\n  border-bottom-width: 1px;\n  border-color: #3b3b3b;\n}\n.list-grid .grid-item .item-wrap {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.list-grid .grid-item .item-wrap .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap .media {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .media-wrap .media-border {\n  position: absolute;\n  display: none;\n  width: 0px;\n  height: 0px;\n}\n.list-grid .grid-item .item-wrap .content .control-wrap {\n  position: relative;\n}\n.list-grid .grid-item .item-wrap .content .control-wrap .title {\n  position: absolute;\n  left: 8px;\n  width: calc(100% - 50px);\n  height: 25px;\n  line-height: 25px;\n  color: #d7d7d7;\n  font-family: RGMajorBook;\n  font-weight: normal;\n  font-size: 14px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.thumbnail-grid .grid-item-base {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n}\n.thumbnail-grid .rg_grid_item {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n}\n.thumbnail-grid .grid-item {\n  min-width: 100px;\n  max-width: 178.44px;\n  width: calc(33% - 2px);\n  max-height: 150px;\n  overflow: hidden;\n  position: relative;\n  display: inline-block;\n  margin-left: 1px;\n  background: transparent;\n}\n.thumbnail-grid .grid-item .item-wrap {\n  background-color: transparent;\n  position: relative;\n  width: calc(100% - 10px);\n  padding-top: calc(100% - 10px);\n  margin-top: 5px;\n  margin-left: 5px;\n}\n.thumbnail-grid .grid-item .item-wrap .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap {\n  position: absolute;\n  width: 100%;\n  padding-bottom: 56.25%;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap .media {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  background: black;\n}\n.thumbnail-grid .grid-item .item-wrap .content .media-wrap .media-border {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n}\n.thumbnail-grid .grid-item .item-wrap .content .control-wrap {\n  position: absolute;\n  width: 100%;\n  top: calc(56.25% + 4px);\n  text-align: center;\n}\n.thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n  display: block;\n  width: 100%;\n  color: #d7d7d7;\n  font-family: RGMajorBook;\n  font-weight: normal;\n  font-size: 12px;\n  margin-bottom: 4px;\n}\n.thumbnail-grid .grid-item.rg_grid_item_collapsed {\n  display: none;\n}\n.thumbnail-grid .desc-grid-item-base {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.thumbnail-grid .rg_grid_item.description-item {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.thumbnail-grid .grid-item.description-item {\n  width: calc(100% - 2 * 10px);\n  max-width: none;\n}\n.grid-item.can-hover:hover {\n  background-color: #3c3c3c;\n}\n.grid-item.can-select.grid-item-selected {\n  background-color: #3c3c3c;\n}\n@media (max-width: 535px) {\n  .thumbnail-grid .grid-item {\n    min-height: 115px;\n  }\n  .thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n    min-height: 25px;\n    margin-bottom: 1px;\n  }\n}\n@media (min-width: 750px) {\n  .thumbnail-grid .grid-item .item-wrap .content .control-wrap .title {\n    font-size: 14px;\n  }\n}\n", ""]);

// exports


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _content_arranger_simple = __webpack_require__(28);

var _display_strings = _interopRequireDefault(__webpack_require__(56));

var _expansionState = _interopRequireDefault(__webpack_require__(57));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var PresetGridGroupers = {
  groupByCategory: function groupByCategory(contentItem) {
    if (contentItem.isUserGenerated) {
      return "Custom";
    }

    if (typeof contentItem.category === "string" && !PresetGridGroupers.isDefaultPreset(contentItem)) {
      return contentItem.category;
    }

    return "";
  },
  isDefaultPreset: function isDefaultPreset(contentItem) {
    return contentItem.name === "Default" || contentItem.displayName === "Default";
  },
  sortGroups: function sortGroups(a, b) {
    var s1 = "" + a;
    var s2 = "" + b; // empty at the front

    if (s1 === "") {
      return -1;
    } else if (s2 === "") {
      return 1;
    } // custom at the end


    if (s1 === "Custom") {
      return 1;
    } else if (s2 === "Custom") {
      return -1;
    } // alphabetical


    return s1.localeCompare(s2);
  }
};

var PresetGridArranger =
/*#__PURE__*/
function (_ContentArrangerSimpl) {
  _inherits(PresetGridArranger, _ContentArrangerSimpl);

  function PresetGridArranger(params) {
    _classCallCheck(this, PresetGridArranger);

    if (!params) {
      params = {};
    }

    _.defaults(params, {
      getGroupId: PresetGridGroupers.groupByCategory,
      getDataForGroupId: function getDataForGroupId(grouypId) {
        return {
          name: _display_strings.default.categoryName(grouypId),
          expand: true
        };
      },
      groupCompareFunction: PresetGridGroupers.sortGroups
    });

    return _possibleConstructorReturn(this, _getPrototypeOf(PresetGridArranger).call(this, params));
  }

  _createClass(PresetGridArranger, [{
    key: "setRootItem",
    value: function setRootItem(contentItem) {
      this._rootItem = contentItem;
    }
  }, {
    key: "getRootItem",
    value: function getRootItem() {
      return this._rootItem;
    }
  }, {
    key: "setContent",
    value: function setContent(contentList) {
      this._items = this.filterItems(contentList);

      if (typeof this._params.compareItemFunc === "function") {
        this._items.sort(this._params.compareItemFunc);
      } // move the "default" preset to the front


      for (var i = 0; i < this._items.length; i++) {
        if (PresetGridGroupers.isDefaultPreset(this._items[i])) {
          var dp = this._items[i];

          this._items.splice(i, 1);

          this._items.splice(0, 0, dp);

          break;
        }
      } // add a description item at the very top


      if (this._rootItem) {
        this._items.splice(0, 0, {
          kind: "description",
          rootItem: this._rootItem
        });
      }

      this._buildGroups();
    }
  }, {
    key: "getGroupExpansionStates",
    value: function getGroupExpansionStates() {
      if (this._rootItem === null || this._rootItem === undefined) {
        return [];
      }

      if (!Array.isArray(this._groups)) {
        return [];
      }

      var states = [];

      for (var i = 0; i < this._groups.length; i++) {
        var group = this._groups[i];

        var state = _expansionState.default.findState(this._rootItem._id, group.groupId);

        states.push({
          id: group.groupId,
          isExpanded: state.isExpanded
        });
      }

      return states;
    }
  }]);

  return PresetGridArranger;
}(_content_arranger_simple.ContentArrangerSimple);

module.exports = PresetGridArranger;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var DisplayStrings = {
  keyToTitle: function keyToTitle(keyStr) {
    // Underscore to space
    var s = keyStr.replace(/_/g, " "); // Title case
    // https://stackoverflow.com/questions/196972/convert-string-to-title-case-with-javascript

    return s.replace(/\w\S*/g, function (txt) {
      return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
    });
  },
  categoryName: function categoryName(nameStr) {
    // Remove any formatting characters
    var displayStr = DisplayStrings.keyToTitle(nameStr); // Knock "Universe " off the front.

    var uniPrefix = "Universe ";

    if (displayStr.indexOf(uniPrefix) === 0) {
      displayStr = nameStr.substr(uniPrefix.length);
    }

    return displayStr;
  }
};
module.exports = DisplayStrings;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionState =
/*#__PURE__*/
function () {
  function ExpansionState(api) {
    _classCallCheck(this, ExpansionState);

    this.api = api;
    this.state = {
      _id: null,
      kind: 'expansion-state',
      items: []
    };
  }

  _createClass(ExpansionState, [{
    key: "initialize",
    value: function initialize() {
      var _this = this;

      if (this.state._id !== null) {
        // We've already initialized
        return new Promise(function (resolve, reject) {
          resolve(_this.state);
        });
      }

      var request = this.api.get({
        kind: 'expansion-state'
      });
      return request.then(function (data) {
        if (data.length === 0) {
          return _this.api.create(_this.state).then(function (data) {
            _this.state = data;
          });
        } else {
          _this.state = data[0];
          return new Promise(function (resolve, reject) {
            resolve(_this.state);
          });
        }
      }).catch(function (err) {
        console.log("Error when calling initialize");
        console.log(err); // Return whatever cached state we have

        return _this.state;
      });
    }
  }, {
    key: "getState",
    value: function getState() {
      var _this2 = this;

      // UP-3779: Due to timing we could get into getState()
      // very early in the startup process.
      // We need to ensure initialize() has completed, otherwise
      // we could have a null for this.state._id 
      return this.initialize().then(function () {
        var request = _this2.api.get({
          _id: _this2.state._id
        });

        return request.then(function (data) {
          if (data.length === 0) {
            return _this2.state;
          } else {
            var model = data[0];
            _this2.state = model;
            return _this2.state;
          }
        });
      }).catch(function (err) {
        console.log("Error when calling getState");
        console.log(err); // Return whatever cached state we have

        return _this2.state;
      });
    }
  }, {
    key: "setState",
    value: function setState(effectId, category, isExpanded) {
      var _this3 = this;

      return this.initialize().then(function () {
        var filter = function filter(item) {
          return item.effectId === effectId && item.category === category;
        };

        var foundItems = _this3._findItems(filter);

        if (foundItems.length > 0) {
          for (var i = foundItems.length - 1; i >= 0; i--) {
            var foundItem = foundItems[i];

            _this3.state.items.splice(foundItem.index, 1);
          }
        }

        _this3.state.items.push({
          effectId: effectId,
          category: category,
          isExpanded: isExpanded
        });

        return _this3.api.update(_this3.state).then(function () {
          return _this3.state;
        });
      });
    }
  }, {
    key: "findState",
    value: function findState(effectId, category) {
      var filter = function filter(item) {
        return item.effectId === effectId && item.category === category;
      };

      var foundItems = this._findItems(filter);

      if (foundItems.length > 0) {
        return foundItems[0].item;
      }

      return {
        effectId: effectId,
        category: category,
        isExpanded: true
      };
    }
  }, {
    key: "_findItems",
    value: function _findItems(filter) {
      var foundItems = [];

      for (var i = 0; i < this.state.items.length; i++) {
        var item = this.state.items[i];

        if (filter(item)) {
          foundItems.push({
            index: i,
            item: item
          });
        }
      }

      return foundItems;
    }
  }]);

  return ExpansionState;
}();

;

var ExpansionStateService =
/*#__PURE__*/
function () {
  function ExpansionStateService() {
    _classCallCheck(this, ExpansionStateService);

    this.instance = null;
  }

  _createClass(ExpansionStateService, [{
    key: "initialize",
    value: function initialize(api) {
      this.instance = new ExpansionState(api);
      return this.instance.initialize();
    }
  }, {
    key: "setState",
    value: function setState(effectId, category, isExpanded) {
      if (this.instance === null || this.instance === undefined) {
        throw 'Service is not initialized, did you forget to set the api?';
      }

      return this.instance.setState(effectId, category, isExpanded);
    }
  }, {
    key: "getState",
    value: function getState() {
      if (this.instance === null || this.instance === undefined) {
        throw 'Service is not initialized, did you forget to set the api?';
      }

      return this.instance.getState();
    }
  }, {
    key: "findState",
    value: function findState(effectId, category) {
      if (this.instance === null || this.instance === undefined) {
        throw 'Service is not initialized, did you forget to set the api?';
      }

      return this.instance.findState(effectId, category);
    }
  }]);

  return ExpansionStateService;
}();

module.exports = new ExpansionStateService();

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var NxContentTransport =
/*#__PURE__*/
function () {
  function NxContentTransport() {
    _classCallCheck(this, NxContentTransport);

    this._apiPrefix = "/nx_api/";
    this._contentPrefix = this._apiPrefix + "universe/content/";
  }

  _createClass(NxContentTransport, [{
    key: "makeRequest",
    value: function makeRequest(requestParams) {
      if (!requestParams) {
        console.log("Error: empty request made.");
        return;
      }

      requestParams.path = this._contentPrefix + requestParams.path;

      _.defaults(requestParams, {
        method: "GET",
        success: null,
        failure: null
      });

      nx_api.router.makeRequest(requestParams);
    }
  }]);

  return NxContentTransport;
}();

module.exports = NxContentTransport;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionState =
/*#__PURE__*/
function () {
  function ExpansionState(matchname, assetKind, api) {
    _classCallCheck(this, ExpansionState);

    this.matchname = matchname !== undefined ? matchname : "";
    this.assetKind = assetKind;
    this.api = api;
    this.expansionstate = [];
  }

  _createClass(ExpansionState, [{
    key: "getState",
    value: function getState() {
      var _this = this;

      try {
        return this.api.get(this.matchname, this.assetKind).then(function (data) {
          _this.expansionstate = data.expansionstate;
          return _this.expansionstate;
        });
      } catch (err) {
        console.log("Error when calling getState");
        console.log(err);
        return this.expansionstate;
      }

      ;
    }
  }, {
    key: "setState",
    value: function setState(category, isExpanded) {
      var _this2 = this;

      var filter = function filter(item) {
        return item.category === category;
      };

      var foundItems = this._findItems(filter);

      if (foundItems.length > 0) {
        for (var i = foundItems.length - 1; i >= 0; i--) {
          var foundItem = foundItems[i];
          this.expansionstate.splice(foundItem.index, 1);
        }
      }

      this.expansionstate.push({
        category: category,
        isExpanded: isExpanded
      });

      try {
        return this.api.update(this.matchname, this.assetKind, this.expansionstate).then(function (data) {
          _this2.expansionstate = data.expansionstate;
          return _this2.expansionstate;
        });
      } catch (err) {
        console.log("Error when calling setState");
        console.log(err);
        return this.expansionstate;
      }

      ;
    }
  }, {
    key: "findState",
    value: function findState(category) {
      var filter = function filter(item) {
        return item.category === category;
      };

      var foundItems = this._findItems(filter);

      if (foundItems.length > 0) {
        return foundItems[0].item;
      } else {
        return {
          category: category,
          isExpanded: true
        };
      }
    }
  }, {
    key: "_findItems",
    value: function _findItems(filter) {
      var foundItems = [];

      for (var i = 0; i < this.expansionstate.length; i++) {
        var item = this.expansionstate[i];

        if (filter(item)) {
          foundItems.push({
            index: i,
            item: item
          });
        }
      }

      return foundItems;
    }
  }]);

  return ExpansionState;
}();

;
module.exports = ExpansionState;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionStateAPI =
/*#__PURE__*/
function () {
  function ExpansionStateAPI(apiTransport) {
    _classCallCheck(this, ExpansionStateAPI);

    this._transport = apiTransport;
  }

  _createClass(ExpansionStateAPI, [{
    key: "_buildQuery",
    value: function _buildQuery(effectMatchName, assetKind) {
      return "matchname=" + effectMatchName + "&" + "assetKind=" + assetKind;
    }
  }, {
    key: "get",
    value: function get(effectMatchName, assetKind) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        if (!_this._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "GET",
          query: _this._buildQuery(effectMatchName, assetKind),
          success: function success(d) {
            return resolve(d);
          },
          failure: reject
        };

        _this._transport.makeRequest(requestParams);
      });
    }
  }, {
    key: "update",
    value: function update(effectMatchName, assetKind, state) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        if (!_this2._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "PUT",
          query: _this2._buildQuery(effectMatchName, assetKind),
          data: {
            expansionstate: state
          },
          success: function success(d) {
            return resolve(d);
          },
          failure: reject
        };

        _this2._transport.makeRequest(requestParams);
      });
    }
  }]);

  return ExpansionStateAPI;
}();

module.exports = ExpansionStateAPI;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionStateTransport =
/*#__PURE__*/
function () {
  function ExpansionStateTransport() {
    _classCallCheck(this, ExpansionStateTransport);

    this._apiPath = "/nx_api/expansionstate";
  }

  _createClass(ExpansionStateTransport, [{
    key: "makeRequest",
    value: function makeRequest(requestParams) {
      if (!requestParams) {
        console.log("Error: empty request made.");
        return;
      }

      requestParams.path = this._apiPath;

      if (requestParams.query) {
        requestParams.path += "?" + requestParams.query;
      }

      _.defaults(requestParams, {
        method: "GET",
        success: null,
        failure: null
      });

      nx_api.router.makeRequest(requestParams);
    }
  }]);

  return ExpansionStateTransport;
}();

module.exports = ExpansionStateTransport;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DialogFooter =
/*#__PURE__*/
function () {
  /* 
  Delegate methods
       validateOk: function() { return true; }
      getDialogResult: function() { return {}; }
      onCancel: function() { }
      onOk: function(dialogResult) { }
   */
  function DialogFooter(delegate) {
    _classCallCheck(this, DialogFooter);

    this._delegate = delegate ? delegate : {};

    this._buildUI();

    this._handleKeys();

    this.updateState();
  }

  _createClass(DialogFooter, [{
    key: "_buildUI",
    value: function _buildUI() {
      var holder = $('#dialog_footer');
      var footer = $('<div class="dialog_footer_outer"></div>');
      holder.append(footer);
      var footerInner = $('<div class="dialog_footer_inner"></div>');
      footer.append(footerInner);
      var cancelDiv = $('<div class="dialog_footer_button"></div>');
      Widgets.buildFlatButton(cancelDiv, __("Cancel"), this._onCancel.bind(this));
      footerInner.append(cancelDiv);
      footerInner.append('<div class="dialog_footer_space"></div>');
      var okDiv = $('<div class="dialog_footer_button"></div>');
      Widgets.buildFlatButton(okDiv, __("Apply"), this._onOk.bind(this));
      footerInner.append(okDiv);
      this._okButton = okDiv;
    }
  }, {
    key: "updateState",
    value: function updateState() {
      var enableOk = true;

      if (typeof this._delegate.validateOk === "function") {
        enableOk = this._delegate.validateOk();
      }

      this._okButton.toggleClass('disabled', !enableOk);
    }
  }, {
    key: "_handleKeys",
    value: function _handleKeys() {
      var _this = this;

      var self = this;
      $(document).keydown(function (e) {
        if (e.keyCode === 13) {
          // Enter
          if (!_this._okButton.hasClass('disabled')) {
            _this._onOk();
          }
        } else if (e.keyCode === 27) {
          // Escape
          _this._onCancel();
        }
      });
    }
  }, {
    key: "_onCancel",
    value: function _onCancel() {
      if (typeof this._delegate.onCancel === "function") {
        this._delegate.onCancel();
      }
    }
  }, {
    key: "_onOk",
    value: function _onOk() {
      var result = typeof this._delegate.getDialogResult === "function" ? this._delegate.getDialogResult() : {};

      if (typeof this._delegate.onOk === "function") {
        this._delegate.onOk(result);
      }
    }
  }]);

  return DialogFooter;
}();

module.exports = DialogFooter;

/***/ })
/******/ ]);