function NameDialogFunc() {

    var isFileNameValid = function(fileName) {
		if (fileName.length > 0 && fileName[0] != '.') {
			var illegalCharRegex = new RegExp('[\\\\\/:*?\"<>|]+');
            
			return !illegalCharRegex.test(fileName);
        }
        
		return false;
    };

    this.init = function() {

        this.nameField = document.getElementById('name-field');
        this.okButton = document.getElementById('ok_button');
        this.cancelButton = document.getElementById('cancel_button');

        this.nameField.focus();

        if (typeof nx_api !== "undefined") {

            nx_api.init();
            nx_api.initialState.get().then(_prepareDialog);

            this.onCancelButtonClicked = function() {
                nx_api.nx_window.setDialogResult(0);
                nx_api.nx_window.close();
            };

            this.cancelClickedDelegate = this.onCancelButtonClicked.bind(this);
            this.cancelButton.onclick = this.cancelClickedDelegate;

            this.onOkButtonClicked = function () {
                var name = this.nameField.value;

                var params = {
                    name: name
                };

                nx_api.nx_window.setDialogResult(1, params);
                nx_api.nx_window.close();
            }

            this.okayClickedDelegate = this.onOkButtonClicked.bind(this);
            this.okButton.onclick = this.okayClickedDelegate;
        }

        this.okButton.disabled = true;

        this.processTextChanged = function() {
            var text = this.nameField.value;
    
            this.okButton.disabled = false;

            if (!isFileNameValid(text)) {
                this.okButton.disabled = true;
            }
        }

        this.processTextChangedDelegate = this.processTextChanged.bind(this);

        this.onKeyDown = function(event) {
            if (event.key === 'Escape') {
                this.cancelClickedDelegate();
            }

            if (event.key === 'Enter' && this.okButton.disabled === false) {
                this.okayClickedDelegate();
            }
            else {
                setTimeout(this.processTextChangedDelegate, 15);
            }
        }

        this.onTextChanged = function() {
            setTimeout(this.processTextChangedDelegate, 15);
        }

        this.onKeyDownDelegate = this.onKeyDown.bind(this);
        this.onTextChangedDelegate = this.onTextChanged.bind(this);

        this.nameField.onchange = this.onTextChangedDelegate;
        this.nameField.onkeyup = this.onTextChangedDelegate;
        this.nameField.onkeydown = this.onKeyDownDelegate;
        this.nameField.onpaste = this.onTextChangedDelegate;

        this.onWindowKey = function(event) {
            if (event.key === 'Escape') {
                this.cancelClickedDelegate();
            }
            if (event.key === 'Enter' && this.okButton.disabled === false) {
                this.okayClickedDelegate();
            }
        }

        this.onWindowKeyDelegate = this.onWindowKey.bind(this);
        window.onkeyup = this.onWindowKeyDelegate;
    };

    var _prepareDialog = function(params) {
        
    };

};

var DialogApp = new NameDialogFunc();

document.addEventListener("DOMContentLoaded", function() {    
    DialogApp.init();
});