/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1);

var _content_store = _interopRequireDefault(__webpack_require__(6));

var _filtered_content_provider = _interopRequireDefault(__webpack_require__(12));

var _content_grid = _interopRequireDefault(__webpack_require__(14));

var _content_arranger_simple = __webpack_require__(17);

var _content_api_json = _interopRequireDefault(__webpack_require__(19));

var _mockHud = _interopRequireDefault(__webpack_require__(22));

var _footer2 = _interopRequireDefault(__webpack_require__(23));

var _videoRollover = _interopRequireDefault(__webpack_require__(24));

var _expansionstate = _interopRequireDefault(__webpack_require__(27));

var _expansionstate_api = _interopRequireDefault(__webpack_require__(28));

var _expansionstate_transport = _interopRequireDefault(__webpack_require__(29));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function mainFunc() {
  var _self = this;

  var _contentStore = null;
  var _grid = null;
  var _footer = null;
  var _chosenItems = [];

  var _initialIndex = -1;

  var _categoryList = [];

  this.getApplicationParameters = function () {
    return {
      connectWs: false,
      validateServerVersion: false,
      loadSysInfo: false,
      hasAppServer: false
    };
  };

  this.init = function () {
    if (typeof nx_api !== "undefined") {
      nx_api.init();
    }
  };

  this.initGrid = function (params) {
    _initialIndex = params.initialSelectionIdx;
    _categoryList = this.buildCategoryList(params.itemsAvailable);
    _contentStore = new _content_store.default(new _content_api_json.default(params.itemsAvailable));
    _grid = new _content_grid.default({
      delegate: _self,
      gridDelegate: _self,
      gridStyler: _self,
      contentProvider: new _filtered_content_provider.default({
        contentProvider: _contentStore,
        filter: {
          kind: "item"
        }
      }),
      contentArranger: _.extend(new _content_arranger_simple.ContentArrangerSimple({
        getGroupId: _content_arranger_simple.GridGroupers.groupByKey("category"),
        getDataForGroupId: _content_arranger_simple.GridGroupers.groupDataByKey("category", {
          kind: "category"
        }, _contentStore),
        groupCompareFunction: this.sortCategoryByIndex
      }), {
        // ContentArrangerSimple extensions
        getGroupExpansionStates: this.getGroupExpansionStates.bind(this)
      }),
      onGroupExpansionChanged: this.onGroupExpansionChanged
    });
    $('#grid_area').append(_grid.getDiv());

    _contentStore.reload();
  };

  this.initExpansionState = function (matchname) {
    var transport = new _expansionstate_transport.default();
    var stateAPI = new _expansionstate_api.default(transport);
    return new _expansionstate.default(matchname, "choices", stateAPI);
  };

  this.getGroupExpansionStates = function () {
    var states = [];

    for (var i = 0; i < _categoryList.length; i++) {
      var category = _categoryList[i];

      var state = this._expansionState.findState(category);

      states.push({
        id: category,
        isExpanded: state.isExpanded
      });
    }

    return states;
  };

  this.onGroupExpansionChanged = function (gridView, isExpanded, groupIndex, groupData) {
    this._expansionState.setState(groupData.groupId, isExpanded);
  };

  this.buildCategoryList = function (itemsAvailable) {
    var result = [];

    for (var i = 0; i < itemsAvailable.length; i++) {
      var category = itemsAvailable[i].category;

      if (result.indexOf(category) == -1) {
        result.push(category);
      }
    }

    return result;
  };

  this.sortCategoryByIndex = function (a, b) {
    var i1 = _categoryList.indexOf(a);

    var i2 = _categoryList.indexOf(b);

    return i1 > i2 ? 1 : -1;
  };

  this.onApplicationFinishedLaunching = function () {
    var _this = this;

    if (typeof nx_api !== "undefined") {
      nx_api.initialState.get().then(function (initialState) {
        _this._expansionState = _this.initExpansionState(initialState.choiceSettings.matchname);

        _this._expansionState.getState().then(function (expansionState) {
          document.getElementById("header").innerHTML = initialState.windowConfig.headerText;
          document.getElementById("instructions").innerHTML = initialState.windowConfig.instructionText;

          _this.initGrid(initialState.choiceSettings);
        });
      });
    } else {
      var initialState = {
        "windowConfig": {
          "headerText": "Sample Choice Dialog from Mock Data",
          "instructionText": "Double-click to select an Element Type."
        },
        "choiceSettings": {
          "initialSelectionIdx": 0,
          "itemsAvailable": _mockHud.default
        }
      };
      document.getElementById("header").innerHTML = initialState.windowConfig.headerText;
      document.getElementById("instructions").innerHTML = initialState.windowConfig.instructionText;
      this.initGrid(initialState.choiceSettings);
    }

    _footer = new _footer2.default(_self);
  };

  this.onContentSelected = function (gridView, selection) {
    _chosenItems = selection;

    if (_footer) {
      _footer.updateState();
    }
  }; // Grid Delegate


  this.onSelectionUpdated = function (gridView, selectedItems) {
    var selection = [];

    for (var i = 0; i < selectedItems.length; i++) {
      selection.push(gridView.getDataForGridItem(selectedItems[i]));
    }

    this.onContentSelected(gridView, selection);
  };

  this.onGridItemDoubleClicked = function (gridView, gridItem) {
    this.onSelectionUpdated(gridView, [gridItem]);
    this.onOk(this.getDialogResult());
  }; // Grid Styler


  this.styleGridItem = function (gridView, gridItemDiv, gridData) {
    // Use defaults
    _grid.styleGridItem(gridView, gridItemDiv, gridData);

    gridItemDiv.addClass('grid-item');
    gridItemDiv.addClass('can-hover');
    gridItemDiv.addClass('can-select');

    if (gridData.selectionIndex == _initialIndex) {
      gridItemDiv.addClass('grid-item-selected');
    }

    var options = {
      imageExtension: '.png',
      videoExtensions: ['.gif', '.mp4']
    };
    var videoPath = "choiceThumbs/" + gridData.name;
    var videoRollover = new _videoRollover.default(videoPath, videoPath, options);
    videoRollover.root.classList.add("uni-choice");
    gridItemDiv.append(videoRollover.root);
  };

  this.styleGridGroupHeader = function (gridView, groupHeaderDiv, groupData) {
    // Use defaults
    _grid.styleGridGroupHeader(gridView, groupHeaderDiv, groupData);
  }; // Delegate for the footer


  this.validateOk = function () {
    return _chosenItems.length === 1;
  };

  this.getDialogResult = function () {
    var result = {};

    if (_chosenItems.length === 1) {
      result.chosenIndex = _chosenItems[0].selectionIndex;
    }

    return result;
  };

  this.onCancel = function () {
    if (typeof nx_api !== "undefined") {
      nx_api.nx_window.setDialogResult(0);
      nx_api.nx_window.close();
    }
  };

  this.onOk = function (dialogResult) {
    if (typeof nx_api !== "undefined") {
      nx_api.nx_window.setDialogResult(1, dialogResult);
      nx_api.nx_window.close();
    }
  };
}

var main = new mainFunc();
RGClientMain.init(main);

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(2);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, "body {\n  background: darkgrey;\n  height: 100%;\n  -webkit-user-select: none;\n  margin: 0px;\n  overflow: hidden;\n  cursor: default;\n}\n#header {\n  text-align: center;\n  color: #ffffff;\n  background-color: #2f2f2f;\n  height: 25px;\n  padding-top: 5px;\n  font-size: 14pt;\n  font-weight: lighter;\n}\n#instructions {\n  color: #c0c0c0;\n  background-color: #535353;\n  height: 27px;\n  padding-top: 8px;\n  padding-left: 8px;\n  font-size: 10pt;\n}\n#content {\n  position: absolute;\n  left: 0px;\n  right: 0px;\n  top: 65px;\n  bottom: 40px;\n  background-color: #535353;\n}\n#grid_area {\n  position: absolute;\n  left: 0px;\n  top: 0px;\n  bottom: 0px;\n  width: 100%;\n}\n.grid-item.can-hover:hover {\n  background-color: #bbbbbb;\n}\n.grid-item.can-select.grid-item-selected {\n  background-color: #bbbbbb;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header {\n  height: 34px;\n}\n.rg_grid_holder_no_resize .rg_grid_item_default_style {\n  height: 146px;\n  background-color: #949494;\n}\n.rg_cb_grid .rg_grid_item .rg_grid_item_title {\n  top: 124px;\n  color: #1e1e1e;\n}\n.rg_grid_scroll_wrap::-webkit-scrollbar {\n  background-color: #1d1d1d;\n}\n.rg_grid_scroll_wrap::-webkit-scrollbar-corner {\n  background-color: #1d1d1d;\n}\n.rg_grid_scroll_wrap::-webkit-scrollbar-thumb {\n  background-color: #313131;\n  border-radius: 10px;\n}\n#dialog_footer {\n  position: absolute;\n  background-color: #525252;\n  bottom: 0px;\n  left: 0px;\n  right: 0px;\n  height: 39px;\n  border-top: 1px solid black;\n}\n.dialog_footer_outer {\n  position: absolute;\n  float: left;\n  left: 50%;\n  bottom: 14px;\n  height: 24px;\n}\n.dialog_footer_inner {\n  position: relative;\n  float: left;\n  left: -50%;\n  height: 100%;\n  top: 8px;\n}\n.dialog_footer_button {\n  display: inline-block;\n  min-width: 52px;\n  height: 24px;\n  line-height: 22px;\n}\n.dialog_footer_space {\n  display: inline-block;\n  width: 5px;\n}\n.video-rollover.uni-choice {\n  position: absolute;\n  left: 0px;\n  top: 0px;\n  right: 0px;\n  bottom: 25px;\n  background-color: black;\n  border: 1px solid #555555;\n}\n.video-rollover.uni-choice .place-holder {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover.uni-choice video {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover.uni-choice video.hidden {\n  width: 0px;\n  height: 0px;\n}\n", ""]);

// exports


/***/ }),
/* 3 */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getTarget = function (target) {
  return document.querySelector(target);
};

var getElement = (function (fn) {
	var memo = {};

	return function(target) {
                // If passing function in options, then use it for resolve "head" element.
                // Useful for Shadow Root style i.e
                // {
                //   insertInto: function () { return document.querySelector("#foo").shadowRoot }
                // }
                if (typeof target === 'function') {
                        return target();
                }
                if (typeof memo[target] === "undefined") {
			var styleTarget = getTarget.call(this, target);
			// Special case to return head of iframe instead of iframe itself
			if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[target] = styleTarget;
		}
		return memo[target]
	};
})();

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(5);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
        if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),
/* 5 */
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(7));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(10));

var _content_change_context = _interopRequireDefault(__webpack_require__(11));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ContentStore =
/*#__PURE__*/
function () {
  function ContentStore(api, params) {
    _classCallCheck(this, ContentStore);

    this._api = api;
    this._content = [];

    this._contentProviderInit(params);

    this._contentFilterInit();

    this._incrementalChangeLimits = {
      updates: 100,
      removals: 100,
      additions: 0
    };
  }

  _createClass(ContentStore, [{
    key: "getContent",
    value: function getContent() {
      return this._content;
    }
  }, {
    key: "_doReload",
    value: function _doReload(changeContext) {
      var _this = this;

      var onLoaded = function onLoaded(d) {
        _this._onLoaded(d, changeContext);
      };

      return this._api.get(this._filter).then(onLoaded);
    }
  }, {
    key: "_onLoaded",
    value: function _onLoaded(d, changeContext) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        _this2._content = d;

        _this2._onContentChanged(changeContext);

        resolve(_this2);
      });
    } // ContentFilter

  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      this.invalidate();

      if (this.getChangeWatching()) {
        this.getChangeWatching().setFilter(this.getFilter());
      }
    } // ContentProvider

  }, {
    key: "_onWatchedChangesFound",
    value: function _onWatchedChangesFound(updates, removals, needsFullRefresh) {
      if (needsFullRefresh) {
        this.invalidate();
        return;
      } // See if the raw change is too big for us


      if (updates.length > this._incrementalChangeLimits.updates || removals.length > this._incrementalChangeLimits.removals) {
        this.invalidate();
        return;
      } // see if we can handle this directly or if a full refresh is actually needed


      var changeContext = this._digestWatchedChanges(this._content, updates, removals);

      if (!_content_change_context.default.WithinLimits(changeContext, this._incrementalChangeLimits)) {
        this.invalidate();
        return;
      }

      if (!_content_change_context.default.IsEmpty(changeContext)) {
        this._applyWatchedChanges(this._content, changeContext.details.updated, changeContext.details.removed);

        this._content = this._content.concat(changeContext.details.added);

        this._onContentChanged(changeContext);
      }
    }
  }]);

  return ContentStore;
}();

exports.default = ContentStore;

_content_provider_contract.default.asContentProvider(ContentStore.prototype);

_content_filter.default.asContentFilter(ContentStore.prototype);

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_predicates = _interopRequireDefault(__webpack_require__(8));

var _content_filter_utils = _interopRequireDefault(__webpack_require__(9));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentFilterAPI = {
  _contentFilterInit: function _contentFilterInit() {
    this._filter = {};
    this._filterEmpty = true;
    this._priorFilter = {};
    this._predicates = {};
  },
  filterItems: function filterItems(contentItemList, context) {
    if (this._filterEmpty) {
      return contentItemList.slice(0);
    }

    var f = [];

    for (var i = 0; i < contentItemList.length; i++) {
      if (this.doesItemPass(contentItemList[i], context)) {
        f.push(contentItemList[i]);
      }
    }

    return f;
  },
  // Override this to do something custom
  doesItemPass: function doesItemPass(contentItem, context) {
    if (this._filterEmpty) {
      return true;
    }

    var k, p, filter; // ContentItem must match every one of these

    for (var k in this._predicates) {
      if (this._predicates.hasOwnProperty(k)) {
        filter = {};
        filter[k] = this._predicates[k].f;
        p = this._predicates[k].p;

        if (!p(k, contentItem, filter, context)) {
          return false;
        }
      }
    }

    return true;
  },
  getFilter: function getFilter() {
    return this._filter;
  },
  createFilterCopy: function createFilterCopy() {
    return _content_filter_utils.default.deepCopy(this._filter);
  },
  setFilter: function setFilter(f, deferUpdate) {
    this._filter = f;

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  addFilter: function addFilter(filter, deferUpdate) {
    if (filter) {
      for (var k in filter) {
        if (filter.hasOwnProperty(k)) {
          this._filter[k] = filter[k];
        }
      }

      if (!deferUpdate) {
        this._onFiltersUpdated();
      }
    }
  },
  removeFilterKeys: function removeFilterKeys(keyList, deferUpdate) {
    for (var k = 0; k < keyList.length; k++) {
      delete this._filter[keyList[k]];
    }

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  clearFilters: function clearFilters(deferUpdate) {
    this._filter = {};

    if (!deferUpdate) {
      this._onFiltersUpdated();
    }
  },
  matchesFilter: function matchesFilter(f) {
    // brute-force approach to this
    try {
      var sMine = JSON.stringify(this._filter);
      var sOther = JSON.stringify(f);
      return sMine === sOther;
    } catch (err) {
      console.log("Error comparing filters");
      console.log(err);
    }

    return false; // to be safe
  },
  _onFiltersUpdated: function _onFiltersUpdated() {
    this._filterEmpty = _.keys(this._filter).length === 0; // Look up our predicate functions for easier processing

    this._predicates = {};

    for (var k in this._filter) {
      if (this._filter.hasOwnProperty(k)) {
        this._predicates[k] = {
          f: this._filter[k],
          p: _content_predicates.default.findPredicate(this._filter[k])
        };
      }
    } // See if anything meaningful actually changed


    var notifyOfChanges = !this.matchesFilter(this._priorFilter);
    this._priorFilter = this.createFilterCopy();

    if (notifyOfChanges) {
      this._handleFiltersUpdated();
    }
  },
  _handleFiltersUpdated: function _handleFiltersUpdated() {// Implement this to react when filters change
  }
};

var asContentFilter = function asContentFilter(target) {
  _.defaults(target, ContentFilterAPI);
};

var ContentFilter = {
  api: ContentFilterAPI,
  asContentFilter: asContentFilter
};
exports.default = ContentFilter;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ContentPredicates;
exports.default = ContentPredicates;
exports.default = ContentPredicates = {
  ///////////////////////////////////////
  // Helper Functions
  findPredicate: function findPredicate(filterEntry) {
    if (filterEntry && _typeof(filterEntry) === "object") {
      var keys = _.keys(filterEntry);

      for (var i = 0; i < keys.length; i++) {
        if (keys[i][0] === "_" && ContentPredicates[keys[i]]) {
          return ContentPredicates[keys[i]];
        }
      }
    }

    return ContentPredicates._equals;
  },
  addToAny: function addToAny(existing, value) {
    if (!existing) {
      existing = {
        _any: []
      };
    }

    existing._any.push(value);

    return existing;
  },
  addToNotAny: function addToNotAny(existing, value) {
    if (!existing) {
      existing = {
        _notAny: []
      };
    }

    existing._notAny.push(value);

    return existing;
  },
  ///////////////////////////////////////
  // Predicates
  // Exact match
  // filter[k] = anything
  _equals: function _equals(k, contentItem, filter, context) {
    return contentItem[k] === filter[k];
  },
  // Matches any provided
  // filter[k] = { _any:[array, of, anything] };
  _any: function _any(k, contentItem, filter, context) {
    for (var i = 0; i < filter[k]._any.length; i++) {
      if (contentItem[k] === filter[k]._any[i]) {
        return true;
      }
    }

    return false;
  },
  // Not equal
  // filter[k] = { _not:anything };
  _not: function _not(k, contentItem, filter, context) {
    return typeof contentItem[k] === "undefined" || contentItem[k] !== filter[k]._not;
  },
  // Not equal to any of these
  // filter[k] = { _notAny:[array, of, anything] };
  _notAny: function _notAny(k, contentItem, filter, context) {
    if (typeof contentItem[k] === "undefined") {
      return true;
    }

    for (var i = 0; i < filter[k]._notAny.length; i++) {
      if (contentItem[k] === filter[k]._notAny[i]) {
        return false;
      }
    }

    return true;
  },
  // Presence/absence of contentItem[k]
  // filter[k] = { _isSet:true|false };
  _isSet: function _isSet(k, contentItem, filter, context) {
    return typeof contentItem[k] === "undefined" !== filter[k]._isSet;
  },
  // Custom function/filter id
  // filter[k] = { _custom: { _id: "someId", _func: function(k, contentItem, filter, id, context) { return true; } } }
  _custom: function _custom(k, contentItem, filter, context) {
    return filter[k]._custom._func(k, contentItem, filter, filter[k]._custom._id, context);
  }
};

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ContentFilterUtils;
exports.default = ContentFilterUtils;
exports.default = ContentFilterUtils = {
  // Replacement for having to have a jQuery dependency via $.extend(true, {}, this._filter);
  // This doesn't handle cycles... but there shouldn't be any in a content filter.
  deepCopy: function deepCopy(input) {
    var output;

    if (input === null) {
      output = null;
    } else if (Array.isArray(input)) {
      output = [];

      for (var i = 0; i < input.length; i++) {
        output.push(ContentFilterUtils.deepCopy(input[i]));
      }
    } else if (input && _typeof(input) === "object") {
      output = {};

      for (var k in input) {
        if (input.hasOwnProperty(k)) {
          output[k] = ContentFilterUtils.deepCopy(input[k]);
        }
      }
    } else {
      output = input;
    }

    return output;
  }
};

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_change_context = _interopRequireDefault(__webpack_require__(11));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentProviderNotifications = {
  ChangePreview: "rg.cpc.content.change.preview",
  Changed: "rg.cpc.content.changed",
  Reloading: "rg.cpc.content.reloading"
};
var ContentProviderContractAPI = {
  _contentProviderInit: function _contentProviderInit(params) {
    var _this = this;

    if (!this.notifier) {
      this.notifier = new RG.utils.Notifier();
    }

    this._reloadPromise = null;
    var p = params ? params : {};

    _.defaults(p, {
      deferInit: false,
      // set to true to avoid any querying of the API until init() is called
      changeWatching: null
    });

    this._changeWatching = p.changeWatching ? p.changeWatching : null;

    if (this._changeWatching) {
      this._changeWatching.setChangeTrackingCallback(this._onWatchedChangesFound.bind(this));
    }

    this._didProviderInit = false;
    this._onProviderInit = null;
    this._providerInvalidated = false;
    this._providerInitPromise = new Promise(function (resolve, reject) {
      _this._onProviderInit = resolve;
    });

    if (!p.deferInit) {
      this.init();
    }
  },
  init: function init() {
    if (!this._didProviderInit) {
      this._didProviderInit = true;

      if (this._onProviderInit) {
        this._onProviderInit(); // allow any deferred operation to go through

      }

      if (this._changeWatching) {
        this._changeWatching.start();
      }
    }
  },
  // returns array of ContentItems
  getContent: function getContent() {
    throw "Interface implementor must implement getContent";
  },
  getContentLength: function getContentLength() {
    return this.getContent().length;
  },
  // register for this type with this.notifier to be informed before consumers handler the ContentItem change
  getChangePreviewNotificationType: function getChangePreviewNotificationType() {
    return ContentProviderNotifications.ChangePreview;
  },
  // register for this type with this.notifier to be informed when the ContentItem array contents change
  getChangedNotificationType: function getChangedNotificationType() {
    return ContentProviderNotifications.Changed;
  },
  // register for this type with this.notifier to be informed when reloading starts or ends
  // n = { sender: this, reloadPhase: "start"|"end"}
  getReloadingNotificationType: function getReloadingNotificationType() {
    return ContentProviderNotifications.Reloading;
  },
  getChangeWatching: function getChangeWatching() {
    return this._changeWatching;
  },
  // this will trigger a reload or queue one for after the current reload completes
  invalidate: function invalidate(changeContext) {
    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    this._providerInvalidated = true;
    this.reload(changeContext);
  },
  reload: function reload(changeContext) {
    var _this2 = this;

    if (this._reloadPromise) {
      return this._reloadPromise;
    }

    if (!this._didProviderInit) {
      return this._providerInitPromise.then(function () {
        return _this2.reload();
      });
    }

    if (this._providerInvalidated) {
      this._providerInvalidated = false;
    }

    this.notifier.postNotification(ContentProviderNotifications.Reloading, {
      sender: this,
      reloadPhase: "start"
    });
    this._reloadPromise = this._doReload(changeContext);

    this._reloadPromise.then(this._afterReload.bind(this)).catch(this._afterReload.bind(this));

    return this._reloadPromise;
  },
  _afterReload: function _afterReload() {
    this._reloadPromise = null;
    this.notifier.postNotification(ContentProviderNotifications.Reloading, {
      sender: this,
      reloadPhase: "end"
    });

    if (this._providerInvalidated) {
      this.reload();
    }
  },
  _onContentChanged: function _onContentChanged(changeContext) {
    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    this.notifier.postNotification(ContentProviderNotifications.ChangePreview, {
      sender: this,
      changeContext: changeContext
    });
    this.notifier.postNotification(ContentProviderNotifications.Changed, {
      sender: this,
      changeContext: changeContext
    });
  },
  // implement this to start the reload operation and return a promise
  // if the reload operation finds new content, call this._onContentChanged()
  _doReload: function _doReload(changeContext) {
    return new Promise(function (resolve, reject) {
      reject("This provider doesn't support reload");
    });
  },
  // override this to do something custom when changes are found
  _onWatchedChangesFound: function _onWatchedChangesFound(updates, removals, needsFullRefresh) {
    this.invalidate();
  },
  ////////////////////////////
  // utility methods to use from _onWatchedChangesFound()
  // produces a changeContext that can be passed to _onContentChanged
  _digestWatchedChanges: function _digestWatchedChanges(currentContent, updates, removals, identityProperty) {
    if (!identityProperty) {
      identityProperty = this._defaultCompareProperty;
    }

    var added = [];
    var updated = [];
    var removed = [];

    var removeIds = _.pluck(removals, identityProperty);

    var updateIds = _.pluck(updates, identityProperty);

    var addedIds = updateIds.slice(0);
    var rIdx;
    var uIdx;
    var nextId;
    var i;

    for (i = 0; i < currentContent.length; i++) {
      nextId = currentContent[i][identityProperty];
      rIdx = removeIds.indexOf(nextId);

      if (rIdx !== -1) {
        removed.push(removals[rIdx]);
      }

      uIdx = updateIds.indexOf(nextId);

      if (uIdx !== -1) {
        // We have it, so it's not an addition
        addedIds = _.without(addedIds, nextId);
        updated.push(updates[uIdx]);
      }
    } // Anything else we didn't touch is an addition


    if (addedIds.length > 0) {
      for (i = 0; i < updates.length; i++) {
        nextId = updates[i][identityProperty];
        uIdx = addedIds.indexOf(nextId);

        if (uIdx !== -1) {
          added.push(updates[i]);
        }
      }
    }

    return _content_change_context.default.Create(_content_change_context.default.ChangeSource.Data, added, updated, removed);
  },
  // finds matching items in currentContent and replaces/removes them from updates/removals
  _applyWatchedChanges: function _applyWatchedChanges(currentContent, updates, removals, identityProperty) {
    if (!identityProperty) {
      identityProperty = this._defaultCompareProperty;
    }

    var removeIds = _.pluck(removals, identityProperty);

    var updateIds = _.pluck(updates, identityProperty);

    var rIdx;
    var uIdx;
    var nextId;

    for (var i = 0; i < currentContent.length; i++) {
      nextId = currentContent[i][identityProperty]; // Updates

      uIdx = updateIds.indexOf(nextId);

      if (uIdx !== -1) {
        currentContent.splice(i, 1, updates[uIdx]);
      } // Removals


      rIdx = removeIds.indexOf(nextId);

      if (rIdx !== -1) {
        currentContent.splice(i, 1);
        i--;
      }
    }
  },
  _defaultCompareProperty: "_id"
};

var asContentProvider = function asContentProvider(target) {
  _.defaults(target, ContentProviderContractAPI);
};

var ContentProviderContract = {
  api: ContentProviderContractAPI,
  asContentProvider: asContentProvider
};
exports.default = ContentProviderContract;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var ContentChangeContext;
exports.default = ContentChangeContext;
exports.default = ContentChangeContext = {
  ChangeSource: {
    View: "view",
    // looking at different data source
    Data: "data",
    // change in the underlying data itself, e.g. live update
    Filter: "filter",
    // change in the filter applied to the data
    Format: "format" // change in the format applied to the data

  },
  GetChangeSource: function GetChangeSource(candidateSource) {
    if (candidateSource) {
      for (var k in ContentChangeContext.ChangeSource) {
        if (ContentChangeContext.ChangeSource.hasOwnProperty(k)) {
          if (ContentChangeContext.ChangeSource[k] === candidateSource) {
            return candidateSource;
          }
        }
      }
    }

    return ContentChangeContext.ChangeSource.Data;
  },

  /**
   * 
   * @param {ChangeSource} changeSource - optional - the source of the change
   * @param {array} added - optional - array of added items
   * @param {array} updated - optional - array of updated items
   * @param {array} removed - optional - array of removed items
   * @return {object} ChangeContext - see below
   * 
   * {
   * 	source: string - see ChangeSource
   * 	hasDetails: boolean,
   *  details: object - optional { 
   *  	addded: array,
   * 		updated: array,
   * 		removed: array
   *    }
   *  }
   * 	
   * 	MBL-2627
   * 	If hasDetails === false, this means something changed but no further information is available.
   * 	The correct action to take in response is a full refresh.
   * 
   */
  Create: function Create(changeSource, added, updated, removed) {
    var hasDetails = Array.isArray(added) || Array.isArray(updated) || Array.isArray(removed);
    var context = {
      source: ContentChangeContext.GetChangeSource(changeSource),
      hasDetails: hasDetails
    };

    if (hasDetails) {
      context.details = {
        added: Array.isArray(added) ? added : [],
        updated: Array.isArray(updated) ? updated : [],
        removed: Array.isArray(removed) ? removed : []
      };
    }

    return context;
  },

  /**
   * 
   * @param {ChangeContext} existingContext 
   */
  Copy: function Copy(existingContext) {
    if (existingContext.hasDetails) {
      var _existingContext$deta = existingContext.details,
          added = _existingContext$deta.added,
          updated = _existingContext$deta.updated,
          removed = _existingContext$deta.removed;
      return ContentChangeContext.Create(existingContext.source, added.slice(0), updated.slice(0), removed.slice(0));
    }

    return ContentChangeContext.Create(existingContext.source);
  },

  /**
   * 
   * @param {ChangeContext} changeContext 
   * @return {boolean} true if the change has details but no additions, updates, or removals. False otherwise.
   */
  IsEmpty: function IsEmpty(changeContext) {
    // If no change details are known, we cannot say that the change is empty
    if (!changeContext.hasDetails) {
      return false;
    }

    var _changeContext$detail = changeContext.details,
        added = _changeContext$detail.added,
        updated = _changeContext$detail.updated,
        removed = _changeContext$detail.removed;
    return added.length === 0 && updated.length === 0 && removed.length === 0;
  },

  /**
   * 
   * @param {ChangeContext} changeContext 
   * @param {object} changeLimits - object with optional numeric fields "updates, additions, removals"
   * @return {boolean} - true if the details of changeContext are within the specified limits
   */
  WithinLimits: function WithinLimits(changeContext, changeLimits) {
    // If no change details are known, we cannot say whether it is within the limits
    if (!changeContext.hasDetails) {
      return false;
    }

    if (!changeLimits) {
      return true;
    }

    if (changeLimits.hasOwnProperty("updates") && changeContext.details.updated.length > changeLimits.updates) {
      return false;
    }

    if (changeLimits.hasOwnProperty("removals") && changeContext.details.removed.length > changeLimits.removals) {
      return false;
    }

    if (changeLimits.hasOwnProperty("additions") && changeContext.details.added.length > changeLimits.additions) {
      return false;
    }

    return true;
  }
};

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(7));

var _content_consumer = _interopRequireDefault(__webpack_require__(13));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(10));

var _content_change_context = _interopRequireDefault(__webpack_require__(11));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var FilteredContentProvider =
/*#__PURE__*/
function () {
  function FilteredContentProvider(params) {
    _classCallCheck(this, FilteredContentProvider);

    this._params = params ? params : {};

    _.defaults(this._params, {
      filterContext: null,
      filter: {},
      contentProvider: null
    });

    this._content = [];

    this._contentProviderInit();

    this._contentFilterInit();

    this._incrementalChangeLimits = {
      updates: 100,
      removals: 100,
      additions: 1
    };
    this.addFilter(this._params.filter);

    if (this._params.contentProvider) {
      this.setContentProvider(this._params.contentProvider);
    }
  } // Content Proivder


  _createClass(FilteredContentProvider, [{
    key: "getContent",
    value: function getContent() {
      return this._content;
    }
  }, {
    key: "_doReload",
    value: function _doReload(changeContext) {
      var _this = this;

      if (this._contentProvider) {
        // We will refresh when the upstream provider does
        return this._contentProvider.reload(changeContext);
      } // Otherwise just refresh locally


      return new Promise(function (resolve, reject) {
        _this.refresh(changeContext);

        resolve(_this);
      });
    } // Content Consumer

  }, {
    key: "refresh",
    value: function refresh(changeContext) {
      if (this._contentProvider) {
        this._content = this.filterItems(this._contentProvider.getContent(), this._params.filterContext);
      } else {
        this._content = [];
      }

      this._onContentChanged(changeContext);
    } // Content Filter

  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      this.refresh(_content_change_context.default.Create(_content_change_context.default.ChangeSource.Filter));

      if (this.getChangeWatching()) {
        this.getChangeWatching().setFilter(this.getFilter());
      }
    }
  }, {
    key: "_handleIncrementalContentChange",
    value: function _handleIncrementalContentChange(changeContext) {
      if (!changeContext.hasDetails) {
        // Not the kind of change we understand
        return false;
      }

      if (!_content_change_context.default.WithinLimits(changeContext, this._incrementalChangeLimits)) {
        // Change is too big
        return false;
      }

      var forwardContext;

      if (this._filterEmpty) {
        forwardContext = _content_change_context.default.Copy(changeContext);
      } else {
        forwardContext = _content_change_context.default.Create(changeContext.source, [], [], []); // We need to figure out our own additions/updates/removals based on filtering

        var i;
        var alreadyPresent;
        var identityProperty = this._defaultCompareProperty;

        var currentIds = _.pluck(this._content, identityProperty);

        var nextItem; // Additions

        for (i = 0; i < changeContext.details.added.length; i++) {
          if (this.doesItemPass(changeContext.details.added[i], this._params.filterContext)) {
            forwardContext.details.added.push(changeContext.details.added[i]);
          }
        } // Updates


        for (i = 0; i < changeContext.details.updated.length; i++) {
          nextItem = changeContext.details.updated[i];
          var alreadyPresent = currentIds.indexOf(nextItem[identityProperty]) !== -1;

          if (this.doesItemPass(nextItem, this._params.filterContext)) {
            if (alreadyPresent) {
              forwardContext.details.updated.push(nextItem);
            } else {
              forwardContext.details.added.push(nextItem);
            }
          } else if (alreadyPresent) {
            forwardContext.details.removed.push(nextItem);
          }
        } // Removals


        for (i = 0; i < changeContext.details.removed.length; i++) {
          nextItem = changeContext.details.removed[i];
          var alreadyPresent = currentIds.indexOf(nextItem[identityProperty]) !== -1;

          if (alreadyPresent) {
            forwardContext.details.removed.push(nextItem);
          }
        }
      }

      if (!_content_change_context.default.WithinLimits(forwardContext, this._incrementalChangeLimits)) {
        // Change is too big
        return false;
      }

      this._applyWatchedChanges(this._content, forwardContext.details.updated, forwardContext.details.removed);

      this._content = this._content.concat(forwardContext.details.added);

      this._onContentChanged(forwardContext);

      return true;
    }
  }]);

  return FilteredContentProvider;
}();

exports.default = FilteredContentProvider;

_content_provider_contract.default.asContentProvider(FilteredContentProvider.prototype);

_content_consumer.default.asContentConsumer(FilteredContentProvider.prototype);

_content_filter.default.asContentFilter(FilteredContentProvider.prototype);

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_change_context = _interopRequireDefault(__webpack_require__(11));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentConsumerAPI = {
  setContentProvider: function setContentProvider(cp) {
    if (this._contentProvider) {
      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);

      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getChangedNotificationType(), this.onContentUpdated, this);

      this._contentProvider.notifier.deregisterForNotificationsWithTarget(this._contentProvider.getReloadingNotificationType(), this.onContentReloading, this);
    }

    this._contentProvider = cp;

    if (this._contentProvider) {
      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);

      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getChangedNotificationType(), this.onContentUpdated, this);

      this._contentProvider.notifier.registerForNotificationsWithTarget(this._contentProvider.getReloadingNotificationType(), this.onContentReloading, this);
    }

    this.refresh(_content_change_context.default.Create(_content_change_context.default.ChangeSource.View));
  },
  getContentProvider: function getContentProvider() {
    return this._contentProvider;
  },
  // Prefer setContentProvider unless you need to listen to multiple content streams
  addContentProvider: function addContentProvider(cp) {
    if (cp) {
      cp.notifier.registerForNotificationsWithTarget(cp.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);
      cp.notifier.registerForNotificationsWithTarget(cp.getChangedNotificationType(), this.onContentUpdated, this);
      cp.notifier.registerForNotificationsWithTarget(cp.getReloadingNotificationType(), this.onContentReloading, this);
    }
  },
  // Prefer setContentProvider unless you need to listen to multiple content streams
  removeContentProvider: function removeContentProvider(cp) {
    if (cp) {
      cp.notifier.deregisterForNotificationsWithTarget(cp.getChangePreviewNotificationType(), this.onContentUpdatedPreview, this);
      cp.notifier.deregisterForNotificationsWithTarget(cp.getChangedNotificationType(), this.onContentUpdated, this);
      cp.notifier.deregisterForNotificationsWithTarget(cp.getReloadingNotificationType(), this.onContentReloading, this);
    }
  },
  // Optional method called when new content is found.
  // Implementer can provide a version of this to perfrom whatever updates are needed.
  refresh: function refresh(changeContext) {// ...
  },
  // Optinal method called during provider reload
  // Implementor can perform custom actions here to show reloading state
  // check n.data.reloadPhase for details
  onContentReloading: function onContentReloading(n) {// ...
  },
  // Optional method called before onContentUpdated
  // Use to peek at changes before they flow through the system
  onContentUpdatedPreview: function onContentUpdatedPreview(n) {// ...
  },
  onContentUpdated: function onContentUpdated(n) {
    var changeContext = null;

    if (n && n.data) {
      changeContext = n.data.changeContext;
    }

    if (!changeContext) {
      changeContext = _content_change_context.default.Create();
    }

    if (changeContext.hasDetails) {
      if (this._handleIncrementalContentChange(changeContext)) {
        return;
      }
    } // If we were not able to do an incremental change, drop the details and go to full refresh


    this.refresh(_content_change_context.default.Create(changeContext.source));
  },
  // Override this to do incremental updates in response to content change notifications
  // return true if you handled the change
  _handleIncrementalContentChange: function _handleIncrementalContentChange(changeContext) {
    return false;
  }
};

var asContentConsumer = function asContentConsumer(target) {
  _.defaults(target, ContentConsumerAPI);
};

var ContentConsumer = {
  api: ContentConsumerAPI,
  asContentConsumer: asContentConsumer
};
exports.default = ContentConsumer;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

__webpack_require__(15);

var _content_arranger_simple = __webpack_require__(17);

var _content_consumer = _interopRequireDefault(__webpack_require__(13));

var _content_provider_contract = _interopRequireDefault(__webpack_require__(10));

var _content_properties = _interopRequireDefault(__webpack_require__(18));

var _content_change_context = _interopRequireDefault(__webpack_require__(11));

var _content_filter = _interopRequireDefault(__webpack_require__(7));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
    delegate = {

        // Optional - be noitified of selection updates. 
        // Note: if you install a custom gridDelegate, handle onSelectionUpdated() instead 
        onContentSelected: function(contentGrid, contentList) { }    

        // Optional - return dom element to insert if the grid has no items
        getGridEmptyContent: function(contentGrid) { }

        // Optional - examine the change and decided if the grid should maintain state on 
        //              refresh, overriding the default behaviour
        function: shouldMaintainStateOnRefresh(contentGrid, changeContext) { return true; }

    }

    contentArranger = {

        // required - be notified when content arrives
        setContent: function(contentList) { }, 

        // required - return all items to add to RGGridView
        getItems: function() { return []; },

        // optional - return group data suitable for RGGridView
        getGroups: function() { return {groups:[], totalCount:0} },

        // optional - be informed when installed in a grid
        function: setContentGrid(contentGrid) { }

        // optional - return false to bypass custom incremental update logic
        function: doDefaultIncrementalGridUpdate(contentGrid, changeContext) { return true; }

        // optional - will be called if above returns false. Return false to trigger a full refresh
        function: handleIncrementalGridUpdate(contentGrid, changeContext) { return false; }

    }

    gridStyler = {

        // optional - be informed when installed in a grid
        setContentGrid: function(contentGrid) { }

        // optional - be notified at the start of a content grid reload
        onContentGridReloading: function(contentGrid, changeContext, gridMaintainingState) { }

        // Plus all RGGridView styler methods
    }
*/
var ContentGrid =
/*#__PURE__*/
function () {
  function ContentGrid(params) {
    _classCallCheck(this, ContentGrid);

    this._params = params ? params : {};

    _.defaults(this._params, {
      allowIncrementalUpdate: true,
      delegate: null,
      // expansion callbacks
      onGroupExpansionChanged: null,
      getGroupExpansionStates: null,
      // Main Components
      contentProvider: null,
      contentArranger: new _content_arranger_simple.ContentArrangerSimple(),
      gridStyler: this,
      gridDelegate: this,
      // can pass a custom grid delegate for more control
      gridSelectionClass: 'grid-item-selected',
      gridBaseAppearanceClass: null,
      // grid default - set to "" to clear completely
      contentProperties: new _content_properties.default()
    });

    this._delegate = this._params.delegate;
    this._div = $('<div tabindex="0" class="rg_cb_grid"></div>');
    this._gridView = new RGGridView();

    this._gridView.init(this._div, this._params.gridStyler, this._params.gridDelegate, {
      selectionClassName: this._params.gridSelectionClass,
      baseAppearanceClassName: this._params.gridBaseAppearanceClass
    });

    this._contentIsLoading = false;
    this._loadingIndicatorActive = false;
    this._loadingIndicatorAddedTime = 0;
    this._showLoadingUntilFoundContent = false;

    if (this._params.contentProvider) {
      this.setContentProvider(this._params.contentProvider);
    }

    if (this._params.contentArranger && typeof this._params.contentArranger.setContentGrid === "function") {
      this._params.contentArranger.setContentGrid(this);
    }

    if (this._params.gridStyler && typeof this._params.gridStyler.setContentGrid === "function") {
      this._params.gridStyler.setContentGrid(this);
    }
  }

  _createClass(ContentGrid, [{
    key: "getDiv",
    value: function getDiv() {
      return this._div;
    }
  }, {
    key: "getGridView",
    value: function getGridView() {
      return this._gridView;
    }
  }, {
    key: "getContentArranger",
    value: function getContentArranger() {
      return this._params.contentArranger;
    }
  }, {
    key: "refresh",
    value: function refresh(changeContext) {
      var _this = this;

      if (!changeContext) {
        changeContext = _content_change_context.default.Create();
      }

      if (this._params.contentArranger) {
        if (this._contentProvider) {
          this._params.contentArranger.setContent(this._contentProvider.getContent());
        } else {
          this._params.contentArranger.setContent([]);
        }

        var scrollPos = 0;
        var currentSelection = [];
        var selectAll = false;
        var maintainGridState = this.shouldMaintainStateOnRefresh(changeContext);

        if (this._params.gridStyler && typeof this._params.gridStyler.onContentGridReloading === "function") {
          this._params.gridStyler.onContentGridReloading(this, changeContext, maintainGridState);
        }

        if (maintainGridState) {
          // Scroll position
          scrollPos = this._gridView.getScrollPosition(); // Selection

          selectAll = this._gridView.isSelectAllActive();

          if (!selectAll) {
            currentSelection = this.getIdsForCurrentSelection();
          }
        }

        this._gridView.emptyGrid();

        this._gridView.clearSelection(true);

        var allGroups = [];

        if (typeof this._params.contentArranger.getGroups === "function") {
          var groupInfo = this._params.contentArranger.getGroups();

          allGroups = groupInfo.groups;

          this._gridView.setGroups(groupInfo.groups, groupInfo.totalCount);
        }

        var items = this._params.contentArranger.getItems();

        this._gridView.addItemsToGrid(items, 0);

        if (maintainGridState) {
          // Selection
          if (selectAll) {
            this._gridView.selectAll();
          } else {
            this._setSelectionByIds(currentSelection, allGroups, items);
          } // Scroll position


          this._gridView.scrollToPosition(scrollPos);
        }
      }

      this._contentIsLoading = false;

      this._removeLoadingIndicator();

      window.requestAnimationFrame(function () {
        return _this.afterRefresh();
      });
    }
  }, {
    key: "shouldMaintainStateOnRefresh",
    value: function shouldMaintainStateOnRefresh(changeContext) {
      if (this._delegate && typeof this._delegate.shouldMaintainStateOnChange === "function") {
        return this._delegate.shouldMaintainStateOnRefresh(this, changeContext);
      } // For live updates or things like sort order, keep position


      return changeContext.source === _content_change_context.default.ChangeSource.Data || changeContext.source === _content_change_context.default.ChangeSource.Format;
    }
    /**
     * return: [ { itemId: "", groupId: ""} ]
     */

  }, {
    key: "getIdsForCurrentSelection",
    value: function getIdsForCurrentSelection() {
      var idPairs = [];

      var gridItems = this._gridView.getSelectedItems();

      for (var i = 0; i < gridItems.length; i++) {
        var nextItem = $(gridItems[i]);

        var nextData = this._gridView.getDataForGridItem(nextItem);

        var groupHeader = this._gridView.getGroupHeaderForItem(nextItem);

        var groupId = "ungrouped";

        if (groupHeader) {
          groupId = groupHeader.data().groupId;
        }

        idPairs.push({
          itemId: nextData._id,
          groupId: groupId
        });
      }

      return idPairs;
    }
    /**
     * @param {string} contentId - id to look up
     * @return: [ $Item1, $Item2, ... ]
     */

  }, {
    key: "getGridItemsForContentId",
    value: function getGridItemsForContentId(contentId, includingCollapsedItems) {
      var filter = {
        _id: contentId
      };
      return this.getMatchingGridItems(filter, includingCollapsedItems);
    }
    /**
    * @param {object} contentFilter - the filter to return items that match
    * @return: [ $Item1, $Item2, ... ]
    */

  }, {
    key: "getMatchingGridItems",
    value: function getMatchingGridItems(contentFilter, includingCollapsedItems) {
      if (!this._params.contentArranger) {
        return [];
      }

      var filter = {};

      _content_filter.default.asContentFilter(filter);

      filter._contentFilterInit();

      filter.setFilter(contentFilter); // Get the data indicies

      var items = this._params.contentArranger.getItems();

      var indicies = [];

      for (var i = 0; i < items.length; i++) {
        if (filter.doesItemPass(items[i])) {
          indicies.push(i);
        }
      } // Get the corresponding grid items


      var result = [];

      for (var _i = 0; _i < indicies.length; _i++) {
        var nextItem = this._gridView.getGridItemForIndex(indicies[_i], includingCollapsedItems);

        if (nextItem && nextItem.length > 0) {
          result.push(nextItem);
        }
      }

      return result;
    }
    /**
     * This function will select all items whose itemId AND groupId match idPairs.
     * @param {array} idPairs - as returned by getIdsForCurrentSelection
     * @param {array} groups - array of groups from the content arranger
     * @param {array} items - raw items in the grid
     */

  }, {
    key: "_setSelectionByIds",
    value: function _setSelectionByIds(idPairs, groups, items) {
      if (idPairs.length === 0) {
        // Nothing to do if there was no selection
        return;
      } // Prepare groups to account for ungrouped items, if any


      groups = groups.slice(0);
      var ungroupedItem = {
        offs: 0,
        len: items.length,
        expand: true,
        groupId: "ungrouped"
      };

      if (groups.length === 0) {
        // If we have no groups, create the "ungrouped" holder
        groups = [ungroupedItem];
      } else if (groups[0].offs > 0) {
        // Insert holder for ungrouped items at top
        ungroupedItem.len = groups[0].offs;
        groups.splice(0, 0, ungroupedItem);
      } // Sort the selection pairs by group


      var itemsPerGroup = {};

      for (var i = 0; i < idPairs.length; i++) {
        var _idPairs$i = idPairs[i],
            itemId = _idPairs$i.itemId,
            groupId = _idPairs$i.groupId;

        if (!itemsPerGroup[groupId]) {
          itemsPerGroup[groupId] = [];
        }

        itemsPerGroup[groupId].push(itemId);
      } // Walk through the grid and find items that match the previous selection


      var itemsToSelect = $();

      for (var _i2 = 0; _i2 < groups.length; _i2++) {
        var nextGroup = groups[_i2];

        if (nextGroup.expand && itemsPerGroup.hasOwnProperty(nextGroup.groupId)) {
          var idsInGroup = itemsPerGroup[nextGroup.groupId];

          for (var j = nextGroup.offs; j < nextGroup.offs + nextGroup.len && idsInGroup.length > 0; j++) {
            var igIdx = idsInGroup.indexOf(items[j]._id);

            if (igIdx !== -1) {
              // This item needs to be selected
              var gridItem = this._gridView.getGridItemForIndex(j);

              if (gridItem && gridItem.length > 0) {
                itemsToSelect = itemsToSelect.add(gridItem[0]);
              }

              idsInGroup.splice(igIdx, 1);
            }
          }
        }
      } // console.log("itemsToSelect");
      // console.log(itemsToSelect);
      // console.log(itemsToSelect ? itemsToSelect.length : "null");


      if (itemsToSelect.length > 0) {
        this._gridView.selectItems(itemsToSelect, true);
      }
    }
  }, {
    key: "afterRefresh",
    value: function afterRefresh() {
      var expansionStates = [];

      if (typeof this._params.getGroupExpansionStates === "function") {
        // First-chance use of the installed param version
        expansionStates = this._params.getGroupExpansionStates();
      } else if (this._params.contentArranger && typeof this._params.contentArranger.getGroupExpansionStates === 'function') {
        // Fallback to old-style contentArranger option
        expansionStates = this._params.contentArranger.getGroupExpansionStates();
      }

      for (var i = 0; i < expansionStates.length; i++) {
        var state = expansionStates[i];

        this._gridView.setGroupExpansion(state.id, state.isExpanded);
      }
    }
  }, {
    key: "onContentReloading",
    value: function onContentReloading(n) {
      if (n.data.reloadPhase === "start") {
        this._contentIsLoading = true;

        this._addLoadingIndicator();
      }
    }
  }, {
    key: "showLoadingUntilFoundContent",
    value: function showLoadingUntilFoundContent(shouldShow) {
      if (shouldShow !== this._showLoadingUntilFoundContent) {
        this._showLoadingUntilFoundContent = shouldShow;

        if (!this._contentIsLoading) {
          if (this._showLoadingUntilFoundContent) {
            this._contentIsLoading = true;

            this._addLoadingIndicator();
          } else {
            this._removeLoadingIndicator();
          }
        }
      }
    }
  }, {
    key: "_addLoadingIndicator",
    value: function _addLoadingIndicator() {
      var _this2 = this;

      if (this._loadingIndicatorActive) {
        return;
      } // Delay showing the loading indicator to avoid flicker


      _.delay(function () {
        if (_this2._gridView.isGridEmpty() && (_this2._contentIsLoading || _this2._showLoadingUntilFoundContent) && !_this2._loadingIndicatorActive) {
          _this2._div.addClass('content_loading');

          _this2._gridView.setToTextMode(_this2.getLoadingAnimationHTML(), true);

          _this2._loadingIndicatorActive = true;
          _this2._loadingIndicatorAddedTime = performance.now();
        }
      }, 50);
    }
  }, {
    key: "_removeLoadingIndicator",
    value: function _removeLoadingIndicator() {
      var _this3 = this;

      // Check to see if we should keep this around for a while anyway
      var gridEmpty = this._gridView.isGridEmpty();

      if (gridEmpty && this._showLoadingUntilFoundContent) {
        return;
      } // Avoid flicker - always show the indicator for a short time


      if (this._loadingIndicatorActive) {
        var nowTime = performance.now();
        var remainingTimeMS = 200 - (nowTime - this._loadingIndicatorAddedTime);

        if (remainingTimeMS > 0) {
          remainingTimeMS += 10;

          _.delay(function () {
            _this3._removeLoadingIndicator();
          }, remainingTimeMS);

          return;
        }
      } // Actually do the removal


      this._div.removeClass('content_loading');

      this._loadingIndicatorActive = false;
      var isInTextMode = false;

      if (gridEmpty) {
        if (this._delegate && typeof this._delegate.getGridEmptyContent === "function") {
          this._gridView.setToTextMode(this._delegate.getGridEmptyContent(this), true);

          isInTextMode = true;
        }
      }

      if (!isInTextMode) {
        this._gridView.setToGridMode();
      }
    }
  }, {
    key: "getLoadingAnimationHTML",
    value: function getLoadingAnimationHTML() {
      return '<div class="content_grid_loading"><div class="pip"></div><div class="pip"></div><div class="pip"></div></div>';
    }
  }, {
    key: "_handleIncrementalContentChange",
    value: function _handleIncrementalContentChange(changeContext) {
      if (!this._params.allowIncrementalUpdate) {
        return false;
      }

      if (!this._params.contentArranger) {
        return false;
      }

      if (!changeContext.hasDetails) {
        // Not the kind of change we understand
        return false;
      }

      if (changeContext.details.added.length > 0 || changeContext.details.removed.length > 0 || changeContext.details.updated.length === 0) {
        // @todo - handle additions and removals
        return false;
      }

      var arranger = this._params.contentArranger; // Make sure all the updates aren't affected by any filtering in the content arranger

      if (typeof arranger.filterItems === "function") {
        var filtered = arranger.filterItems(changeContext.details.updated);

        if (filtered.length !== changeContext.details.updated.length) {
          // this change would result in an add/remove, so bail out
          return false;
        }
      } // Give the content arranger a crack at doing this in case it has special requirements


      if (typeof arranger.doDefaultIncrementalGridUpdate === "function") {
        if (!arranger.doDefaultIncrementalGridUpdate(this, changeContext)) {
          // The content arranger wants to handle this, or else wants us to do a full refresh
          var arrangerDidUpdate = false;

          if (typeof arranger.handleIncrementalGridUpdate === "function") {
            arrangerDidUpdate = arranger.handleIncrementalGridUpdate(this, changeContext);
          }

          return arrangerDidUpdate;
        }
      } // Make sure the content arranger has the most up-to-date stuff


      var items = arranger.getItems();

      _content_provider_contract.default.api._applyWatchedChanges(items, changeContext.details.updated, []); // Find grid items for everything that changed and refresh them


      var changedIds = _.pluck(changeContext.details.updated, _content_provider_contract.default.api._defaultCompareProperty);

      var gridItems = [];
      var gridItem;

      for (var i = 0; i < items.length; i++) {
        if (changedIds.indexOf(items[i][_content_provider_contract.default.api._defaultCompareProperty]) !== -1) {
          gridItem = this._gridView.getGridItemForIndex(i);

          if (gridItem && gridItem.length > 0) {
            gridItem.data(items[i]);
            gridItems.push(gridItem);
          } else {
            // We couldn't find a grid item for this record. Do a full refresh for safety
            return false;
          }
        }
      }

      this._gridView.refreshGridItems(gridItems);

      return true;
    }
  }, {
    key: "onSelectionUpdated",
    ///////////////////////////////
    // Grid Delegate Methods
    value: function onSelectionUpdated(gridView, selectedItems) {
      var content = [];

      for (var i = 0; i < selectedItems.length; i++) {
        content.push(gridView.getDataForGridItem(selectedItems[i]));
      }

      if (this._delegate && typeof this._delegate.onContentSelected === "function") {
        this._delegate.onContentSelected(this, content);
      }
    }
  }, {
    key: "onGroupExpansionChanged",
    value: function onGroupExpansionChanged(gridView, isExpanded, groupIndex, groupData) {
      if (typeof this._params.onGroupExpansionChanged === 'function') {
        this._params.onGroupExpansionChanged(gridView, isExpanded, groupIndex, groupData);
      }
    } ///////////////////////////////
    // Grid Styler Methods - only used as a fallback if no styler is passed in	                       

  }, {
    key: "styleGridItem",
    value: function styleGridItem(gridView, gridItemDiv, gridData) {
      var titleStr = "" + this._params.contentProperties.getDisplayName(gridData);

      var divString = '<div class="rg_grid_item_title">' + titleStr + '</div>';
      gridItemDiv.append(divString);
    }
  }, {
    key: "styleGridGroupHeader",
    value: function styleGridGroupHeader(gridView, groupHeaderDiv, groupData) {
      groupHeaderDiv.addClass("rg_cb_grid_header");
      var titleStr = "";

      if (groupData.name) {
        titleStr = "" + groupData.name;
      } else {
        // find the first string property and use that ¯\_(ツ)_/¯
        for (var k in groupData) {
          if (groupData.hasOwnProperty(k) && typeof groupData[k] === "string") {
            titleStr = groupData[k];
            break;
          }
        }
      }

      groupHeaderDiv.append('<div class="rg_cb_grid_header_title">' + titleStr + '</div>');
    }
  }]);

  return ContentGrid;
}();

exports.default = ContentGrid;

_content_consumer.default.asContentConsumer(ContentGrid.prototype);

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(16);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".rg_cb_grid {\n  background-color: #282828;\n  height: 100%;\n}\n.rg_cb_grid .rg_grid_item .rg_grid_item_title {\n  font-size: 12px;\n  text-shadow: none;\n}\n.rg_cb_grid .rg_grid_item_selected .rg_grid_item_title {\n  text-shadow: none;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header {\n  height: 29px;\n  margin: 0px;\n  background: -webkit-gradient(linear, left top, left bottom, from(#666666), to(#4a4a4a));\n  border-top: 1px solid #141414;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header .rg_grid_group_toggle {\n  position: relative;\n  top: 4px;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header:nth-of-type(1) {\n  border-top: none;\n  border-bottom: none;\n}\n.rg_cb_grid .rg_cb_grid_header_title {\n  display: inline-block;\n  height: 29px;\n  line-height: 29px;\n  font-size: 14px;\n  font-family: RGMajorSans, helvetica;\n  color: #dfdfdf;\n  text-transform: uppercase;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short {\n  height: 18px;\n  padding-top: 1px;\n  border-top: none;\n  background: #484848;\n  border-bottom: 1px solid #404040;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_cb_grid_header_title {\n  height: 18px;\n  line-height: 18px;\n  text-transform: none;\n}\n.rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_grid_group_toggle {\n  position: relative;\n  top: 0px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_cb_grid_header_title {\n  font-size: 13px;\n  line-height: 27px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short {\n  padding-top: 0px;\n  padding-bottom: 1px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_cb_grid_header_title {\n  font-size: 12px;\n}\n.rg_use_modern_major_font .rg_cb_grid .rg_grid_group.rg_cb_grid_header.rg_cb_group_header_short .rg_grid_group_toggle {\n  position: relative;\n  top: 1px;\n}\n@keyframes pip_fade {\n  0% {\n    opacity: 1;\n  }\n  25% {\n    opacity: 0.25;\n  }\n  50% {\n    opacity: 0.25;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n.content_loading .rg_grid_empty_text {\n  opacity: 1;\n}\n.content_grid_loading {\n  display: inline-block;\n  width: 100px;\n  text-align: center;\n  height: 24px;\n}\n.content_grid_loading .pip {\n  height: 8px;\n  width: 8px;\n  background-color: #a1a1a1;\n  border-radius: 50%;\n  display: inline-block;\n  margin: 8px;\n  animation: pip_fade 2s linear;\n  animation-iteration-count: infinite;\n}\n.content_grid_loading :nth-child(2) {\n  animation-delay: -1.66s;\n}\n.content_grid_loading :nth-child(3) {\n  animation-delay: 0.66s;\n}\n", ""]);

// exports


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridGroupers = exports.ContentArrangerSimple = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(7));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var GridGroupers = {
  groupByKey: function groupByKey(groupKey, defaultGroupId) {
    if (!defaultGroupId) {
      defaultGroupId = "";
    }

    return function (contentItem) {
      if (typeof contentItem[groupKey] === "string") {
        return contentItem[groupKey];
      }

      return defaultGroupId;
    };
  },
  groupDataByKey: function groupDataByKey(groupKey, filter, contentProvider) {
    var cf = {};

    _content_filter.default.asContentFilter(cf);

    cf._contentFilterInit();

    return function (groupId) {
      filter[groupKey] = groupId;
      cf.setFilter(filter);
      var d = cf.filterItems(contentProvider.getContent());

      if (d.length > 0) {
        return d[0];
      }

      return {};
    };
  },
  groupByProperty: function groupByProperty(contentProperties, propertyName, defaultGroupId) {
    if (!defaultGroupId) {
      defaultGroupId = "";
    }

    if (!propertyName) {
      propertyName = "displayCategory";
    }

    return function (contentItem) {
      var groupId = contentProperties.getProperty(contentItem, propertyName);

      if (typeof groupId === "string") {
        return groupId;
      }

      return defaultGroupId;
    };
  },
  makeSimpleDataForGroupId: function makeSimpleDataForGroupId(groupId) {
    return {
      groupId: groupId,
      name: RG.utils.toTitleCase(groupId)
    };
  }
};
exports.GridGroupers = GridGroupers;

var ContentArrangerSimple =
/*#__PURE__*/
function () {
  /*
      params = {    
          getGroupId: function(contentItem) { return ""; } // return a group id key for an item
          getDataForGroupId: function(groupId) { return { name: "Group Name"}; }
          groupCompareFunction: null, // (optional - function): a sort predicate function for groupKey values: https://www.w3schools.com/jsref/jsref_sort.asp
          alwaysShowOneGroup: false, // (optional - boolean): if true, a group header is shown if there is only one group
          compareItemFunc: null // (optional - function - depricated): a sort predicate for contentItems. Prefer ContentFormat.ordering instead.
      }
  */
  function ContentArrangerSimple(params) {
    _classCallCheck(this, ContentArrangerSimple);

    this._params = params ? params : {};

    _.defaults(this._params, {
      getGroupId: function getGroupId() {
        return "";
      },
      getDataForGroupId: null,
      groupCompareFunction: null,
      alwaysShowOneGroup: false
    });

    this._items = [];
    this._groups = [];

    this._contentFilterInit(); // MBL-2584: ContentFormat.ordering exists now - use that instead of the old compare function


    if (typeof this._params.compareItemFunc === "function") {
      console.log("Deprecation Warning: params.compareItemFunc is depreciated. Use ContentFormat.ordering instead");
    }
  }

  _createClass(ContentArrangerSimple, [{
    key: "setContentGrid",
    value: function setContentGrid(contentGrid) {
      this._contentGrid = contentGrid;
    }
  }, {
    key: "setGetGroupIdFunc",
    value: function setGetGroupIdFunc(getGroupIdFunc) {
      this._params.getGroupId = getGroupIdFunc;
    }
  }, {
    key: "setContent",
    value: function setContent(contentList) {
      this._items = this.filterItems(contentList); // Depricated but leave it in case someone is still using it UP-4125

      if (typeof this._params.compareItemFunc === "function") {
        this._items.sort(this._params.compareItemFunc);
      }

      this._buildGroups(this._params.alwaysShowOneGroup);
    }
  }, {
    key: "getItems",
    value: function getItems() {
      return this._items;
    }
  }, {
    key: "getGroups",
    value: function getGroups() {
      return {
        groups: this._groups,
        totalCount: this._items.length
      };
    }
  }, {
    key: "_handleFiltersUpdated",
    value: function _handleFiltersUpdated() {
      if (this._contentGrid) {
        this._contentGrid.refresh();
      }
    }
  }, {
    key: "_sortGroupIdsByCategories",
    value: function _sortGroupIdsByCategories(groupIds, categories) {
      var orderedLookup = [];
      var unorderedLookup = [];

      for (var i = 0; i < groupIds.length; i++) {
        var id = groupIds[i];
        var index = -1;

        for (var c = 0; c < categories.length; c++) {
          var category = categories[c];

          if (category.Name === id) {
            index = c;
          }
        }

        if (index >= 0) {
          orderedLookup.push({
            index: index,
            name: id
          });
        } else {
          unorderedLookup.push(id);
        }
      }

      orderedLookup = _.sortBy(orderedLookup, function (item) {
        return item.index;
      });
      var sortedIds = [];

      for (var i = 0; i < orderedLookup.length; i++) {
        var item = orderedLookup[i];
        sortedIds.push(item.name);
      }

      for (var i = 0; i < unorderedLookup.length; i++) {
        var item = unorderedLookup[i];
        sortedIds.push(item);
      }

      return sortedIds;
    }
  }, {
    key: "_buildGroups",
    value: function _buildGroups(alwaysShowOneGroup) {
      this._groups = [];

      if (typeof this._params.getGroupId !== "function") {
        // No groups - nothing to do!
        return;
      }

      var groupings = {};
      var ungrouped = [];
      var groupId;
      var i; // Find groups

      for (i = 0; i < this._items.length; i++) {
        groupId = this._params.getGroupId(this._items[i]);

        if (!groupId) {
          ungrouped.push(this._items[i]);
        } else {
          if (!groupings[groupId]) {
            groupings[groupId] = [];
          }

          groupings[groupId].push(this._items[i]);
        }
      }

      var groupIds = _.keys(groupings);

      if (!alwaysShowOneGroup) {
        if (groupIds.length === 0 || groupIds.length === 1 && ungrouped.length === 0) {
          // don't bother to create any groups since we want to hide the first one
          return;
        }
      } // Sort groups


      if (typeof this._params.groupCompareFunction === "function") {
        // custom sort
        groupIds.sort(this._params.groupCompareFunction);
      } else {
        // alphabetical
        groupIds.sort();
      }

      if (typeof this.getRootItem === 'function') {
        var rootItem = this.getRootItem();

        if (rootItem !== null && rootItem !== undefined && Array.isArray(rootItem.categories)) {
          var categories = rootItem.categories;
          groupIds = this._sortGroupIdsByCategories(groupIds, categories);
        }
      } // Reorder our items to match the group order


      var sortedItems = ungrouped;
      var g, gData;

      for (i = 0; i < groupIds.length; i++) {
        g = {
          offs: sortedItems.length,
          groupId: groupIds[i],
          len: groupings[groupIds[i]].length,
          expand: true
        };

        if (typeof this._params.getDataForGroupId === "function") {
          gData = this._params.getDataForGroupId(groupIds[i]);

          if (gData) {
            _.defaults(g, gData);
          }
        }

        this._groups.push(g);

        sortedItems = sortedItems.concat(groupings[groupIds[i]]);
      }

      this._items = sortedItems;
    }
  }]);

  return ContentArrangerSimple;
}();

exports.ContentArrangerSimple = ContentArrangerSimple;

_content_filter.default.asContentFilter(ContentArrangerSimple.prototype);

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
	A mapper that can be used to read common display properties
	from a contentItem, either by convention or by configuration.

	propertyMap = {
		// Will iterate through the array trying to find a set match
		propertyName: ["otherPropertyName", getPropertyFunction() { }]
	}

 */
var ContentProperties =
/*#__PURE__*/
function () {
  function ContentProperties(propertyMap) {
    _classCallCheck(this, ContentProperties);

    this._propertyMap = propertyMap ? propertyMap : {}; // Register default decoder maps for standard properties

    _.defaults(this._propertyMap, {
      displayName: ["displayName", "name", this._getFileNameNoExtension.bind(this)],
      displayCategory: ["displayCategory", "category", this._getParentFolderName.bind(this)],
      filePath: ["filePath", "path"],
      fileName: ["fileName", this._getFileName.bind(this)],
      parentFolderName: ["parentFolderName", this._getParentFolderName.bind(this)],
      parentFolderPath: ["parentFolderPath", this._getParentFolderPath.bind(this)]
    });
  }

  _createClass(ContentProperties, [{
    key: "getProperty",
    value: function getProperty(contentItem, propertyName) {
      if (!contentItem) {
        return undefined;
      }

      if (this._propertyMap.hasOwnProperty(propertyName)) {
        var mapper = this._propertyMap[propertyName];
        var result = undefined;

        for (var i = 0; i < mapper.length; i++) {
          if (typeof mapper[i] === "string") {
            result = contentItem[mapper[i]];
          } else if (typeof mapper[i] === "function") {
            try {
              result = mapper[i](contentItem, propertyName, this);
            } catch (err) {
              console.log("ContentProperties caught error in function for " + propertyName);
              console.log(err);
            }
          }

          if (result !== undefined) {
            return result;
          }
        }
      }

      return contentItem[propertyName];
    } ////////////////////////////////////
    // Convenience

  }, {
    key: "getDisplayName",
    value: function getDisplayName(contentItem) {
      return this.getProperty(contentItem, "displayName");
    }
  }, {
    key: "getDisplayCategory",
    value: function getDisplayCategory(contentItem) {
      return this.getProperty(contentItem, "displayCategory");
    }
  }, {
    key: "getFilePath",
    value: function getFilePath(contentItem) {
      return this.getProperty(contentItem, "filePath");
    }
  }, {
    key: "getFileName",
    value: function getFileName(contentItem) {
      return this.getProperty(contentItem, "fileName");
    }
  }, {
    key: "getParentFolderName",
    value: function getParentFolderName(contentItem) {
      return this.getProperty(contentItem, "parentFolderName");
    } ////////////////////////////////////
    // Special property decoders

  }, {
    key: "_getFileName",
    value: function _getFileName(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getFileNameFromPath(path);
      }

      return undefined;
    }
  }, {
    key: "_getFileNameNoExtension",
    value: function _getFileNameNoExtension(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getFileNameWithoutExtensionFromPath(path);
      }

      return undefined;
    }
  }, {
    key: "_getParentFolderName",
    value: function _getParentFolderName(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        var parentFolderPath = RG.utils.getParentFolderFromPath(path);
        return RG.utils.getFileNameFromPath(parentFolderPath);
      }

      return undefined;
    }
  }, {
    key: "_getParentFolderPath",
    value: function _getParentFolderPath(contentItem) {
      var path = this.getFilePath(contentItem);

      if (typeof path === "string") {
        return RG.utils.getParentFolderFromPath(path);
      }

      return undefined;
    }
  }]);

  return ContentProperties;
}();

exports.default = ContentProperties;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _content_filter = _interopRequireDefault(__webpack_require__(7));

var _content_filter_utils = _interopRequireDefault(__webpack_require__(9));

var _content_watching = _interopRequireDefault(__webpack_require__(20));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ChangeEvents = {
  create: "cb.api.json.create",
  update: "cb.api.json.update",
  remove: "cb.api.json.remove"
};

var ContentAPIJson =
/*#__PURE__*/
function () {
  function ContentAPIJson(content) {
    _classCallCheck(this, ContentAPIJson);

    this._exposeRawItems = false;
    this._content = [];

    if (content) {
      if (typeof content === "string") {
        this._content = JSON.parse(content);
      } else {
        this._content = content;
      }
    }

    var c;

    for (var i = 0; i < this._content.length; i++) {
      c = this._content[i];

      if (!c._id) {
        c._id = RG.Uuid.create();
      }
    }

    this._notifier = new RG.utils.Notifier();
  }
  /**
   * Control whether a get() will return copies of the underlying ContentItems (default) or
   * the actual items. 
   * 
   * Returning copies is more in-line with with the actual ContentAPI would do (ideal for 
   * mock data), but is less efficient, so it can be turned off for use in production, assuming
   * you know what you're doing.
   * 
   */


  _createClass(ContentAPIJson, [{
    key: "setShouldExposeRawItems",
    value: function setShouldExposeRawItems(expose) {
      this._exposeRawItems = expose;
    }
    /**
     * Query items that match filter, organized by format
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "get",
    value: function get(filter, format) {
      this.setFilter(filter);
      var results = this.filterItems(this._content);

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        resolve(results);
      });
    }
    /**
     * Create a new item from contentItem
     * @return a promise that fulfills with a single created contentItem
     */

  }, {
    key: "create",
    value: function create(contentItem) {
      var _this = this;

      if (!contentItem) {
        return Promise.reject(new Error("400 bad request"));
      }

      var result = null;

      if (this._exposeRawItems) {
        contentItem._id = RG.Uuid.create();

        this._content.push(contentItem);

        result = contentItem;
      } else {
        var result = _content_filter_utils.default.deepCopy(contentItem);

        result._id = RG.Uuid.create();

        this._content.push(result);

        result = _content_filter_utils.default.deepCopy(result);
      }

      return new Promise(function (resolve, reject) {
        _this._notifyChanges(ChangeEvents.create, result); // Resolve


        resolve(result);
      });
    }
    /**
     * Update a single contentItem
     * @return a promise that fulfills with a single updated contentItem
     */

  }, {
    key: "update",
    value: function update(contentItem) {
      return this.updateAll([contentItem]).then(function (contentList) {
        return contentList[0];
      });
    }
    /**
     * Update all matching items
     * @param filter the filter the existing items must match to be updated
     * @param changes a json object of key-values to be applied to all matching items
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateWhere",
    value: function updateWhere(filter, modifier) {
      var _this2 = this;

      this.setFilter(filter);
      var results = this.filterItems(this._content); // safety check

      if (modifier.hasOwnProperty("_id")) {
        delete modifier._id;
      } // make changes


      for (var i = 0; i < results.length; i++) {
        _.extend(results[i], modifier);
      }

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        _this2._notifyChanges(ChangeEvents.update, results);

        resolve(results);
      });
    }
    /**
     * Update a list of items - like update() but takes an array
     * @return a promise that fulfills with an array of contentItems
     */

  }, {
    key: "updateAll",
    value: function updateAll(contentList) {
      var _this3 = this;

      var map = this._buildMap(contentList); // Ensure we have everything


      var foundCount = 0;

      for (var i = 0; i < this._content.length; i++) {
        if (map.hasOwnProperty(this._content[i]._id)) {
          foundCount++;
        }
      }

      if (foundCount !== contentList.length) {
        // Asked to update something invalid
        return Promise.reject(new Error("404 not found"));
      }

      var results = [];

      for (var _i = 0; _i < this._content.length; _i++) {
        if (map.hasOwnProperty(this._content[_i]._id)) {
          _.extend(this._content[_i], map[this._content[_i]._id]);

          results.push(this._content[_i]);
        }
      }

      if (!this._exposeRawItems) {
        results = _content_filter_utils.default.deepCopy(results);
      }

      return new Promise(function (resolve, reject) {
        _this3._notifyChanges(ChangeEvents.update, results);

        resolve(results);
      });
    }
    /**
     * Delete an item
     * @param contentItem must contain _id - all other fields ignored
     * @return a promise that fulfills with a single removed of contentItem
     */

  }, {
    key: "delete",
    value: function _delete(contentItem) {
      var _this4 = this;

      if (!contentItem || typeof contentItem._id === "undefined") {
        return Promise.reject(new Error("400 bad request"));
      }

      var result = null;
      var uuid = contentItem._id;

      for (var i = 0; i < this._content.length; i++) {
        if (this._content[i]._id === uuid) {
          result = this._content[i];

          this._content.splice(i, 1);

          break;
        }
      }

      if (!result) {
        return Promise.reject(new Error("404 not found"));
      }

      if (!this._exposeRawItems) {
        result = _content_filter_utils.default.deepCopy(result);
      }

      return new Promise(function (resolve, reject) {
        _this4._notifyChanges(ChangeEvents.remove, result);

        resolve(result);
      });
    }
  }, {
    key: "_buildMap",
    value: function _buildMap(contentList) {
      return _.indexBy(contentList, "_id");
    } ////////////////////////////////////
    // ContentWatching

  }, {
    key: "createContentWatcher",
    value: function createContentWatcher() {
      return new _content_watching.default(this, ChangeEvents.create, ChangeEvents.update, ChangeEvents.remove);
    }
  }, {
    key: "addListener",
    value: function addListener(eventName, callback) {
      this._notifier.registerForNotifications(eventName, function (n) {
        callback(n.data);
      });
    }
  }, {
    key: "_notifyChanges",
    value: function _notifyChanges(event, changes) {
      var _this5 = this;

      var changedItems = [];

      if (Array.isArray(changes)) {
        changedItems = changes.slice(0);
      } else {
        changedItems = [changes];
      }

      if (!this._exposeRawItems) {
        changedItems = _content_filter_utils.default.deepCopy(changedItems);
      }

      var n = {
        content: changedItems
      };

      _.defer(function () {
        _this5._notifier.postNotification(event, n);
      });
    }
  }]);

  return ContentAPIJson;
}();

exports.default = ContentAPIJson;

_content_filter.default.asContentFilter(ContentAPIJson.prototype);

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _change_tracking = _interopRequireDefault(__webpack_require__(21));

var _content_filter = _interopRequireDefault(__webpack_require__(7));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ContentWatching =
/*#__PURE__*/
function () {
  function ContentWatching(api, createEventName, updateEventName, removeEventName) {
    _classCallCheck(this, ContentWatching);

    this._changeTrackingInit();

    api.addListener(createEventName, this._onContentCreated.bind(this));
    api.addListener(updateEventName, this._onContentUpdated.bind(this));
    api.addListener(removeEventName, this._onContentRemoved.bind(this));
  }

  _createClass(ContentWatching, [{
    key: "_onChangeTrackingStart",
    value: function _onChangeTrackingStart() {
      if (this.isChangeTrackingInvalid()) {
        this.refreshChangeTracking();
      }
    }
  }, {
    key: "_onContentCreated",
    value: function _onContentCreated(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.updates = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }, {
    key: "_onContentUpdated",
    value: function _onContentUpdated(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.updates = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }, {
    key: "_onContentRemoved",
    value: function _onContentRemoved(message) {
      var filteredContent = this.filterItems(message.content);

      if (filteredContent.length > 0) {
        if (this.isChangeTrackingActive()) {
          var result = {
            updates: [],
            removals: []
          };
          result.removals = filteredContent;

          this._handleChangeTrackingResult(result);
        } else {
          this.invalidateChangeTracking();
        }
      }
    }
  }]);

  return ContentWatching;
}();

exports.default = ContentWatching;

_change_tracking.default.asChangeTracking(ContentWatching.prototype);

_content_filter.default.asContentFilter(ContentWatching.prototype);

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var ChangeTrackingAPI = {
  _changeTrackingInit: function _changeTrackingInit(params) {
    this._changeTrackingActive = false;
    this._changeTrackingInvalidated = false;
    this._changeTrackingCallback = null;
  },
  // callback = function(updates, removals, needsFullRefresh) { }
  setChangeTrackingCallback: function setChangeTrackingCallback(callback) {
    this._changeTrackingCallback = callback;
  },
  start: function start() {
    if (!this._changeTrackingActive) {
      this._changeTrackingActive = true;

      this._onChangeTrackingStart();
    }
  },
  stop: function stop() {
    if (this._changeTrackingActive) {
      this._changeTrackingActive = false;

      this._onChangeTrackingStop();
    }
  },
  isChangeTrackingActive: function isChangeTrackingActive() {
    return this._changeTrackingActive;
  },
  isChangeTrackingInvalid: function isChangeTrackingInvalid() {
    return this._changeTrackingInvalidated;
  },
  // call when something changes and the current request should be discarded
  invalidateChangeTracking: function invalidateChangeTracking() {
    this._changeTrackingInvalidated = true;
  },
  refreshChangeTracking: function refreshChangeTracking() {
    try {
      if (this._changeTrackingCallback) {
        this._changeTrackingCallback(null, null, true);
      }

      this._changeTrackingInvalidated = false;
    } catch (err) {
      console.log("Error refreshing change tracking:");
      console.log(err);
    }
  },
  _onChangeTrackingStart: function _onChangeTrackingStart() {},
  _onChangeTrackingStop: function _onChangeTrackingStop() {},
  _handleChangeTrackingResult: function _handleChangeTrackingResult(result) {
    try {
      if (result.updates.length > 0 || result.removals.length > 0) {
        if (this._changeTrackingCallback) {
          this._changeTrackingCallback(result.updates, result.removals, false);
        }
      }
    } catch (err) {
      console.log("Error handling change tracking results:");
      console.log(err);
    }
  }
};

var asChangeTracking = function asChangeTracking(target) {
  _.defaults(target, ChangeTrackingAPI);
};

var ChangeTracking = {
  api: ChangeTrackingAPI,
  asChangeTracking: asChangeTracking
};
exports.default = ChangeTracking;

/***/ }),
/* 22 */
/***/ (function(module) {

module.exports = [{"name":"Basic Arrow","category":"Arrows","kind":"item","selectionIndex":0},{"name":"Open Arrow","category":"Arrows","kind":"item","selectionIndex":1},{"name":"Thin Double Arrow","category":"Arrows","kind":"item","selectionIndex":2},{"name":"8 Bit Arrow","category":"Arrows","kind":"item","selectionIndex":3},{"name":"Pointer","category":"Arrows","kind":"item","selectionIndex":4},{"name":"Arc","category":"Arcs","kind":"item","selectionIndex":5},{"name":"Measure Arc 1","category":"Arcs","kind":"item","selectionIndex":6},{"name":"Measure Arc 2","category":"Arcs","kind":"item","selectionIndex":7},{"name":"Measure Arc 3","category":"Arcs","kind":"item","selectionIndex":8},{"name":"Measure Arc 4","category":"Arcs","kind":"item","selectionIndex":9},{"name":"Measure Arc 5","category":"Arcs","kind":"item","selectionIndex":10},{"name":"Crosshair 1","category":"Targeting","kind":"item","selectionIndex":11},{"name":"Crosshair 2","category":"Targeting","kind":"item","selectionIndex":12},{"name":"Crosshair 3","category":"Targeting","kind":"item","selectionIndex":13},{"name":"Crosshair 4","category":"Targeting","kind":"item","selectionIndex":14},{"name":"Crosshair 5","category":"Targeting","kind":"item","selectionIndex":15},{"name":"Crosshair 6","category":"Targeting","kind":"item","selectionIndex":16},{"name":"Crosshair 7","category":"Targeting","kind":"item","selectionIndex":17},{"name":"Target 1","category":"Targeting","kind":"item","selectionIndex":18},{"name":"Target 2","category":"Targeting","kind":"item","selectionIndex":19},{"name":"8 Bit Target","category":"Targeting","kind":"item","selectionIndex":20},{"name":"Circle Target","category":"Targeting","kind":"item","selectionIndex":21}];

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DialogFooter =
/*#__PURE__*/
function () {
  /* 
  Delegate methods
       validateOk: function() { return true; }
      getDialogResult: function() { return {}; }
      onCancel: function() { }
      onOk: function(dialogResult) { }
   */
  function DialogFooter(delegate) {
    _classCallCheck(this, DialogFooter);

    this._delegate = delegate ? delegate : {};

    this._buildUI();

    this._handleKeys();

    this.updateState();
  }

  _createClass(DialogFooter, [{
    key: "_buildUI",
    value: function _buildUI() {
      var holder = $('#dialog_footer');
      var footer = $('<div class="dialog_footer_outer"></div>');
      holder.append(footer);
      var footerInner = $('<div class="dialog_footer_inner"></div>');
      footer.append(footerInner);
      var cancelDiv = $('<div class="dialog_footer_button"></div>');
      Widgets.buildFlatButton(cancelDiv, __("Cancel"), this._onCancel.bind(this));
      footerInner.append(cancelDiv);
      footerInner.append('<div class="dialog_footer_space"></div>');
      var okDiv = $('<div class="dialog_footer_button"></div>');
      Widgets.buildFlatButton(okDiv, __("Apply"), this._onOk.bind(this));
      footerInner.append(okDiv);
      this._okButton = okDiv;
    }
  }, {
    key: "updateState",
    value: function updateState() {
      var enableOk = true;

      if (typeof this._delegate.validateOk === "function") {
        enableOk = this._delegate.validateOk();
      }

      this._okButton.toggleClass('disabled', !enableOk);
    }
  }, {
    key: "_handleKeys",
    value: function _handleKeys() {
      var _this = this;

      var self = this;
      $(document).keydown(function (e) {
        if (e.keyCode === 13) {
          // Enter
          if (!_this._okButton.hasClass('disabled')) {
            _this._onOk();
          }
        } else if (e.keyCode === 27) {
          // Escape
          _this._onCancel();
        }
      });
    }
  }, {
    key: "_onCancel",
    value: function _onCancel() {
      if (typeof this._delegate.onCancel === "function") {
        this._delegate.onCancel();
      }
    }
  }, {
    key: "_onOk",
    value: function _onOk() {
      var result = typeof this._delegate.getDialogResult === "function" ? this._delegate.getDialogResult() : {};

      if (typeof this._delegate.onOk === "function") {
        this._delegate.onOk(result);
      }
    }
  }]);

  return DialogFooter;
}();

module.exports = DialogFooter;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(25);

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var VideoRollover =
/*#__PURE__*/
function () {
  function VideoRollover(imagePath, videoPath, options) {
    _classCallCheck(this, VideoRollover);

    if (!videoPath && !imagePath) {
      // UP-3038: Only show the fallback video if we're showing the fallback thumbnail, otherwise it's distracting
      videoPath = "".concat(this.getFallbackMediaPath(), "plugin-preview");
    }

    if (!imagePath) {
      imagePath = "".concat(this.getFallbackMediaPath(), "plugin-thumbnail");
    }

    this.imagePath = imagePath;
    this.videoPath = videoPath;
    this.setDefaults(options);
    this.root = document.createElement('div');
    this.root.classList.add('video-rollover');
    this.placeHolder = document.createElement('div');
    this.placeHolder.classList.add('place-holder');
    this.video = document.createElement('video');
    this.video.classList.add('video');
    this.video.autoplay = true;
    this.video.muted = true;
    this.video.loop = true;
    this.video.preload = 'none';
    this.playing = false;
    this.loadMedia();
    this.root.appendChild(this.placeHolder);
    this.mouseMoveDelegate = this.onMouseMove.bind(this);
    this.mouseOutDelegate = this.onMouseOut.bind(this);
    window.addEventListener('mousemove', this.mouseMoveDelegate);
    window.addEventListener('blur', this.mouseOutDelegate);
    this.onDelayDelegate = this.onPlayDelay.bind(this);
  }

  _createClass(VideoRollover, [{
    key: "loadMedia",
    value: function loadMedia() {
      var _this = this;

      this.isMediaLoaded = false;
      this.placeHolder.style.background = 'black';
      var fallbackPath = this.getFallbackMediaPath();
      this.urls = {
        image: ["".concat(this.imagePath).concat(this.imageExtension), "".concat(fallbackPath, "plugin-thumbnail").concat(this.imageExtension)],
        video: [this.videoPath ? "".concat(this.videoPath).concat(this.videoExtensions[0]) : null, this.videoPath ? "".concat(this.videoPath).concat(this.videoExtensions[1]) : null, this.videoPath ? "".concat(fallbackPath, "plugin-preview").concat(this.videoExtensions[0]) : null]
      };
      this.loadImage(this.urls.image[0], function (event) {
        _this.onLoadImage(event, _this.urls.image[0]);
      }, function (event) {
        _this.disposeImage(event.target);

        _this.loadImage(_this.urls.image[1], function (event) {
          _this.onLoadImage(event, _this.urls.image[1]);
        }, function () {
          console.log('Unable to load image or fallback image.');
        });
      });
      this.loadVideo(this.urls.video[0], function () {
        _this.onLoadVideo(_this.urls.video[0]);
      }, function () {
        _this.loadVideo(_this.urls.video[1], function () {
          _this.onLoadVideo(_this.urls.video[1]);
        }, function () {
          _this.urls.video[2], function () {
            _this.onLoadVideo(_this.urls.video[2]);
          }, function () {
            console.log('Unable to load video or fallback video.');
          };
        });
      });
    }
  }, {
    key: "loadImage",
    value: function loadImage(url, onLoad, onError) {
      var image = new Image();
      image.onload = onLoad;
      image.onerror = onError;
      image.src = url;
    }
  }, {
    key: "loadVideo",
    value: function loadVideo(url, onLoad, onError) {
      if (!url) {
        onError();
        return;
      }

      var request = new XMLHttpRequest();
      request.open('GET', url, true);

      request.onload = function () {
        onLoad();
      };

      request.onerror = function () {
        onError();
      };

      request.send();
    }
  }, {
    key: "onLoadImage",
    value: function onLoadImage(event, url) {
      var formattedUrl = this.calculateCssUrl(url);
      this.placeHolder.style.background = "".concat(formattedUrl, " center / contain no-repeat");
      this.disposeImage(event.target);
      this.isMediaLoaded = true;
    }
  }, {
    key: "onLoadVideo",
    value: function onLoadVideo(url) {
      if (url.includes('.gif')) {
        this.isGif = true;
        this.gif = document.createElement('img');
        this.gif.src = url;
        this.gif.style.height = '100%';
        this.video = document.createElement('div');
        this.video.style.width = '100%';
        this.video.style.height = '100%';
        this.video.style.textAlign = 'center';
        this.video.appendChild(this.gif);
      }

      this.videoUrl = url;
      this.isMediaLoaded = true;
    }
  }, {
    key: "disposeImage",
    value: function disposeImage(image) {
      if (_typeof(image) !== 'object') {
        return;
      }

      if (typeof image.onload !== 'function') {
        return;
      }

      image.onload = null;

      if (typeof image.onerror !== 'function') {
        return;
      }

      image.onerror = null;
    }
  }, {
    key: "calculateCssUrl",
    value: function calculateCssUrl(url) {
      var space = ' ';
      var regEx = new RegExp(space, 'g');
      var sanitizedUrl = url.replace(regEx, '%20');
      return "url(".concat(sanitizedUrl, ")");
    }
  }, {
    key: "getFallbackMediaPath",
    value: function getFallbackMediaPath() {
      return "fallback/";
    }
  }, {
    key: "setDefaults",
    value: function setDefaults(options) {
      _.extend(this, options);

      _.defaults(this, {
        imageExtension: '.png',
        videoExtensions: ['.mp4', '.gif']
      });
    }
  }, {
    key: "getIsHovered",
    value: function getIsHovered() {
      if (typeof RGPanel !== "undefined") {
        var rect = this.root.getBoundingClientRect();
        return event.clientX >= rect.left && event.clientX <= rect.left + rect.width && event.clientY >= rect.top && event.clientY <= rect.top + rect.height;
      } else {
        return $(this.root).is(":hover");
      }
    }
  }, {
    key: "onMouseMove",
    value: function onMouseMove(event) {
      var isHovered = this.getIsHovered();

      if (isHovered) {
        this.onMouseOver();
      } else {
        this.onMouseOut();
      }
    }
  }, {
    key: "onMouseOver",
    value: function onMouseOver() {
      var _this2 = this;

      if (!this.isGif && !this.requestPlay && !this.playing && this.isMediaLoaded && this.videoUrl) {
        this.requestPlay = true;
        this.video.classList.add('hidden');
        this.video.src = this.videoUrl;
        this.root.appendChild(this.video);
        this.video.load();
        this.playPromise = this.video.play();

        var onPlaying = function onPlaying() {
          _this2.playing = true;

          _this2.root.removeChild(_this2.root.firstChild);

          _this2.video.classList.remove('hidden');

          var duration = 45000;

          if (_this2.playPromise !== null && _this2.playPromise !== undefined) {
            duration = 5 * _this2.video.duration * 1000;
          }

          _this2.delayTimeout = setTimeout(_this2.onDelayDelegate, duration);
        };

        if (this.playPromise === null || this.playPromise === undefined) {
          onPlaying();
        } else {
          this.playPromise.then(function () {
            onPlaying();
          });
        }
      }

      if (this.isGif && this.isMediaLoaded && !this.requestPlay) {
        this.requestPlay = true;
        this.root.appendChild(this.video);
        this.root.removeChild(this.root.firstChild);
        this.video.classList.remove('hidden');
        this.playing = true;
      }
    }
  }, {
    key: "onMouseOut",
    value: function onMouseOut() {
      var _this3 = this;

      if (this.requestPlay && !this.playing && this.playPromise !== null && this.playPromise !== undefined) {
        this.playPromise.then(function () {
          _this3.pauseVideo();
        });
      } else if (this.requestPlay && this.playing) {
        this.pauseVideo();
      }
    }
  }, {
    key: "pauseVideo",
    value: function pauseVideo() {
      if (!this.isGif) {
        this.video.pause();
        this.video.currentTime = 0;

        if (this.delayTimeout !== null && this.delayTimeout !== undefined) {
          clearTimeout(this.delayTimeout);
        }
      }

      if (this.root.firstChild !== undefined && this.root.firstChild !== null) {
        this.root.removeChild(this.root.firstChild);
      }

      this.root.appendChild(this.placeHolder);
      this.playing = false;
      this.requestPlay = false;
    }
  }, {
    key: "onPlayDelay",
    value: function onPlayDelay() {
      this.onMouseOut();
    }
  }]);

  return VideoRollover;
}();

module.exports = VideoRollover;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {


var content = __webpack_require__(26);

if(typeof content === 'string') content = [[module.i, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(4)(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(3)(false);
// imports


// module
exports.push([module.i, ".video-rollover {\n  position: absolute;\n  left: 0;\n  top: 0;\n  right: 0;\n  bottom: 0;\n}\n.video-rollover .place-holder {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover video {\n  width: 100%;\n  height: 100%;\n}\n.video-rollover video.hidden {\n  width: 0px;\n  height: 0px;\n}\n", ""]);

// exports


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionState =
/*#__PURE__*/
function () {
  function ExpansionState(matchname, assetKind, api) {
    _classCallCheck(this, ExpansionState);

    this.matchname = matchname !== undefined ? matchname : "";
    this.assetKind = assetKind;
    this.api = api;
    this.expansionstate = [];
  }

  _createClass(ExpansionState, [{
    key: "getState",
    value: function getState() {
      var _this = this;

      try {
        return this.api.get(this.matchname, this.assetKind).then(function (data) {
          _this.expansionstate = data.expansionstate;
          return _this.expansionstate;
        });
      } catch (err) {
        console.log("Error when calling getState");
        console.log(err);
        return this.expansionstate;
      }

      ;
    }
  }, {
    key: "setState",
    value: function setState(category, isExpanded) {
      var _this2 = this;

      var filter = function filter(item) {
        return item.category === category;
      };

      var foundItems = this._findItems(filter);

      if (foundItems.length > 0) {
        for (var i = foundItems.length - 1; i >= 0; i--) {
          var foundItem = foundItems[i];
          this.expansionstate.splice(foundItem.index, 1);
        }
      }

      this.expansionstate.push({
        category: category,
        isExpanded: isExpanded
      });

      try {
        return this.api.update(this.matchname, this.assetKind, this.expansionstate).then(function (data) {
          _this2.expansionstate = data.expansionstate;
          return _this2.expansionstate;
        });
      } catch (err) {
        console.log("Error when calling setState");
        console.log(err);
        return this.expansionstate;
      }

      ;
    }
  }, {
    key: "findState",
    value: function findState(category) {
      var filter = function filter(item) {
        return item.category === category;
      };

      var foundItems = this._findItems(filter);

      if (foundItems.length > 0) {
        return foundItems[0].item;
      } else {
        return {
          category: category,
          isExpanded: true
        };
      }
    }
  }, {
    key: "_findItems",
    value: function _findItems(filter) {
      var foundItems = [];

      for (var i = 0; i < this.expansionstate.length; i++) {
        var item = this.expansionstate[i];

        if (filter(item)) {
          foundItems.push({
            index: i,
            item: item
          });
        }
      }

      return foundItems;
    }
  }]);

  return ExpansionState;
}();

;
module.exports = ExpansionState;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionStateAPI =
/*#__PURE__*/
function () {
  function ExpansionStateAPI(apiTransport) {
    _classCallCheck(this, ExpansionStateAPI);

    this._transport = apiTransport;
  }

  _createClass(ExpansionStateAPI, [{
    key: "_buildQuery",
    value: function _buildQuery(effectMatchName, assetKind) {
      return "matchname=" + effectMatchName + "&" + "assetKind=" + assetKind;
    }
  }, {
    key: "get",
    value: function get(effectMatchName, assetKind) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        if (!_this._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "GET",
          query: _this._buildQuery(effectMatchName, assetKind),
          success: function success(d) {
            return resolve(d);
          },
          failure: reject
        };

        _this._transport.makeRequest(requestParams);
      });
    }
  }, {
    key: "update",
    value: function update(effectMatchName, assetKind, state) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        if (!_this2._transport) {
          reject("No api transport provided");
        }

        var requestParams = {
          method: "PUT",
          query: _this2._buildQuery(effectMatchName, assetKind),
          data: {
            expansionstate: state
          },
          success: function success(d) {
            return resolve(d);
          },
          failure: reject
        };

        _this2._transport.makeRequest(requestParams);
      });
    }
  }]);

  return ExpansionStateAPI;
}();

module.exports = ExpansionStateAPI;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpansionStateTransport =
/*#__PURE__*/
function () {
  function ExpansionStateTransport() {
    _classCallCheck(this, ExpansionStateTransport);

    this._apiPath = "/nx_api/expansionstate";
  }

  _createClass(ExpansionStateTransport, [{
    key: "makeRequest",
    value: function makeRequest(requestParams) {
      if (!requestParams) {
        console.log("Error: empty request made.");
        return;
      }

      requestParams.path = this._apiPath;

      if (requestParams.query) {
        requestParams.path += "?" + requestParams.query;
      }

      _.defaults(requestParams, {
        method: "GET",
        success: null,
        failure: null
      });

      nx_api.router.makeRequest(requestParams);
    }
  }]);

  return ExpansionStateTransport;
}();

module.exports = ExpansionStateTransport;

/***/ })
/******/ ]);