function TestPageFunc() {
	
	var _self = this;
	
	this.init = function() {
		console.log("Neutrino Init");
		
		var animationDelay = 600;
		
		$('#red').animate({opacity:1.0}, animationDelay, function() {
			$('#giant').animate({opacity:1.0}, animationDelay, function() {
				$('#neutrino').animate({opacity:1.0}, animationDelay).delay(animationDelay, function(){
					if (typeof nx_bridge === "undefined") {
						$('#msg_area').append("nx_bridge not found");
					}
					else {

						var showBridgeInfo = function(windowState) {
							var bridgeLine = "version "+ nx_bridge.version[0] + "." + nx_bridge.version[1] + "." + nx_bridge.version[2];

							if (windowState) {
								if (windowState.isNxWindow) {
									bridgeLine += "<br/>hosted in NxWindow";
									if (windowState.isModal) {
										bridgeLine += " (modal)";
									}
								}
							}
							$('#msg_area').append(bridgeLine);
						}

						if (typeof nx_api !== "undefined") {
							nx_api.init();
							nx_api.nx_window.getState().then(showBridgeInfo);
							console.log("Remote nxId: " +nx_api.remoteId);
						}	
						else {
							showBridgeInfo();
						}
					}
				});
			});
		});
	};
}


var TestPageApp = new TestPageFunc();

$(document).ready(function() {   

	TestPageApp.init();
}); 