function RulerFunc() {

    var _self = this;
    var _holder = null;
    var _canvas = null;
    var _details = null;

    this.init = function() {


        window.matchMedia('screen and (min-resolution: 1.1dppx)').addListener(function(){ 
            console.log("Window DPI changed to "+window.devicePixelRatio);
            _self.refresh();
        });

        window.onresize = function() {
            _self.refresh();
        };

        _holder = $('#ruler_holder');
        _canvas = $("#ruler_canvas")[0];
        _details = $('#ruler_details');

        _self.refresh();
    };


    this.refresh = function() {

        var width = window.innerWidth;
        var height = window.innerHeight;
        var dpi = window.devicePixelRatio;
        _details.empty().append(width + " x " + height + " at " + dpi + " dpi");

        $(_canvas).css({
            width: width+"px",
            height: height+"px"
        });
        _canvas.width = width * dpi;
        _canvas.height = height * dpi;


        var ctx = _canvas.getContext('2d');
        ctx.clearRect(0, 0, _canvas.width, _canvas.height);

        ctx.strokeStyle = "#dddddd";

        ctx.beginPath();

        var tickSpacing = 20;
        var tickLength = 8 * dpi;
        var x = 0;
        var y = 0;
        for (x = tickSpacing; x <= width; x+= tickSpacing) {
            ctx.moveTo(x*dpi, 0);
            ctx.lineTo(x*dpi, (x%100 === 0) ? tickLength*3 : tickLength);

            ctx.moveTo(x*dpi, _canvas.height);
            ctx.lineTo(x*dpi, _canvas.height - ((x%100 === 0) ? tickLength*3 : tickLength));
        }

        for (y = tickSpacing; y <= height; y+= tickSpacing) {
            ctx.moveTo(0, y * dpi);
            ctx.lineTo((y%100 === 0) ? tickLength*3 : tickLength, y*dpi);

            ctx.moveTo(_canvas.width, y * dpi);
            ctx.lineTo(_canvas.width - ((y%100 === 0) ? tickLength*3 : tickLength), y*dpi);
        }

        ctx.stroke();

    };
}

var RulerApp = new RulerFunc();

$(document).ready(function() {   

	RulerApp.init();
}); 