function ControlsTestFunc() {
	
	var _self = this;
	var _notifier = null;

	this.init = function() {
		
		if (typeof nx_api !== "undefined") {
			nx_api.init();
			nx_api.nx_notifier.transmitAll(true);
			_notifier = nx_api.notifier;

			// Register a close handler
			nx_api.closeHandler.setHandler(_onCloseRequested);
		}
		else {
			_notifier = new RG.utils.Notifier();
		}
		
		$('#test_button').click(function(e){
			_notifier.postNotification("ui_event", {kind:"click"});
		});
		
		$('#dev_button').click(function(e){
			nx_api.devTools.show();
		});

		$('body').keydown(function(e) {
			console.log("keydown: " + e.key + ", " + e.keyCode);
			console.log(e);
		});
		
		// Build up the "absurd" select element
		for (var i = 1; i < 1000; i++) {
			$('#absurd_select').append('<option value="'+i+'+">Item '+i+'</select>');
		}

		// Focus detection
		$('body').addClass('windowFocused');
		$(window).focus(function() {
			console.log("Window got focus");
			$('body').addClass('windowFocused');			
		});

		$(window).blur(function(){
			console.log("Window lost focus");
			$('body').removeClass('windowFocused');
		});
	

	};

	var _onCloseRequested = function(closeContext) {
		console.log("Close requested. Context:");
		console.log(closeContext);

		/*
		// Return of an async promise is allowed
		return new Promise(function(resolve, reject) {
			var canClose = !$('#prevent_close').is(':checked');
			resolve(canClose);
		});
		*/

		// So is just returning a boolean
		var canClose = !$('#prevent_close').is(':checked');
		return canClose;
	};
	
}

var TestPageApp = new ControlsTestFunc();
$(document).ready(function() {   
	TestPageApp.init();
}); 