function ApiTestFunc() {
	
	var _self = this;
	
	this.init = function() {
		
		if (typeof nx_api !== "undefined") {
			nx_api.init();
		}
		else {
			_showContent("nx_api not found");
		}
		
		$('#query_button').click(_doQuery);
		$('#clear_button').click(_doClear);
		$('#dev_button').click(_devTools);
	};
	
	var _doClear = function() {
		$('#history_content').empty();
	};
	
	var _devTools = function() {
		nx_api.devTools.show();
	};
	
	var _doQuery = function() {
		
		var params = {
			method:$('#mode_select').val(),
			path: $('#api_path').val()
		};
		
		try {
			
			if (params.method !== "GET") {
				var payload = $('#req_body').val();
				if (payload) {
					params.data = JSON.parse(payload);
				}
			}
		}
		catch(err) {
			_onFailure(params, "bad params json");
			return;
		}

		
		params.success = function(d) {
			_onSuccess(params, d);
		};
		
		params.failure = function(err) {
			_onFailure(params, err);
		};
		
		_makeRequest(params);
	};
	
	// requestParams: {method:"GET", path:"/nx_api/nova/project", data:{}, success:function, failure:function }
	var _makeRequest = function(requestParams) {
		if (!requestParams.path) {
			if (requestParams.failure) {
				requestParams.failure("no path set");
			}
		}
		else if (typeof nx_api === "undefined") { 
			if (requestParams.failure) {
				requestParams.failure("nx_api not available");
			}
		}
		else {
			nx_api.router.makeRequest(requestParams);
		}
	};
	
	var _onSuccess = function(params, response) {
		var entry = $('<div class="history_entry"</div>');
		entry.append(_makeRequestSummary(params));
		entry.append(_makeResponseSummary(response));
		_logRequest(params, response);
		_showContent(entry);
	};
	
	var _onFailure = function(params, err) {
		var entry = $('<div class="history_entry"</div>');
		entry.append(_makeRequestSummary(params));
		entry.append(_makeResponseSummary(err, true));
		_logRequest(params, err);
		_showContent(entry);
	};
	
	var _makeRequestSummary = function(params) {
		
		var mtd = params.method.toLowerCase();
		var div = $('<div class="req_summary"><span class="req_type '+mtd+'">'+params.method + ":</span> <span>" + params.path + '</span></div>');
		
		var loadButton = $('<div class="load_button"></div>');
		loadButton.click(_onLoadClicked);
		div.find('.req_type').prepend(loadButton);
		
		div.data('req_params', params);
		return div;
	};
	
	var _makeResponseSummary = function(response, isError) {
		
		var innerText = (typeof response === "string") ? response : JSON.stringify(response, null, 2);
		var content = $('<pre class="response_content">'+innerText+'</pre>');
		if (isError) {
			content.addClass('err_content');
		}
		return content;
	};
	
	var _showContent = function(content) {
		$('#history_content').prepend(content);
		$('#history_wrapper').stop().animate({ scrollTop: 0}, 500);
	};
	
	var _logRequest = function(params, response) {
		console.log("-------");
		console.log(params);
		console.log(response);
	};
	
	var _onLoadClicked = function(e) {
		var d = $(e.target).closest('.req_summary');
		var params = d.data('req_params');
		if (params) {
			$('#mode_select').val(params.method);
			$('#api_path').val(params.path);
			
			
			if (params.data) {
				$('#req_body').val(JSON.stringify(params.data, null, 2));
			}
			else {
				$('#req_body').val("");
			}
			
			
			// method:$('#mode_select').val(),
			// path: $('#api_path').val()
		
		}
	}
}

var TestPageApp = new ApiTestFunc();
$(document).ready(function() {   
	TestPageApp.init();
}); 