function AnimateTestFunc() {
	
	var _self = this;
	var _bc = null;
	
	this.bubbleCanvasController = (function(){
		
		var constructor = function(canvas) {
			this.canvas = canvas;
			this.chains = [];
			this.lastTime = 0;
			
			this.blockStyle = {
				width: 40,
				height: 10,
				vSpace: 4,
				hSpace: 4,
				minStepDelay:50,
				minNumBlocks: 10
			};
			
			this.blockStyle.maxX = Math.floor(this.canvas.width / (this.blockStyle.width + this.blockStyle.hSpace));
			this.blockStyle.maxNumBlocks = Math.floor(this.canvas.height / (this.blockStyle.height + this.blockStyle.hSpace));
			
			this.maxChains = this.blockStyle.maxX - 2;
		};
		
		var publicAPI = {
			
			start: function() {
				ctx = this.canvas.getContext('2d'); 
				ctx.fillStyle = "#555";
				ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
				
				var self = this;
				
				var useRAM = true;
				var doUpdateFunc;
				if (useRAM) {
				
					doUpdateFunc = function(t) {
						_doUpdate.call(self, t);
						window.requestAnimationFrame(doUpdateFunc);					
					};
					
					window.requestAnimationFrame(doUpdateFunc);
				}
				else {
					var interval = Math.floor(1000/60); // 60 fps
					var elapsedTime = 0;
					doUpdateFunc = function() {
						_doUpdate.call(self, elapsedTime);
						elapsedTime += interval;
					};
					
					window.setInterval(doUpdateFunc, interval);			
					console.log("setting interval");
				}
			}
		};
		
		var _doUpdate = function(timestamp) {
			if (this.lastTime === 0) {
				this.lastTime = timestamp;
				return;
			}
						
			var delta = timestamp - this.lastTime;
			this.lastTime = timestamp;
			
			ctx = this.canvas.getContext('2d'); 
			ctx.fillStyle = "#555";
			ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
			
			if (delta > 2000) {
				// high frame rate, bail out for safety
				return;
			}
			
			if (this.chains.length < this.maxChains) {
				this.chains.push(_createChain.call(this, timestamp));
			}
			
			var i = 0;
			while (i < this.chains.length) {
				_drawChain.call(this, ctx, this.chains[i], timestamp);
				
				if (_chainComplete.call(this, this.chains[i], timestamp)) {
					this.chains.splice(i, 1);
				}
				else {
					i++;
				}
			}
		};
		
		var _createChain = function(timestamp) {
			
			var stepDelay = this.blockStyle.minStepDelay;
			var numBlocks = Math.floor(Math.random() * (this.blockStyle.maxNumBlocks - this.blockStyle.minNumBlocks)) + this.blockStyle.minNumBlocks;
			
			var x = -1;
			var i;
			while (x === -1 ) {
				x = Math.floor(Math.random() *this.blockStyle. maxX);
				for (i = 0; i < this.chains.length; i++) {
					if (this.chains[i].x === x) {
						x = -1;
						break;
					}
				}
			}
			
			return {
				x: x,
				numBlocks: numBlocks,
				color: [Math.floor(Math.random()*128)+127, Math.floor(Math.random()*128)+127, Math.floor(Math.random()*128)+127],
				startTime: timestamp,
				stepDelay: stepDelay,
				blockLife: stepDelay * numBlocks * 2
			}
		};
		
		var _drawChain = function(ctx, chain, timestamp) {
			var delta = timestamp - chain.startTime;
			
			var x = chain.x * (this.blockStyle.width + this.blockStyle.hSpace);
			var y = ctx.canvas.height - this.blockStyle.vSpace - this.blockStyle.height;
			var w = this.blockStyle.width;
			var h = this.blockStyle.height;
			var opacity = 1.0;
			var lifePoint = 0;
			var fadeUpTime = 0;
			
			for (var i = 0; i < chain.numBlocks && delta > 0; i++) {
				
				if (delta <= chain.blockLife) {
					
					lifePoint = (delta / chain.blockLife);
					if (lifePoint < fadeUpTime) {
						opacity = lifePoint / fadeUpTime;
					}
					else {
						lifePoint = lifePoint / (1 - fadeUpTime);
						opacity = 1 - lifePoint;
					}
					
					ctx.fillStyle = 'rgba('+chain.color[0]+','+chain.color[1]+','+chain.color[2]+', '+opacity+')';
					ctx.fillRect(x, y, w, h);
				}
				
				y -= (this.blockStyle.height + this.blockStyle.vSpace);
				
				delta = delta - chain.stepDelay;
			}
			
		};
		
		var _chainComplete = function(chain, timestamp) {
			var delta = timestamp - chain.startTime;
			return (delta > (chain.stepDelay * chain.numBlocks) + chain.blockLife);			
		};
		
		
		constructor.prototype = publicAPI;
		constructor.prototype.constructor = _self.bubbleCanvasController;
		return constructor;		
	})();
	
	this.init = function() {
		if (typeof nx_bridge !== "undefined") {
			nx_api.init();
		}

		_bc = new _self.bubbleCanvasController($('#demo_canvas')[0]);
		_bc.start();
	};
}

var TestPageApp = new AnimateTestFunc();

$(document).ready(function() {   

	TestPageApp.init();
}); 