function AnimateTestFunc() {
	
	var _self = this;
	var _playing = false;
	var _countDiv;
	var _canvas;
	
	this.init = function() {
		
		if (typeof nx_bridge !== "undefined") {
			nx_api.init();
			_notifier = nx_api.notifier;
		}
		else {
			_notifier = new RG.utils.Notifier();
		}
		
		_notifier.registerForNotifications("an.start", _startPlayback);
		_notifier.registerForNotifications("an.stop", _stopPlayback);
		_notifier.registerForNotifications("an.update", _update);
		
		_countDiv = $('#time_count');
		_canvas = $('#demo_canvas')[0];
		
		var urlParams = RG.utils.getUrlParams();
		if (urlParams.start === "true") {
			_notifier.postNotification("an.start");
		}
		else if (typeof nx_bridge === "undefined") {
			// debugging			
			// _notifier.postNotification("an.update", {offset:3200});
			// _notifier.postNotification("an.start");
		}
	};
	
	
	var _startPlayback = function(n) {
		
		if (!_playing) {
			_playing = true;
			doUpdateFunc = function(t) {
				if (_playing) {
					_notifier.postNotification("an.update", {offset:t});
					window.requestAnimationFrame(doUpdateFunc);					
				}
			};
			
			window.requestAnimationFrame(doUpdateFunc);			
		}		
	};
	
	var _stopPlayback = function(n) {
		_playing = false;
	};
	
	var _update = function(n) {
		
		// console.log("Update: "+n.data.offset);
		
		var offset = n.data.offset % _getMaxTime();
		_countDiv.empty().append(Math.floor(offset));
		
		ctx = _canvas.getContext('2d'); 
		// ctx.fillStyle = "#444";
		// ctx.fillRect(0, 0, _canvas.width, _canvas.height);
		ctx.clearRect(0, 0, _canvas.width, _canvas.height);

		
		// _drawLine(ctx, offset);
		_drawCircle(ctx, offset);
	};
	
	///////////////////////////
	// Animation properties
	
	var _colors = ["#54d9fd", "#f17f35", "#f4d9fd", "#62b97f", "#e83736"];
	var _circleTime = 1000;
	var _clearCircles = true;
	
	
	var _getMaxTime = function() {
		return _colors.length * _circleTime * (_clearCircles ? 2 : 1);
	};
	
	var _drawLine = function(ctx, offset) {
		ctx.strokeStyle = "#999";
		ctx.lineWidth = 4;
		
		var x = _canvas.width * (offset / _getMaxTime());
		var y = _canvas.height/2; // - 100;
		
		ctx.beginPath();
		ctx.moveTo(0, y);
		ctx.lineTo(x, y);
		ctx.stroke();
	};
	
	var _drawCircle = function(ctx, offset) {
		
		var startAngle = 0;
		var endAngle = 2*Math.PI;
		
		var circleOffset = offset % (_circleTime * (_clearCircles ? 2 : 1));
		
		if (_clearCircles && circleOffset > _circleTime) {
			startAngle = 2*Math.PI * (circleOffset / _circleTime);
		}
		else {
			endAngle = endAngle * (circleOffset / _circleTime);
		}
		
		
		ctx.strokeStyle = _getColor(offset);
		ctx.lineWidth = 6;
		ctx.beginPath();
		ctx.arc(_canvas.width/2,_canvas.height/2,(_canvas.height-50)/2,startAngle,endAngle);
		ctx.stroke();

		ctx.beginPath();
		ctx.arc(_canvas.width/2,_canvas.height/2,(_canvas.height-100)/2,startAngle,endAngle);
		ctx.stroke();
		
		
	};
	
	var _getColor = function(offset) {
		var cTime = _circleTime * (_clearCircles ? 2 : 1);
		return _colors[Math.floor(offset/cTime)];
	};
}

var TestPageApp = new AnimateTestFunc();

$(document).ready(function() {   

	TestPageApp.init();
}); 