/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.area.Area;
import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.inline.BasicLinkArea;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnflattenProcessor {
    private List<InlineArea> il;
    private List<InlineArea> ilNew;
    private int iaLevelLast;
    private TextArea tcOrig;
    private TextArea tcNew;
    private Stack<InlineParent> icOrig;
    private Stack<InlineParent> icNew;

    UnflattenProcessor(List<InlineArea> inlines) {
        this.il = inlines;
        this.ilNew = new ArrayList<InlineArea>();
        this.iaLevelLast = -1;
        this.icOrig = new Stack();
        this.icNew = new Stack();
    }

    List unflatten() {
        if (this.il != null) {
            Iterator<InlineArea> it = this.il.iterator();
            while (it.hasNext()) {
                this.process(it.next());
            }
        }
        this.finishAll();
        return this.ilNew;
    }

    private void process(InlineArea ia) {
        this.process(this.findInlineContainers(ia), this.findTextContainer(ia), ia);
    }

    private void process(List<InlineParent> ich, TextArea tc, InlineArea ia) {
        if (this.tcNew == null || tc != this.tcNew) {
            this.maybeFinishTextContainer(tc, ia);
            this.maybeFinishInlineContainers(ich, tc, ia);
            this.update(ich, tc, ia);
        }
    }

    private boolean shouldFinishTextContainer(TextArea tc, InlineArea ia) {
        if (this.tcOrig != null && tc != this.tcOrig) {
            return true;
        }
        return this.iaLevelLast != -1 && ia.getBidiLevel() != this.iaLevelLast;
    }

    private void finishTextContainer() {
        this.finishTextContainer(null, null);
    }

    private void finishTextContainer(TextArea tc, InlineArea ia) {
        if (this.tcNew != null) {
            this.updateIPD(this.tcNew);
            if (!this.icNew.empty()) {
                this.icNew.peek().addChildArea(this.tcNew);
            } else {
                this.ilNew.add(this.tcNew);
            }
        }
        this.tcNew = null;
    }

    private void maybeFinishTextContainer(TextArea tc, InlineArea ia) {
        if (this.shouldFinishTextContainer(tc, ia)) {
            this.finishTextContainer(tc, ia);
        }
    }

    private boolean shouldFinishInlineContainer(List<InlineParent> ich, TextArea tc, InlineArea ia) {
        if (ich == null || ich.isEmpty()) {
            return !this.icOrig.empty();
        }
        if (!this.icOrig.empty()) {
            InlineParent ic0;
            InlineParent ic = ich.get(0);
            return ic != (ic0 = this.icOrig.peek()) && !this.isInlineParentOf(ic, ic0);
        }
        return false;
    }

    private void finishInlineContainer() {
        this.finishInlineContainer(null, null, null);
    }

    private void finishInlineContainer(List<InlineParent> ich, TextArea tc, InlineArea ia) {
        if (ich != null && !ich.isEmpty()) {
            for (InlineParent ic : ich) {
                InlineParent ic0;
                InlineParent inlineParent = ic0 = this.icOrig.empty() ? null : this.icOrig.peek();
                if (ic0 == null) {
                    assert (this.icNew.empty());
                    continue;
                }
                if (ic == ic0) break;
                assert (!this.icNew.empty());
                InlineParent icO0 = this.icOrig.pop();
                InlineParent icN0 = this.icNew.pop();
                assert (icO0 != null);
                assert (icN0 != null);
                if (this.icNew.empty()) {
                    this.ilNew.add(icN0);
                } else {
                    this.icNew.peek().addChildArea(icN0);
                }
                if (this.icOrig.empty() || this.icOrig.peek() != ic) continue;
                break;
            }
        } else {
            while (!this.icNew.empty()) {
                InlineParent icO0 = this.icOrig.pop();
                InlineParent icN0 = this.icNew.pop();
                assert (icO0 != null);
                assert (icN0 != null);
                if (this.icNew.empty()) {
                    this.ilNew.add(icN0);
                    continue;
                }
                this.icNew.peek().addChildArea(icN0);
            }
        }
    }

    private void maybeFinishInlineContainers(List<InlineParent> ich, TextArea tc, InlineArea ia) {
        if (this.shouldFinishInlineContainer(ich, tc, ia)) {
            this.finishInlineContainer(ich, tc, ia);
        }
    }

    private void finishAll() {
        this.finishTextContainer();
        this.finishInlineContainer();
    }

    private void update(List<InlineParent> ich, TextArea tc, InlineArea ia) {
        if (!this.alreadyUnflattened(ia)) {
            if (ich != null && !ich.isEmpty()) {
                this.pushInlineContainers(ich);
            }
            if (tc != null) {
                this.pushTextContainer(tc, ia);
            } else {
                this.pushNonTextInline(ia);
            }
            this.iaLevelLast = ia.getBidiLevel();
            this.tcOrig = tc;
        } else if (this.tcNew != null) {
            this.finishTextContainer();
            this.tcOrig = null;
        } else {
            this.tcOrig = null;
        }
    }

    private boolean alreadyUnflattened(InlineArea ia) {
        Iterator<InlineArea> it = this.ilNew.iterator();
        while (it.hasNext()) {
            if (!ia.isAncestorOrSelf(it.next())) continue;
            return true;
        }
        return false;
    }

    private void pushInlineContainers(List<InlineParent> ich) {
        LinkedList<InlineParent> icl = new LinkedList<InlineParent>();
        for (InlineParent ic : ich) {
            if (this.icOrig.search(ic) >= 0) break;
            icl.addFirst(ic);
        }
        for (InlineParent ic : icl) {
            this.icOrig.push(ic);
            this.icNew.push(this.generateInlineContainer(ic));
        }
    }

    private void pushTextContainer(TextArea tc, InlineArea ia) {
        if (tc instanceof UnresolvedPageNumber) {
            this.tcNew = tc;
        } else {
            if (this.tcNew == null) {
                this.tcNew = this.generateTextContainer(tc);
            }
            this.tcNew.addChildArea(ia);
        }
    }

    private void pushNonTextInline(InlineArea ia) {
        if (this.icNew.empty()) {
            this.ilNew.add(ia);
        } else {
            this.icNew.peek().addChildArea(ia);
        }
    }

    private InlineParent generateInlineContainer(InlineParent i) {
        if (i instanceof BasicLinkArea) {
            return this.generateBasicLinkArea((BasicLinkArea)i);
        }
        if (i instanceof FilledArea) {
            return this.generateFilledArea((FilledArea)i);
        }
        return this.generateInlineContainer0(i);
    }

    private InlineParent generateBasicLinkArea(BasicLinkArea l) {
        BasicLinkArea lc = new BasicLinkArea();
        if (l != null) {
            this.initializeInlineContainer(lc, l);
            this.initializeLinkArea(lc, l);
        }
        return lc;
    }

    private void initializeLinkArea(BasicLinkArea lc, BasicLinkArea l) {
        String[] idrefs;
        assert (lc != null);
        assert (l != null);
        LinkResolver r = l.getResolver();
        if (r != null && (idrefs = r.getIDRefs()).length > 0) {
            String idref = idrefs[0];
            LinkResolver lr = new LinkResolver(idref, lc);
            lc.setResolver(lr);
            r.addDependent(lr);
        }
    }

    private InlineParent generateFilledArea(FilledArea f) {
        FilledArea fc = new FilledArea();
        if (f != null) {
            this.initializeInlineContainer(fc, f);
            this.initializeFilledArea(fc, f);
        }
        return fc;
    }

    private void initializeFilledArea(FilledArea fc, FilledArea f) {
        assert (fc != null);
        assert (f != null);
        fc.setIPD(f.getIPD());
        fc.setUnitWidth(f.getUnitWidth());
    }

    private InlineParent generateInlineContainer0(InlineParent i) {
        InlineParent ic = new InlineParent();
        if (i != null) {
            this.initializeInlineContainer(ic, i);
        }
        return ic;
    }

    private void initializeInlineContainer(InlineParent ic, InlineParent i) {
        assert (ic != null);
        assert (i != null);
        ic.setTraits(i.getTraits());
        ic.setBPD(i.getBPD());
        ic.setBlockProgressionOffset(i.getBlockProgressionOffset());
    }

    private TextArea generateTextContainer(TextArea t) {
        TextArea tc = new TextArea();
        if (t != null) {
            tc.setTraits(t.getTraits());
            tc.setBPD(t.getBPD());
            tc.setBlockProgressionOffset(t.getBlockProgressionOffset());
            tc.setBaselineOffset(t.getBaselineOffset());
            tc.setTextWordSpaceAdjust(t.getTextWordSpaceAdjust());
            tc.setTextLetterSpaceAdjust(t.getTextLetterSpaceAdjust());
        }
        return tc;
    }

    private void updateIPD(TextArea tc) {
        int numAdjustable = 0;
        for (InlineArea ia : tc.getChildAreas()) {
            SpaceArea sa;
            if (!(ia instanceof SpaceArea) || !(sa = (SpaceArea)ia).isAdjustable()) continue;
            ++numAdjustable;
        }
        if (numAdjustable > 0) {
            tc.setIPD(tc.getIPD() + numAdjustable * tc.getTextWordSpaceAdjust());
        }
    }

    private TextArea findTextContainer(InlineArea ia) {
        assert (ia != null);
        TextArea t = null;
        while (t == null) {
            if (ia instanceof TextArea) {
                t = (TextArea)ia;
                continue;
            }
            Area p = ia.getParentArea();
            if (!(p instanceof InlineArea)) break;
            ia = (InlineArea)p;
        }
        return t;
    }

    private List<InlineParent> findInlineContainers(InlineArea ia) {
        assert (ia != null);
        ArrayList<InlineParent> ich = new ArrayList<InlineParent>();
        Area a = ia.getParentArea();
        while (a != null) {
            if (a instanceof InlineArea) {
                if (a instanceof InlineParent && !(a instanceof TextArea)) {
                    ich.add((InlineParent)a);
                }
                a = ((InlineArea)a).getParentArea();
                continue;
            }
            a = null;
        }
        return ich;
    }

    private boolean isInlineParentOf(InlineParent ic0, InlineParent ic1) {
        assert (ic0 != null);
        return ic0.getParentArea() == ic1;
    }
}

