/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.photoshop.PsdHeaderDirectory;
import java.io.IOException;

public class PsdReader
implements MetadataReader {
    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        PsdHeaderDirectory psdHeaderDirectory = metadata.getOrCreateDirectory(PsdHeaderDirectory.class);
        try {
            int n = randomAccessReader.getInt32(0);
            if (n != 943870035) {
                psdHeaderDirectory.addError("Invalid PSD file signature");
                return;
            }
            int n2 = randomAccessReader.getUInt16(4);
            if (n2 != 1 && n2 != 2) {
                psdHeaderDirectory.addError("Invalid PSD file version (must be 1 or 2)");
                return;
            }
            int n3 = randomAccessReader.getUInt16(12);
            psdHeaderDirectory.setInt(1, n3);
            int n4 = randomAccessReader.getInt32(14);
            psdHeaderDirectory.setInt(2, n4);
            int n5 = randomAccessReader.getInt32(18);
            psdHeaderDirectory.setInt(3, n5);
            int n6 = randomAccessReader.getUInt16(22);
            psdHeaderDirectory.setInt(4, n6);
            int n7 = randomAccessReader.getUInt16(24);
            psdHeaderDirectory.setInt(5, n7);
        }
        catch (IOException iOException) {
            psdHeaderDirectory.addError("Unable to read PSD header");
        }
    }
}

