/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopReader
implements JpegSegmentMetadataReader,
MetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPD);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length > 12 && "Photoshop 3.0".equals(new String(byArray, 0, 13));
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        this.extract(new ByteArrayReader(byArray), metadata);
    }

    @Override
    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        long l;
        int n;
        PhotoshopDirectory photoshopDirectory = metadata.getOrCreateDirectory(PhotoshopDirectory.class);
        try {
            n = randomAccessReader.getString(0, 13).equals("Photoshop 3.0") ? 14 : 0;
        }
        catch (IOException iOException) {
            photoshopDirectory.addError("Unable to read header");
            return;
        }
        try {
            l = randomAccessReader.getLength();
        }
        catch (IOException iOException) {
            photoshopDirectory.addError("Unable to read Photoshop data: " + iOException.getMessage());
            return;
        }
        while ((long)n < l) {
            try {
                int n2 = randomAccessReader.getUInt16(n += 4);
                int n3 = randomAccessReader.getUInt16(n += 2);
                if (n3 < 0 || (long)(n3 + (n += 2)) > l) {
                    return;
                }
                if ((n += n3) % 2 != 0) {
                    ++n;
                }
                int n4 = randomAccessReader.getInt32(n);
                byte[] byArray = randomAccessReader.getBytes(n += 4, n4);
                if ((n += n4) % 2 != 0) {
                    ++n;
                }
                photoshopDirectory.setByteArray(n2, byArray);
                if (n2 == 1028) {
                    new IptcReader().extract(new SequentialByteArrayReader(byArray), metadata, byArray.length);
                }
                if (n2 < 4000 || n2 > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(n2, String.format("Plug-in %d Data", n2 - 4000 + 1));
            }
            catch (IOException iOException) {
                photoshopDirectory.addError(iOException.getMessage());
                return;
            }
        }
    }
}

