/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.photoshop.PhotoshopDescriptor;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopDirectory
extends Directory {
    public static final int TAG_CHANNELS_ROWS_COLUMNS_DEPTH_MODE = 1000;
    public static final int TAG_MAC_PRINT_INFO = 1001;
    public static final int TAG_XML = 1002;
    public static final int TAG_INDEXED_COLOR_TABLE = 1003;
    public static final int TAG_RESOLUTION_INFO = 1005;
    public static final int TAG_ALPHA_CHANNELS = 1006;
    public static final int TAG_DISPLAY_INFO = 1007;
    public static final int TAG_CAPTION = 1008;
    public static final int TAG_BORDER_INFORMATION = 1009;
    public static final int TAG_BACKGROUND_COLOR = 1010;
    public static final int TAG_PRINT_FLAGS = 1011;
    public static final int TAG_GRAYSCALE_AND_MULTICHANNEL_HALFTONING_INFORMATION = 1012;
    public static final int TAG_COLOR_HALFTONING_INFORMATION = 1013;
    public static final int TAG_DUOTONE_HALFTONING_INFORMATION = 1014;
    public static final int TAG_GRAYSCALE_AND_MULTICHANNEL_TRANSFER_FUNCTION = 1015;
    public static final int TAG_COLOR_TRANSFER_FUNCTIONS = 1016;
    public static final int TAG_DUOTONE_TRANSFER_FUNCTIONS = 1017;
    public static final int TAG_DUOTONE_IMAGE_INFORMATION = 1018;
    public static final int TAG_EFFECTIVE_BLACK_AND_WHITE_VALUES = 1019;
    public static final int TAG_EPS_OPTIONS = 1021;
    public static final int TAG_QUICK_MASK_INFORMATION = 1022;
    public static final int TAG_LAYER_STATE_INFORMATION = 1024;
    public static final int TAG_LAYERS_GROUP_INFORMATION = 1026;
    public static final int TAG_IPTC = 1028;
    public static final int TAG_IMAGE_MODE_FOR_RAW_FORMAT_FILES = 1029;
    public static final int TAG_JPEG_QUALITY = 1030;
    public static final int TAG_GRID_AND_GUIDES_INFORMATION = 1032;
    public static final int TAG_THUMBNAIL_OLD = 1033;
    public static final int TAG_COPYRIGHT = 1034;
    public static final int TAG_URL = 1035;
    public static final int TAG_THUMBNAIL = 1036;
    public static final int TAG_GLOBAL_ANGLE = 1037;
    public static final int TAG_ICC_UNTAGGED_PROFILE = 1041;
    public static final int TAG_SEED_NUMBER = 1044;
    public static final int TAG_GLOBAL_ALTITUDE = 1049;
    public static final int TAG_SLICES = 1050;
    public static final int TAG_URL_LIST = 1054;
    public static final int TAG_VERSION = 1057;
    public static final int TAG_CAPTION_DIGEST = 1061;
    public static final int TAG_PRINT_SCALE = 1062;
    public static final int TAG_PIXEL_ASPECT_RATIO = 1064;
    public static final int TAG_PRINT_INFO = 1071;
    public static final int TAG_PRINT_FLAGS_INFO = 10000;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public PhotoshopDirectory() {
        this.setDescriptor(new PhotoshopDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Photoshop";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @Nullable
    public byte[] getThumbnailBytes() {
        byte[] byArray = this.getByteArray(1036);
        if (byArray == null) {
            byArray = this.getByteArray(1033);
        }
        if (byArray == null) {
            return null;
        }
        int n = byArray.length - 28;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 28, byArray2, 0, n);
        return byArray2;
    }

    static {
        _tagNameMap.put(1000, "Channels, Rows, Columns, Depth, Mode");
        _tagNameMap.put(1001, "Mac Print Info");
        _tagNameMap.put(1002, "XML Data");
        _tagNameMap.put(1003, "Indexed Color Table");
        _tagNameMap.put(1005, "Resolution Info");
        _tagNameMap.put(1006, "Alpha Channels");
        _tagNameMap.put(1007, "Display Info");
        _tagNameMap.put(1008, "Caption");
        _tagNameMap.put(1009, "Border Information");
        _tagNameMap.put(1010, "Background Color");
        _tagNameMap.put(1011, "Print Flags");
        _tagNameMap.put(1012, "Grayscale and Multichannel Halftoning Information");
        _tagNameMap.put(1013, "Color Halftoning Information");
        _tagNameMap.put(1014, "Duotone Halftoning Information");
        _tagNameMap.put(1015, "Grayscale and Multichannel Transfer Function");
        _tagNameMap.put(1016, "Color Transfer Functions");
        _tagNameMap.put(1017, "Duotone Transfer Functions");
        _tagNameMap.put(1018, "Duotone Image Information");
        _tagNameMap.put(1019, "Effective Black and White Values");
        _tagNameMap.put(1021, "EPS Options");
        _tagNameMap.put(1022, "Quick Mask Information");
        _tagNameMap.put(1024, "Layer State Information");
        _tagNameMap.put(1026, "Layers Group Information");
        _tagNameMap.put(1028, "IPTC-NAA Record");
        _tagNameMap.put(1029, "Image Mode for Raw Format Files");
        _tagNameMap.put(1030, "JPEG Quality");
        _tagNameMap.put(1032, "Grid and Guides Information");
        _tagNameMap.put(1033, "Photoshop 4.0 Thumbnail");
        _tagNameMap.put(1034, "Copyright Flag");
        _tagNameMap.put(1035, "URL");
        _tagNameMap.put(1036, "Thumbnail Data");
        _tagNameMap.put(1037, "Global Angle");
        _tagNameMap.put(1041, "ICC Untagged Profile");
        _tagNameMap.put(1044, "Seed Number");
        _tagNameMap.put(1049, "Global Altitude");
        _tagNameMap.put(1050, "Slices");
        _tagNameMap.put(1054, "URL List");
        _tagNameMap.put(1057, "Version Info");
        _tagNameMap.put(1061, "Caption Digest");
        _tagNameMap.put(1062, "Print Scale");
        _tagNameMap.put(1064, "Pixel Aspect Ratio");
        _tagNameMap.put(1071, "Print Info");
        _tagNameMap.put(10000, "Print Flags Information");
    }
}

