/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifTiffHandler;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader
implements JpegSegmentMetadataReader {
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private boolean _storeThumbnailBytes = true;

    public boolean isStoreThumbnailBytes() {
        return this._storeThumbnailBytes;
    }

    public void setStoreThumbnailBytes(boolean bl) {
        this._storeThumbnailBytes = bl;
    }

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length >= JPEG_EXIF_SEGMENT_PREAMBLE.length() && new String(byArray, 0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equalsIgnoreCase(JPEG_EXIF_SEGMENT_PREAMBLE);
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        if (byArray == null) {
            throw new NullPointerException("segmentBytes cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        if (jpegSegmentType == null) {
            throw new NullPointerException("segmentType cannot be null");
        }
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            try {
                if (!byteArrayReader.getString(0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equals(JPEG_EXIF_SEGMENT_PREAMBLE)) {
                    System.err.println("Invalid JPEG Exif segment preamble");
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return;
            }
            new TiffReader().processTiff(byteArrayReader, new ExifTiffHandler(metadata, this._storeThumbnailBytes), JPEG_EXIF_SEGMENT_PREAMBLE.length());
        }
        catch (TiffProcessingException tiffProcessingException) {
            tiffProcessingException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }
}

