/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.adobe;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.adobe.AdobeJpegDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeJpegReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPE);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length == 12 && "Adobe".equalsIgnoreCase(new String(byArray, 0, 5));
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        this.extract(new SequentialByteArrayReader(byArray), metadata);
    }

    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        AdobeJpegDirectory adobeJpegDirectory = metadata.getOrCreateDirectory(AdobeJpegDirectory.class);
        try {
            sequentialReader.setMotorolaByteOrder(false);
            if (!sequentialReader.getString(5).equals("Adobe")) {
                adobeJpegDirectory.addError("Invalid Adobe JPEG data header.");
                return;
            }
            adobeJpegDirectory.setInt(0, sequentialReader.getUInt16());
            adobeJpegDirectory.setInt(1, sequentialReader.getUInt16());
            adobeJpegDirectory.setInt(2, sequentialReader.getUInt16());
            adobeJpegDirectory.setInt(3, sequentialReader.getInt8());
        }
        catch (IOException iOException) {
            adobeJpegDirectory.addError("IO exception processing data: " + iOException.getMessage());
        }
    }
}

