/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class RandomAccessReader {
    private boolean _isMotorolaByteOrder = true;

    protected abstract byte getByte(int var1) throws IOException;

    @NotNull
    public abstract byte[] getBytes(int var1, int var2) throws IOException;

    protected abstract void validateIndex(int var1, int var2) throws IOException;

    protected abstract boolean isValidIndex(int var1, int var2) throws IOException;

    public abstract long getLength() throws IOException;

    public void setMotorolaByteOrder(boolean bl) {
        this._isMotorolaByteOrder = bl;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public short getUInt8(int n) throws IOException {
        this.validateIndex(n, 1);
        return (short)(this.getByte(n) & 0xFF);
    }

    public byte getInt8(int n) throws IOException {
        this.validateIndex(n, 1);
        return this.getByte(n);
    }

    public int getUInt16(int n) throws IOException {
        this.validateIndex(n, 2);
        if (this._isMotorolaByteOrder) {
            return this.getByte(n) << 8 & 0xFF00 | this.getByte(n + 1) & 0xFF;
        }
        return this.getByte(n + 1) << 8 & 0xFF00 | this.getByte(n) & 0xFF;
    }

    public short getInt16(int n) throws IOException {
        this.validateIndex(n, 2);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.getByte(n) << 8 & 0xFFFFFF00 | (short)this.getByte(n + 1) & 0xFF);
        }
        return (short)((short)this.getByte(n + 1) << 8 & 0xFFFFFF00 | (short)this.getByte(n) & 0xFF);
    }

    public long getUInt32(int n) throws IOException {
        this.validateIndex(n, 4);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(n) << 24 & 0xFF000000L | (long)this.getByte(n + 1) << 16 & 0xFF0000L | (long)this.getByte(n + 2) << 8 & 0xFF00L | (long)this.getByte(n + 3) & 0xFFL;
        }
        return (long)this.getByte(n + 3) << 24 & 0xFF000000L | (long)this.getByte(n + 2) << 16 & 0xFF0000L | (long)this.getByte(n + 1) << 8 & 0xFF00L | (long)this.getByte(n) & 0xFFL;
    }

    public int getInt32(int n) throws IOException {
        this.validateIndex(n, 4);
        if (this._isMotorolaByteOrder) {
            return this.getByte(n) << 24 & 0xFF000000 | this.getByte(n + 1) << 16 & 0xFF0000 | this.getByte(n + 2) << 8 & 0xFF00 | this.getByte(n + 3) & 0xFF;
        }
        return this.getByte(n + 3) << 24 & 0xFF000000 | this.getByte(n + 2) << 16 & 0xFF0000 | this.getByte(n + 1) << 8 & 0xFF00 | this.getByte(n) & 0xFF;
    }

    public long getInt64(int n) throws IOException {
        this.validateIndex(n, 8);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(n) << 56 & 0xFF00000000000000L | (long)this.getByte(n + 1) << 48 & 0xFF000000000000L | (long)this.getByte(n + 2) << 40 & 0xFF0000000000L | (long)this.getByte(n + 3) << 32 & 0xFF00000000L | (long)this.getByte(n + 4) << 24 & 0xFF000000L | (long)this.getByte(n + 5) << 16 & 0xFF0000L | (long)this.getByte(n + 6) << 8 & 0xFF00L | (long)this.getByte(n + 7) & 0xFFL;
        }
        return (long)this.getByte(n + 7) << 56 & 0xFF00000000000000L | (long)this.getByte(n + 6) << 48 & 0xFF000000000000L | (long)this.getByte(n + 5) << 40 & 0xFF0000000000L | (long)this.getByte(n + 4) << 32 & 0xFF00000000L | (long)this.getByte(n + 3) << 24 & 0xFF000000L | (long)this.getByte(n + 2) << 16 & 0xFF0000L | (long)this.getByte(n + 1) << 8 & 0xFF00L | (long)this.getByte(n) & 0xFFL;
    }

    public float getS15Fixed16(int n) throws IOException {
        this.validateIndex(n, 4);
        if (this._isMotorolaByteOrder) {
            float f = (this.getByte(n) & 0xFF) << 8 | this.getByte(n + 1) & 0xFF;
            int n2 = (this.getByte(n + 2) & 0xFF) << 8 | this.getByte(n + 3) & 0xFF;
            return (float)((double)f + (double)n2 / 65536.0);
        }
        float f = (this.getByte(n + 3) & 0xFF) << 8 | this.getByte(n + 2) & 0xFF;
        int n3 = (this.getByte(n + 1) & 0xFF) << 8 | this.getByte(n) & 0xFF;
        return (float)((double)f + (double)n3 / 65536.0);
    }

    public float getFloat32(int n) throws IOException {
        return Float.intBitsToFloat(this.getInt32(n));
    }

    public double getDouble64(int n) throws IOException {
        return Double.longBitsToDouble(this.getInt64(n));
    }

    @NotNull
    public String getString(int n, int n2) throws IOException {
        return new String(this.getBytes(n, n2));
    }

    @NotNull
    public String getString(int n, int n2, String string) throws IOException {
        byte[] byArray = this.getBytes(n, n2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    @NotNull
    public String getNullTerminatedString(int n, int n2) throws IOException {
        int n3;
        byte[] byArray = this.getBytes(n, n2);
        for (n3 = 0; n3 < byArray.length && byArray[n3] != 0; ++n3) {
        }
        return new String(byArray, 0, n3);
    }
}

