/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegSegmentReader {
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData readSegments(@NotNull File file, @Nullable Iterable<JpegSegmentType> iterable) throws JpegProcessingException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(new StreamReader(fileInputStream), iterable);
            return jpegSegmentData;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    @NotNull
    public static JpegSegmentData readSegments(@NotNull SequentialReader sequentialReader, @Nullable Iterable<JpegSegmentType> iterable) throws JpegProcessingException, IOException {
        assert (sequentialReader.isMotorolaByteOrder());
        int n = sequentialReader.getUInt16();
        if (n != 65496) {
            throw new JpegProcessingException("JPEG data is expected to begin with 0xFFD8 (\u00ff\u00d8) not 0x" + Integer.toHexString(n));
        }
        HashSet<Byte> hashSet = null;
        if (iterable != null) {
            hashSet = new HashSet<Byte>();
            for (JpegSegmentType jpegSegmentType : iterable) {
                hashSet.add(jpegSegmentType.byteValue);
            }
        }
        JpegSegmentData jpegSegmentData = new JpegSegmentData();
        while (true) {
            short s;
            if ((s = sequentialReader.getUInt8()) != 255) {
                throw new JpegProcessingException("Expected JPEG segment start identifier 0xFF, not 0x" + Integer.toHexString(s).toUpperCase());
            }
            byte by = sequentialReader.getInt8();
            while (by == -1) {
                by = sequentialReader.getInt8();
            }
            if (by == 0) {
                throw new JpegProcessingException("Expected non-zero byte as part of JPEG marker identifier");
            }
            if (by == -38) {
                return jpegSegmentData;
            }
            if (by == -39) {
                return jpegSegmentData;
            }
            int n2 = sequentialReader.getUInt16();
            if ((n2 -= 2) < 0) {
                throw new JpegProcessingException("JPEG segment size would be less than zero");
            }
            if (hashSet == null || hashSet.contains(by)) {
                byte[] byArray = sequentialReader.getBytes(n2);
                assert (n2 == byArray.length);
                jpegSegmentData.addSegment(by, byArray);
                continue;
            }
            if (!sequentialReader.trySkip(n2)) break;
        }
        return jpegSegmentData;
    }

    private JpegSegmentReader() throws Exception {
        throw new Exception("Not intended for instantiation.");
    }
}

