/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.dev.POIFSViewEngine;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OleObjectBinaryPart
extends BinaryPart {
    private static Logger log = LoggerFactory.getLogger(OleObjectBinaryPart.class);
    POIFSFileSystem fs;

    public OleObjectBinaryPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public OleObjectBinaryPart() throws InvalidFormatException {
        super(new PartName("/word/embeddings/oleObject1.bin"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.oleObject"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject");
    }

    public POIFSFileSystem getFs() throws IOException {
        if (this.fs == null) {
            this.initPOIFSFileSystem();
        }
        return this.fs;
    }

    public void initPOIFSFileSystem() throws IOException {
        if (this.getBuffer() != null) {
            log.info("initing POIFSFileSystem from existing data");
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getBytes());
            this.fs = new POIFSFileSystem((InputStream)bais);
        } else {
            log.info("creating new empty POIFSFileSystem");
            this.fs = new POIFSFileSystem();
            this.writePOIFSFileSystem();
        }
    }

    public void writePOIFSFileSystem() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getFs().writeFilesystem((OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        this.setBinaryData(ByteBuffer.wrap(bytes));
    }

    public void viewFile(boolean verbose) throws IOException {
        this.viewFile(System.out, verbose);
    }

    public void viewFile(OutputStream os, boolean verbose) throws IOException {
        String indent = "";
        boolean withSizes = true;
        this.displayDirectory(this.getFs().getRoot(), os, indent, withSizes);
        if (verbose) {
            List strings = POIFSViewEngine.inspectViewable((Object)this.fs, (boolean)true, (int)0, (String)"  ");
            Iterator iter = strings.iterator();
            while (iter.hasNext()) {
                os.write(((String)iter.next()).getBytes());
            }
        }
    }

    private void displayDirectory(DirectoryNode dir, OutputStream os, String indent, boolean withSizes) throws IOException {
        System.out.println(indent + dir.getName() + " -");
        String newIndent = indent + "  ";
        boolean hadChildren = false;
        Iterator it = dir.getEntries();
        while (it.hasNext()) {
            hadChildren = true;
            Entry entry = (Entry)it.next();
            if (entry instanceof DirectoryNode) {
                this.displayDirectory((DirectoryNode)entry, os, newIndent, withSizes);
                continue;
            }
            DocumentNode doc = (DocumentNode)entry;
            String name = doc.getName();
            String size = "";
            if (name.charAt(0) < '\n') {
                String altname = "(0x0" + name.charAt(0) + ")" + name.substring(1);
                name = name.substring(1) + " <" + altname + ">";
            }
            if (withSizes) {
                size = " [" + doc.getSize() + " / 0x" + Integer.toHexString(doc.getSize()) + "]";
            }
            os.write((newIndent + name + size + "\n").getBytes());
        }
        if (!hadChildren) {
            os.write((newIndent + "(no children)").getBytes());
        }
    }
}

