/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import org.docx4j.model.listnumbering.NumberFormat;

public abstract class NumberFormatRomanAbstract
extends NumberFormat {
    RomanValue[] ROMAN_VALUE_TABLE;

    public String format(int n) {
        if (n >= 4000 || n < 1) {
            throw new NumberFormatException("Numbers must be in range 1-3999");
        }
        StringBuffer result = new StringBuffer(10);
        for (RomanValue equiv : this.ROMAN_VALUE_TABLE) {
            while (n >= equiv.intVal) {
                n -= equiv.intVal;
                result.append(equiv.romVal);
            }
        }
        return result.toString();
    }

    protected static class RomanValue {
        int intVal;
        String romVal;

        RomanValue(int dec, String rom) {
            this.intVal = dec;
            this.romVal = rom;
        }
    }
}

