/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.writer.AbstractFldSimpleWriter;
import org.docx4j.convert.out.common.writer.AbstractPagerefHandler;
import org.docx4j.convert.out.common.writer.RefHandler;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.convert.out.fo.HyperlinkWriter;
import org.docx4j.convert.out.fo.XsltFOFunctions;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.properties.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FldSimpleWriter
extends AbstractFldSimpleWriter {
    protected static final String FO_NS = "http://www.w3.org/1999/XSL/Format";
    protected static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";

    protected FldSimpleWriter() {
        super(FO_NS, "fo:inline");
    }

    @Override
    protected void registerHandlers() {
        super.registerHandlers();
        this.registerHandler(new PageHandler());
        this.registerHandler(new HyperlinkWriter());
        this.registerHandler(new RefHandler(2));
        this.registerHandler(new PagerefHandler());
        this.registerHandler(new NumpagesHandler());
        this.registerHandler(new SectionpagesHandler());
    }

    @Override
    protected void applyProperties(List<Property> properties, Node node) {
        XsltFOFunctions.applyFoAttributes(properties, (Element)node);
    }

    protected static class PagerefHandler
    extends AbstractPagerefHandler {
        protected PagerefHandler() {
            super(2);
        }

        protected Node createPageref(AbstractWmlConversionContext context, Document doc, String bookmarkId) {
            Element ret = doc.createElementNS(FldSimpleWriter.FO_NS, "fo:page-number-citation");
            ret.setAttribute("ref-id", bookmarkId);
            return ret;
        }
    }

    protected static class SectionpagesHandler
    extends AbstractPagesHandler {
        protected SectionpagesHandler() {
            super("SECTIONPAGES");
        }

        protected String getParameterName(AbstractWmlConversionContext context) {
            return "field_sectionpages_" + context.getSections().getCurrentSection().getId() + "_value";
        }

        protected String getRefid(AbstractWmlConversionContext context) {
            return "section_" + context.getSections().getCurrentSection().getId();
        }
    }

    protected static class NumpagesHandler
    extends AbstractPagesHandler {
        protected NumpagesHandler() {
            super("NUMPAGES");
        }

        protected String getParameterName(AbstractWmlConversionContext context) {
            return "field_numpages_" + context.getSections().getCurrentSection().getId() + "_value";
        }

        protected String getRefid(AbstractWmlConversionContext context) {
            List<ConversionSectionWrapper> wrappers = context.getSections().getList();
            return "section_" + wrappers.get(wrappers.size() - 1).getId();
        }
    }

    protected static abstract class AbstractPagesHandler
    implements AbstractFldSimpleWriter.FldSimpleNodeWriterHandler {
        protected String fieldName = null;

        protected AbstractPagesHandler(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getName() {
            return this.fieldName;
        }

        public int getProcessType() {
            return 1;
        }

        public Node toNode(AbstractWmlConversionContext context, FldSimpleModel model, Document doc) throws TransformerException {
            Element ret = null;
            if (((FOConversionContext)context).isRequires2Pass()) {
                ret = doc.createElementNS(FldSimpleWriter.FO_NS, "fo:inline");
                ret.appendChild(doc.createTextNode("${" + this.getParameterName(context) + "}"));
            } else {
                ret = doc.createElementNS(FldSimpleWriter.FO_NS, "fo:wrapper");
                Element pncl = doc.createElementNS(FldSimpleWriter.FO_NS, "fo:page-number-citation-last");
                String refId = this.getRefid(context);
                pncl.setAttribute("ref-id", this.getRefid(context));
                ret.appendChild(pncl);
                ret.appendChild(doc.createTextNode("\u200b"));
            }
            return ret;
        }

        protected abstract String getRefid(AbstractWmlConversionContext var1);

        protected abstract String getParameterName(AbstractWmlConversionContext var1);
    }

    protected static class PageHandler
    implements AbstractFldSimpleWriter.FldSimpleNodeWriterHandler {
        protected PageHandler() {
        }

        public String getName() {
            return "PAGE";
        }

        public int getProcessType() {
            return 1;
        }

        public Node toNode(AbstractWmlConversionContext context, FldSimpleModel model, Document doc) throws TransformerException {
            return doc.createElementNS(FldSimpleWriter.FO_NS, "fo:page-number");
        }
    }
}

