/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialDeepCopy {
    protected static Logger log = LoggerFactory.getLogger(PartialDeepCopy.class);

    public static OpcPackage process(OpcPackage opcPackage, Set<String> relationshipTypes) throws Docx4JException {
        OpcPackage ret = null;
        Object relPart = null;
        if (opcPackage != null) {
            if (relationshipTypes != null && relationshipTypes.isEmpty()) {
                ret = opcPackage;
            } else {
                ret = PartialDeepCopy.createPackage(opcPackage);
                if (ret == null) {
                    log.error("createPackage returned null!");
                }
                PartialDeepCopy.deepCopyRelationships(ret, opcPackage, ret, relationshipTypes);
                if (opcPackage instanceof WordprocessingMLPackage) {
                    try {
                        ((WordprocessingMLPackage)ret).setFontMapper(((WordprocessingMLPackage)opcPackage).getFontMapper(), false);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw new Docx4JException("Error setting font mapper on copy", e);
                    }
                }
            }
        }
        return ret;
    }

    protected static OpcPackage createPackage(OpcPackage opcPackage) throws Docx4JException {
        OpcPackage ret = null;
        try {
            ret = (OpcPackage)opcPackage.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new Docx4JException("InstantiationException duplicating package", e);
        }
        catch (IllegalAccessException e) {
            throw new Docx4JException("IllegalAccessException duplicating package", e);
        }
        ret.setContentType(new ContentType(opcPackage.getContentType()));
        ret.setPartName(opcPackage.getPartName());
        ret.setContentTypeManager(opcPackage.getContentTypeManager());
        ret.getCustomXmlDataStorageParts().putAll(opcPackage.getCustomXmlDataStorageParts());
        ret.setPartShortcut(opcPackage.getDocPropsCorePart(), "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        ret.setPartShortcut(opcPackage.getDocPropsCustomPart(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
        ret.setPartShortcut(opcPackage.getDocPropsExtendedPart(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        ret.getExternalResources().putAll(opcPackage.getExternalResources());
        ret.setSourcePartStore(opcPackage.getSourcePartStore());
        return ret;
    }

    protected static void deepCopyRelationships(OpcPackage opcPackage, Base sourcePart, Base targetPart, Set<String> relationshipTypes) throws Docx4JException {
        RelationshipsPart sourceRelationshipsPart = sourcePart.getRelationshipsPart(false);
        Relationships sourceRelationships = sourceRelationshipsPart != null ? sourceRelationshipsPart.getRelationships() : null;
        List<Relationship> sourceRelationshipList = sourceRelationships != null ? sourceRelationships.getRelationship() : null;
        RelationshipsPart targetRelationshipsPart = null;
        Relationships targetRelationships = null;
        Relationship sourceRelationship = null;
        Object targetRelationship = null;
        Part sourceChild = null;
        Part targetChild = null;
        if (sourceRelationshipList != null && !sourceRelationshipList.isEmpty()) {
            targetRelationshipsPart = targetPart.getRelationshipsPart();
            targetRelationships = targetRelationshipsPart.getRelationships();
            for (int i = 0; i < sourceRelationshipList.size(); ++i) {
                sourceRelationship = sourceRelationshipList.get(i);
                targetRelationships.getRelationship().add(sourceRelationship);
                if (sourceRelationship.getTargetMode() != null && "external".equals(sourceRelationship.getTargetMode().toLowerCase()) || (sourceChild = sourceRelationshipsPart.getPart(sourceRelationship)) == (targetChild = PartialDeepCopy.deepCopyPart(opcPackage, targetPart, sourceChild, relationshipTypes))) continue;
                PartialDeepCopy.deepCopyRelationships(opcPackage, sourceChild, targetChild, relationshipTypes);
            }
        }
    }

    protected static Part deepCopyPart(OpcPackage opcPackage, Base targetParent, Part sourcePart, Set<String> relationshipTypes) throws Docx4JException {
        Part ret = opcPackage.getParts().get(sourcePart.getPartName());
        if (ret == null) {
            ret = PartialDeepCopy.copyPart(sourcePart, opcPackage, relationshipTypes == null || relationshipTypes.contains(sourcePart.getRelationshipType()));
            opcPackage.getParts().put(ret);
            targetParent.setPartShortcut(ret, ret.getRelationshipType());
        }
        return ret;
    }

    protected static Part copyPart(Part part, OpcPackage targetPackage, boolean deepCopy) throws Docx4JException {
        Part ret = null;
        try {
            ret = (Part)part.getClass().getConstructor(PartName.class).newInstance(part.getPartName());
        }
        catch (Exception e) {
            throw new Docx4JException("Error cloning part of class " + part.getClass().getName(), e);
        }
        ret.setRelationshipType(part.getRelationshipType());
        ret.setContentType(new ContentType(part.getContentType()));
        if (targetPackage != null) {
            ret.setPackage(targetPackage);
        }
        if (deepCopy) {
            PartialDeepCopy.deepCopyContent(part, ret);
        } else {
            PartialDeepCopy.shallowCopyContent(part, ret);
        }
        return ret;
    }

    protected static void deepCopyContent(Part source, Part destination) throws Docx4JException {
        if (source instanceof BinaryPart) {
            byte[] byteData = new byte[((BinaryPart)source).getBuffer().limit()];
            ((BinaryPart)source).getBuffer().get(byteData);
            ((BinaryPart)destination).setBinaryData(ByteBuffer.wrap(byteData));
        } else if (source instanceof JaxbXmlPart) {
            ((JaxbXmlPart)destination).setJaxbElement(XmlUtils.deepCopy(((JaxbXmlPart)source).getJaxbElement(), ((JaxbXmlPart)source).getJAXBContext()));
            ((JaxbXmlPart)destination).setJAXBContext(((JaxbXmlPart)source).getJAXBContext());
            if (log.isDebugEnabled() && source instanceof MainDocumentPart) {
                log.debug("source: " + ((JaxbXmlPart)source).getXML());
                log.debug("destination: " + ((JaxbXmlPart)destination).getXML());
            }
        } else if (source instanceof CustomXmlDataStoragePart) {
            CustomXmlDataStorage dataStorage = ((CustomXmlDataStoragePart)source).getData().factory();
            dataStorage.setDocument((Document)((CustomXmlDataStoragePart)source).getData().getDocument().cloneNode(true));
            ((CustomXmlDataStoragePart)destination).setData(dataStorage);
        } else if (source instanceof XmlPart) {
            ((XmlPart)destination).setDocument((Document)((XmlPart)source).getDocument().cloneNode(true));
        } else {
            throw new IllegalArgumentException("Dont know how to handle a part of type " + source.getClass().getName());
        }
    }

    protected static void shallowCopyContent(Part source, Part destination) throws Docx4JException {
        if (source instanceof BinaryPart) {
            ((BinaryPart)destination).setBinaryData(((BinaryPart)source).getBuffer());
        } else if (source instanceof JaxbXmlPart) {
            ((JaxbXmlPart)destination).setJaxbElement(((JaxbXmlPart)source).getJaxbElement());
            ((JaxbXmlPart)destination).setJAXBContext(((JaxbXmlPart)source).getJAXBContext());
        } else if (source instanceof CustomXmlDataStoragePart) {
            ((CustomXmlDataStoragePart)destination).setData(((CustomXmlDataStoragePart)source).getData());
        } else if (source instanceof XmlPart) {
            ((XmlPart)destination).setDocument(((XmlPart)source).getDocument());
        } else {
            throw new IllegalArgumentException("Dont know how to handle a part of type " + source.getClass().getName());
        }
    }
}

