/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.wml.CTCompatSetting;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphStylesInTableFix {
    protected static Logger log = LoggerFactory.getLogger(ParagraphStylesInTableFix.class);
    private static final CTCompatSetting defaultSetting = Context.getWmlObjectFactory().createCTCompatSetting();

    public static void process(WordprocessingMLPackage wmlPackage) {
        Throwable t = new Throwable();
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            if (!trace[i].getClassName().contains("FOPAreaTreeHelper")) continue;
            return;
        }
        StyleRenamer styleRenamer = new StyleRenamer();
        try {
            DocumentSettingsPart dsp = wmlPackage.getMainDocumentPart().getDocumentSettingsPart();
            if (dsp == null) {
                dsp = new DocumentSettingsPart();
                wmlPackage.getMainDocumentPart().addTargetPart(dsp);
                dsp.setContents(Context.getWmlObjectFactory().createCTSettings());
            } else {
                styleRenamer.overrideTableStyleFontSizeAndJustification = dsp.getWordCompatSetting("overrideTableStyleFontSizeAndJustification");
                if (styleRenamer.overrideTableStyleFontSizeAndJustification == null) {
                    styleRenamer.overrideTableStyleFontSizeAndJustification = defaultSetting;
                }
            }
            dsp.setWordCompatSetting("overrideTableStyleFontSizeAndJustification", "1");
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            styleRenamer.setDefaultParagraphStyle(wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle().getStyleId());
        }
        catch (NullPointerException npe) {
            log.warn("No default paragraph style!!");
        }
        Style defaultTableStyle = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultTableStyle();
        if (defaultTableStyle != null) {
            styleRenamer.setDefaultTableStyle(defaultTableStyle);
        }
        Styles styles = (Styles)wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getJaxbElement();
        styleRenamer.propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        styleRenamer.setStyles(styles);
        try {
            new TraversalUtil(wmlPackage.getMainDocumentPart().getContents(), styleRenamer);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ CTCompatSetting access$100() {
        return defaultSetting;
    }

    static {
        defaultSetting.setVal("0");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StyleRenamer
    extends TraversalUtil.CallbackImpl {
        protected static Logger log = LoggerFactory.getLogger(StyleRenamer.class);
        CTCompatSetting overrideTableStyleFontSizeAndJustification = ParagraphStylesInTableFix.access$100();
        private PropertyResolver propertyResolver;
        private String defaultParagraphStyle;
        private Style defaultTableStyle;
        private LinkedList<Tbl> tblStack = new LinkedList();
        private Map<String, Style> allStyles = null;
        private Set<String> cellPStyles = new HashSet<String>();

        public void setDefaultParagraphStyle(String defaultParagraphStyle) {
            log.debug(defaultParagraphStyle);
            this.defaultParagraphStyle = defaultParagraphStyle;
        }

        public void setDefaultTableStyle(Style defaultTableStyle) {
            this.defaultTableStyle = defaultTableStyle;
        }

        public void setStyles(Styles newStyles) {
            this.allStyles = new HashMap<String, Style>();
            for (Style s : newStyles.getStyle()) {
                this.allStyles.put(s.getStyleId(), s);
            }
        }

        private boolean isFalse(CTCompatSetting overrideTableStyleFontSizeAndJustification) {
            return overrideTableStyleFontSizeAndJustification.getVal().equals("0") || overrideTableStyleFontSizeAndJustification.getVal().toLowerCase().equals("false") || overrideTableStyleFontSizeAndJustification.getVal().toLowerCase().equals("no");
        }

        private String getCellPStyle(String styleVal, boolean pStyleIsDefault) {
            Style thisStyle;
            Style expressStyle = this.allStyles.get(styleVal);
            Jc expressStyleJc = expressStyle.getPPr() == null ? null : expressStyle.getPPr().getJc();
            HpsMeasure expressStyleFontSize = null;
            if (expressStyle.getRPr() != null) {
                expressStyleFontSize = expressStyle.getRPr().getSz();
            }
            PPr effectivePPr = this.propertyResolver.getEffectivePPr(styleVal);
            Jc effectiveJc = effectivePPr.getJc();
            RPr effectiveRPr = this.propertyResolver.getEffectiveRPr(styleVal);
            HpsMeasure effectiveFontSize = null;
            if (effectiveRPr != null) {
                effectiveFontSize = effectiveRPr.getSz();
            }
            String tableStyle = null;
            TblPr tblPr = this.tblStack.peek().getTblPr();
            if (tblPr != null && tblPr.getTblStyle() != null) {
                tableStyle = tblPr.getTblStyle().getVal();
            } else {
                if (this.defaultTableStyle == null) {
                    log.warn("No default table style defined in docx Style Definitions part");
                    return null;
                }
                if (this.defaultTableStyle.getName() != null && this.defaultTableStyle.getName().getVal() != null && this.defaultTableStyle.getName().getVal().equals("Normal Table")) {
                    log.debug("Ignoring style with name 'Normal Table' (mimicking Word)");
                    return null;
                }
                tableStyle = this.defaultTableStyle.getStyleId();
                if (tableStyle == null) {
                    log.error("Default table style has no ID!");
                    log.error(XmlUtils.marshaltoString(tableStyle));
                    return null;
                }
            }
            String resultStyleID = styleVal + "-" + tableStyle;
            if (!tableStyle.endsWith("-BR")) {
                resultStyleID = resultStyleID + "-BR";
            }
            if (this.cellPStyles.contains(resultStyleID)) {
                return resultStyleID;
            }
            ArrayList<Style> hierarchy = new ArrayList<Style>();
            Object basedOn = null;
            String currentStyle = styleVal;
            do {
                thisStyle = this.allStyles.get(currentStyle);
                hierarchy.add(thisStyle);
            } while ((currentStyle = thisStyle.getBasedOn() != null ? thisStyle.getBasedOn().getVal() : null) != null);
            Style newStyle = Context.getWmlObjectFactory().createStyle();
            newStyle.setType("paragraph");
            Style styleToApply = (Style)hierarchy.get(hierarchy.size() - 1);
            log.debug("DocDefault");
            log.debug(XmlUtils.marshaltoString((Object)styleToApply, true, true));
            StyleUtil.apply(styleToApply, newStyle);
            log.debug("Result");
            log.debug(XmlUtils.marshaltoString((Object)newStyle, true, true));
            Style tableStyleContrib = null;
            ArrayList<Style> tblStyles = new ArrayList<Style>();
            if (tableStyle != null) {
                Style thisStyle2;
                currentStyle = tableStyle;
                do {
                    log.debug(currentStyle);
                    thisStyle2 = this.allStyles.get(currentStyle);
                    if (thisStyle2.getName().getVal().equals("Normal Table")) break;
                    tblStyles.add(thisStyle2);
                } while ((currentStyle = thisStyle2.getBasedOn() != null ? thisStyle2.getBasedOn().getVal() : null) != null);
                for (int i = tblStyles.size() - 1; i >= 0; --i) {
                    styleToApply = (Style)tblStyles.get(i);
                    log.debug("Applying " + styleToApply.getStyleId() + "\n" + XmlUtils.marshaltoString((Object)styleToApply, true, true));
                    tableStyleContrib = StyleUtil.apply(styleToApply, tableStyleContrib);
                    log.debug(XmlUtils.marshaltoString((Object)tableStyleContrib, true, true));
                }
            }
            if (tableStyleContrib == null) {
                tableStyleContrib = Context.getWmlObjectFactory().createStyle();
            }
            Jc tableStyleJc = tableStyleContrib.getPPr() == null ? null : tableStyleContrib.getPPr().getJc();
            HpsMeasure tableStyleFontSize = null;
            if (tableStyleContrib.getRPr() != null) {
                tableStyleFontSize = tableStyleContrib.getRPr().getSz();
            }
            newStyle.setPPr(StyleUtil.apply(tableStyleContrib.getPPr(), newStyle.getPPr()));
            newStyle.setRPr(StyleUtil.apply(tableStyleContrib.getRPr(), newStyle.getRPr()));
            log.debug(XmlUtils.marshaltoString((Object)newStyle, true, true));
            for (int i = hierarchy.size() - 2; i >= 0; --i) {
                styleToApply = (Style)hierarchy.get(i);
                log.debug("Applying " + styleToApply.getStyleId() + "\n" + XmlUtils.marshaltoString((Object)styleToApply, true, true));
                StyleUtil.apply(styleToApply, newStyle);
                log.debug("Result: \n" + XmlUtils.marshaltoString((Object)newStyle, true, true));
            }
            if (this.isFalse(this.overrideTableStyleFontSizeAndJustification)) {
                log.info("giving TableStyleFontSizeAndJustification primacy, as per this docx w:compatSetting");
                if ((styleVal.equals(this.defaultParagraphStyle) || expressStyleFontSize == null) && tableStyleFontSize != null && effectiveFontSize != null && effectiveFontSize.getVal().intValue() == 24) {
                    newStyle.getRPr().setSz(tableStyleFontSize);
                }
                if ((styleVal.equals(this.defaultParagraphStyle) || expressStyleJc == null) && tableStyleJc != null && effectiveJc != null && effectiveJc.getVal().equals((Object)JcEnumeration.LEFT)) {
                    newStyle.getPPr().setJc(tableStyleJc);
                }
            }
            Style.Name name = Context.getWmlObjectFactory().createStyleName();
            name.setVal(resultStyleID);
            newStyle.setName(name);
            newStyle.setStyleId(resultStyleID);
            this.cellPStyles.add(resultStyleID);
            this.propertyResolver.activateStyle(newStyle);
            log.debug(XmlUtils.marshaltoString((Object)newStyle, true, true));
            return resultStyleID;
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P) {
                P p = (P)o;
                if (p.getPPr() == null) {
                    p.setPPr(Context.getWmlObjectFactory().createPPr());
                }
                if (p.getPPr().getPStyle() == null) {
                    String newStyle = this.defaultParagraphStyle;
                    p.getPPr().setPStyle(Context.getWmlObjectFactory().createPPrBasePStyle());
                    if (this.tblStack.size() == 0) {
                        p.getPPr().getPStyle().setVal(newStyle);
                    } else {
                        String resultStyle = this.getCellPStyle(newStyle, true);
                        if (resultStyle == null) {
                            p.getPPr().getPStyle().setVal(newStyle);
                        } else {
                            p.getPPr().getPStyle().setVal(resultStyle);
                        }
                    }
                } else {
                    PPrBase.PStyle pstyle = p.getPPr().getPStyle();
                    String styleVal = pstyle.getVal();
                    if (styleVal != null && this.tblStack.size() > 0) {
                        log.debug("Fixing " + pstyle.getVal());
                        String newStyle = this.getCellPStyle(styleVal, styleVal.equals(this.defaultParagraphStyle));
                        if (newStyle == null) {
                            log.debug("getCellPStyle returned null, so leave as is");
                        } else {
                            p.getPPr().getPStyle().setVal(newStyle);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    if ((o = XmlUtils.unwrap(o)) instanceof Child) {
                        if (parent instanceof SdtBlock) {
                            ((Child)o).setParent(((SdtBlock)parent).getSdtContent());
                        } else {
                            ((Child)o).setParent(parent);
                        }
                    }
                    this.apply(o);
                    if (o instanceof Tbl) {
                        this.tblStack.push((Tbl)o);
                    }
                    if (this.shouldTraverse(o)) {
                        this.walkJAXBElements(o);
                    }
                    if (!(o instanceof Tbl)) continue;
                    this.tblStack.pop();
                }
            }
        }
    }
}

