/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.common.AbstractExporterDelegate;
import org.docx4j.convert.out.common.AbstractVisitorExporterGenerator;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.events.EventFinished;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.Part;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVisitorExporterDelegate<CS extends AbstractConversionSettings, CC extends AbstractWmlConversionContext>
extends AbstractExporterDelegate<CS, CC> {
    protected AbstractVisitorExporterGeneratorFactory<CC> generatorFactory = null;

    protected AbstractVisitorExporterDelegate(AbstractVisitorExporterGeneratorFactory<CC> generatorFactory) {
        this.generatorFactory = generatorFactory;
    }

    @Override
    public void process(CS conversionSettings, CC conversionContext, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(((AbstractConversionSettings)conversionSettings).getWmlPackage(), WellKnownProcessSteps.OUT_AbstractVisitorExporterDelegate);
        startEvent.publish();
        Document document = null;
        Element documentRoot = null;
        Element documentRootBody = null;
        Element sectionRoot = null;
        Element sectionRootBody = null;
        Element currentParent = null;
        Object flow = null;
        ((AbstractWmlConversionContext)conversionContext).setCurrentPartMainDocument();
        document = XmlUtils.neww3cDomDocument();
        currentParent = documentRoot = this.createDocumentRoot(conversionContext, document);
        document.appendChild(documentRoot);
        this.appendDocumentHeader(conversionContext, document, documentRoot);
        documentRootBody = this.createDocumentBody(conversionContext, document, documentRoot);
        if (documentRootBody != null) {
            currentParent.appendChild(documentRootBody);
            currentParent = documentRootBody;
        }
        List<ConversionSectionWrapper> sectionWrappers = ((AbstractWmlConversionContext)conversionContext).getSections().getList();
        for (int secindex = 0; secindex < sectionWrappers.size(); ++secindex) {
            ConversionSectionWrapper sectionWrapper = sectionWrappers.get(secindex);
            ((AbstractWmlConversionContext)conversionContext).getSections().next();
            sectionRoot = this.createSectionRoot(conversionContext, document, sectionWrapper, currentParent);
            if (sectionRoot != null) {
                currentParent.appendChild(sectionRoot);
                currentParent = sectionRoot;
            }
            this.appendSectionHeader(conversionContext, document, sectionWrapper, currentParent);
            sectionRootBody = this.createSectionBody(conversionContext, document, sectionWrapper, currentParent);
            if (sectionRootBody != null) {
                currentParent.appendChild(sectionRootBody);
                currentParent = sectionRootBody;
            }
            this.generateBodyContent(conversionContext, document, sectionWrapper.getContent(), currentParent);
            currentParent = sectionRoot;
            if (currentParent == null && (currentParent = documentRootBody) == null) {
                currentParent = documentRoot;
            }
            this.appendSectionFooter(conversionContext, document, sectionWrapper, currentParent);
            currentParent = documentRootBody;
            if (currentParent != null) continue;
            currentParent = documentRoot;
        }
        this.appendDocumentFooter(conversionContext, document, documentRoot);
        this.writeDocument(conversionContext, document, outputStream);
        new EventFinished(startEvent).publish();
    }

    protected abstract Element createDocumentRoot(CC var1, Document var2) throws Docx4JException;

    protected void appendDocumentHeader(CC conversionContext, Document document, Element documentRoot) throws Docx4JException {
    }

    protected Element createDocumentBody(CC conversionContext, Document document, Element documentRoot) {
        return null;
    }

    protected Element createSectionRoot(CC conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        return null;
    }

    protected void appendSectionHeader(CC conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
    }

    protected Element createSectionBody(CC conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        return null;
    }

    protected void appendPartContent(CC conversionContext, Document document, Part part, List<Object> content, Element currentParent) throws Docx4JException {
        Part previousPart = ((AbstractWmlConversionContext)conversionContext).getCurrentPart();
        ((AbstractWmlConversionContext)conversionContext).setCurrentPart(part);
        this.generateBodyContent(conversionContext, document, content, currentParent);
        ((AbstractWmlConversionContext)conversionContext).setCurrentPart(previousPart);
    }

    protected void generateBodyContent(CC conversionContext, Document document, List<Object> content, Element currentParent) throws Docx4JException {
        AbstractVisitorExporterGenerator<CC> generator = this.generatorFactory.createInstance(conversionContext, document, currentParent);
        new TraversalUtil(content, generator);
    }

    protected void appendSectionFooter(CC conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
    }

    protected void appendDocumentFooter(CC conversionContext, Document document, Element documentRoot) throws Docx4JException {
    }

    protected void writeDocument(CC conversionContext, Document document, OutputStream outputStream) throws Docx4JException {
        Transformer serializer = null;
        try {
            serializer = XmlUtils.getTransformerFactory().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("method", "xml");
            serializer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            throw new Docx4JException("Exception writing Document to OutputStream: " + e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AbstractVisitorExporterGeneratorFactory<CC extends AbstractWmlConversionContext> {
        public AbstractVisitorExporterGenerator<CC> createInstance(CC var1, Document var2, Node var3);
    }
}

