/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.mpp.TimescaleUnits;

public final class TimescaleUtility {
    private int m_weekStartDay = 2;

    public final ArrayList<DateRange> createTimescale(Date startDate, TimescaleUnits segmentUnit, int segmentCount) {
        int calendarIncrementAmount;
        int calendarIncrementUnit;
        ArrayList<DateRange> result = new ArrayList<DateRange>(segmentCount);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        switch (segmentUnit) {
            case MINUTES: {
                calendarIncrementUnit = 12;
                calendarIncrementAmount = 1;
                break;
            }
            case HOURS: {
                calendarIncrementUnit = 11;
                calendarIncrementAmount = 1;
                break;
            }
            case WEEKS: {
                cal.set(7, this.m_weekStartDay);
                calendarIncrementUnit = 6;
                calendarIncrementAmount = 7;
                break;
            }
            case THIRDS_OF_MONTHS: {
                cal.set(5, 1);
                calendarIncrementUnit = 6;
                calendarIncrementAmount = 10;
                break;
            }
            case MONTHS: {
                cal.set(5, 1);
                calendarIncrementUnit = 2;
                calendarIncrementAmount = 1;
                break;
            }
            case QUARTERS: {
                int currentMonth = cal.get(2);
                int currentQuarter = currentMonth / 3;
                int startMonth = currentQuarter * 3;
                cal.set(5, 1);
                cal.set(2, startMonth);
                calendarIncrementUnit = 2;
                calendarIncrementAmount = 3;
                break;
            }
            case HALF_YEARS: {
                int currentMonth = cal.get(2);
                int currentHalf = currentMonth / 6;
                int startMonth = currentHalf * 6;
                cal.set(5, 1);
                cal.set(2, startMonth);
                calendarIncrementUnit = 2;
                calendarIncrementAmount = 6;
                break;
            }
            case YEARS: {
                cal.set(5, 1);
                cal.set(2, 0);
                calendarIncrementUnit = 1;
                calendarIncrementAmount = 1;
                break;
            }
            default: {
                calendarIncrementUnit = 6;
                calendarIncrementAmount = 1;
            }
        }
        for (int loop = 0; loop < segmentCount; ++loop) {
            Date rangeStart = cal.getTime();
            if (segmentUnit == TimescaleUnits.THIRDS_OF_MONTHS && (loop + 1) % 3 == 0) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.set(5, 1);
                cal.add(2, 1);
            } else {
                cal.add(calendarIncrementUnit, calendarIncrementAmount);
            }
            cal.add(14, -1);
            result.add(new DateRange(rangeStart, cal.getTime()));
            cal.add(14, 1);
        }
        return result;
    }

    public void setWeekStartDay(int weekStartDay) {
        this.m_weekStartDay = weekStartDay;
    }

    public int getWeekStartDay() {
        return this.m_weekStartDay;
    }
}

