/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.sf.mpxj.MPXJException;

class ReplaceOnceStream
extends InputStream {
    private final InputStream m_parent;
    private int m_bufferIndex;
    private byte[] m_buffer;

    public ReplaceOnceStream(InputStream parent, String regex, String replacement, int scope, Charset charset) throws MPXJException {
        try {
            this.m_parent = parent;
            this.m_buffer = new byte[scope];
            int bytesRead = parent.read(this.m_buffer);
            String scopeString = new String(this.m_buffer, 0, bytesRead, charset);
            String resultString = scopeString.replaceFirst(regex, replacement);
            this.m_buffer = resultString.getBytes(charset);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file header", ex);
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.m_buffer == null) {
            result = this.m_parent.read();
        } else {
            result = this.m_buffer[this.m_bufferIndex++];
            if (this.m_bufferIndex == this.m_buffer.length) {
                this.m_buffer = null;
            }
        }
        return result;
    }
}

