/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedCostData;
import net.sf.mpxj.TimephasedCostNormaliser;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkData;
import net.sf.mpxj.TimephasedWorkNormaliser;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.utility.NumberUtility;

final class TimephasedDataFactory {
    TimephasedDataFactory() {
    }

    public List<TimephasedWork> getCompleteWork(ProjectCalendar calendar, Date startDate, byte[] data) {
        LinkedList<TimephasedWork> list = new LinkedList<TimephasedWork>();
        if (data != null && data.length > 0) {
            double time;
            int blockCount = MPPUtility.getShort(data, 0);
            double previousCumulativeWork = 0.0;
            TimephasedItem previousAssignment = null;
            int index = 32;
            for (int currentBlock = 0; currentBlock < blockCount && index + 20 <= data.length; ++currentBlock) {
                time = MPPUtility.getInt(data, index + 0);
                Duration startWork = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                double currentCumulativeWork = (long)MPPUtility.getDouble(data, index + 4);
                double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
                previousCumulativeWork = currentCumulativeWork;
                Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
                time = (long)MPPUtility.getDouble(data, index + 12);
                time /= 125.0;
                Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                Date start = startWork.getDuration() == 0.0 ? startDate : calendar.getDate(startDate, startWork, true);
                TimephasedWork assignment = new TimephasedWork();
                assignment.setStart(start);
                assignment.setAmountPerDay(workPerDay);
                assignment.setTotalAmount(totalWork);
                if (previousAssignment != null) {
                    Date finish = calendar.getDate(startDate, startWork, false);
                    previousAssignment.setFinish(finish);
                    if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                        list.removeLast();
                    }
                }
                list.add(assignment);
                previousAssignment = assignment;
                index += 20;
            }
            if (previousAssignment != null) {
                time = MPPUtility.getInt(data, 24);
                Duration finishWork = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                Date finish = calendar.getDate(startDate, finishWork, false);
                previousAssignment.setFinish(finish);
                if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                    list.removeLast();
                }
            }
        }
        return list;
    }

    public List<TimephasedWork> getPlannedWork(ProjectCalendar calendar, Date startDate, double units, byte[] data, List<TimephasedWork> timephasedComplete) {
        LinkedList<TimephasedWork> list = new LinkedList<TimephasedWork>();
        if (data != null && data.length > 0) {
            int blockCount = MPPUtility.getShort(data, 0);
            if (blockCount == 0) {
                if (!timephasedComplete.isEmpty() && units != 0.0) {
                    TimephasedWork lastComplete = timephasedComplete.get(timephasedComplete.size() - 1);
                    Date startWork = calendar.getNextWorkStart(lastComplete.getFinish());
                    double time = MPPUtility.getDouble(data, 16);
                    Duration totalWork = Duration.getInstance(time /= 1000.0, TimeUnit.MINUTES);
                    Duration adjustedTotalWork = Duration.getInstance(time * 100.0 / units, TimeUnit.MINUTES);
                    Date finish = calendar.getDate(startWork, adjustedTotalWork, false);
                    time = MPPUtility.getDouble(data, 8);
                    time /= 2000.0;
                    Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                    TimephasedWork assignment = new TimephasedWork();
                    assignment.setStart(startWork);
                    assignment.setAmountPerDay(workPerDay);
                    assignment.setModified(false);
                    assignment.setFinish(finish);
                    assignment.setTotalAmount(totalWork);
                    if (assignment.getStart().getTime() != assignment.getFinish().getTime()) {
                        list.add(assignment);
                    }
                }
            } else {
                Duration blockDuration;
                double time;
                Date offset = startDate;
                if (!timephasedComplete.isEmpty()) {
                    TimephasedWork lastComplete = timephasedComplete.get(timephasedComplete.size() - 1);
                    offset = lastComplete.getFinish();
                }
                int index = 40;
                double previousCumulativeWork = 0.0;
                TimephasedItem previousAssignment = null;
                for (int currentBlock = 0; currentBlock < blockCount && index + 28 <= data.length; ++currentBlock) {
                    time = MPPUtility.getInt(data, index);
                    blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                    Date start = blockDuration.getDuration() == 0.0 ? offset : calendar.getDate(offset, blockDuration, true);
                    double currentCumulativeWork = MPPUtility.getDouble(data, index + 4);
                    double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
                    Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
                    previousCumulativeWork = currentCumulativeWork;
                    time = MPPUtility.getDouble(data, index + 12);
                    time /= 2000.0;
                    Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                    int modifiedFlag = MPPUtility.getShort(data, index + 22);
                    boolean modified = modifiedFlag == 0 && currentBlock != 0 || (modifiedFlag & 0x3000) != 0;
                    TimephasedWork assignment = new TimephasedWork();
                    assignment.setStart(start);
                    assignment.setAmountPerDay(workPerDay);
                    assignment.setModified(modified);
                    assignment.setTotalAmount(totalWork);
                    if (previousAssignment != null) {
                        Date finish = calendar.getDate(offset, blockDuration, false);
                        previousAssignment.setFinish(finish);
                        if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                            list.removeLast();
                        }
                    }
                    list.add(assignment);
                    previousAssignment = assignment;
                    index += 28;
                }
                if (previousAssignment != null) {
                    time = MPPUtility.getInt(data, 24);
                    blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                    Date finish = calendar.getDate(offset, blockDuration, false);
                    previousAssignment.setFinish(finish);
                    if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                        list.removeLast();
                    }
                }
            }
        }
        return list;
    }

    public boolean getWorkModified(List<TimephasedWork> list) {
        TimephasedWork assignment;
        boolean result = false;
        Iterator<TimephasedWork> i$ = list.iterator();
        while (i$.hasNext() && !(result = (assignment = i$.next()).getModified())) {
        }
        return result;
    }

    public TimephasedWorkData getBaselineWork(ResourceAssignment assignment, ProjectCalendar calendar, TimephasedWorkNormaliser normaliser, byte[] data, boolean raw) {
        TimephasedWorkData result = null;
        if (data != null && data.length > 0) {
            LinkedList<TimephasedItem> list = null;
            int index = 8;
            int blockSize = 40;
            double previousCumulativeWorkPerformedInMinutes = 0.0;
            Date blockStartDate = MPPUtility.getTimestampFromTenths(data, index + 36);
            index += blockSize;
            TimephasedItem work = null;
            while (index + blockSize <= data.length) {
                double cumulativeWorkInMinutes = (double)((long)MPPUtility.getDouble(data, index + 20)) / 1000.0;
                if (!Duration.durationValueEquals(cumulativeWorkInMinutes, previousCumulativeWorkPerformedInMinutes)) {
                    double normalActualWorkThisPeriodInMinutes = (double)MPPUtility.getInt(data, index + 8) / 10.0;
                    double normalRemainingWorkThisPeriodInMinutes = (double)MPPUtility.getInt(data, index + 28) / 10.0;
                    double workThisPeriodInMinutes = cumulativeWorkInMinutes - previousCumulativeWorkPerformedInMinutes;
                    double overtimeWorkThisPeriodInMinutes = workThisPeriodInMinutes - (normalActualWorkThisPeriodInMinutes + normalRemainingWorkThisPeriodInMinutes);
                    double overtimeFactor = overtimeWorkThisPeriodInMinutes / (normalActualWorkThisPeriodInMinutes + normalRemainingWorkThisPeriodInMinutes);
                    double normalWorkPerDayInMinutes = 480.0;
                    double overtimeWorkPerDayInMinutes = normalWorkPerDayInMinutes * overtimeFactor;
                    work = new TimephasedWork();
                    work.setFinish(MPPUtility.getTimestampFromTenths(data, index + 16));
                    work.setStart(blockStartDate);
                    work.setTotalAmount(Duration.getInstance(workThisPeriodInMinutes, TimeUnit.MINUTES));
                    work.setAmountPerDay(Duration.getInstance(normalWorkPerDayInMinutes + overtimeWorkPerDayInMinutes, TimeUnit.MINUTES));
                    previousCumulativeWorkPerformedInMinutes = cumulativeWorkInMinutes;
                    if (list == null) {
                        list = new LinkedList<TimephasedItem>();
                    }
                    list.add(work);
                }
                blockStartDate = MPPUtility.getTimestampFromTenths(data, index + 36);
                index += blockSize;
            }
            if (list != null) {
                if (work != null) {
                    work.setFinish(assignment.getFinish());
                }
                result = new TimephasedWorkData(calendar, normaliser, list, raw);
            }
        }
        return result;
    }

    public TimephasedCostData getBaselineCost(ProjectCalendar calendar, TimephasedCostNormaliser normaliser, byte[] data, boolean raw) {
        TimephasedCostData result = null;
        if (data != null && data.length > 0) {
            LinkedList<TimephasedCost> list = null;
            int index = 16;
            int blockSize = 20;
            double previousTotalCost = 0.0;
            Date blockStartDate = MPPUtility.getTimestampFromTenths(data, index + 16);
            index += blockSize;
            while (index + blockSize <= data.length) {
                Date blockEndDate = MPPUtility.getTimestampFromTenths(data, index + 16);
                double currentTotalCost = (double)((long)MPPUtility.getDouble(data, index + 8)) / 100.0;
                if (!this.costEquals(previousTotalCost, currentTotalCost)) {
                    TimephasedCost cost = new TimephasedCost();
                    cost.setStart(blockStartDate);
                    cost.setFinish(blockEndDate);
                    cost.setTotalAmount(currentTotalCost - previousTotalCost);
                    if (list == null) {
                        list = new LinkedList<TimephasedCost>();
                    }
                    list.add(cost);
                    previousTotalCost = currentTotalCost;
                }
                blockStartDate = blockEndDate;
                index += blockSize;
            }
            if (list != null) {
                result = new TimephasedCostData(calendar, normaliser, list, raw);
            }
        }
        return result;
    }

    private boolean costEquals(double lhs, double rhs) {
        return NumberUtility.equals(lhs, rhs, 1.0E-5);
    }
}

