/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Column;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

final class TableFactory {
    private Integer m_tableColumnDataStandard;
    private Integer m_tableColumnDataEnterprise;
    private Integer m_tableColumnDataBaseline;

    public TableFactory(Integer tableColumnDataStandard, Integer tableColumnDataEnterprise, Integer tableColumnDataBaseline) {
        this.m_tableColumnDataStandard = tableColumnDataStandard;
        this.m_tableColumnDataEnterprise = tableColumnDataEnterprise;
        this.m_tableColumnDataBaseline = tableColumnDataBaseline;
    }

    public Table createTable(ProjectFile file, byte[] data, VarMeta varMeta, Var2Data varData) {
        Table table = new Table();
        table.setID(MPPUtility.getInt(data, 0));
        table.setResourceFlag(MPPUtility.getShort(data, 108) == 1);
        table.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(data, 4)));
        byte[] columnData = null;
        Integer tableID = table.getID();
        if (this.m_tableColumnDataBaseline != null) {
            columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataBaseline));
        }
        if (columnData == null && (columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataEnterprise))) == null) {
            columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataStandard));
        }
        this.processColumnData(file, table, columnData);
        return table;
    }

    private void processColumnData(ProjectFile file, Table table, byte[] data) {
        if (data != null) {
            int columnCount = MPPUtility.getShort(data, 4) + 1;
            int index = 8;
            for (int loop = 0; loop < columnCount; ++loop) {
                int alignment;
                Column column = new Column(file);
                int fieldType = MPPUtility.getShort(data, index);
                if (!table.getResourceFlag()) {
                    column.setFieldType(MPPTaskField.getInstance(fieldType));
                } else {
                    column.setFieldType(MPPResourceField.getInstance(fieldType));
                }
                column.setWidth(MPPUtility.getByte(data, index + 4));
                int columnTitleOffset = MPPUtility.getShort(data, index + 6);
                if (columnTitleOffset != 0) {
                    column.setTitle(MPPUtility.getUnicodeString(data, columnTitleOffset));
                }
                if (((alignment = MPPUtility.getByte(data, index + 8)) & 0xF) == 0) {
                    column.setAlignTitle(1);
                } else if ((alignment & 0xF) == 1) {
                    column.setAlignTitle(2);
                } else {
                    column.setAlignTitle(3);
                }
                alignment = MPPUtility.getByte(data, index + 10);
                if ((alignment & 0xF) == 0) {
                    column.setAlignData(1);
                } else if ((alignment & 0xF) == 1) {
                    column.setAlignData(2);
                } else {
                    column.setAlignData(3);
                }
                table.addColumn(column);
                index += 12;
            }
        }
    }
}

