/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.GanttBarMiddleShape;
import net.sf.mpxj.mpp.GanttBarShowForTasks;
import net.sf.mpxj.mpp.GanttBarStartEndShape;
import net.sf.mpxj.mpp.GanttBarStartEndType;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GanttBarStyleFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public final class GanttBarStyleFactoryCommon
implements GanttBarStyleFactory {
    private static final Integer DEFAULT_PROPERTIES = 574619686;
    private static final Integer EXCEPTION_PROPERTIES = 574619661;

    @Override
    public GanttBarStyle[] processDefaultStyles(Props props) {
        GanttBarStyle[] barStyles = null;
        byte[] barStyleData = props.getByteArray(DEFAULT_PROPERTIES);
        if (barStyleData != null) {
            barStyles = new GanttBarStyle[barStyleData[812]];
            int styleOffset = 840;
            int nameOffset = styleOffset + barStyles.length * 58;
            for (int loop = 0; loop < barStyles.length; ++loop) {
                GanttBarStyle style;
                String styleName = MPPUtility.getUnicodeString(barStyleData, nameOffset);
                nameOffset += (styleName.length() + 1) * 2;
                barStyles[loop] = style = new GanttBarStyle();
                style.setName(styleName);
                style.setMiddleShape(GanttBarMiddleShape.getInstance(barStyleData[styleOffset]));
                style.setMiddlePattern(ChartPattern.getInstance(barStyleData[styleOffset + 1]));
                style.setMiddleColor(ColorType.getInstance(barStyleData[styleOffset + 2]).getColor());
                style.setStartShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 4] % 21));
                style.setStartType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 4] / 21));
                style.setStartColor(ColorType.getInstance(barStyleData[styleOffset + 5]).getColor());
                style.setEndShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 6] % 21));
                style.setEndType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 6] / 21));
                style.setEndColor(ColorType.getInstance(barStyleData[styleOffset + 7]).getColor());
                style.setFromField(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 8)));
                style.setToField(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 12)));
                this.extractFlags(style, GanttBarShowForTasks.NORMAL, MPPUtility.getLong6(barStyleData, styleOffset + 16));
                this.extractFlags(style, GanttBarShowForTasks.NOT_NORMAL, MPPUtility.getLong6(barStyleData, styleOffset + 24));
                style.setRow(barStyleData[styleOffset + 32] + 1);
                style.setLeftText(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 34)));
                style.setRightText(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 38)));
                style.setTopText(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 42)));
                style.setBottomText(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 46)));
                style.setInsideText(MPPTaskField.getInstance(MPPUtility.getShort(barStyleData, styleOffset + 50)));
                styleOffset += 58;
            }
        }
        return barStyles;
    }

    @Override
    public GanttBarStyleException[] processExceptionStyles(Props props) {
        GanttBarStyleException[] barStyle = null;
        byte[] barData = props.getByteArray(EXCEPTION_PROPERTIES);
        if (barData != null) {
            barStyle = new GanttBarStyleException[barData.length / 38];
            int offset = 0;
            for (int loop = 0; loop < barStyle.length; ++loop) {
                GanttBarStyleException style;
                barStyle[loop] = style = new GanttBarStyleException();
                style.setTaskUniqueID(MPPUtility.getInt(barData, offset));
                style.setBarStyleIndex(MPPUtility.getShort(barData, offset + 4) - 1);
                style.setStartShape(GanttBarStartEndShape.getInstance(barData[offset + 9] % 21));
                style.setStartType(GanttBarStartEndType.getInstance(barData[offset + 9] / 21));
                style.setStartColor(ColorType.getInstance(barData[offset + 10]).getColor());
                style.setMiddleShape(GanttBarMiddleShape.getInstance(barData[offset + 6]));
                style.setMiddlePattern(ChartPattern.getInstance(barData[offset + 7]));
                style.setMiddleColor(ColorType.getInstance(barData[offset + 8]).getColor());
                style.setEndShape(GanttBarStartEndShape.getInstance(barData[offset + 11] % 21));
                style.setEndType(GanttBarStartEndType.getInstance(barData[offset + 11] / 21));
                style.setEndColor(ColorType.getInstance(barData[offset + 12]).getColor());
                style.setLeftText(MPPTaskField.getInstance(MPPUtility.getShort(barData, offset + 16)));
                style.setRightText(MPPTaskField.getInstance(MPPUtility.getShort(barData, offset + 20)));
                style.setTopText(MPPTaskField.getInstance(MPPUtility.getShort(barData, offset + 24)));
                style.setBottomText(MPPTaskField.getInstance(MPPUtility.getShort(barData, offset + 28)));
                style.setInsideText(MPPTaskField.getInstance(MPPUtility.getShort(barData, offset + 32)));
                offset += 38;
            }
        }
        return barStyle;
    }

    private void extractFlags(GanttBarStyle style, GanttBarShowForTasks baseCriteria, long flagValue) {
        long flag = 1L;
        for (int index = 0; index < 48; ++index) {
            if ((flagValue & flag) != 0L) {
                GanttBarShowForTasks enumValue = GanttBarShowForTasks.getInstance(baseCriteria.getValue() + index);
                style.addShowForTasks(enumValue);
            }
            flag <<= 1;
        }
    }
}

