/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.View;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.GanttBarDateFormat;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.TableFontStyle;

public class MppGanttTest
extends MPXJTestCase {
    private static final String[] TABLE_FONT_STYLES = new String[]{"[ColumnFontStyle rowUniqueID=3 fieldType=Text2 color=java.awt.Color[r=0,g=0,b=255]]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Task Name italic=false bold=true underline=false font=[FontBase name=Arial Black size=8] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Duration italic=false bold=true underline=false font=[FontBase name=Arial size=8] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Start italic=true bold=false underline=false font=[FontBase name=Arial size=8] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Finish italic=true bold=true underline=false font=[FontBase name=Arial size=8] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Predecessors italic=false bold=false underline=false font=[FontBase name=Arial size=10] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Text1 italic=false bold=false underline=true font=[FontBase name=Arial size=8] color=null backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]", "[ColumnFontStyle rowUniqueID=-1 fieldType=Text2 italic=false bold=false underline=false font=[FontBase name=Arial size=8] color=java.awt.Color[r=255,g=0,b=0] backgroundColor=java.awt.Color[r=0,g=0,b=0] backgroundPattern=Transparent]"};
    private static Set<String> TABLE_FONT_STYLES_SET = new HashSet<String>();

    public void testMpp9Gantt() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9gantt.mpp");
        this.testAll(mpp);
    }

    public void testMpp9GanttFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9gantt-from12.mpp");
        this.testAll(mpp);
    }

    public void testMpp9GanttFrom14() throws Exception {
    }

    public void testMpp12Gantt() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12gantt.mpp");
        this.testAll(mpp);
    }

    public void testMpp12GanttFrom14() throws Exception {
    }

    public void testMpp14Gantt() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14gantt.mpp");
        this.testAll(mpp);
    }

    private void testAll(ProjectFile mpp) {
        this.testSummaryData(mpp);
        this.testFontStyles(mpp);
        this.testGridlines(mpp);
        this.testTimescales(mpp);
        this.testLayout(mpp);
        this.testTableFontStyles(mpp);
        this.testProgressLines(mpp);
    }

    private void testSummaryData(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertTrue((boolean)view.getShowInMenu());
        MppGanttTest.assertEquals((int)778, (int)view.getTableWidth());
        MppGanttTest.assertFalse((boolean)view.getHighlightFilter());
        MppGanttTest.assertEquals((String)"Entry", (String)view.getTableName());
        MppGanttTest.assertEquals((String)"&All Tasks", (String)view.getDefaultFilterName());
        MppGanttTest.assertEquals((String)"No Group", (String)view.getGroupName());
        MppGanttTest.assertEquals((String)"Standard", (String)view.getNonWorkingDaysCalendarName());
        MppGanttTest.assertEquals((String)"java.awt.Color[r=194,g=220,b=255]", (String)view.getNonWorkingColor().toString());
        MppGanttTest.assertEquals((Object)ChartPattern.LIGHTDOTTED, (Object)view.getNonWorkingPattern());
        MppGanttTest.assertEquals((Object)NonWorkingTimeStyle.BEHIND, (Object)view.getNonWorkingStyle());
    }

    private void testFontStyles(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=java.awt.Color[r=0,g=0,b=255] backgroundColor=null backgroundPattern=Solid]", (String)view.getHighlightedTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getRowAndColumnFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Berlin Sans FB size=8] italic=false bold=true underline=true strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getNonCriticalTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getCriticalTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getSummaryTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Baskerville Old Face size=9] italic=true bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getMilestoneTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getMiddleTimescaleFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getBottomTimescaleFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getBarTextLeftFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getBarTextRightFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getBarTextTopFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getBarTextBottomFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=true underline=false strikethrough=false color=java.awt.Color[r=0,g=0,b=0] backgroundColor=null backgroundPattern=Solid]", (String)view.getBarTextInsideFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=BankGothic Lt BT size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getMarkedTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=10] italic=false bold=true underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getProjectSummaryTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=java.awt.Color[r=128,g=128,b=128] backgroundColor=null backgroundPattern=Solid]", (String)view.getExternalTasksFontStyle().toString());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=null backgroundColor=null backgroundPattern=Solid]", (String)view.getTopTimescaleFontStyle().toString());
    }

    private void testGridlines(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=null NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getGanttRowsGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=255,g=0,b=0] NormalLineStyle=Solid IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getBarRowsGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=0,g=0,b=255] NormalLineStyle=Dotted1 IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=java.awt.Color[r=0,g=0,b=0]]", (String)view.getMiddleTierColumnGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=0,g=128,b=0] NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getBottomTierColumnGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=128,g=128,b=128] NormalLineStyle=Dotted1 IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=java.awt.Color[r=128,g=128,b=128]]", (String)view.getCurrentDateGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=192,g=192,b=192] NormalLineStyle=Solid IntervalNumber=5 IntervalLineStyle=None IntervalLineColor=java.awt.Color[r=192,g=192,b=192]]", (String)view.getSheetRowsGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=192,g=192,b=192] NormalLineStyle=Solid IntervalNumber=2 IntervalLineStyle=Dotted1 IntervalLineColor=java.awt.Color[r=192,g=192,b=192]]", (String)view.getSheetColumnsGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=128,g=128,b=128] NormalLineStyle=Solid IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=java.awt.Color[r=128,g=128,b=128]]", (String)view.getTitleVerticalGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=128,g=128,b=128] NormalLineStyle=Solid IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=java.awt.Color[r=128,g=128,b=128]]", (String)view.getTitleHorizontalGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=null NormalLineStyle=Dashed IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getPageBreakGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=null NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getProjectStartGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=null NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getProjectFinishGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=null NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getStatusDateGridLines().toString());
        MppGanttTest.assertEquals((String)"[GridLines NormalLineColor=java.awt.Color[r=0,g=0,b=128] NormalLineStyle=None IntervalNumber=0 IntervalLineStyle=None IntervalLineColor=null]", (String)view.getTopTierColumnGridLines().toString());
    }

    private void testTimescales(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertEquals((int)2, (int)view.getTimescaleShowTiers());
        MppGanttTest.assertEquals((int)100, (int)view.getTimescaleSize());
        MppGanttTest.assertTrue((boolean)view.getTimescaleScaleSeparator());
        MppGanttTest.assertEquals((String)"[TimescaleTier UsesFiscalYear=true TickLines=true Units=None Count=1 Format=[None] Alignment=Center]", (String)view.getTimescaleTopTier().toString());
        MppGanttTest.assertEquals((String)"[TimescaleTier UsesFiscalYear=true TickLines=true Units=Weeks Count=1 Format=[January 27, '02] Alignment=Left]", (String)view.getTimescaleMiddleTier().toString());
        MppGanttTest.assertEquals((String)"[TimescaleTier UsesFiscalYear=true TickLines=true Units=Days Count=1 Format=[S, M, T, ...] Alignment=Center]", (String)view.getTimescaleBottomTier().toString());
    }

    private void testLayout(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertTrue((boolean)view.getShowDrawings());
        MppGanttTest.assertTrue((boolean)view.getRoundBarsToWholeDays());
        MppGanttTest.assertTrue((boolean)view.getShowBarSplits());
        MppGanttTest.assertFalse((boolean)view.getAlwaysRollupGanttBars());
        MppGanttTest.assertFalse((boolean)view.getHideRollupBarsWhenSummaryExpanded());
        MppGanttTest.assertEquals((int)12, (int)view.getGanttBarHeight());
        MppGanttTest.assertEquals((Object)GanttBarDateFormat.DDMM, (Object)view.getBarDateFormat());
        MppGanttTest.assertEquals((Object)LinkStyle.END_TOP, (Object)view.getLinkStyle());
    }

    private void testTableFontStyles(ProjectFile file) {
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        TableFontStyle[] tfs = view.getTableFontStyles();
        MppGanttTest.assertEquals((int)TABLE_FONT_STYLES.length, (int)tfs.length);
        for (int loop = 0; loop < tfs.length; ++loop) {
            MppGanttTest.assertTrue((boolean)TABLE_FONT_STYLES_SET.contains(tfs[loop].toString()));
        }
    }

    private void testProgressLines(ProjectFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List<View> views = file.getViews();
        GanttChartView view = (GanttChartView)views.get(0);
        MppGanttTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        MppGanttTest.assertTrue((boolean)view.getProgressLinesEnabled());
        MppGanttTest.assertFalse((boolean)view.getProgressLinesAtCurrentDate());
        MppGanttTest.assertTrue((boolean)view.getProgressLinesAtRecurringIntervals());
        MppGanttTest.assertEquals((Object)Interval.WEEKLY, (Object)view.getProgressLinesInterval());
        MppGanttTest.assertEquals((int)1, (int)view.getProgressLinesIntervalDailyDayNumber());
        MppGanttTest.assertTrue((boolean)view.isProgressLinesIntervalDailyWorkday());
        boolean[] weeklyDay = view.getProgressLinesIntervalWeeklyDay();
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.SUNDAY.getValue()]);
        MppGanttTest.assertTrue((boolean)weeklyDay[Day.MONDAY.getValue()]);
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.TUESDAY.getValue()]);
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.WEDNESDAY.getValue()]);
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.THURSDAY.getValue()]);
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.FRIDAY.getValue()]);
        MppGanttTest.assertFalse((boolean)weeklyDay[Day.SATURDAY.getValue()]);
        MppGanttTest.assertEquals((int)1, (int)view.getProgressLinesIntervalWeekleyWeekNumber());
        MppGanttTest.assertFalse((boolean)view.getProgressLinesIntervalMonthlyDay());
        MppGanttTest.assertEquals((int)1, (int)view.getProgressLinesIntervalMonthlyDayMonthNumber());
        MppGanttTest.assertEquals((int)1, (int)view.getProgressLinesIntervalMonthlyDayDayNumber());
        MppGanttTest.assertEquals((Object)ProgressLineDay.DAY, (Object)view.getProgressLinesIntervalMonthlyFirstLastDay());
        MppGanttTest.assertTrue((boolean)view.getProgressLinesIntervalMonthlyFirstLast());
        MppGanttTest.assertEquals((int)1, (int)view.getProgressLinesIntervalMonthlyFirstLastMonthNumber());
        MppGanttTest.assertFalse((boolean)view.getProgressLinesBeginAtProjectStart());
        MppGanttTest.assertEquals((String)"13/05/2010", (String)df.format(view.getProgressLinesBeginAtDate()));
        MppGanttTest.assertTrue((boolean)view.getProgressLinesDisplaySelected());
        MppGanttTest.assertTrue((boolean)view.getProgressLinesActualPlan());
        MppGanttTest.assertEquals((int)0, (int)view.getProgressLinesDisplayType());
        MppGanttTest.assertFalse((boolean)view.getProgressLinesShowDate());
        MppGanttTest.assertEquals((int)26, (int)view.getProgressLinesDateFormat());
        MppGanttTest.assertEquals((String)"[FontStyle fontBase=[FontBase name=Arial size=8] italic=false bold=false underline=false strikethrough=false color=java.awt.Color[r=0,g=0,b=0] backgroundColor=null backgroundPattern=Solid]", (String)view.getProgressLinesFontStyle().toString());
        MppGanttTest.assertEquals((String)"java.awt.Color[r=255,g=0,b=0]", (String)view.getProgressLinesCurrentLineColor().toString());
        MppGanttTest.assertEquals((Object)LineStyle.SOLID, (Object)view.getProgressLinesCurrentLineStyle());
        MppGanttTest.assertEquals((String)"java.awt.Color[r=255,g=0,b=0]", (String)view.getProgressLinesCurrentProgressPointColor().toString());
        MppGanttTest.assertEquals((int)13, (int)view.getProgressLinesCurrentProgressPointShape());
        MppGanttTest.assertEquals(null, (Object)view.getProgressLinesOtherLineColor());
        MppGanttTest.assertEquals((Object)LineStyle.SOLID, (Object)view.getProgressLinesOtherLineStyle());
        MppGanttTest.assertEquals(null, (Object)view.getProgressLinesOtherProgressPointColor());
        MppGanttTest.assertEquals((int)0, (int)view.getProgressLinesOtherProgressPointShape());
        MppGanttTest.assertEquals((int)2, (int)view.getProgressLinesDisplaySelectedDates().length);
        MppGanttTest.assertEquals((String)"01/02/2010", (String)df.format(view.getProgressLinesDisplaySelectedDates()[0]));
        MppGanttTest.assertEquals((String)"01/01/2010", (String)df.format(view.getProgressLinesDisplaySelectedDates()[1]));
    }

    static {
        for (String style : TABLE_FONT_STYLES) {
            TABLE_FONT_STYLES_SET.add(style);
        }
    }
}

