/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.io.File;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mpx.MPXWriter;

public class LocaleTest
extends MPXJTestCase {
    public void testLocales() throws Exception {
        Locale[] locales;
        for (Locale locale : locales = new MPXReader().getSupportedLocales()) {
            try {
                this.testLocale(locale);
            }
            catch (UnsupportedCharsetException ex) {
                if (this.m_ikvm) continue;
                throw ex;
            }
        }
    }

    private void testLocale(Locale locale) throws Exception {
        MPXReader reader = new MPXReader();
        MPXWriter writer = new MPXWriter();
        File in = new File(this.m_basedir + "/sample.mpx");
        ProjectFile mpx = reader.read(in);
        File out = File.createTempFile("junit-" + locale.getLanguage(), ".mpx");
        writer.setLocale(locale);
        writer.write(mpx, out);
        reader.setLocale(locale);
        reader.read(out);
        out.deleteOnExit();
    }

    public void testReadGerman() throws Exception {
        File in = new File(this.m_basedir + "/sample.de.mpx");
        MPXReader reader = new MPXReader();
        reader.setLocale(Locale.GERMAN);
        reader.read(in);
    }
}

