/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ikvm;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MapFileGenerator {
    private List<String> m_responseList;
    private static final Map<Class<?>, String> TYPE_MAP = new HashMap();
    private static final String[] IGNORED_METHODS;

    public static void main(String[] args) throws ClassNotFoundException, XMLStreamException, IOException, IntrospectionException {
        if (args.length != 3) {
            System.out.println("Usage: MapFileGenerator <file.jar> <remapfile.xml> <map class methods flag>");
        } else {
            MapFileGenerator generator = new MapFileGenerator();
            generator.generateMapFile(new File(args[0]), args[1], Boolean.parseBoolean(args[2]));
        }
    }

    public void generateMapFile(File jarFile, String mapFileName, boolean mapClassMethods) throws XMLStreamException, IOException, ClassNotFoundException, IntrospectionException {
        this.m_responseList = new LinkedList<String>();
        this.writeMapFile(mapFileName, jarFile, mapClassMethods);
    }

    private void writeMapFile(String mapFileName, File jarFile, boolean mapClassMethods) throws IOException, XMLStreamException, ClassNotFoundException, IntrospectionException {
        FileWriter fw = new FileWriter(mapFileName);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = xof.createXMLStreamWriter(fw);
        writer.writeStartDocument();
        writer.writeStartElement("root");
        writer.writeStartElement("assembly");
        this.addClasses(writer, jarFile, mapClassMethods);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        fw.flush();
        fw.close();
    }

    private void addClasses(XMLStreamWriter writer, File jarFile, boolean mapClassMethods) throws IOException, ClassNotFoundException, XMLStreamException, IntrospectionException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, currentThreadClassLoader);
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
            this.addClass(loader, jarEntry, writer, mapClassMethods);
        }
        jar.close();
    }

    private void addClass(URLClassLoader loader, JarEntry jarEntry, XMLStreamWriter writer, boolean mapClassMethods) throws ClassNotFoundException, XMLStreamException, IntrospectionException {
        String className = jarEntry.getName().replaceAll("\\.class", "").replaceAll("/", ".");
        writer.writeStartElement("class");
        writer.writeAttribute("name", className);
        HashSet<Method> methodSet = new HashSet<Method>();
        Class<?> aClass = loader.loadClass(className);
        this.processProperties(writer, methodSet, aClass);
        if (mapClassMethods && !Modifier.isInterface(aClass.getModifiers())) {
            this.processClassMethods(writer, aClass, methodSet);
        }
        writer.writeEndElement();
    }

    private void processProperties(XMLStreamWriter writer, Set<Method> methodSet, Class<?> aClass) throws IntrospectionException, XMLStreamException {
        BeanInfo beanInfo = Introspector.getBeanInfo(aClass, aClass.getSuperclass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (propertyDescriptor.getPropertyType() != null) {
                String name = propertyDescriptor.getName();
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                String readMethodName = readMethod == null ? null : readMethod.getName();
                String writeMethodName = writeMethod == null ? null : writeMethod.getName();
                this.addProperty(writer, name, propertyDescriptor.getPropertyType(), readMethodName, writeMethodName);
                if (readMethod != null) {
                    methodSet.add(readMethod);
                }
                if (writeMethod == null) continue;
                methodSet.add(writeMethod);
                continue;
            }
            this.processAmbiguousProperty(writer, methodSet, aClass, propertyDescriptor);
        }
    }

    private void addProperty(XMLStreamWriter writer, String name, Class<?> propertyType, String readMethod, String writeMethod) throws XMLStreamException {
        if (name.length() != 0) {
            writer.writeStartElement("property");
            String propertyName = name.substring(0, 1).toUpperCase() + name.substring(1);
            writer.writeAttribute("name", propertyName);
            String type = this.getTypeString(propertyType);
            writer.writeAttribute("sig", "()" + type);
            if (readMethod != null) {
                writer.writeStartElement("getter");
                writer.writeAttribute("name", readMethod);
                writer.writeAttribute("sig", "()" + type);
                writer.writeEndElement();
            }
            if (writeMethod != null) {
                writer.writeStartElement("setter");
                writer.writeAttribute("name", writeMethod);
                writer.writeAttribute("sig", "(" + type + ")V");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private String getTypeString(Class<?> c) {
        String result = TYPE_MAP.get(c);
        if (result == null && !(result = c.getName()).endsWith(";") && !result.startsWith("[")) {
            result = "L" + result + ";";
        }
        return result;
    }

    private void processAmbiguousProperty(XMLStreamWriter writer, Set<Method> methodSet, Class<?> aClass, PropertyDescriptor propertyDescriptor) throws SecurityException, XMLStreamException {
        String name = propertyDescriptor.getName();
        name = name.toUpperCase().charAt(0) + name.substring(1);
        Method readMethod = null;
        try {
            readMethod = aClass.getMethod("get" + name, null);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (readMethod != null) {
            Method writeMethod = null;
            try {
                writeMethod = aClass.getMethod("set" + name, readMethod.getReturnType());
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            String readMethodName = readMethod.getName();
            String writeMethodName = writeMethod == null ? null : writeMethod.getName();
            this.addProperty(writer, name, readMethod.getReturnType(), readMethodName, writeMethodName);
            methodSet.add(readMethod);
            if (writeMethod != null) {
                methodSet.add(writeMethod);
            }
        }
    }

    private void processClassMethods(XMLStreamWriter writer, Class<?> aClass, Set<Method> methodSet) throws XMLStreamException {
        Method[] methods;
        for (Method method : methods = aClass.getDeclaredMethods()) {
            if (methodSet.contains(method) || !Modifier.isPublic(method.getModifiers()) || Modifier.isInterface(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            String name = method.getName();
            String methodSignature = this.createMethodSignature(method);
            String fullJavaName = aClass.getCanonicalName() + "." + name + methodSignature;
            if (this.ignoreMethod(fullJavaName)) continue;
            writer.writeStartElement("method");
            writer.writeAttribute("name", name);
            writer.writeAttribute("sig", methodSignature);
            writer.writeStartElement("attribute");
            writer.writeAttribute("type", "System.ComponentModel.EditorBrowsableAttribute");
            writer.writeAttribute("sig", "(Lcli.System.ComponentModel.EditorBrowsableState;)V");
            writer.writeStartElement("parameter");
            writer.writeCharacters("Never");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            name = name.toUpperCase().charAt(0) + name.substring(1);
            writer.writeStartElement("method");
            writer.writeAttribute("name", name);
            writer.writeAttribute("sig", methodSignature);
            writer.writeAttribute("modifiers", "public");
            writer.writeStartElement("body");
            for (int index = 0; index <= method.getParameterTypes().length; ++index) {
                if (index < 4) {
                    writer.writeEmptyElement("ldarg_" + index);
                    continue;
                }
                writer.writeStartElement("ldarg_s");
                writer.writeAttribute("argNum", Integer.toString(index));
                writer.writeEndElement();
            }
            writer.writeStartElement("callvirt");
            writer.writeAttribute("class", aClass.getName());
            writer.writeAttribute("name", method.getName());
            writer.writeAttribute("sig", methodSignature);
            writer.writeEndElement();
            if (!method.getReturnType().getName().equals("void")) {
                writer.writeEmptyElement("ldnull");
                writer.writeEmptyElement("pop");
            }
            writer.writeEmptyElement("ret");
            writer.writeEndElement();
            writer.writeEndElement();
            this.m_responseList.add(fullJavaName);
        }
    }

    private boolean ignoreMethod(String name) {
        boolean result = false;
        for (String ignoredName : IGNORED_METHODS) {
            if (!name.matches(ignoredName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String createMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> type : method.getParameterTypes()) {
            sb.append(this.getTypeString(type));
        }
        sb.append(")");
        Class<?> type = method.getReturnType();
        if (type.getName().equals("void")) {
            sb.append("V");
        } else {
            sb.append(this.getTypeString(type));
        }
        return sb.toString();
    }

    static {
        TYPE_MAP.put(Boolean.TYPE, "Z");
        TYPE_MAP.put(Byte.TYPE, "B");
        TYPE_MAP.put(Short.TYPE, "S");
        TYPE_MAP.put(Character.TYPE, "C");
        TYPE_MAP.put(Integer.TYPE, "I");
        TYPE_MAP.put(Long.TYPE, "J");
        TYPE_MAP.put(Float.TYPE, "F");
        TYPE_MAP.put(Double.TYPE, "D");
        IGNORED_METHODS = new String[]{".*\\.toString\\(\\)Ljava.lang.String;"};
    }
}

