/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum ProjectTimeFormat implements MpxjEnum
{
    TWELVE_HOUR(0),
    TWENTY_FOUR_HOUR(1);

    private static final ProjectTimeFormat[] TYPE_VALUES;
    private int m_value;

    private ProjectTimeFormat(int type) {
        this.m_value = type;
    }

    public static ProjectTimeFormat getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = TWELVE_HOUR.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ProjectTimeFormat getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ProjectTimeFormat.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return Integer.toString(this.m_value);
    }

    static {
        TYPE_VALUES = (ProjectTimeFormat[])EnumUtility.createTypeArray(ProjectTimeFormat.class);
    }
}

