/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

public final class ProjectCalendar
extends ProjectCalendarWeek {
    private ProjectFile m_projectFile;
    private Integer m_uniqueID = 0;
    private List<ProjectCalendarException> m_exceptions = new LinkedList<ProjectCalendarException>();
    private boolean m_exceptionsSorted;
    private Resource m_resource;
    private ArrayList<ProjectCalendar> m_derivedCalendars = new ArrayList();
    private Map<DateRange, Long> m_workingDateCache = new WeakHashMap<DateRange, Long>();
    private Map<Date, Date> m_startTimeCache = new WeakHashMap<Date, Date>();
    private ArrayList<ProjectCalendarWeek> m_workWeeks = new ArrayList();
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    private static final int MAX_NONWORKING_DAYS = 1000;

    public ProjectCalendar(ProjectFile file) {
        this.m_projectFile = file;
        if (file.getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getCalendarUniqueID());
        }
    }

    public ProjectCalendarWeek addWorkWeek() {
        ProjectCalendarWeek week = new ProjectCalendarWeek();
        week.setParent(this);
        this.m_workWeeks.add(week);
        return week;
    }

    public List<ProjectCalendarWeek> getWorkWeeks() {
        return this.m_workWeeks;
    }

    public ProjectCalendarException addCalendarException(Date fromDate, Date toDate) {
        ProjectCalendarException bce = new ProjectCalendarException(fromDate, toDate);
        this.m_exceptions.add(bce);
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
        return bce;
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        if (!this.m_exceptionsSorted) {
            Collections.sort(this.m_exceptions);
        }
        return this.m_exceptions;
    }

    @Override
    public ProjectCalendarHours addCalendarHours(Day day) {
        this.clearWorkingDateCache();
        return super.addCalendarHours(day);
    }

    @Override
    public void attachHoursToDay(ProjectCalendarHours hours) {
        this.clearWorkingDateCache();
        super.attachHoursToDay(hours);
    }

    @Override
    public void removeHoursFromDay(ProjectCalendarHours hours) {
        this.clearWorkingDateCache();
        super.removeHoursFromDay(hours);
    }

    public void setParent(ProjectCalendar calendar) {
        if (this.getParent() != null) {
            this.getParent().removeDerivedCalendar(this);
        }
        super.setParent(calendar);
        if (calendar != null) {
            calendar.addDerivedCalendar(this);
        }
        this.clearWorkingDateCache();
    }

    @Override
    public ProjectCalendar getParent() {
        return (ProjectCalendar)super.getParent();
    }

    public boolean isWorkingDay(Day day) {
        ProjectCalendar cal;
        DayType value = this.getWorkingDay(day);
        boolean result = value == DayType.DEFAULT ? ((cal = this.getParent()) != null ? cal.isWorkingDay(day) : day != Day.SATURDAY && day != Day.SUNDAY) : value == DayType.WORKING;
        return result;
    }

    public Duration getDuration(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        Day day = Day.getInstance(cal.get(7));
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), day)) {
                ++duration;
            }
            --days;
            day = day.getNextDay();
            cal.set(6, cal.get(6) + 1);
        }
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getStartTime(Date date) {
        Date result = this.m_startTimeCache.get(date);
        if (result == null) {
            ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
            result = ranges == null ? this.getParentFile().getProjectHeader().getDefaultStartTime() : ranges.getRange(0).getStart();
            result = DateUtility.getCanonicalTime(result);
            this.m_startTimeCache.put(new Date(date.getTime()), result);
        }
        return result;
    }

    public Date getFinishTime(Date date) {
        Date result = null;
        if (date != null) {
            ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
            if (ranges == null) {
                result = this.getParentFile().getProjectHeader().getDefaultEndTime();
                result = DateUtility.getCanonicalTime(result);
            } else {
                Date rangeStart = result = ranges.getRange(0).getStart();
                Date rangeFinish = ranges.getRange(ranges.getRangeCount() - 1).getEnd();
                Date startDay = DateUtility.getDayStartDate(rangeStart);
                Date finishDay = DateUtility.getDayStartDate(rangeFinish);
                result = DateUtility.getCanonicalTime(rangeFinish);
                if (startDay != null && finishDay != null && startDay.getTime() != finishDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(result);
                    calendar.add(6, 1);
                    result = calendar.getTime();
                }
            }
        }
        return result;
    }

    public Date getDate(Date startDate, Duration duration, boolean returnNextWorkStart) {
        ProjectHeader header = this.getParentFile().getProjectHeader();
        double remainingMinutes = NumberUtility.truncate(duration.convertUnits(TimeUnit.MINUTES, header).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            endCal.setTime(currentDate);
            endCal.add(6, 1);
            Date currentDateEnd = DateUtility.getDayStartDate(endCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDate, currentDateEnd, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberUtility.truncate(remainingMinutes - currentDateWorkingMinutes, 2.0);
                int nonWorkingDayCount = 0;
                do {
                    cal.add(6, 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(startDate);
                    cal.add(6, 1);
                    remainingMinutes = 0.0;
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date startTime = this.getStartTime(cal.getTime());
                DateUtility.setTime(cal, startTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getRanges(cal.getTime(), cal, null);
            Date endTime = null;
            Date currentDateStartTime = DateUtility.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (DateRange range : ranges) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateUtility.getDayStartDate(rangeStart);
                Date rangeEndDay = DateUtility.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeEnd);
                    calendar.add(6, 1);
                    canonicalRangeEnd = calendar.getTime();
                }
                if (firstRange && canonicalRangeEnd.getTime() < currentDateStartTime.getTime()) continue;
                if (firstRange && canonicalRangeStart.getTime() < currentDateStartTime.getTime()) {
                    canonicalRangeStart = currentDateStartTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberUtility.truncate(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                if (Duration.durationValueEquals(remainingMinutes, rangeMinutes)) {
                    endTime = canonicalRangeEnd;
                    if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                        cal.add(6, 1);
                    }
                } else {
                    endTime = new Date((long)((double)canonicalRangeStart.getTime() + remainingMinutes * 60000.0));
                    returnNextWorkStart = false;
                }
                remainingMinutes = 0.0;
                break;
            }
            DateUtility.setTime(cal, endTime);
        }
        if (returnNextWorkStart) {
            this.updateToNextWorkStart(cal);
        }
        return cal.getTime();
    }

    public Date getStartDate(Date finishDate, Duration duration) {
        ProjectHeader header = this.getParentFile().getProjectHeader();
        double remainingMinutes = NumberUtility.truncate(duration.convertUnits(TimeUnit.MINUTES, header).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(finishDate);
        Calendar startCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            startCal.setTime(currentDate);
            startCal.add(6, -1);
            Date currentDateEnd = DateUtility.getDayEndDate(startCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDateEnd, currentDate, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                int count;
                remainingMinutes = NumberUtility.truncate(remainingMinutes - currentDateWorkingMinutes, 2.0);
                for (count = 0; count <= 7; ++count) {
                    cal.add(6, -1);
                    Day day = Day.getInstance(cal.get(7));
                    if (!this.isWorkingDate(cal.getTime(), day)) continue;
                }
                if (count > 7) {
                    return null;
                }
                Date finishTime = this.getFinishTime(cal.getTime());
                DateUtility.setTime(cal, finishTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getRanges(cal.getTime(), cal, null);
            Date startTime = null;
            Date currentDateFinishTime = DateUtility.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (int i = ranges.getRangeCount() - 1; i >= 0; --i) {
                DateRange range = ranges.getRange(i);
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateUtility.getDayStartDate(rangeStart);
                Date rangeEndDay = DateUtility.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeEnd);
                    calendar.add(6, 1);
                    canonicalRangeEnd = calendar.getTime();
                }
                if (firstRange && canonicalRangeStart.getTime() > currentDateFinishTime.getTime()) continue;
                if (firstRange && canonicalRangeEnd.getTime() > currentDateFinishTime.getTime()) {
                    canonicalRangeEnd = currentDateFinishTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberUtility.truncate(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                startTime = Duration.durationValueEquals(remainingMinutes, rangeMinutes) ? canonicalRangeStart : new Date((long)((double)canonicalRangeEnd.getTime() - remainingMinutes * 60000.0));
                remainingMinutes = 0.0;
                break;
            }
            DateUtility.setTime(cal, startTime);
        }
        return cal.getTime();
    }

    private void updateToNextWorkStart(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarDateRanges ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateUtility.getCanonicalTime(cal.getTime());
            Date startTime = null;
            for (DateRange range : ranges) {
                Date rangeStart = DateUtility.getCanonicalTime(range.getStart());
                Date rangeEnd = DateUtility.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateUtility.getDayStartDate(range.getStart());
                Date rangeEndDay = DateUtility.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(rangeEnd);
                    calendar.add(6, 1);
                    rangeEnd = calendar.getTime();
                }
                if (calTime.getTime() >= rangeEnd.getTime()) continue;
                if (calTime.getTime() > rangeStart.getTime()) {
                    startTime = calTime;
                    break;
                }
                startTime = rangeStart;
                break;
            }
            if (startTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) + 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                startTime = this.getStartTime(cal.getTime());
            }
            DateUtility.setTime(cal, startTime);
        }
    }

    private void updateToPreviousWorkFinish(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarDateRanges ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateUtility.getCanonicalTime(cal.getTime());
            Date finishTime = null;
            for (DateRange range : ranges) {
                Date rangeEnd = DateUtility.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateUtility.getDayStartDate(range.getStart());
                Date rangeEndDay = DateUtility.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(rangeEnd);
                    calendar.add(6, 1);
                    rangeEnd = calendar.getTime();
                }
                if (calTime.getTime() < rangeEnd.getTime()) continue;
                finishTime = rangeEnd;
                break;
            }
            if (finishTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) - 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                finishTime = this.getFinishTime(cal.getTime());
            }
            DateUtility.setTime(cal, finishTime);
        }
    }

    public Date getNextWorkStart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToNextWorkStart(cal);
        return cal.getTime();
    }

    public Date getPreviousWorkFinish(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToPreviousWorkFinish(cal);
        return cal.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Day day = Day.getInstance(cal.get(7));
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarDateRanges ranges = this.getRanges(date, null, day);
        return ranges.getRangeCount() != 0;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        return result;
    }

    public void setUniqueID(Integer uniqueID) {
        ProjectFile parent = this.getParentFile();
        if (this.m_uniqueID != null) {
            parent.unmapCalendarUniqueID(this.m_uniqueID);
        }
        parent.mapCalendarUniqueID(uniqueID, this);
        this.m_uniqueID = uniqueID;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
        String name = this.m_resource.getName();
        if (name == null || name.length() == 0) {
            name = "Unnamed Resource";
        }
        this.setName(name);
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        ProjectCalendarException exception = null;
        if (!this.m_exceptions.isEmpty()) {
            if (!this.m_exceptionsSorted) {
                Collections.sort(this.m_exceptions);
                this.m_exceptionsSorted = true;
            }
            int low = 0;
            int high = this.m_exceptions.size() - 1;
            long targetDate = date.getTime();
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarException midVal = this.m_exceptions.get(mid);
                int cmp = 0 - DateUtility.compare(midVal.getFromDate(), midVal.getToDate(), targetDate);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                exception = midVal;
                break;
            }
        }
        if (exception == null && this.getParent() != null) {
            exception = this.getParent().getException(date);
        }
        return exception;
    }

    public Duration getWork(Date date, TimeUnit format) {
        ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
        long time = this.getTotalTime(ranges);
        return this.convertFormat(time, format);
    }

    public Duration getWork(Date startDate, Date endDate, TimeUnit format) {
        DateRange range = new DateRange(startDate, endDate);
        Long cachedResult = this.m_workingDateCache.get(range);
        long totalTime = 0L;
        if (cachedResult == null) {
            boolean invert = false;
            if (startDate.getTime() > endDate.getTime()) {
                invert = true;
                Date temp = startDate;
                startDate = endDate;
                endDate = temp;
            }
            Date canonicalStartDate = DateUtility.getDayStartDate(startDate);
            Date canonicalEndDate = DateUtility.getDayStartDate(endDate);
            if (canonicalStartDate.getTime() == canonicalEndDate.getTime()) {
                ProjectCalendarDateRanges ranges = this.getRanges(startDate, null, null);
                if (ranges.getRangeCount() != 0) {
                    totalTime = this.getTotalTime(ranges, startDate, endDate);
                }
            } else {
                ProjectCalendarDateRanges ranges;
                Date currentDate = startDate;
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                Day day = Day.getInstance(cal.get(7));
                while (!this.isWorkingDate(currentDate, day) && currentDate.getTime() < canonicalEndDate.getTime()) {
                    cal.add(6, 1);
                    currentDate = cal.getTime();
                    day = day.getNextDay();
                }
                if (currentDate.getTime() < canonicalEndDate.getTime()) {
                    totalTime += this.getTotalTime(this.getRanges(currentDate, null, day), currentDate, true);
                    while (true) {
                        cal.add(6, 1);
                        currentDate = cal.getTime();
                        day = day.getNextDay();
                        if (currentDate.getTime() >= canonicalEndDate.getTime()) break;
                        ranges = this.getRanges(currentDate, null, day);
                        if (ranges.getRangeCount() == 0) continue;
                        totalTime += this.getTotalTime(ranges);
                    }
                }
                if ((ranges = this.getRanges(endDate, null, day)).getRangeCount() != 0) {
                    totalTime += this.getTotalTime(ranges, DateUtility.getDayStartDate(endDate), endDate);
                }
            }
            if (invert) {
                totalTime = -totalTime;
            }
            this.m_workingDateCache.put(range, totalTime);
        } else {
            totalTime = cachedResult;
        }
        return this.convertFormat(totalTime, format);
    }

    private Duration convertFormat(long totalTime, TimeUnit format) {
        double duration = totalTime;
        double minutesPerDay = this.getParentFile().getProjectHeader().getMinutesPerDay().doubleValue();
        double minutesPerWeek = this.getParentFile().getProjectHeader().getMinutesPerWeek().doubleValue();
        double daysPerMonth = this.getParentFile().getProjectHeader().getDaysPerMonth().doubleValue();
        switch (format) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration /= 60000.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration /= 3600000.0;
                break;
            }
            case DAYS: {
                if (minutesPerDay != 0.0) {
                    duration /= minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case WEEKS: {
                if (minutesPerWeek != 0.0) {
                    duration /= minutesPerWeek * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case MONTHS: {
                if (daysPerMonth != 0.0 && minutesPerDay != 0.0) {
                    duration /= daysPerMonth * minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration /= 8.64E7;
                break;
            }
            case ELAPSED_WEEKS: {
                duration /= 6.048E8;
                break;
            }
            case ELAPSED_MONTHS: {
                duration /= -1.702967296E9;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarDateRanges exception, Date date, boolean after) {
        long currentTime = DateUtility.getCanonicalTime(date).getTime();
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges exception) {
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges hours, Date startDate, Date endDate) {
        long total = 0L;
        if (startDate.getTime() != endDate.getTime()) {
            Date start = DateUtility.getCanonicalTime(startDate);
            Date end = DateUtility.getCanonicalTime(endDate);
            for (DateRange range : hours) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canoncialRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date startDay = DateUtility.getDayStartDate(rangeStart);
                Date finishDay = DateUtility.getDayStartDate(rangeEnd);
                if (startDay.getTime() != finishDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeEnd);
                    calendar.add(6, 1);
                    canonicalRangeEnd = calendar.getTime();
                }
                if (canoncialRangeStart.getTime() == canonicalRangeEnd.getTime() && rangeEnd.getTime() > rangeStart.getTime()) {
                    total += 86400000L;
                    continue;
                }
                total += this.getTime(start, end, canoncialRangeStart, canonicalRangeEnd);
            }
        }
        return total;
    }

    private long getTime(Date start, Date end, long target, boolean after) {
        long total = 0L;
        if (start != null && end != null) {
            int diff;
            Date startTime = DateUtility.getCanonicalTime(start);
            Date endTime = DateUtility.getCanonicalTime(end);
            Date startDay = DateUtility.getDayStartDate(start);
            Date finishDay = DateUtility.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endTime);
                calendar.add(6, 1);
                endTime = calendar.getTime();
            }
            if ((diff = DateUtility.compare(startTime, endTime, target)) == 0) {
                total = after ? endTime.getTime() - target : target - startTime.getTime();
            } else if (after && diff < 0 || !after && diff > 0) {
                total = endTime.getTime() - startTime.getTime();
            }
        }
        return total;
    }

    private long getTime(Date start, Date end) {
        long total = 0L;
        if (start != null && end != null) {
            Date startTime = DateUtility.getCanonicalTime(start);
            Date endTime = DateUtility.getCanonicalTime(end);
            Date startDay = DateUtility.getDayStartDate(start);
            Date finishDay = DateUtility.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endTime);
                calendar.add(6, 1);
                endTime = calendar.getTime();
            }
            total = endTime.getTime() - startTime.getTime();
        }
        return total;
    }

    private long getTime(Date start1, Date end1, Date start2, Date end2) {
        long end;
        long start;
        long total = 0L;
        if (start1 != null && end1 != null && start2 != null && end2 != null && (start = start1.getTime() < start2.getTime() ? start2.getTime() : start1.getTime()) < (end = end1.getTime() < end2.getTime() ? end1.getTime() : end2.getTime())) {
            total = end - start;
        }
        return total;
    }

    protected void addDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.add(calendar);
    }

    protected void removeDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.remove(calendar);
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return this.m_derivedCalendars;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.getName());
        pw.println("   baseCalendarName=" + (this.getParent() == null ? "" : this.getParent().getName()));
        pw.println("   resource=" + (this.m_resource == null ? "" : this.m_resource.getName()));
        String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        for (int loop = 0; loop < 7; ++loop) {
            pw.println("   [Day " + dayName[loop]);
            pw.println("      type=" + this.getDays()[loop]);
            pw.println("      hours=" + this.getHours()[loop]);
            pw.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            for (ProjectCalendarException ex : this.m_exceptions) {
                pw.println("      " + ex.toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }

    public ProjectCalendar(ProjectFile file, ProjectCalendar taskCalendar, ProjectCalendar resourceCalendar) {
        this.m_projectFile = file;
        this.setResource(resourceCalendar.getResource());
        block0: for (int i = 1; i <= 7; ++i) {
            Day day;
            this.setWorkingDay(day, taskCalendar.isWorkingDay(day = Day.getInstance(i)) && resourceCalendar.isWorkingDay(day));
            ProjectCalendarHours hours = this.addCalendarHours(day);
            int taskIndex = 0;
            int resourceIndex = 0;
            ProjectCalendarHours taskHours = taskCalendar.getHours(day);
            ProjectCalendarHours resourceHours = resourceCalendar.getHours(day);
            DateRange range1 = null;
            DateRange range2 = null;
            Date start = null;
            Date end = null;
            Date start1 = null;
            Date start2 = null;
            Date end1 = null;
            Date end2 = null;
            while (taskHours.getRangeCount() > taskIndex) {
                range1 = taskHours.getRange(taskIndex);
                if (resourceHours.getRangeCount() <= resourceIndex) continue block0;
                range2 = resourceHours.getRange(resourceIndex);
                start1 = range1.getStart();
                start2 = range2.getStart();
                end1 = range1.getEnd();
                end2 = range2.getEnd();
                start = start1.compareTo(start2) > 0 ? start1 : start2;
                if (end1.compareTo(end2) < 0) {
                    end = end1;
                    ++taskIndex;
                } else {
                    end = end2;
                    ++resourceIndex;
                }
                if (end == null || end.compareTo(start) <= 0) continue;
                hours.addRange(new DateRange(start, end));
            }
        }
        this.m_exceptions.addAll(taskCalendar.getCalendarExceptions());
        this.m_exceptions.addAll(resourceCalendar.getCalendarExceptions());
        this.m_exceptionsSorted = false;
    }

    public void copy(ProjectCalendar cal) {
        this.setName(cal.getName());
        this.setParent(cal.getParent());
        System.arraycopy(cal.getDays(), 0, this.getDays(), 0, this.getDays().length);
        for (ProjectCalendarException ex : cal.m_exceptions) {
            this.addCalendarException(ex.getFromDate(), ex.getToDate());
            for (DateRange range : ex) {
                ex.addRange(new DateRange(range.getStart(), range.getEnd()));
            }
        }
        for (ProjectCalendarHours hours : this.getHours()) {
            if (hours == null) continue;
            ProjectCalendarHours copyHours = cal.addCalendarHours(hours.getDay());
            for (DateRange range : hours) {
                copyHours.addRange(new DateRange(range.getStart(), range.getEnd()));
            }
        }
    }

    private void clearWorkingDateCache() {
        this.m_workingDateCache.clear();
        this.m_startTimeCache.clear();
        for (ProjectCalendar calendar : this.m_derivedCalendars) {
            calendar.clearWorkingDateCache();
        }
    }

    private ProjectCalendarDateRanges getRanges(Date date, Calendar cal, Day day) {
        ProjectCalendarDateRanges ranges = this.getException(date);
        if (ranges == null) {
            if (day == null) {
                if (cal == null) {
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                }
                day = Day.getInstance(cal.get(7));
            }
            ranges = this.getHours(day);
        }
        return ranges;
    }

    public final ProjectFile getParentFile() {
        return this.m_projectFile;
    }
}

