/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.TeamFolderAccessError;
import com.dropbox.core.v2.team.TeamFolderInvalidStatusError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TeamFolderRenameError {
    public static final TeamFolderRenameError OTHER = new TeamFolderRenameError(Tag.OTHER, null, null);
    public static final TeamFolderRenameError INVALID_FOLDER_NAME = new TeamFolderRenameError(Tag.INVALID_FOLDER_NAME, null, null);
    public static final TeamFolderRenameError FOLDER_NAME_ALREADY_USED = new TeamFolderRenameError(Tag.FOLDER_NAME_ALREADY_USED, null, null);
    public static final TeamFolderRenameError FOLDER_NAME_RESERVED = new TeamFolderRenameError(Tag.FOLDER_NAME_RESERVED, null, null);
    private final Tag _tag;
    private final TeamFolderAccessError accessErrorValue;
    private final TeamFolderInvalidStatusError statusErrorValue;

    private TeamFolderRenameError(Tag _tag, TeamFolderAccessError accessErrorValue, TeamFolderInvalidStatusError statusErrorValue) {
        this._tag = _tag;
        this.accessErrorValue = accessErrorValue;
        this.statusErrorValue = statusErrorValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static TeamFolderRenameError accessError(TeamFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderRenameError(Tag.ACCESS_ERROR, value, null);
    }

    public TeamFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isStatusError() {
        return this._tag == Tag.STATUS_ERROR;
    }

    public static TeamFolderRenameError statusError(TeamFolderInvalidStatusError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderRenameError(Tag.STATUS_ERROR, null, value);
    }

    public TeamFolderInvalidStatusError getStatusErrorValue() {
        if (this._tag != Tag.STATUS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.STATUS_ERROR, but was Tag." + this._tag.name());
        }
        return this.statusErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isInvalidFolderName() {
        return this._tag == Tag.INVALID_FOLDER_NAME;
    }

    public boolean isFolderNameAlreadyUsed() {
        return this._tag == Tag.FOLDER_NAME_ALREADY_USED;
    }

    public boolean isFolderNameReserved() {
        return this._tag == Tag.FOLDER_NAME_RESERVED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue, this.statusErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TeamFolderRenameError) {
            TeamFolderRenameError other = (TeamFolderRenameError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case STATUS_ERROR: {
                    return this.statusErrorValue == other.statusErrorValue || this.statusErrorValue.equals((Object)other.statusErrorValue);
                }
                case OTHER: {
                    return true;
                }
                case INVALID_FOLDER_NAME: {
                    return true;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    return true;
                }
                case FOLDER_NAME_RESERVED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TeamFolderRenameError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderRenameError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    TeamFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case STATUS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("status_error", g);
                    g.writeFieldName("status_error");
                    TeamFolderInvalidStatusError.Serializer.INSTANCE.serialize(value.statusErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case INVALID_FOLDER_NAME: {
                    g.writeString("invalid_folder_name");
                    break;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    g.writeString("folder_name_already_used");
                    break;
                }
                case FOLDER_NAME_RESERVED: {
                    g.writeString("folder_name_reserved");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public TeamFolderRenameError deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamFolderRenameError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                TeamFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = TeamFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderRenameError.accessError(fieldValue);
            } else if ("status_error".equals(tag)) {
                TeamFolderInvalidStatusError fieldValue = null;
                Serializer.expectField("status_error", p);
                fieldValue = TeamFolderInvalidStatusError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderRenameError.statusError(fieldValue);
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("invalid_folder_name".equals(tag)) {
                value = INVALID_FOLDER_NAME;
            } else if ("folder_name_already_used".equals(tag)) {
                value = FOLDER_NAME_ALREADY_USED;
            } else if ("folder_name_reserved".equals(tag)) {
                value = FOLDER_NAME_RESERVED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        STATUS_ERROR,
        OTHER,
        INVALID_FOLDER_NAME,
        FOLDER_NAME_ALREADY_USED,
        FOLDER_NAME_RESERVED;

    }
}

