/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkPermission;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SharedContentLinkMetadataBase {
    protected final List<LinkAudience> audienceOptions;
    protected final LinkAudience currentAudience;
    protected final Date expiry;
    protected final List<LinkPermission> linkPermissions;
    protected final boolean passwordProtected;

    public SharedContentLinkMetadataBase(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, Date expiry) {
        if (audienceOptions == null) {
            throw new IllegalArgumentException("Required value for 'audienceOptions' is null");
        }
        for (LinkAudience linkAudience : audienceOptions) {
            if (linkAudience != null) continue;
            throw new IllegalArgumentException("An item in list 'audienceOptions' is null");
        }
        this.audienceOptions = audienceOptions;
        if (currentAudience == null) {
            throw new IllegalArgumentException("Required value for 'currentAudience' is null");
        }
        this.currentAudience = currentAudience;
        this.expiry = LangUtil.truncateMillis(expiry);
        if (linkPermissions == null) {
            throw new IllegalArgumentException("Required value for 'linkPermissions' is null");
        }
        for (LinkPermission linkPermission : linkPermissions) {
            if (linkPermission != null) continue;
            throw new IllegalArgumentException("An item in list 'linkPermissions' is null");
        }
        this.linkPermissions = linkPermissions;
        this.passwordProtected = passwordProtected;
    }

    public SharedContentLinkMetadataBase(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected) {
        this(audienceOptions, currentAudience, linkPermissions, passwordProtected, null);
    }

    public List<LinkAudience> getAudienceOptions() {
        return this.audienceOptions;
    }

    public LinkAudience getCurrentAudience() {
        return this.currentAudience;
    }

    public List<LinkPermission> getLinkPermissions() {
        return this.linkPermissions;
    }

    public boolean getPasswordProtected() {
        return this.passwordProtected;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.audienceOptions, this.currentAudience, this.expiry, this.linkPermissions, this.passwordProtected});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentLinkMetadataBase other = (SharedContentLinkMetadataBase)obj;
            return !(this.audienceOptions != other.audienceOptions && !this.audienceOptions.equals(other.audienceOptions) || this.currentAudience != other.currentAudience && !this.currentAudience.equals((Object)other.currentAudience) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.passwordProtected != other.passwordProtected || this.expiry != other.expiry && (this.expiry == null || !this.expiry.equals(other.expiry)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    private static class Serializer
    extends StructSerializer<SharedContentLinkMetadataBase> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(SharedContentLinkMetadataBase value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("audience_options");
            StoneSerializers.list(LinkAudience.Serializer.INSTANCE).serialize(value.audienceOptions, g);
            g.writeFieldName("current_audience");
            LinkAudience.Serializer.INSTANCE.serialize(value.currentAudience, g);
            g.writeFieldName("link_permissions");
            StoneSerializers.list(LinkPermission.Serializer.INSTANCE).serialize(value.linkPermissions, g);
            g.writeFieldName("password_protected");
            StoneSerializers.boolean_().serialize((Boolean)value.passwordProtected, g);
            if (value.expiry != null) {
                g.writeFieldName("expiry");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expiry, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedContentLinkMetadataBase deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_expiry;
            Boolean f_passwordProtected;
            List<LinkPermission> f_linkPermissions;
            LinkAudience f_currentAudience;
            List<LinkAudience> f_audienceOptions;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_audienceOptions = null;
                f_currentAudience = null;
                f_linkPermissions = null;
                f_passwordProtected = null;
                f_expiry = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("audience_options".equals(field)) {
                        f_audienceOptions = StoneSerializers.list(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("current_audience".equals(field)) {
                        f_currentAudience = LinkAudience.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("link_permissions".equals(field)) {
                        f_linkPermissions = StoneSerializers.list(LinkPermission.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("password_protected".equals(field)) {
                        f_passwordProtected = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("expiry".equals(field)) {
                        f_expiry = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_audienceOptions == null) {
                    throw new JsonParseException(p, "Required field \"audience_options\" missing.");
                }
                if (f_currentAudience == null) {
                    throw new JsonParseException(p, "Required field \"current_audience\" missing.");
                }
                if (f_linkPermissions == null) {
                    throw new JsonParseException(p, "Required field \"link_permissions\" missing.");
                }
                if (f_passwordProtected == null) {
                    throw new JsonParseException(p, "Required field \"password_protected\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentLinkMetadataBase value = new SharedContentLinkMetadataBase(f_audienceOptions, f_currentAudience, f_linkPermissions, f_passwordProtected, f_expiry);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

