/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AddMember;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class AddFolderMemberArg {
    protected final String sharedFolderId;
    protected final List<AddMember> members;
    protected final boolean quiet;
    protected final String customMessage;

    public AddFolderMemberArg(String sharedFolderId, List<AddMember> members, boolean quiet, String customMessage) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (AddMember x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.quiet = quiet;
        if (customMessage != null && customMessage.length() < 1) {
            throw new IllegalArgumentException("String 'customMessage' is shorter than 1");
        }
        this.customMessage = customMessage;
    }

    public AddFolderMemberArg(String sharedFolderId, List<AddMember> members) {
        this(sharedFolderId, members, false, null);
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public List<AddMember> getMembers() {
        return this.members;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public static Builder newBuilder(String sharedFolderId, List<AddMember> members) {
        return new Builder(sharedFolderId, members);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.members, this.quiet, this.customMessage});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddFolderMemberArg other = (AddFolderMemberArg)obj;
            return !(this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.members != other.members && !this.members.equals(other.members) || this.quiet != other.quiet || this.customMessage != other.customMessage && (this.customMessage == null || !this.customMessage.equals(other.customMessage)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AddFolderMemberArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddFolderMemberArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("shared_folder_id");
            StoneSerializers.string().serialize(value.sharedFolderId, g);
            g.writeFieldName("members");
            StoneSerializers.list(AddMember.Serializer.INSTANCE).serialize(value.members, g);
            g.writeFieldName("quiet");
            StoneSerializers.boolean_().serialize((Boolean)value.quiet, g);
            if (value.customMessage != null) {
                g.writeFieldName("custom_message");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.customMessage, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AddFolderMemberArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_customMessage;
            Boolean f_quiet;
            List<AddMember> f_members;
            String f_sharedFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedFolderId = null;
                f_members = null;
                f_quiet = false;
                f_customMessage = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(AddMember.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("quiet".equals(field)) {
                        f_quiet = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("custom_message".equals(field)) {
                        f_customMessage = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"shared_folder_id\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AddFolderMemberArg value = new AddFolderMemberArg(f_sharedFolderId, f_members, f_quiet, f_customMessage);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String sharedFolderId;
        protected final List<AddMember> members;
        protected boolean quiet;
        protected String customMessage;

        protected Builder(String sharedFolderId, List<AddMember> members) {
            if (sharedFolderId == null) {
                throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            for (AddMember x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            this.quiet = false;
            this.customMessage = null;
        }

        public Builder withQuiet(Boolean quiet) {
            this.quiet = quiet != null ? quiet : false;
            return this;
        }

        public Builder withCustomMessage(String customMessage) {
            if (customMessage != null && customMessage.length() < 1) {
                throw new IllegalArgumentException("String 'customMessage' is shorter than 1");
            }
            this.customMessage = customMessage;
            return this;
        }

        public AddFolderMemberArg build() {
            return new AddFolderMemberArg(this.sharedFolderId, this.members, this.quiet, this.customMessage);
        }
    }
}

