/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberSelector;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class AddFileMemberArgs {
    protected final String file;
    protected final List<MemberSelector> members;
    protected final String customMessage;
    protected final boolean quiet;
    protected final AccessLevel accessLevel;
    protected final boolean addMessageAsComment;

    public AddFileMemberArgs(String file, List<MemberSelector> members, String customMessage, boolean quiet, AccessLevel accessLevel, boolean addMessageAsComment) {
        if (file == null) {
            throw new IllegalArgumentException("Required value for 'file' is null");
        }
        if (file.length() < 1) {
            throw new IllegalArgumentException("String 'file' is shorter than 1");
        }
        if (!Pattern.matches("((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?", file)) {
            throw new IllegalArgumentException("String 'file' does not match pattern");
        }
        this.file = file;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (MemberSelector x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.customMessage = customMessage;
        this.quiet = quiet;
        if (accessLevel == null) {
            throw new IllegalArgumentException("Required value for 'accessLevel' is null");
        }
        this.accessLevel = accessLevel;
        this.addMessageAsComment = addMessageAsComment;
    }

    public AddFileMemberArgs(String file, List<MemberSelector> members) {
        this(file, members, null, false, AccessLevel.VIEWER, false);
    }

    public String getFile() {
        return this.file;
    }

    public List<MemberSelector> getMembers() {
        return this.members;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public boolean getAddMessageAsComment() {
        return this.addMessageAsComment;
    }

    public static Builder newBuilder(String file, List<MemberSelector> members) {
        return new Builder(file, members);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.file, this.members, this.customMessage, this.quiet, this.accessLevel, this.addMessageAsComment});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddFileMemberArgs other = (AddFileMemberArgs)obj;
            return !(this.file != other.file && !this.file.equals(other.file) || this.members != other.members && !this.members.equals(other.members) || this.customMessage != other.customMessage && (this.customMessage == null || !this.customMessage.equals(other.customMessage)) || this.quiet != other.quiet || this.accessLevel != other.accessLevel && !this.accessLevel.equals((Object)other.accessLevel) || this.addMessageAsComment != other.addMessageAsComment);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AddFileMemberArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddFileMemberArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file");
            StoneSerializers.string().serialize(value.file, g);
            g.writeFieldName("members");
            StoneSerializers.list(MemberSelector.Serializer.INSTANCE).serialize(value.members, g);
            if (value.customMessage != null) {
                g.writeFieldName("custom_message");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.customMessage, g);
            }
            g.writeFieldName("quiet");
            StoneSerializers.boolean_().serialize((Boolean)value.quiet, g);
            g.writeFieldName("access_level");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessLevel, g);
            g.writeFieldName("add_message_as_comment");
            StoneSerializers.boolean_().serialize((Boolean)value.addMessageAsComment, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AddFileMemberArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_addMessageAsComment;
            AccessLevel f_accessLevel;
            Boolean f_quiet;
            String f_customMessage;
            List<MemberSelector> f_members;
            String f_file;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_file = null;
                f_members = null;
                f_customMessage = null;
                f_quiet = false;
                f_accessLevel = AccessLevel.VIEWER;
                f_addMessageAsComment = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file".equals(field)) {
                        f_file = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(MemberSelector.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("custom_message".equals(field)) {
                        f_customMessage = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("quiet".equals(field)) {
                        f_quiet = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("access_level".equals(field)) {
                        f_accessLevel = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("add_message_as_comment".equals(field)) {
                        f_addMessageAsComment = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_file == null) {
                    throw new JsonParseException(p, "Required field \"file\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AddFileMemberArgs value = new AddFileMemberArgs(f_file, f_members, f_customMessage, f_quiet, f_accessLevel, f_addMessageAsComment);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String file;
        protected final List<MemberSelector> members;
        protected String customMessage;
        protected boolean quiet;
        protected AccessLevel accessLevel;
        protected boolean addMessageAsComment;

        protected Builder(String file, List<MemberSelector> members) {
            if (file == null) {
                throw new IllegalArgumentException("Required value for 'file' is null");
            }
            if (file.length() < 1) {
                throw new IllegalArgumentException("String 'file' is shorter than 1");
            }
            if (!Pattern.matches("((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?", file)) {
                throw new IllegalArgumentException("String 'file' does not match pattern");
            }
            this.file = file;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            for (MemberSelector x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            this.customMessage = null;
            this.quiet = false;
            this.accessLevel = AccessLevel.VIEWER;
            this.addMessageAsComment = false;
        }

        public Builder withCustomMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public Builder withQuiet(Boolean quiet) {
            this.quiet = quiet != null ? quiet : false;
            return this;
        }

        public Builder withAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel != null ? accessLevel : AccessLevel.VIEWER;
            return this;
        }

        public Builder withAddMessageAsComment(Boolean addMessageAsComment) {
            this.addMessageAsComment = addMessageAsComment != null ? addMessageAsComment : false;
            return this;
        }

        public AddFileMemberArgs build() {
            return new AddFileMemberArgs(this.file, this.members, this.customMessage, this.quiet, this.accessLevel, this.addMessageAsComment);
        }
    }
}

