/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.properties.PropertyField;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class PropertyGroupUpdate {
    protected final String templateId;
    protected final List<PropertyField> addOrUpdateFields;
    protected final List<String> removeFields;

    public PropertyGroupUpdate(String templateId, List<PropertyField> addOrUpdateFields, List<String> removeFields) {
        if (templateId == null) {
            throw new IllegalArgumentException("Required value for 'templateId' is null");
        }
        if (templateId.length() < 1) {
            throw new IllegalArgumentException("String 'templateId' is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", templateId)) {
            throw new IllegalArgumentException("String 'templateId' does not match pattern");
        }
        this.templateId = templateId;
        if (addOrUpdateFields != null) {
            for (PropertyField propertyField : addOrUpdateFields) {
                if (propertyField != null) continue;
                throw new IllegalArgumentException("An item in list 'addOrUpdateFields' is null");
            }
        }
        this.addOrUpdateFields = addOrUpdateFields;
        if (removeFields != null) {
            for (String string : removeFields) {
                if (string != null) continue;
                throw new IllegalArgumentException("An item in list 'removeFields' is null");
            }
        }
        this.removeFields = removeFields;
    }

    public PropertyGroupUpdate(String templateId) {
        this(templateId, null, null);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public List<PropertyField> getAddOrUpdateFields() {
        return this.addOrUpdateFields;
    }

    public List<String> getRemoveFields() {
        return this.removeFields;
    }

    public static Builder newBuilder(String templateId) {
        return new Builder(templateId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.templateId, this.addOrUpdateFields, this.removeFields});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            PropertyGroupUpdate other = (PropertyGroupUpdate)obj;
            return (this.templateId == other.templateId || this.templateId.equals(other.templateId)) && (this.addOrUpdateFields == other.addOrUpdateFields || this.addOrUpdateFields != null && this.addOrUpdateFields.equals(other.addOrUpdateFields)) && (this.removeFields == other.removeFields || this.removeFields != null && this.removeFields.equals(other.removeFields));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PropertyGroupUpdate> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertyGroupUpdate value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("template_id");
            StoneSerializers.string().serialize(value.templateId, g);
            if (value.addOrUpdateFields != null) {
                g.writeFieldName("add_or_update_fields");
                StoneSerializers.nullable(StoneSerializers.list(PropertyField.Serializer.INSTANCE)).serialize(value.addOrUpdateFields, g);
            }
            if (value.removeFields != null) {
                g.writeFieldName("remove_fields");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.removeFields, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PropertyGroupUpdate deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_removeFields;
            List<PropertyField> f_addOrUpdateFields;
            String f_templateId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_templateId = null;
                f_addOrUpdateFields = null;
                f_removeFields = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("template_id".equals(field)) {
                        f_templateId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("add_or_update_fields".equals(field)) {
                        f_addOrUpdateFields = StoneSerializers.nullable(StoneSerializers.list(PropertyField.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("remove_fields".equals(field)) {
                        f_removeFields = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_templateId == null) {
                    throw new JsonParseException(p, "Required field \"template_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PropertyGroupUpdate value = new PropertyGroupUpdate(f_templateId, f_addOrUpdateFields, f_removeFields);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String templateId;
        protected List<PropertyField> addOrUpdateFields;
        protected List<String> removeFields;

        protected Builder(String templateId) {
            if (templateId == null) {
                throw new IllegalArgumentException("Required value for 'templateId' is null");
            }
            if (templateId.length() < 1) {
                throw new IllegalArgumentException("String 'templateId' is shorter than 1");
            }
            if (!Pattern.matches("(/|ptid:).*", templateId)) {
                throw new IllegalArgumentException("String 'templateId' does not match pattern");
            }
            this.templateId = templateId;
            this.addOrUpdateFields = null;
            this.removeFields = null;
        }

        public Builder withAddOrUpdateFields(List<PropertyField> addOrUpdateFields) {
            if (addOrUpdateFields != null) {
                for (PropertyField x : addOrUpdateFields) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'addOrUpdateFields' is null");
                }
            }
            this.addOrUpdateFields = addOrUpdateFields;
            return this;
        }

        public Builder withRemoveFields(List<String> removeFields) {
            if (removeFields != null) {
                for (String x : removeFields) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'removeFields' is null");
                }
            }
            this.removeFields = removeFields;
            return this;
        }

        public PropertyGroupUpdate build() {
            return new PropertyGroupUpdate(this.templateId, this.addOrUpdateFields, this.removeFields);
        }
    }
}

