/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.DeleteBatchError;
import com.dropbox.core.v2.files.DeleteBatchResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class DeleteBatchJobStatus {
    public static final DeleteBatchJobStatus IN_PROGRESS = new DeleteBatchJobStatus(Tag.IN_PROGRESS, null, null);
    public static final DeleteBatchJobStatus OTHER = new DeleteBatchJobStatus(Tag.OTHER, null, null);
    private final Tag _tag;
    private final DeleteBatchResult completeValue;
    private final DeleteBatchError failedValue;

    private DeleteBatchJobStatus(Tag _tag, DeleteBatchResult completeValue, DeleteBatchError failedValue) {
        this._tag = _tag;
        this.completeValue = completeValue;
        this.failedValue = failedValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static DeleteBatchJobStatus complete(DeleteBatchResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteBatchJobStatus(Tag.COMPLETE, value, null);
    }

    public DeleteBatchResult getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static DeleteBatchJobStatus failed(DeleteBatchError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteBatchJobStatus(Tag.FAILED, null, value);
    }

    public DeleteBatchError getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DeleteBatchJobStatus) {
            DeleteBatchJobStatus other = (DeleteBatchJobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals((Object)other.failedValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<DeleteBatchJobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteBatchJobStatus value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    DeleteBatchResult.Serializer.INSTANCE.serialize(value.completeValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    this.writeTag("failed", g);
                    g.writeFieldName("failed");
                    DeleteBatchError.Serializer.INSTANCE.serialize(value.failedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public DeleteBatchJobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            DeleteBatchJobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                DeleteBatchResult fieldValue = null;
                fieldValue = DeleteBatchResult.Serializer.INSTANCE.deserialize(p, true);
                value = DeleteBatchJobStatus.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                DeleteBatchError fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = DeleteBatchError.Serializer.INSTANCE.deserialize(p);
                value = DeleteBatchJobStatus.failed(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED,
        OTHER;

    }
}

