/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.BadRequestException;
import com.dropbox.core.BadResponseCodeException;
import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSdkVersion;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.RateLimitException;
import com.dropbox.core.RetryException;
import com.dropbox.core.ServerException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class DbxRequestUtil {
    private static final Random RAND = new Random();

    public static String encodeUrlParam(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw LangUtil.mkAssert("UTF-8 should always be supported", ex);
        }
    }

    public static String buildUrlWithParams(String userLocale, String host, String path, String[] params) {
        return DbxRequestUtil.buildUri(host, path) + "?" + DbxRequestUtil.encodeUrlParams(userLocale, params);
    }

    static String[] toParamsArray(Map<String, String> params) {
        String[] arr = new String[2 * params.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            arr[i] = entry.getKey();
            arr[i + 1] = entry.getValue();
            i += 2;
        }
        return arr;
    }

    public static String buildUri(String host, String path) {
        try {
            return new URI("https", host, "/" + path, null).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw LangUtil.mkAssert("URI creation failed, host=" + StringUtil.jq(host) + ", path=" + StringUtil.jq(path), ex);
        }
    }

    private static String encodeUrlParams(String userLocale, String[] params) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (userLocale != null) {
            buf.append("locale=").append(userLocale);
            sep = "&";
        }
        if (params != null) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("'params.length' is " + params.length + "; expecting a multiple of two");
            }
            for (int i = 0; i < params.length; i += 2) {
                String key = params[i];
                String value = params[i + 1];
                if (key == null) {
                    throw new IllegalArgumentException("params[" + i + "] is null");
                }
                if (value == null) continue;
                buf.append(sep);
                sep = "&";
                buf.append(DbxRequestUtil.encodeUrlParam(key));
                buf.append("=");
                buf.append(DbxRequestUtil.encodeUrlParam(value));
            }
        }
        return buf.toString();
    }

    public static List<HttpRequestor.Header> addAuthHeader(List<HttpRequestor.Header> headers, String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken");
        }
        if (headers == null) {
            headers = new ArrayList<HttpRequestor.Header>();
        }
        headers.add(new HttpRequestor.Header("Authorization", "Bearer " + accessToken));
        return headers;
    }

    public static List<HttpRequestor.Header> addSelectUserHeader(List<HttpRequestor.Header> headers, String memberId) {
        if (memberId == null) {
            throw new NullPointerException("memberId");
        }
        if (headers == null) {
            headers = new ArrayList<HttpRequestor.Header>();
        }
        headers.add(new HttpRequestor.Header("Dropbox-API-Select-User", memberId));
        return headers;
    }

    public static List<HttpRequestor.Header> addBasicAuthHeader(List<HttpRequestor.Header> headers, String username, String password) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (headers == null) {
            headers = new ArrayList<HttpRequestor.Header>();
        }
        String credentials = username + ":" + password;
        String base64Credentials = StringUtil.base64Encode(StringUtil.stringToUtf8(credentials));
        headers.add(new HttpRequestor.Header("Authorization", "Basic " + base64Credentials));
        return headers;
    }

    public static List<HttpRequestor.Header> addUserAgentHeader(List<HttpRequestor.Header> headers, DbxRequestConfig requestConfig, String sdkUserAgentIdentifier) {
        if (headers == null) {
            headers = new ArrayList<HttpRequestor.Header>();
        }
        headers.add(DbxRequestUtil.buildUserAgentHeader(requestConfig, sdkUserAgentIdentifier));
        return headers;
    }

    public static List<HttpRequestor.Header> addUserLocaleHeader(List<HttpRequestor.Header> headers, DbxRequestConfig requestConfig) {
        if (requestConfig.getUserLocale() == null) {
            return headers;
        }
        if (headers == null) {
            headers = new ArrayList<HttpRequestor.Header>();
        }
        headers.add(new HttpRequestor.Header("Dropbox-API-User-Locale", requestConfig.getUserLocale()));
        return headers;
    }

    public static HttpRequestor.Header buildUserAgentHeader(DbxRequestConfig requestConfig, String sdkUserAgentIdentifier) {
        return new HttpRequestor.Header("User-Agent", requestConfig.getClientIdentifier() + " " + sdkUserAgentIdentifier + "/" + DbxSdkVersion.Version);
    }

    public static HttpRequestor.Response startGet(DbxRequestConfig requestConfig, String accessToken, String sdkUserAgentIdentifier, String host, String path, String[] params, List<HttpRequestor.Header> headers) throws NetworkIOException {
        headers = DbxRequestUtil.copyHeaders(headers);
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig, sdkUserAgentIdentifier);
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        String url = DbxRequestUtil.buildUrlWithParams(requestConfig.getUserLocale(), host, path, params);
        try {
            return requestConfig.getHttpRequestor().doGet(url, headers);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public static HttpRequestor.Uploader startPut(DbxRequestConfig requestConfig, String accessToken, String sdkUserAgentIdentifier, String host, String path, String[] params, List<HttpRequestor.Header> headers) throws NetworkIOException {
        headers = DbxRequestUtil.copyHeaders(headers);
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig, sdkUserAgentIdentifier);
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        String url = DbxRequestUtil.buildUrlWithParams(requestConfig.getUserLocale(), host, path, params);
        try {
            return requestConfig.getHttpRequestor().startPut(url, headers);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public static HttpRequestor.Response startPostNoAuth(DbxRequestConfig requestConfig, String sdkUserAgentIdentifier, String host, String path, String[] params, List<HttpRequestor.Header> headers) throws NetworkIOException {
        byte[] encodedParams = StringUtil.stringToUtf8(DbxRequestUtil.encodeUrlParams(requestConfig.getUserLocale(), params));
        headers = DbxRequestUtil.copyHeaders(headers);
        headers.add(new HttpRequestor.Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        return DbxRequestUtil.startPostRaw(requestConfig, sdkUserAgentIdentifier, host, path, encodedParams, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequestor.Response startPostRaw(DbxRequestConfig requestConfig, String sdkUserAgentIdentifier, String host, String path, byte[] body, List<HttpRequestor.Header> headers) throws NetworkIOException {
        String uri = DbxRequestUtil.buildUri(host, path);
        headers = DbxRequestUtil.copyHeaders(headers);
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig, sdkUserAgentIdentifier);
        headers.add(new HttpRequestor.Header("Content-Length", Integer.toString(body.length)));
        HttpRequestor.Uploader uploader = requestConfig.getHttpRequestor().startPost(uri, headers);
        try {
            uploader.upload(body);
            HttpRequestor.Response response = uploader.finish();
            uploader.close();
            return response;
        }
        catch (Throwable throwable) {
            try {
                uploader.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
        }
    }

    private static List<HttpRequestor.Header> copyHeaders(List<HttpRequestor.Header> headers) {
        if (headers == null) {
            return new ArrayList<HttpRequestor.Header>();
        }
        return new ArrayList<HttpRequestor.Header>(headers);
    }

    public static byte[] loadErrorBody(HttpRequestor.Response response) throws NetworkIOException {
        if (response.getBody() == null) {
            return new byte[0];
        }
        try {
            return IOUtil.slurp(response.getBody(), 4096);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public static String parseErrorBody(String requestId, int statusCode, byte[] body) throws BadResponseException {
        try {
            return StringUtil.utf8ToString(body);
        }
        catch (CharacterCodingException e) {
            throw new BadResponseException(requestId, "Got non-UTF8 response body: " + statusCode + ": " + e.getMessage());
        }
    }

    public static DbxException unexpectedStatus(HttpRequestor.Response response) throws NetworkIOException, BadResponseException {
        String requestId = DbxRequestUtil.getRequestId(response);
        byte[] body = DbxRequestUtil.loadErrorBody(response);
        String message = DbxRequestUtil.parseErrorBody(requestId, response.getStatusCode(), body);
        switch (response.getStatusCode()) {
            case 400: {
                return new BadRequestException(requestId, message);
            }
            case 401: {
                return new InvalidAccessTokenException(requestId, message);
            }
            case 429: {
                try {
                    int backoffSecs = Integer.parseInt(DbxRequestUtil.getFirstHeader(response, "Retry-After"));
                    return new RateLimitException(requestId, message, backoffSecs, TimeUnit.SECONDS);
                }
                catch (NumberFormatException ex) {
                    return new BadResponseException(requestId, "Invalid value for HTTP header: \"Retry-After\"");
                }
            }
            case 500: {
                return new ServerException(requestId, message);
            }
            case 503: {
                String retryAfter = DbxRequestUtil.getFirstHeaderMaybe(response, "Retry-After");
                try {
                    if (retryAfter != null && !retryAfter.trim().isEmpty()) {
                        int backoffSecs = Integer.parseInt(retryAfter);
                        return new RetryException(requestId, message, backoffSecs, TimeUnit.SECONDS);
                    }
                    return new RetryException(requestId, message);
                }
                catch (NumberFormatException ex) {
                    return new BadResponseException(requestId, "Invalid value for HTTP header: \"Retry-After\"");
                }
            }
        }
        return new BadResponseCodeException(requestId, "unexpected HTTP status code: " + response.getStatusCode() + ": " + message, response.getStatusCode());
    }

    public static <T> T readJsonFromResponse(JsonReader<T> reader, HttpRequestor.Response response) throws BadResponseException, NetworkIOException {
        try {
            return reader.readFully(response.getBody());
        }
        catch (JsonReadException ex) {
            String requestId = DbxRequestUtil.getRequestId(response);
            throw new BadResponseException(requestId, "error in response JSON: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public static <T> T doGet(final DbxRequestConfig requestConfig, final String accessToken, final String sdkUserAgentIdentifier, final String host, final String path, final String[] params, final List<HttpRequestor.Header> headers, final ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.runAndRetry(requestConfig.getMaxRetries(), new RequestMaker<T, DbxException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T run() throws DbxException {
                HttpRequestor.Response response = DbxRequestUtil.startGet(requestConfig, accessToken, sdkUserAgentIdentifier, host, path, params, headers);
                try {
                    Object t = handler.handle(response);
                    return t;
                }
                finally {
                    try {
                        response.getBody().close();
                    }
                    catch (IOException ex) {
                        throw new NetworkIOException(ex);
                    }
                }
            }
        });
    }

    public static <T> T doPost(DbxRequestConfig requestConfig, String accessToken, String sdkUserAgentIdentifier, String host, String path, String[] params, List<HttpRequestor.Header> headers, ResponseHandler<T> handler) throws DbxException {
        headers = DbxRequestUtil.copyHeaders(headers);
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        return DbxRequestUtil.doPostNoAuth(requestConfig, sdkUserAgentIdentifier, host, path, params, headers, handler);
    }

    public static <T> T doPostNoAuth(final DbxRequestConfig requestConfig, final String sdkUserAgentIdentifier, final String host, final String path, final String[] params, final List<HttpRequestor.Header> headers, final ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.runAndRetry(requestConfig.getMaxRetries(), new RequestMaker<T, DbxException>(){

            @Override
            public T run() throws DbxException {
                HttpRequestor.Response response = DbxRequestUtil.startPostNoAuth(requestConfig, sdkUserAgentIdentifier, host, path, params, headers);
                return DbxRequestUtil.finishResponse(response, handler);
            }
        });
    }

    public static <T> T finishResponse(HttpRequestor.Response response, ResponseHandler<T> handler) throws DbxException {
        try {
            T t = handler.handle(response);
            return t;
        }
        finally {
            IOUtil.closeInput(response.getBody());
        }
    }

    public static String getFirstHeader(HttpRequestor.Response response, String name) throws BadResponseException {
        List<String> values = response.getHeaders().get(name);
        if (values == null || values.isEmpty()) {
            throw new BadResponseException(DbxRequestUtil.getRequestId(response), "missing HTTP header \"" + name + "\"");
        }
        return values.get(0);
    }

    public static String getFirstHeaderMaybe(HttpRequestor.Response response, String name) {
        List<String> values = response.getHeaders().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public static String getRequestId(HttpRequestor.Response response) {
        return DbxRequestUtil.getFirstHeaderMaybe(response, "X-Dropbox-Request-Id");
    }

    public static <T, E extends Throwable> T runAndRetry(int maxRetries, RequestMaker<T, E> requestMaker) throws DbxException, E {
        int numRetries = 0;
        while (true) {
            long backoff;
            DbxException thrown = null;
            try {
                return requestMaker.run();
            }
            catch (RetryException ex) {
                backoff = ex.getBackoffMillis();
                thrown = ex;
            }
            catch (ServerException ex) {
                backoff = 0L;
                thrown = ex;
            }
            if (numRetries >= maxRetries) {
                throw thrown;
            }
            if ((backoff += (long)RAND.nextInt(1000)) > 0L) {
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            ++numRetries;
        }
    }

    public static abstract class RequestMaker<T, E extends Throwable> {
        public abstract T run() throws DbxException, E;
    }

    public static abstract class ResponseHandler<T> {
        public abstract T handle(HttpRequestor.Response var1) throws DbxException;
    }
}

