/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.WordComparator;
import com.wintertree.util.UniCharacter;

public class TypographicalComparator
implements WordComparator {
    private boolean isAccented;
    static final int CASE_MISMATCH_PENALTY = 5;
    static final int ACCENT_MISMATCH_PENALTY = 10;
    static final int DOUBLE_CONSONANT_INS_DEL_PENALTY = 20;
    static final int DOUBLE_VOWEL_INS_DEL_PENALTY = 25;
    static final int VOWEL_TRANSPOSITION_PENALTY = 20;
    static final int CONSONANT_TRANSPOSITION_PENALTY = 25;
    static final int TRANSPOSITION_PENALTY = 25;
    static final int INS_DEL_PENALTY = 50;
    static final int SUBSTITUTE_PENALTY = 100;
    static final int EXACT_MATCH_SCORE = 100;
    static final int FIRST_BASE = 65;
    private static final short[][] charSimTbl = new short[][]{{100, 0, 5, 15, 40, 0, 0, 0, 20, 0, 0, 0, 0, 0, 40, 0, 40, 0, 20, 0, 20, 0, 20, 0, 0, 0}, {0, 100, 0, 15, 0, 5, 10, 15, 0, 0, 0, 5, 0, 20, 10, 20, 5, 0, 0, 10, 0, 20, 0, 0, 0, 0}, {5, 0, 100, 20, 20, 10, 0, 0, 0, 0, 20, 0, 0, 0, 10, 0, 20, 0, 10, 0, 0, 20, 0, 20, 0, 20}, {15, 15, 20, 100, 10, 20, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5, 5, 5, 20, 20, 0, 0, 5, 10, 0, 0}, {40, 0, 20, 10, 100, 0, 0, 0, 20, 0, 0, 0, 0, 0, 40, 0, 0, 20, 10, 5, 20, 0, 20, 0, 5, 0}, {0, 5, 10, 20, 0, 100, 20, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 10, 10, 10, 0, 30, 0, 0, 0, 0}, {0, 10, 0, 0, 0, 20, 100, 20, 0, 20, 0, 0, 0, 0, 0, 0, 5, 5, 0, 10, 0, 10, 0, 0, 5, 0}, {0, 15, 0, 0, 0, 0, 20, 100, 0, 20, 20, 10, 0, 10, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 10, 0}, {20, 0, 0, 0, 20, 5, 0, 0, 100, 25, 10, 25, 0, 0, 40, 0, 0, 0, 0, 5, 40, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 20, 20, 25, 100, 20, 0, 10, 10, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0}, {0, 0, 20, 0, 0, 0, 0, 20, 10, 20, 100, 30, 10, 0, 5, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 5, 0, 5, 0, 0, 0, 10, 25, 0, 30, 100, 0, 0, 5, 0, 0, 5, 0, 20, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 0, 100, 60, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0}, {0, 20, 0, 0, 0, 0, 0, 10, 0, 10, 0, 0, 60, 100, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0}, {40, 10, 10, 5, 40, 0, 0, 0, 40, 0, 5, 0, 0, 0, 100, 30, 20, 0, 0, 0, 20, 0, 10, 0, 0, 0}, {0, 20, 0, 5, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 30, 100, 20, 0, 0, 20, 0, 0, 0, 0, 0, 0}, {40, 5, 20, 5, 0, 0, 5, 0, 0, 0, 20, 0, 0, 0, 20, 20, 100, 0, 0, 0, 0, 0, 20, 0, 0, 0}, {0, 0, 0, 5, 20, 10, 5, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 100, 0, 20, 0, 0, 0, 0, 0, 0}, {20, 0, 10, 20, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 10, 20, 0, 25}, {0, 10, 20, 5, 10, 10, 0, 0, 5, 0, 0, 20, 0, 0, 0, 20, 0, 20, 0, 100, 0, 0, 0, 0, 20, 0}, {20, 0, 0, 0, 20, 0, 0, 5, 40, 10, 0, 0, 0, 20, 20, 0, 0, 0, 0, 0, 100, 20, 10, 0, 20, 0}, {0, 20, 20, 0, 0, 30, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 100, 20, 0, 10, 0}, {20, 0, 0, 5, 20, 0, 0, 0, 0, 0, 0, 0, 10, 0, 10, 0, 20, 0, 10, 0, 10, 20, 100, 0, 0, 0}, {0, 0, 20, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 100, 0, 20}, {0, 0, 0, 0, 5, 0, 5, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 10, 0, 0, 100, 0}, {0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 20, 0, 100}};

    public TypographicalComparator() {
        this.isAccented = false;
    }

    public TypographicalComparator(boolean bl) {
        this.isAccented = bl;
    }

    public int compare(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < string.length() && n4 < string2.length()) {
            char c;
            ++n2;
            char c2 = string.charAt(n3);
            if (c2 != (c = string2.charAt(n4))) {
                char c3;
                char c4;
                char c5 = '\u0000';
                char c6 = '\u0000';
                if (this.isAccented || !UniCharacter.isASCII(c2) || !UniCharacter.isASCII(c)) {
                    c4 = UniCharacter.toBase(c2);
                    c3 = UniCharacter.toBase(c);
                } else {
                    c4 = Character.toUpperCase(c2);
                    c3 = Character.toUpperCase(c);
                }
                if (c4 == c3) {
                    if (UniCharacter.isLowerCase(c2) != UniCharacter.isLowerCase(c)) {
                        n += 95;
                    }
                    if (Character.toLowerCase(c2) != Character.toLowerCase(c)) {
                        n += 90;
                    }
                    ++n3;
                    ++n4;
                    continue;
                }
                if (this.isAccented) {
                    if (n3 + 1 < string.length()) {
                        c5 = UniCharacter.toBase(string.charAt(n3 + 1));
                    }
                    if (n4 + 1 < string2.length()) {
                        c6 = UniCharacter.toBase(string2.charAt(n4 + 1));
                    }
                } else {
                    char c7;
                    if (n3 + 1 < string.length()) {
                        c7 = string.charAt(n3 + 1);
                        c5 = UniCharacter.isASCII(c7) ? Character.toUpperCase(c7) : UniCharacter.toBase(c7);
                    }
                    if (n4 + 1 < string2.length()) {
                        c7 = string2.charAt(n4 + 1);
                        c6 = UniCharacter.isASCII(c7) ? Character.toUpperCase(string2.charAt(n4 + 1)) : UniCharacter.toBase(c7);
                    }
                }
                if (c5 != '\u0000' && c6 != '\u0000' && c3 == c5 && c6 == c4) {
                    n = UniCharacter.isVowel(c4) && UniCharacter.isVowel(c3) ? (n += 160) : (!UniCharacter.isVowel(c4) && !UniCharacter.isVowel(c3) ? (n += 150) : (n += 150));
                    n3 += 2;
                    n4 += 2;
                    ++n2;
                    continue;
                }
                if (c5 != '\u0000' && c3 == c5) {
                    n = n3 > 0 && n4 > 0 && c2 == string.charAt(n3 - 1) && c2 == string2.charAt(n4 - 1) ? (UniCharacter.isVowel(c2) ? (n += 75) : (n += 80)) : (n += 50);
                    ++n3;
                    continue;
                }
                if (c6 != '\u0000' && c4 == c6) {
                    n = n3 > 0 && n4 > 0 && c == string2.charAt(n4 - 1) && c == string.charAt(n3 - 1) ? (UniCharacter.isVowel(c) ? (n += 75) : (n += 80)) : (n += 50);
                    ++n4;
                    continue;
                }
                if (c4 >= 'A' && c4 - 65 < charSimTbl.length && c3 >= 'A' && c3 - 65 < charSimTbl[0].length) {
                    n += charSimTbl[c4 - 65][c3 - 65];
                    ++n3;
                    ++n4;
                    continue;
                }
                n += 0;
                ++n3;
                ++n4;
                continue;
            }
            n += 100;
            ++n3;
            ++n4;
        }
        if (n <= 0) {
            return 0;
        }
        while (n3++ < string.length()) {
            n += 50;
            ++n2;
        }
        while (n4++ < string2.length()) {
            n += 50;
            ++n2;
        }
        if (n <= 0 || n2 <= 0) {
            return 0;
        }
        return n / n2;
    }
}

