/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.util.NoSuchElementException;

public class StringWordParser
implements WordParser {
    protected int cursor = 0;
    protected boolean is1stWord = true;
    protected boolean isHyphenDelimiter;
    protected int nReplacements;
    protected int nWords;
    protected StringBuffer theString;
    protected int subWordLength;
    protected StringBuffer cachedWord;

    public StringWordParser(String string, boolean bl) {
        this.isHyphenDelimiter = bl;
        this.nReplacements = 0;
        this.nWords = 0;
        this.theString = string != null ? new StringBuffer(string) : null;
        this.subWordLength = -1;
        this.cachedWord = new StringBuffer();
    }

    public StringWordParser(boolean bl) {
        this(null, bl);
    }

    public void deleteText(int n) throws NoSuchElementException {
        if (n > this.theString.length() - this.cursor) {
            throw new NoSuchElementException();
        }
        String string = this.theString.toString().substring(this.cursor + n);
        this.theString.setLength(this.cursor);
        this.theString.append(string);
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public int deleteWord() throws NoSuchElementException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.deleteWord(stringBuffer);
    }

    public int deleteWord(StringBuffer stringBuffer) throws NoSuchElementException {
        int n;
        for (n = this.cursor; n > 0 && UniCharacter.isWhitespace(this.theString.charAt(n - 1)); --n) {
        }
        String string = this.getWord();
        int n2 = this.cursor - n + string.length();
        stringBuffer.setLength(0);
        stringBuffer.append(this.theString.toString().substring(n, n + n2));
        this.cursor = n;
        this.deleteText(n2);
        while (this.cursor < this.theString.length() && UniCharacter.isWhitespace(this.theString.charAt(this.cursor))) {
            ++this.cursor;
        }
        return n;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getNumReplacements() {
        return this.nReplacements;
    }

    public int getNumWords() {
        return this.nWords;
    }

    public String getWord() throws NoSuchElementException {
        char c;
        int n;
        char c2;
        if (this.cachedWord.length() > 0) {
            return this.cachedWord.toString();
        }
        int n2 = this.findWordStart();
        if (n2 != this.cursor) {
            this.cursor = n2;
            this.subWordLength = -1;
            this.cachedWord.setLength(0);
        }
        if (this.subWordLength > 0 && this.cursor + this.subWordLength < this.theString.length()) {
            this.cachedWord.setLength(0);
            this.cachedWord.append(this.theString.toString().substring(this.cursor, this.cursor + this.subWordLength));
            return this.cachedWord.toString();
        }
        int n3 = this.theString.length();
        if (this.cursor >= n3) {
            throw new NoSuchElementException();
        }
        this.cachedWord.setLength(0);
        int n4 = 0;
        for (n2 = this.cursor; n2 < n3; ++n2) {
            c2 = this.theString.charAt(n2);
            if (c2 == '.' && StringWordParser.isSurroundedByWordChars(this.theString, n2)) {
                ++n4;
            }
            if (!this.includeCharInWord(this.theString, n2, n4 > 0)) break;
            this.cachedWord.append(c2);
        }
        c2 = '\u0001';
        if (n4 > 0) {
            n = 0;
            for (c = '\u0000'; c < this.cachedWord.length(); ++c) {
                if (UniCharacter.isLetterOrDigit(this.cachedWord.charAt(c))) {
                    if (++n <= 2) continue;
                    c2 = '\u0000';
                    break;
                }
                n = 0;
            }
            if (c2 != '\u0000' && n2 < n3 && this.theString.charAt(n2) == '.') {
                this.cachedWord.append(this.theString.charAt(n2));
                ++n4;
                ++n2;
            }
        }
        if (this.cachedWord.length() == 0) {
            return this.cachedWord.toString();
        }
        n = 0;
        do {
            c = this.cachedWord.charAt(this.cachedWord.length() - 1);
            n = 0;
            if (UniCharacter.isApostrophe(c) && this.cachedWord.length() > 1 && Character.toLowerCase(this.cachedWord.charAt(this.cachedWord.length() - 2)) != 's') {
                this.cachedWord.setLength(this.cachedWord.length() - 1);
                n = 1;
            }
            if (c != '.' || c2 != '\u0000' && n4 != 1) continue;
            this.cachedWord.setLength(this.cachedWord.length() - 1);
            n = 1;
        } while (n != 0);
        return this.cachedWord.toString();
    }

    public boolean hasMoreElements() {
        boolean bl = true;
        try {
            String string = this.getWord();
            if (string.length() == 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void highlightWord() {
    }

    public void insertText(int n, String string) {
        this.theString.insert(n, string);
    }

    public boolean isDoubledWord(boolean bl) {
        String string = this.getWord();
        String string2 = this.getPrevWord();
        if (string2 == null) {
            return false;
        }
        boolean bl2 = bl ? string2.equals(string) : string2.equalsIgnoreCase(string);
        if (bl2) {
            char c = string2.charAt(string2.length() - 1);
            for (int i = this.cursor - 1; i >= 0 && bl2 && this.theString.charAt(i) != c; --i) {
                if (UniCharacter.isWhitespace(this.theString.charAt(i))) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    public boolean isFirstWord() {
        return this.is1stWord;
    }

    public Object nextElement() {
        return this.nextWord();
    }

    public String nextWord() throws NoSuchElementException {
        int n = this.findWordStart();
        if (n != this.cursor) {
            this.cachedWord.setLength(0);
            this.cursor = n;
        }
        if (this.cursor >= this.theString.length()) {
            throw new NoSuchElementException();
        }
        String string = this.getWord();
        this.cursor += string.length();
        this.cursor = this.findWordStart();
        this.is1stWord = false;
        ++this.nWords;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        return string;
    }

    public void replaceWord(String string) throws NoSuchElementException {
        String string2 = this.getWord();
        String string3 = this.theString.toString().substring(this.cursor + string2.length());
        this.theString.setLength(this.cursor);
        this.theString.append(string);
        this.theString.append(string3);
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        ++this.nReplacements;
    }

    public void setCursor(int n) throws StringIndexOutOfBoundsException {
        if (n < 0 || n >= this.theString.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.cursor = n;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public void setText(String string) {
        if (this.theString == null) {
            this.theString = new StringBuffer();
        }
        this.theString.setLength(0);
        this.theString.append(string);
        this.cursor = 0;
        this.is1stWord = true;
        this.nReplacements = 0;
        this.nWords = 0;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public void setWordLength(int n) {
        this.subWordLength = n;
        this.cachedWord.setLength(0);
    }

    public String toString() {
        return this.theString.toString();
    }

    protected int findWordStart() {
        int n;
        int n2 = this.theString.length();
        for (n = this.cursor; n < n2 && !StringWordParser.is1stWordChar(this.theString.charAt(n)); ++n) {
        }
        return n;
    }

    protected String getPrevWord() {
        int n;
        for (n = this.cursor - 1; n >= 0 && UniCharacter.isApostrophe(this.theString.charAt(n)); --n) {
        }
        while (n >= 0 && !StringWordParser.isWordChar(this.theString.charAt(n))) {
            --n;
        }
        if (n < 0) {
            return null;
        }
        while (n > 0 && StringWordParser.isWordChar(this.theString.charAt(n - 1))) {
            --n;
        }
        int n2 = this.cursor;
        int n3 = this.subWordLength;
        String string = this.cachedWord.toString();
        this.cursor = n;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        String string2 = this.getWord();
        if (this.cursor == n2) {
            string2 = null;
        }
        this.cursor = n2;
        this.subWordLength = n3;
        this.cachedWord.setLength(0);
        this.cachedWord.append(string);
        return string2;
    }

    protected boolean includeCharInWord(StringBuffer stringBuffer, int n, boolean bl) {
        char c = stringBuffer.charAt(n);
        int n2 = stringBuffer.length();
        if (c == '.') {
            if (StringWordParser.isSurroundedByWordChars(stringBuffer, n)) {
                return true;
            }
        } else if (c == '-' && !this.isHyphenDelimiter) {
            if (StringWordParser.isSurroundedByWordChars(stringBuffer, n)) {
                return true;
            }
        } else if ('@' == c) {
            char c2;
            boolean bl2 = false;
            for (int i = n + 1; i < n2 && !UniCharacter.isWhitespace(c2 = stringBuffer.charAt(i)); ++i) {
                if ('.' != c2 || !StringWordParser.isSurroundedByWordChars(stringBuffer, i)) continue;
                bl2 = true;
                break;
            }
            if (bl2 && StringWordParser.isSurroundedByWordChars(stringBuffer, n)) {
                return true;
            }
        } else if (':' == c) {
            if (n > 0 && UniCharacter.isLetterOrDigit(stringBuffer.charAt(n - 1)) && n + 1 < n2 && stringBuffer.charAt(n + 1) == '/') {
                return true;
            }
        } else if ('/' == c) {
            if (bl) {
                return true;
            }
            if (n > 0 && (stringBuffer.charAt(n - 1) == ':' || stringBuffer.charAt(n - 1) == '/') && (n + 1 < n2 && stringBuffer.charAt(n + 1) == '/' || UniCharacter.isLetterOrDigit(stringBuffer.charAt(n + 1)))) {
                return true;
            }
        } else if ('&' == c || '%' == c || '+' == c || '=' == c || '?' == c) {
            if (bl) {
                return true;
            }
        } else if ('_' == c) {
            char c3;
            if (bl) {
                return true;
            }
            boolean bl3 = false;
            for (int i = n + 1; i < n2 && !UniCharacter.isWhitespace(c3 = stringBuffer.charAt(i)); ++i) {
                if ('.' != c3 || !StringWordParser.isSurroundedByWordChars(stringBuffer, i)) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                return true;
            }
        } else if (StringWordParser.isWordChar(c)) {
            return true;
        }
        return false;
    }

    protected boolean includeCharInWord(char c, String string, int n, boolean bl) {
        return this.includeCharInWord(new StringBuffer(string), n, bl);
    }

    protected static boolean is1stWordChar(char c) {
        return UniCharacter.isLetterOrDigit(c);
    }

    private static boolean isSurroundedByWordChars(StringBuffer stringBuffer, int n) {
        return n > 0 && StringWordParser.isWordChar(stringBuffer.charAt(n - 1)) && n + 1 < stringBuffer.length() && StringWordParser.isWordChar(stringBuffer.charAt(n + 1));
    }

    protected static boolean isWordChar(char c) {
        return UniCharacter.isLetterOrDigit(c) || UniCharacter.isApostrophe(c);
    }
}

