/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.CLexSegment;
import com.wintertree.ssce.ContainsWordCatcher;
import com.wintertree.ssce.FileFormatException;
import com.wintertree.ssce.LexCompressor;
import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.SuggestWordCatcher;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordCatcher;
import com.wintertree.ssce.WordComparator;
import com.wintertree.util.CharArray;
import com.wintertree.util.Comparable;
import com.wintertree.util.Search;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class CompressedLexicon
implements Lexicon {
    private int accesses;
    private int charSet;
    private String[] extSuffixes;
    private String fileName;
    private int language;
    private int memoryAvailable;
    private int memoryBudget;
    private long segDataOffset;
    private CLexSegment[] segIndex;
    private String[] simpleSuffixes;

    public CompressedLexicon(String string) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        this(string, 0);
    }

    public CompressedLexicon(String string, int n) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        this.open(string, n);
    }

    public CompressedLexicon(InputStream inputStream) throws FileFormatException, IOException, UnsupportedException {
        this.fileName = inputStream.toString();
        this.open(new DataInputStream(inputStream));
    }

    public boolean equals(Object object) {
        return this.fileName.equals(((CompressedLexicon)object).toString());
    }

    public int findWord(String string, boolean bl, StringBuffer stringBuffer) {
        ContainsWordCatcher containsWordCatcher = new ContainsWordCatcher(string, bl);
        CLexSegment cLexSegment = new CLexSegment();
        LexCompressor.toSegId(string, cLexSegment.id);
        if (string.length() < 3) {
            if (bl) {
                int n = Search.binary(this.segIndex, (Comparable)cLexSegment);
                return n >= 0 ? 105 : 0;
            }
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < cLexSegment.id.length; ++j) {
                    cLexSegment.id[j] = (i & 1 << j) != 0 ? Character.toUpperCase(cLexSegment.id[j]) : Character.toLowerCase(cLexSegment.id[j]);
                }
                int n = Search.binary(this.segIndex, (Comparable)cLexSegment);
                if (n < 0) continue;
                return 105;
            }
            return 0;
        }
        if (bl) {
            int n = Search.binary(this.segIndex, (Comparable)cLexSegment);
            if (n < 0) {
                return 0;
            }
            try {
                this.loadSegment(n);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                return 0;
            }
            this.scanSegment(this.segIndex[n], this.charSet, containsWordCatcher, this.simpleSuffixes, this.extSuffixes);
            return containsWordCatcher.IsFound() ? 105 : 0;
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < cLexSegment.id.length; ++j) {
                cLexSegment.id[j] = (i & 1 << j) != 0 ? Character.toUpperCase(cLexSegment.id[j]) : Character.toLowerCase(cLexSegment.id[j]);
            }
            int n = Search.binary(this.segIndex, (Comparable)cLexSegment);
            if (n < 0) continue;
            try {
                this.loadSegment(n);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                return 0;
            }
            this.scanSegment(this.segIndex[n], this.charSet, containsWordCatcher, this.simpleSuffixes, this.extSuffixes);
            if (!containsWordCatcher.IsFound()) continue;
            return 105;
        }
        return 0;
    }

    public int getLanguage() {
        return this.language;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public static boolean isCompressedLexicon(String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            int n = randomAccessFile.readInt();
            randomAccessFile.close();
            return n == 1459619073;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void suggest(String string, int n, WordComparator wordComparator, SuggestionSet suggestionSet) {
        int n2 = 100 - n;
        n2 = Math.max(n2, 0);
        for (int i = 0; i < this.segIndex.length; ++i) {
            int n3;
            String string2;
            CLexSegment cLexSegment = this.segIndex[i];
            if (CharArray.length(cLexSegment.id) < 3) {
                string2 = CharArray.toString(cLexSegment.id);
                n3 = wordComparator.compare(string, string2);
                suggestionSet.add(string2, n3);
                continue;
            }
            n3 = Math.min(3, string.length());
            String string3 = string.substring(0, n3);
            int n4 = wordComparator.compare(string3, string2 = CharArray.toString(cLexSegment.id));
            if (n4 < n2) continue;
            try {
                this.loadSegment(i);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                continue;
            }
            SuggestWordCatcher suggestWordCatcher = new SuggestWordCatcher(string, wordComparator, suggestionSet);
            this.scanSegment(this.segIndex[i], this.charSet, suggestWordCatcher, this.simpleSuffixes, this.extSuffixes);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fileName + ')';
    }

    protected void open(String string, int n) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        int n2;
        int n3;
        this.fileName = new String(string);
        this.memoryBudget = n;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        try {
            n3 = randomAccessFile.readInt();
            if (n3 != 1459619073) {
                randomAccessFile.close();
                throw new FileFormatException(string + ": expected magic number " + 1459619073 + "; read " + n3);
            }
        }
        catch (EOFException eOFException) {
            randomAccessFile.close();
            throw new FileFormatException(string + "No magic");
        }
        n3 = 0;
        block13: while (n3 == 0) {
            int n4;
            try {
                n2 = randomAccessFile.readInt();
            }
            catch (EOFException eOFException) {
                n3 = 1;
                continue;
            }
            try {
                n4 = randomAccessFile.readInt();
            }
            catch (EOFException eOFException) {
                randomAccessFile.close();
                throw new FileFormatException(string + " Unexpected EOF at " + randomAccessFile.getFilePointer());
            }
            switch (n2) {
                case 3: {
                    byte[] byArray = new byte[n4];
                    randomAccessFile.readFully(byArray);
                    Vector vector = new Vector();
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.simpleSuffixes = new String[vector.size()];
                    vector.copyInto(this.simpleSuffixes);
                    vector.removeAllElements();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.extSuffixes = new String[vector.size()];
                    vector.copyInto(this.extSuffixes);
                    continue block13;
                }
                case 4: {
                    byte[] byArray = new byte[n4];
                    randomAccessFile.readFully(byArray);
                    this.loadSegIndexTbl(new DataInputStream(new ByteArrayInputStream(byArray)));
                    continue block13;
                }
                case 1: {
                    this.language = randomAccessFile.readInt();
                    continue block13;
                }
                case 2: {
                    this.charSet = randomAccessFile.readInt();
                    continue block13;
                }
                case 5: {
                    this.segDataOffset = randomAccessFile.getFilePointer();
                    randomAccessFile.skipBytes(n4);
                    continue block13;
                }
            }
            randomAccessFile.skipBytes(n4);
        }
        this.memoryAvailable = this.memoryBudget;
        this.accesses = 0;
        if (this.memoryBudget > 0) {
            for (n2 = 0; n2 < this.segIndex.length; ++n2) {
                if (this.memoryBudget <= 0 || this.segIndex[n2].size <= this.memoryBudget) continue;
                randomAccessFile.close();
                throw new ParameterException("Memory budget " + Integer.toString(this.memoryBudget) + " too small for lexicon " + string + "; should be at least " + Integer.toString(this.segIndex[n2].size));
            }
        }
        randomAccessFile.close();
    }

    protected void open(DataInputStream dataInputStream) throws IOException, FileFormatException, UnsupportedException {
        int n;
        try {
            int n2 = dataInputStream.readInt();
            if (n2 != 1459619073) {
                throw new FileFormatException("expected magic number 1459619073; read " + n2);
            }
        }
        catch (EOFException eOFException) {
            throw new FileFormatException("No magic");
        }
        byte[] byArray = null;
        boolean bl = false;
        block13: while (!bl) {
            int n3;
            try {
                n = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                bl = true;
                continue;
            }
            try {
                n3 = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                bl = true;
                throw new FileFormatException("Unexpected EOF");
            }
            switch (n) {
                case 3: {
                    Vector vector = new Vector();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.simpleSuffixes = new String[vector.size()];
                    vector.copyInto(this.simpleSuffixes);
                    vector.removeAllElements();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.extSuffixes = new String[vector.size()];
                    vector.copyInto(this.extSuffixes);
                    continue block13;
                }
                case 4: {
                    this.loadSegIndexTbl(dataInputStream);
                    continue block13;
                }
                case 1: {
                    this.language = dataInputStream.readInt();
                    continue block13;
                }
                case 2: {
                    this.charSet = dataInputStream.readInt();
                    continue block13;
                }
                case 5: {
                    if (byArray != null) {
                        throw new FileFormatException("Duplicate segment data section");
                    }
                    byArray = new byte[n3];
                    dataInputStream.readFully(byArray);
                    continue block13;
                }
            }
            dataInputStream.skip(n3);
        }
        if (null == byArray || null == this.segIndex) {
            throw new FileFormatException("Missing data or index section");
        }
        for (n = 0; n < this.segIndex.length; ++n) {
            this.segIndex[n].data = new byte[this.segIndex[n].size];
            System.arraycopy(byArray, this.segIndex[n].offset, this.segIndex[n].data, 0, this.segIndex[n].data.length);
        }
    }

    private void loadSegIndexTbl(DataInputStream dataInputStream) throws EOFException, IOException, FileFormatException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            if (dataInputStream == null) {
                throw new UnsupportedException();
            }
            try {
                n4 = -1479411111;
                n3 = 139;
                int n5 = 140;
                n2 = 647;
                n = 1999;
                int n6 = 151;
                int n7 = 499;
                int n8 = SpellingSession.getOption(new Integer(32));
                if ((n8 & 0xFF) == 162) {
                    int n9 = (n8 & 0x1F00) >> 8;
                    int n10 = (n8 & 0x1FFE000) >> 13;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n10 * 86400000L);
                    long l = System.currentTimeMillis();
                    long l2 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n11 = n8 & 0x7FFFE000;
                    int n12 = 0;
                    for (int i = 0; i < 32; ++i) {
                        n12 += n11 & 1;
                        n11 >>= 1;
                    }
                    if (n12 != n9) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l > l2 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i = 0; i < stringArray.length; ++i) {
                                for (int j = 0; j < stringArray[i].length(); ++j) {
                                    System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l > l2 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray[i].length(); ++j) {
                                System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                    }
                } else {
                    int n13;
                    long l = n8 ^ n4;
                    long l3 = 0L;
                    for (n13 = 0; n13 < 32; ++n13) {
                        long l4 = l >> n13 & 1L;
                        l3 |= l4 << 31 - n13;
                    }
                    n13 = (int)(l3 / 10000L);
                    if (n13 != n3 && n13 != n5) {
                        throw new Exception();
                    }
                    int n14 = (int)(l3 % 10000L);
                    if (n13 == n3 && n14 < n2 || n14 > n) {
                        throw new Exception();
                    }
                    if (n13 == n5 && (n14 < n6 || n14 > n7)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + 1000L) {
                }
                throw new UnsupportedException();
            }
            n4 = dataInputStream.readInt();
            this.segIndex = new CLexSegment[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                CLexSegment cLexSegment = new CLexSegment();
                for (n2 = 0; n2 < 3; ++n2) {
                    n = this.charSet == 1 ? (int)((char)(dataInputStream.readByte() & 0xFF)) : (int)dataInputStream.readChar();
                    cLexSegment.id[n2] = n;
                }
                cLexSegment.id[n2] = '\u0000';
                cLexSegment.offset = dataInputStream.readInt();
                cLexSegment.data = null;
                cLexSegment.size = dataInputStream.readInt();
                cLexSegment.lastUsed = 0;
                this.segIndex[n3] = cLexSegment;
            }
        }
        catch (UnsupportedException unsupportedException) {
            this.segIndex = new CLexSegment[0];
        }
    }

    private void loadSegment(int n) throws IOException, FileFormatException {
        Object object;
        ++this.accesses;
        CLexSegment cLexSegment = this.segIndex[n];
        if (cLexSegment.data != null) {
            cLexSegment.lastUsed = this.accesses;
            return;
        }
        if (cLexSegment.size == 0) {
            return;
        }
        while (this.memoryBudget > 0 && this.memoryAvailable < cLexSegment.size) {
            object = null;
            for (int i = 0; i < this.segIndex.length; ++i) {
                CLexSegment cLexSegment2 = this.segIndex[i];
                if (cLexSegment2.data == null || object != null && cLexSegment2.lastUsed >= ((CLexSegment)object).lastUsed) continue;
                object = cLexSegment2;
            }
            ((CLexSegment)object).data = null;
            this.memoryAvailable += ((CLexSegment)object).size;
        }
        cLexSegment.data = new byte[cLexSegment.size];
        object = new RandomAccessFile(this.fileName, "r");
        ((RandomAccessFile)object).seek(this.segDataOffset + (long)cLexSegment.offset);
        if (((RandomAccessFile)object).read(cLexSegment.data) != cLexSegment.data.length) {
            ((RandomAccessFile)object).close();
            throw new FileFormatException(this.fileName + ": Unexpected EOF");
        }
        ((RandomAccessFile)object).close();
        cLexSegment.lastUsed = this.accesses;
        if (this.memoryBudget > 0) {
            this.memoryAvailable -= cLexSegment.size;
        }
    }

    private void loadSuffixTbl(DataInputStream dataInputStream, Vector vector) throws IOException, EOFException, FileFormatException {
        int n = dataInputStream.readInt();
        int n2 = this.charSet == 1 ? n : n / 2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            char c = this.charSet == 1 ? (char)(dataInputStream.readByte() & 0xFF) : dataInputStream.readChar();
            if (c == '\u0000') {
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    void scanSegment(CLexSegment cLexSegment, int n, WordCatcher wordCatcher, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer(CharArray.toString(cLexSegment.id));
        int n2 = 0;
        int n3 = cLexSegment.data.length;
        while (n2 < n3) {
            boolean bl = false;
            stringBuffer.setLength(3 + cLexSegment.data[n2++]);
            while (!bl) {
                char c;
                if (n == 1) {
                    c = (char)(cLexSegment.data[n2++] & 0xFF);
                } else {
                    c = (char)((cLexSegment.data[n2++] & 0xFF) << 8);
                    c = (char)(c | (char)(cLexSegment.data[n2++] & 0xFF));
                }
                if (c >= ' ') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c >= '\u0002' && c < ' ') {
                    stringBuffer.append(stringArray[c - 2]);
                    bl = true;
                    continue;
                }
                if (c == '\u0000') {
                    bl = true;
                    continue;
                }
                if (c != '\u0001') continue;
                if (n == 1) {
                    c = (char)(cLexSegment.data[n2++] & 0xFF);
                } else {
                    c = (char)((cLexSegment.data[n2++] & 0xFF) << 8);
                    c = (char)(c | (char)(cLexSegment.data[n2++] & 0xFF));
                }
                stringBuffer.append(stringArray2[c]);
                bl = true;
            }
            if (wordCatcher.catchWord(stringBuffer.toString())) continue;
            return;
        }
    }
}

