/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.detect.MagicDetector;
import org.apache.tika.mime.AndClause;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MagicMatch;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.apache.tika.mime.OrClause;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MimeTypesReader
implements MimeTypesReaderMetKeys {
    private final MimeTypes types;

    MimeTypesReader(MimeTypes types) {
        this.types = types;
    }

    void read(String filepath) throws IOException, MimeTypeException {
        this.read(MimeTypesReader.class.getClassLoader().getResourceAsStream(filepath));
    }

    void read(InputStream stream) throws IOException, MimeTypeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(stream));
            this.read(document);
        }
        catch (ParserConfigurationException e) {
            throw new MimeTypeException("Unable to create an XML parser", e);
        }
        catch (SAXException e) {
            throw new MimeTypeException("Invalid type configuration", e);
        }
    }

    void read(Document document) throws MimeTypeException {
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("mime-info")) {
            NodeList nodes = element.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Element child;
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && (child = (Element)node).getTagName().equals("mime-type")) {
                    this.readMimeType(child);
                }
                ++i;
            }
        } else {
            throw new MimeTypeException("Not a <mime-info/> configuration document: " + element.getTagName());
        }
    }

    private void readMimeType(Element element) throws MimeTypeException {
        String name = element.getAttribute("type");
        MimeType type = this.types.forName(name);
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("_comment")) {
                    type.setDescription(nodeElement.getFirstChild().getNodeValue());
                } else if (nodeElement.getTagName().equals("glob")) {
                    boolean useRegex = Boolean.valueOf(nodeElement.getAttribute("isregex"));
                    this.types.addPattern(type, nodeElement.getAttribute("pattern"), useRegex);
                } else if (nodeElement.getTagName().equals("magic")) {
                    this.readMagic(nodeElement, type);
                } else if (nodeElement.getTagName().equals("alias")) {
                    String alias = nodeElement.getAttribute("type");
                    type.addAlias(alias);
                } else if (nodeElement.getTagName().equals("root-XML")) {
                    this.readRootXML(nodeElement, type);
                } else if (nodeElement.getTagName().equals("sub-class-of")) {
                    String parent = nodeElement.getAttribute("type");
                    type.setSuperType(this.types.forName(parent));
                }
            }
            ++i;
        }
        this.types.add(type);
    }

    private void readMagic(Element element, MimeType mimeType) throws MimeTypeException {
        int priority = 50;
        String value = element.getAttribute("priority");
        if (value != null && value.length() > 0) {
            priority = Integer.parseInt(value);
        }
        for (Clause clause : this.readMatches(element)) {
            Magic magic = new Magic(mimeType);
            magic.setPriority(priority);
            magic.setClause(clause);
            mimeType.addMagic(magic);
        }
    }

    private List<Clause> readMatches(Element element) throws MimeTypeException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals("match")) {
                clauses.add(this.readMatch(nodeElement));
            }
            ++i;
        }
        return clauses;
    }

    private Clause readMatch(Element element) throws MimeTypeException {
        String type = "string";
        int start = 0;
        int end = 0;
        String value = null;
        String mask = null;
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("offset")) {
                String offset = attr.getValue();
                int colon = offset.indexOf(58);
                if (colon == -1) {
                    end = start = Integer.parseInt(offset);
                } else {
                    start = Integer.parseInt(offset.substring(0, colon));
                    end = Integer.parseInt(offset.substring(colon + 1));
                }
            } else if (attr.getName().equals("type")) {
                type = attr.getValue();
            } else if (attr.getName().equals("value")) {
                value = attr.getValue();
            } else if (attr.getName().equals("mask")) {
                mask = attr.getValue();
            }
            ++i;
        }
        if (value == null) {
            throw new MimeTypeException("Missing magic byte pattern");
        }
        if (start < 0 || end < start) {
            throw new MimeTypeException("Invalid offset range: [" + start + "," + end + "]");
        }
        byte[] patternBytes = this.decodeValue(type, value);
        int length = patternBytes.length;
        byte[] maskBytes = null;
        if (mask != null) {
            maskBytes = this.decodeValue(type, mask);
            length = Math.max(patternBytes.length, maskBytes.length);
        }
        MagicDetector detector = new MagicDetector(MediaType.TEXT_PLAIN, patternBytes, maskBytes, start, end);
        MagicMatch clause = new MagicMatch(detector, length);
        List<Clause> subClauses = this.readMatches(element);
        if (subClauses.size() == 0) {
            return clause;
        }
        if (subClauses.size() == 1) {
            return new AndClause(clause, subClauses.get(0));
        }
        return new AndClause(clause, new OrClause(subClauses));
    }

    private byte[] decodeValue(String type, String value) throws MimeTypeException {
        if (value == null || type == null) {
            return null;
        }
        byte[] decoded = null;
        String tmpVal = null;
        int radix = 8;
        if (value.startsWith("0x")) {
            tmpVal = value.substring(2);
            radix = 16;
        } else {
            tmpVal = value;
            radix = 8;
        }
        if (type.equals("string")) {
            decoded = this.decodeString(value);
        } else if (type.equals("byte")) {
            decoded = tmpVal.getBytes();
        } else if (type.equals("host16") || type.equals("little16")) {
            int i = Integer.parseInt(tmpVal, radix);
            decoded = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
        } else if (type.equals("big16")) {
            int i = Integer.parseInt(tmpVal, radix);
            decoded = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
        } else if (type.equals("host32") || type.equals("little32")) {
            long i = Long.parseLong(tmpVal, radix);
            decoded = new byte[]{(byte)(i & 0xFFL), (byte)((i & 0xFF00L) >> 8), (byte)((i & 0xFF0000L) >> 16), (byte)((i & 0xFFFFFFFFFF000000L) >> 24)};
        } else if (type.equals("big32")) {
            long i = Long.parseLong(tmpVal, radix);
            decoded = new byte[]{(byte)((i & 0xFFFFFFFFFF000000L) >> 24), (byte)((i & 0xFF0000L) >> 16), (byte)((i & 0xFF00L) >> 8), (byte)(i & 0xFFL)};
        }
        return decoded;
    }

    private byte[] decodeString(String value) throws MimeTypeException {
        if (value.startsWith("0x")) {
            byte[] bytes = new byte[(value.length() - 2) / 2];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)Integer.parseInt(value.substring(2 + i * 2, 4 + i * 2), 16);
                ++i;
            }
            return bytes;
        }
        try {
            ByteArrayOutputStream decoded = new ByteArrayOutputStream();
            int i = 0;
            while (i < value.length()) {
                if (value.charAt(i) == '\\') {
                    if (value.charAt(i + 1) == '\\') {
                        decoded.write(92);
                        ++i;
                    } else if (value.charAt(i + 1) == 'x') {
                        decoded.write(Integer.parseInt(value.substring(i + 2, i + 4), 16));
                        i += 3;
                    } else {
                        int j = i + 1;
                        while (j < i + 4 && j < value.length() && Character.isDigit(value.charAt(j))) {
                            ++j;
                        }
                        decoded.write(Short.decode("0" + value.substring(i + 1, j)).byteValue());
                        i = j - 1;
                    }
                } else {
                    decoded.write(value.charAt(i));
                }
                ++i;
            }
            return decoded.toByteArray();
        }
        catch (NumberFormatException e) {
            throw new MimeTypeException("Invalid string value: " + value, e);
        }
    }

    private void readRootXML(Element element, MimeType mimeType) {
        mimeType.addRootXML(element.getAttribute("namespaceURI"), element.getAttribute("localName"));
    }
}

