/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReader;
import org.w3c.dom.Document;

public class MimeTypesFactory {
    public static MimeTypes create() {
        return new MimeTypes();
    }

    public static MimeTypes create(Document document) throws MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        new MimeTypesReader(mimeTypes).read(document);
        return mimeTypes;
    }

    public static MimeTypes create(InputStream inputStream) throws IOException, MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        new MimeTypesReader(mimeTypes).read(inputStream);
        return mimeTypes;
    }

    public static MimeTypes create(URL url) throws IOException, MimeTypeException {
        InputStream stream = url.openStream();
        try {
            MimeTypes mimeTypes = MimeTypesFactory.create(stream);
            return mimeTypes;
        }
        finally {
            stream.close();
        }
    }

    public static MimeTypes create(String filePath) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(MimeTypesReader.class.getResource(filePath));
    }
}

